/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.object;

import fr.pgh.conversion.ConversionTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.uev.object.FullCardNumberAndGeneration;
import transpo.system.util.Fonctions;

public class VuOverSpeedingEvent {
    public static final int RECORD_SIZE = 32;
    private int type = 0;
    private int purpose = 0;
    private Date begin = null;
    private Date end = null;
    private int maxSpeed = 0;
    private int averageSpeed = 0;
    private FullCardNumberAndGeneration card = null;
    private int similarEvent = 0;

    public boolean equals(Object obj) {
        return obj != null && obj instanceof VuOverSpeedingEvent && this.begin.equals(((VuOverSpeedingEvent)obj).getBegin()) && this.begin.equals(((VuOverSpeedingEvent)obj).getBegin()) && this.type == ((VuOverSpeedingEvent)obj).getType();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getPurpose() {
        return this.purpose;
    }

    public void setPurpose(int purpose) {
        this.purpose = purpose;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(int maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public int getAverageSpeed() {
        return this.averageSpeed;
    }

    public void setAverageSpeed(int averageSpeed) {
        this.averageSpeed = averageSpeed;
    }

    public FullCardNumberAndGeneration getCard() {
        return this.card;
    }

    public void setCard(FullCardNumberAndGeneration card) {
        this.card = card;
    }

    public int getSimilarEvent() {
        return this.similarEvent;
    }

    public void setSimilarEvent(int similarEvent) {
        this.similarEvent = similarEvent;
    }

    public VuOverSpeedingEvent(byte[] toParse) {
        this.type = Fonctions.bytesToInt(toParse, 0, 1);
        this.purpose = Fonctions.bytesToInt(toParse, 1, 1);
        long beginTime = Fonctions.bytesToInt(toParse, 2, 4);
        long endTime = Fonctions.bytesToInt(toParse, 6, 4);
        this.maxSpeed = Fonctions.bytesToInt(toParse, 10, 1);
        this.averageSpeed = Fonctions.bytesToInt(toParse, 11, 1);
        this.card = new FullCardNumberAndGeneration(Arrays.copyOfRange(toParse, 12, 31));
        this.similarEvent = Fonctions.bytesToInt(toParse, 31, 1);
        TimsLogger.verbose("#OverSpeeding data# " + ConversionTime.dateToString(ConversionTime.getDate(beginTime), "dd/MM/yyyy HH:mm:ss") + " / " + ConversionTime.dateToString(ConversionTime.getDate(endTime), "dd/MM/yyyy HH:mm:ss") + " " + this.type + " " + this.purpose + " max=" + this.maxSpeed);
        if (endTime - beginTime < 60L) {
            beginTime -= 60L;
        }
        this.begin = ConversionTime.getDate(beginTime);
        this.end = ConversionTime.getDate(endTime);
    }

    public static ArrayList<VuOverSpeedingEvent> parse(byte[] toParse) {
        int start = 0;
        ArrayList<VuOverSpeedingEvent> toReturn = new ArrayList<VuOverSpeedingEvent>();
        while (start < toParse.length) {
            VuOverSpeedingEvent toAdd = new VuOverSpeedingEvent(Arrays.copyOfRange(toParse, start, start + 32));
            toReturn.add(toAdd);
            start += 32;
        }
        return toReturn;
    }
}

