/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.uev.object;

import fr.pgh.conversion.ConversionTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import transpo.system.uev.object.ExtendedSerialNumber;
import transpo.system.util.Fonctions;

public class VuSensorExternalGNSSCoupled {
    public static int RECORD_SIZE = 28;
    private ExtendedSerialNumber serialNumber = null;
    private String approvalNumber = null;
    private Date date = null;

    public ExtendedSerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(ExtendedSerialNumber serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getApprovalNumber() {
        return this.approvalNumber;
    }

    public void setApprovalNumber(String approvalNumber) {
        this.approvalNumber = approvalNumber;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public VuSensorExternalGNSSCoupled(byte[] toParse) {
        this.serialNumber = new ExtendedSerialNumber(Arrays.copyOfRange(toParse, 0, 7));
        this.approvalNumber = Fonctions.getStringFromBuffer(toParse, 7, 16, 0);
        this.date = ConversionTime.getDate(Fonctions.bytesToInt(toParse, 23, 4));
    }

    public static ArrayList<VuSensorExternalGNSSCoupled> parse(byte[] tmp) {
        int start = 0;
        ArrayList<VuSensorExternalGNSSCoupled> toReturn = new ArrayList<VuSensorExternalGNSSCoupled>();
        while (start < tmp.length) {
            VuSensorExternalGNSSCoupled toAdd = new VuSensorExternalGNSSCoupled(Arrays.copyOfRange(tmp, start, start + RECORD_SIZE));
            toReturn.add(toAdd);
            start += RECORD_SIZE;
        }
        return toReturn;
    }
}

