/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui;

import fr.pgh.component.JNotificationFrame;
import fr.pgh.component.JPanelButton;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Configuration;
import fr.pgh.data.bdd.ElementArbre;
import fr.pgh.data.bdd.EmployeeObligation;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.PayPeriod;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.data.bdd.Vehicule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import transpo.system.LicenceManager;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.core.Exitable;
import transpo.system.core.Helpable;
import transpo.system.core.PopupMessengerManager;
import transpo.system.exp.ActivityToCcmx;
import transpo.system.exp.PayPeriodCloser;
import transpo.system.imp.DriverImport;
import transpo.system.imp.VehicleImport;
import transpo.system.jdbox.DBox;
import transpo.system.jdbox.DialogConfigurationDBox;
import transpo.system.jdbox.JDBox;
import transpo.system.jsmartcard.CardEventListenerLauncher;
import transpo.system.jsmartcard.CompanyCardAcquisition;
import transpo.system.traitement.TraitementTempsService;
import transpo.system.ui.ProgressBarIndetermine;
import transpo.system.ui.TabbedViewPane;
import transpo.system.ui.ViewPanel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DetailUserConnexion;
import transpo.system.ui.views.DialogChange;
import transpo.system.ui.views.DialogCompany;
import transpo.system.ui.views.DialogCompanyList;
import transpo.system.ui.views.DialogInfraction;
import transpo.system.ui.views.DialogLog;
import transpo.system.ui.views.DialogPayPeriod;
import transpo.system.ui.views.DialogPays;
import transpo.system.ui.views.DialogRapport;
import transpo.system.ui.views.DialogRate;
import transpo.system.ui.views.DialogRegion;
import transpo.system.ui.views.DialogTelechargementDonneesConducteur;
import transpo.system.ui.views.DialogTelechargementDonneesUEV;
import transpo.system.ui.views.DialogTypeActivite;
import transpo.system.ui.views.DialogTypeContrat;
import transpo.system.ui.views.DialogTypeFrais;
import transpo.system.ui.views.DialogTypeJournee;
import transpo.system.ui.views.OffenceRules;
import transpo.system.ui.views.PnlAccident;
import transpo.system.ui.views.PnlAccueil;
import transpo.system.ui.views.ProgressBar;
import transpo.system.ui.views.admin.DialogAdministrationProfil;
import transpo.system.ui.views.admin.DialogAdministrationRapport;
import transpo.system.ui.views.admin.DialogAdministrationUtilisateur;
import transpo.system.ui.views.agence.DialogCreationAgence;
import transpo.system.ui.views.agence.DialogSupprimerAgence;
import transpo.system.ui.views.agence.PanelInfractionAgence;
import transpo.system.ui.views.agence.PnlAgencyConsumption;
import transpo.system.ui.views.agence.PnlAgencyPosition;
import transpo.system.ui.views.agence.PnlConducteurAgence;
import transpo.system.ui.views.agence.PnlDetailAgence;
import transpo.system.ui.views.agence.PnlPlanningAgence;
import transpo.system.ui.views.agence.PnlRoundAgency;
import transpo.system.ui.views.agence.PnlVehiculeAgence;
import transpo.system.ui.views.calendarManagement.DialogGlobalCalendar;
import transpo.system.ui.views.conducteur.DialogCreationConducteur;
import transpo.system.ui.views.conducteur.DialogSupprimerConducteur;
import transpo.system.ui.views.conducteur.NewDialogCalendrier;
import transpo.system.ui.views.conducteur.PnlActiviteC;
import transpo.system.ui.views.conducteur.PnlDetailConducteur;
import transpo.system.ui.views.conducteur.PnlDriverConsumption;
import transpo.system.ui.views.conducteur.PnlInfractionCond;
import transpo.system.ui.views.conducteur.PnlTourneeC;
import transpo.system.ui.views.export.DialogExportConducteur;
import transpo.system.ui.views.export.DialogExportVehicule;
import transpo.system.ui.views.region.PnlRegion;
import transpo.system.ui.views.scan.DialogScan;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.ui.views.tree.ArbreDonnees;
import transpo.system.ui.views.user.DialogPreferences;
import transpo.system.ui.views.vehicule.DialogCreationVehicule;
import transpo.system.ui.views.vehicule.DialogSupprimerVehicule;
import transpo.system.ui.views.vehicule.PnlActiviteUEV;
import transpo.system.ui.views.vehicule.PnlEtalonnage;
import transpo.system.ui.views.vehicule.PnlEventsFaultsUev;
import transpo.system.ui.views.vehicule.PnlInputOutput;
import transpo.system.ui.views.vehicule.PnlSpeedUEV;
import transpo.system.ui.views.vehicule.PnlVehicleConsumption;
import transpo.system.ui.views.vehicule.PnlVehicule;
import transpo.system.util.Constants;
import transpo.system.util.CopyOfCopyFileServeur2;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.system.util.reader.FileReadManager;
import transpo.system.util.watcher.DirectoryWatcher;
import transpo.system.util.watcher.FileListener;
import transport.report.DayToCcmxCayon;
import transport.report.DynamicGeneric;
import transport.report.MasterReport;
import transport.report.TimeToCcmxCayon;

public class MainFrameTransport
extends JFrame
implements Exitable,
Helpable,
DataListener {
    private static final long serialVersionUID = 1L;
    public static final Color BG_COLOR_UNUSED_DEFAULT = new Color(100, 150, 200);
    public static final Color BG_COLOR_OK_DEFAULT = new Color(176, 242, 182);
    public static final Color BG_COLOR_ALERTE_DEFAULT = new Color(205, 179, 71);
    public static final Color BG_COLOR_TOO_LATE_DEFAULT = new Color(255, 105, 97);
    public static final Color BG_COLOR_UNABLE = Color.lightGray;
    public static final Color BG_PASTEL_RED = new Color(0xFFAAAA);
    public static final Color BG_PASTEL_ORANGE = new Color(16775589);
    public static final Color BG_PASTEL_GREEN = new Color(0xDEFFDE);
    public static final Color BG_PASTEL_BLUE = new Color(0xAAAAFF);
    public static final Color COLOR_OK_DEFAULT = new Color(50, 150, 50);
    public static final Color COLOR_ALERTE_DEFAULT = Color.orange;
    public static final Color COLOR_TOO_LATE_DEFAULT = Color.red;
    public static final Color COLOR_UNABLE = Color.lightGray;
    public static final int ACTIVITY_MODULE = 1;
    public static final int CARD_MODULE = 2;
    public static final int DBOX_MODULE = 3;
    public static final int DLL_MODULE = 4;
    public static final int UEV_MODULE = 5;
    public static final int REPORT_MODULE = 6;
    public static final int COMPANY_MODULE = 7;
    public static final int AGENCY_MODULE = 8;
    public static final int DRIVER_MODULE = 9;
    public static final int DRIVER_VIEW = 1;
    public static final int VEHICLE_VIEW = 2;
    public static final int AGENCY_VIEW = 3;
    public static boolean archivage = false;
    public static int copying = 0;
    public int typeSelection = 0;
    public int indexDriverViewSelected = 0;
    public int indexVehicleViewSelected = 0;
    public int indexAgencyViewSelected = 0;
    private JPanel pnlGauche = null;
    private JPanel panelBouton = null;
    private ButtonGroup choixArbre = null;
    private JToggleButton btnVehicule = null;
    private JToggleButton btnConducteur = null;
    private JPanel panelPrincipal = null;
    private JSplitPane splitMainFrame = null;
    private JPopupMenu allFlag = null;
    private JPanel pnlBtnExportList = null;
    private JButton btnFlag = null;
    private JTextField txtSearch = null;
    private JButton btnSearch = null;
    private JPanel trayLine = null;
    private JLabel lblTray = null;
    private JButton btnAutoDetection = null;
    private JButton btnAutoRead = null;
    private JButton btnConsole = null;
    public DialogScan dialogScan;
    public PnlVehiculeAgence pnlVehiculeAgence = null;
    public PnlConducteurAgence pnlConducteurAgence = null;
    public PnlPlanningAgence pnlPlanningAgence = null;
    public PnlRoundAgency pnlRoundAgency = null;
    public PnlDetailAgence pnlAgence = null;
    private PnlRegion pnlRegion = null;
    public PanelInfractionAgence pnlInfractionS = null;
    public PnlDetailConducteur pnlConducteur = null;
    public PnlActiviteC pnlActiviteC = null;
    public PnlInfractionCond pnlInfractionC = null;
    public PnlTourneeC pnlTourneeC = null;
    public PnlAccueil pnlAccueil = null;
    public PnlActiviteUEV pnlActiviteUEV = null;
    public PnlVehicule pnlVehicule = null;
    public PnlInputOutput pnlInputOutput = null;
    public PnlEventsFaultsUev pnlEventsFaultsUev = null;
    public PnlSpeedUEV pnlSpeedUEV = null;
    public PnlEtalonnage pnlEtalonnage = null;
    public PnlAccident pnlAccident = null;
    public PnlDriverConsumption pnlConsumption = null;
    public PnlAgencyConsumption pnlAgencyConsumption = null;
    public PnlAgencyPosition pnlAgencyPosition = null;
    public PnlVehicleConsumption pnlVehicleConso = null;
    private DirectoryWatcher dw = null;
    private Thread cardListener = null;
    private Thread usbListener = null;
    public static int test = 0;
    public static int test0 = 0;
    public static int test1 = 0;
    public static int test2 = 0;
    private static final String MENU_MNEMO_PREF = "&";
    private static final String MENU_SEPARATOR = ",";
    public static final String FICHE_ADMIN = "ADMINISTRATION";
    public static final String FICHE_ADMIN_PGH = "ADMIN_PGH";
    public static final String FICHE_TYPE_ACTIVITE = "TYPE_ACTIVITE";
    public static final String FICHE_TYPE_PAIE = "TYPE_PAIE";
    public static final String FICHE_TAILLE_AGENCE = "TAILLE_AGENCE";
    public static final String FICHE_TYPE_AGENCE = "TYPE_AGENCE";
    public static final String FICHE_COMMENTAIRE = "COMMENTAIRE";
    public static final String FICHE_CALENDRIER = "CALENDRIER";
    public static final String FICHE_TYPE_PERSONNEL = "TYPE_PERSONNEL";
    public static final String FICHE_SOCIETE = "SOCIETE";
    public static final String FICHE_CONDUCTEUR = "CONDUCTEUR";
    public static final String FICHE_TABLEAUBORD = "TABLEAU DE BORD";
    public static final String FICHE_ACTIVITE = "ACTIVITE";
    public static final String FICHE_TOURNEE = "TOURNEE";
    public static final String FICHE_INFRACTION = "INFRACTION";
    public static final String FICHE_FRAIS = "FRAIS";
    public static final String FICHE_VALIDATION_FRAIS = "EXPENSES_VALIDATION";
    public static final String FICHE_VEHICULE = "VEHICULE";
    public static final String FICHE_V1B = "V1B";
    public static final String FICHE_AGENCE = "AGENCE";
    public static final String FICHE_REGION = "REGION";
    public static final String FICHE_REGLEMENTATION = "REGLEMENTATION";
    public static final String FICHE_PERMIS = "PERMIS";
    public static final String FICHE_EMPLOYEE_OBLIGATION = "EMPLOYEE_OBLIGATION";
    public static final String FICHE_EMPLOYEE_OBLIGATION_TYPE = "EMPLOYEE_OBLIGATION_TYPE";
    public static final String FICHE_SCAN = "SCAN";
    public static final String FICHE_PLACE = "PLACE";
    public static final String FICHE_ANOMALIE = "FAULT";
    public static final String FICHE_INTERVENTION = "INTERVENTION";
    public static final String FICHE_TYPE_INTERVENTION = "INTERVENTION_TYPE";
    public static final String FICHE_TYPE_VEHICULE = "VEHICLE_TYPE";
    public static final String FICHE_CARROSSERIE = "BODY";
    public static final String FICHE_AFFECTATION_VEHICULE = "VEHICLE_AFFECTATION";
    public static final String FICHE_MODELE_VEHICULE = "VEHICLE_MODEL";
    public static final String FICHE_ACCIDENT = "ACCIDENT";
    public static final String FICHE_ACCIDENT_FINANCE = "ACCIDENT_FINANCIAL";
    public static final String FICHE_CODE_ANALYTIQUE_VEHICULE = "VEHICLE_ANALYTIC_CODE";
    public static final String FICHE_CODE_ANALYTIQUE_CONDUCTEUR = "DRIVER_ANALYTIC_CODE";
    public static final String FICHE_CONSOMMATION = "CONSOMMATION";
    public static final String FICHE_EXPORT_PAIE = "EXPORT_PAIE";
    public static final String FICHE_ATTACHEMENT = "ATTACHMENT";
    public static final String FICHE_VEHICLE_ATTACHMENT = "VEHICLE_ATTACHMENT";
    public static final String FICHE_POSITION = "POSITION";
    public static final String FICHE_PLANNING = "PLANNING";
    ClassLoader cl = this.getClass().getClassLoader();
    private TabbedViewPane mainPane = new TabbedViewPane();
    private ArbreDonnees arbreMain = null;
    private static MainFrameTransport appli = null;
    ChangeListener tabPaneListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof JTabbedPane) {
                JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
                if (sourceTabbedPane.getSelectedIndex() == -1) {
                    return;
                }
                if (sourceTabbedPane.getComponentAt(sourceTabbedPane.getSelectedIndex()) instanceof ViewPanel) {
                    ViewPanel selected = (ViewPanel)sourceTabbedPane.getComponentAt(sourceTabbedPane.getSelectedIndex());
                    if (selected == null) {
                        return;
                    }
                    selected.loadData();
                }
            }
        }
    };
    JPanelButton pnlBtnList = null;
    JButton btnExportList = null;
    JButton btnPrintList = null;
    private ProgressBar pg;

    public static MainFrameTransport getInstance() {
        if (Transport.apiMode == 1) {
            return null;
        }
        if (appli == null) {
            appli = new MainFrameTransport();
        }
        return appli;
    }

    private MainFrameTransport() {
        this.setSize(1000, 600);
        this.setTitle(LanguageTranslator.getString("title"));
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setReshowDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            if (Transport.apiMode == 0) {
                TimsLogger.debug("#MainFrameTransport# initialize user's database...");
                Transport.conn.user.afficheUser();
                if (Transport.conn.getUserSociete() != null && !Transport.conn.getUserSociete().equals("AUCUNE")) {
                    Transport.bdd.changeDB(Transport.conn.getUserSociete(), true);
                } else {
                    this.createDialogChangerSociete();
                }
            }
        } else {
            Transport.bdd.changeDB(System.getProperty("INSTANCE") != null ? System.getProperty("INSTANCE") : "TIMS", true);
        }
        ImageIcon im = new ImageIcon(this.cl.getResource(Transport.res.getResourceString("icone")));
        this.setIconImage(im.getImage());
        this.setExtendedState(6);
        this.pnlGauche = new JPanel(new BorderLayout());
        this.panelBouton = new JPanel(new FlowLayout());
        JPanel pnlHigh = new JPanel(new BorderLayout());
        this.btnVehicule = System.getProperty("company.type", "1").equals("1") ? new JToggleButton(new ImageIcon(this.cl.getResource(Transport.res.getResourceString("icone_camion")))) : new JToggleButton(new ImageIcon(this.cl.getResource(Transport.res.getResourceString("icone_bus"))));
        this.btnConducteur = new JToggleButton(new ImageIcon(this.cl.getResource(Transport.res.getResourceString("icone_chauffeur"))), true);
        this.btnConducteur.setBorder(BorderFactory.createLineBorder(Color.RED));
        this.btnVehicule.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.createMenuBar();
        this.splitMainFrame = new JSplitPane();
        this.splitMainFrame.setResizeWeight(0.08);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitMainFrame, "Center");
        this.getContentPane().add((Component)this.getTrayLine(), "South");
        this.panelPrincipal = new JPanel(new BorderLayout());
        this.splitMainFrame.setRightComponent(this.panelPrincipal);
        this.panelPrincipal.add((Component)this.mainPane, "Center");
        this.mainPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent eV) {
                JTabbedPane panel = (JTabbedPane)eV.getSource();
                switch (MainFrameTransport.this.typeSelection) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        MainFrameTransport.this.indexDriverViewSelected = panel.getSelectedIndex();
                        break;
                    }
                    case 3: {
                        MainFrameTransport.this.indexAgencyViewSelected = panel.getSelectedIndex();
                        break;
                    }
                    case 2: {
                        MainFrameTransport.this.indexVehicleViewSelected = panel.getSelectedIndex();
                        break;
                    }
                }
            }
        });
        this.mainPane.addChangeListener(this.tabPaneListener);
        if (Transport.conn.isConsultable(FICHE_CONDUCTEUR)) {
            this.getTree().setType(1);
        } else if (Transport.conn.isConsultable(FICHE_VEHICULE)) {
            this.getTree().setType(2);
        }
        this.choixArbre = new ButtonGroup();
        this.choixArbre.add(this.btnConducteur);
        this.choixArbre.add(this.btnVehicule);
        if (Transport.conn.isConsultable(FICHE_CONDUCTEUR) && Transport.conn.isConsultable(FICHE_VEHICULE)) {
            this.panelBouton.add(this.btnConducteur);
            this.panelBouton.add(this.btnVehicule);
        }
        JScrollPane jspGauche = new JScrollPane();
        jspGauche.setAutoscrolls(true);
        jspGauche.getViewport().add(this.getTree());
        JPanel pnlTree = new JPanel(new BorderLayout());
        pnlTree.add((Component)this.getPnlSearch(), "North");
        pnlTree.add((Component)jspGauche, "Center");
        this.pnlGauche.setLayout(new BorderLayout());
        if (System.getProperty("DEV", "0").equals("1")) {
            JLabel lblDev = new JLabel("Version de d\u00e9veloppement");
            lblDev.setForeground(Color.red);
            lblDev.setFont(lblDev.getFont().deriveFont(14.0f));
            pnlHigh.add((Component)this.panelBouton, "Center");
            pnlHigh.add((Component)lblDev, "North");
            this.pnlGauche.add((Component)pnlHigh, "North");
        } else {
            this.pnlGauche.add((Component)this.panelBouton, "North");
        }
        this.pnlGauche.add((Component)pnlTree, "Center");
        this.pnlGauche.add((Component)this.getPnlBtnLeft(), "South");
        this.splitMainFrame.setLeftComponent(this.pnlGauche);
        this.btnConducteur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrameTransport.this.getTree().setType(1);
                MainFrameTransport.this.btnConducteur.setBorder(BorderFactory.createLineBorder(Color.RED));
                MainFrameTransport.this.btnVehicule.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                MainFrameTransport.this.btnExportList.setToolTipText(LanguageTranslator.getString("button.driver.export"));
                MainFrameTransport.this.btnPrintList.setToolTipText(LanguageTranslator.getString("button.driver.print"));
            }
        });
        this.btnVehicule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrameTransport.this.getTree().setType(2);
                MainFrameTransport.this.btnConducteur.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                MainFrameTransport.this.btnVehicule.setBorder(BorderFactory.createLineBorder(Color.RED));
                MainFrameTransport.this.btnExportList.setToolTipText(LanguageTranslator.getString("button.vehicle.export"));
                MainFrameTransport.this.btnPrintList.setToolTipText(LanguageTranslator.getString("button.vehicle.print"));
            }
        });
        if (Transport.conn.isConsultable(FICHE_TABLEAUBORD)) {
            this.mainPane.addViewPane(this.getPnlAccueil());
        }
        AideAction anAction = new AideAction();
        KeyStroke keystr = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().registerKeyboardAction(anAction, "hlpaction", keystr, 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrameTransport.this.exit();
            }
        });
        this.setDefaultCloseOperation(0);
        Transport.bdd.addDataListener(this);
        TimsSession.getInstance().addVisit(this.getClass().getName());
        PopupMessengerManager.getInstance().showPopup();
        String lastVersion = LicenceManager.isServerLevel() ? Transport.conn.user.getLastVersion() : Transport.res.getResourceString("executableVersion");
        JNotificationFrame w1 = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
        w1.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChangeFlags() == 4L) {
                    TimsLogger.debug("change" + e.getChangeFlags() + " " + e.getID() + " " + e.getChanged());
                    if (!JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).isShowing()) {
                        MainFrameTransport.this.getBtnConsole().setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_log")));
                    } else {
                        MainFrameTransport.this.getBtnConsole().setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_sup")));
                    }
                    MainFrameTransport.this.getBtnConsole().repaint();
                }
            }
        });
        JButton text = new JButton(LanguageTranslator.getString("home.changelog"));
        text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogChange().setVisible(true);
            }
        });
        w1.addMessage(LanguageTranslator.getString("home.welcome", Transport.res.getResourceString("executableVersion")), text, new ImageIcon(this.getClass().getClassLoader().getResource("images/rightArrow.png")));
        if ((Transport.showPopup || lastVersion == null || lastVersion.compareTo(Transport.res.getResourceString("executableVersion")) < 0) && Transport.debug < 1) {
            w1.showNotification(15);
        }
        if ("1".equals(System.getProperty("automatic.tools.detection", "0"))) {
            this.getBtnAutoDetection().setActionCommand(LanguageTranslator.getString("auto.detection.enable"));
            if (Transport.debug < 2) {
                this.startAutoDetection();
            }
        } else {
            this.getBtnAutoDetection().setActionCommand(LanguageTranslator.getString("auto.detection.disable"));
        }
        if (!System.getProperty("automatic.read", "").equals("")) {
            this.startDirectoryWatcher();
        }
    }

    public JPanel getTrayLine() {
        if (this.trayLine == null) {
            this.trayLine = new JPanel(new GridBagLayout());
            this.trayLine.setPreferredSize(new Dimension(0, 28));
            this.trayLine.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.trayLine.add((Component)this.getLblTray(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 13, new Insets(0, 0, 0, 5)));
            this.trayLine.add((Component)this.getBtnAutoDetection(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 13, null));
            this.trayLine.add((Component)this.getBtnAutoRead(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 13, null));
            this.trayLine.add((Component)this.getBtnConsole(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, 13, null));
        }
        return this.trayLine;
    }

    public JLabel getLblTray() {
        if (this.lblTray == null) {
            this.lblTray = new JLabel();
            this.lblTray.setHorizontalAlignment(11);
        }
        return this.lblTray;
    }

    public JButton getBtnConsole() {
        if (this.btnConsole == null) {
            this.btnConsole = new JButton();
            this.btnConsole.setPreferredSize(new Dimension(25, 25));
            this.btnConsole.setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_log")));
            this.btnConsole.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).isShowing()) {
                        JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).hideNotification(true);
                    } else {
                        JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).showNotification(15);
                    }
                }
            });
            this.btnConsole.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    MainFrameTransport.this.getLblTray().setText(LanguageTranslator.getString("generics.showConsole"));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    MainFrameTransport.this.getLblTray().setText("");
                }
            });
        }
        return this.btnConsole;
    }

    public JButton getBtnAutoDetection() {
        if (this.btnAutoDetection == null) {
            this.btnAutoDetection = new JButton();
            this.btnAutoDetection.setPreferredSize(new Dimension(25, 25));
            this.btnAutoDetection.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    MainFrameTransport.this.getLblTray().setText("");
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    MainFrameTransport.this.getLblTray().setText(MainFrameTransport.this.getBtnAutoDetection().getActionCommand());
                }
            });
        }
        return this.btnAutoDetection;
    }

    private void startAutoDetection() {
        this.startCardListener();
        this.startUsbListener();
    }

    public Thread startCardListener() {
        if (this.cardListener == null) {
            this.cardListener = new Thread(){

                @Override
                public void run() {
                    CardEventListenerLauncher listener = new CardEventListenerLauncher();
                    try {
                        listener.listen();
                    }
                    catch (InterruptedException e1) {
                        TimsLogger.warn("Card listener shutted off");
                        e1.printStackTrace();
                    }
                }
            };
            this.cardListener.start();
        }
        return this.cardListener;
    }

    public Thread startUsbListener() {
        TimsLogger.info("Launching USB listener", "MFT");
        if (this.usbListener == null) {
            this.usbListener = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        File[] fileArray = File.listRoots();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File root = fileArray[n2];
                            if (new File(String.valueOf(root.getAbsolutePath()) + "\\CARD").exists() && new File(String.valueOf(root.getAbsolutePath()) + "\\TACHO").exists() && new File(String.valueOf(root.getAbsolutePath()) + "\\Config_NDB.ini").exists()) {
                                MainFrameTransport.this.dbox2unloading(root);
                            } else if (new File(String.valueOf(root.getAbsolutePath()) + "\\CARDOPTAC").exists() && new File(String.valueOf(root.getAbsolutePath()) + "\\TACHO").exists()) {
                                MainFrameTransport.this.optacUnloading(root);
                            } else if (new File(String.valueOf(root.getAbsolutePath()) + "\\download").exists() && new File(String.valueOf(root.getAbsolutePath()) + "\\config").exists()) {
                                MainFrameTransport.this.dlkUnloading(root);
                            }
                            ++n2;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            this.usbListener.start();
        }
        return this.usbListener;
    }

    private int dlkUnloading(File root) {
        int reponse;
        String message;
        String[] param;
        File[] c1b = new File(String.valueOf(root.getAbsolutePath()) + "\\download").listFiles(Fonctions.getC1BDetector());
        File[] v1b = new File(String.valueOf(root.getAbsolutePath()) + "\\download").listFiles(Fonctions.getV1BDetector());
        TimsLogger.info("D\u00e9chargement automatique DLK " + root.getAbsolutePath() + " " + (c1b == null ? "0" : String.valueOf(c1b.length) + " C1B") + ", " + (v1b == null ? "0" : String.valueOf(v1b.length) + " V1B"), "MFT");
        if (v1b != null && v1b.length != 0) {
            param = new String[]{String.valueOf(v1b.length)};
            message = LanguageTranslator.getString("dbox.unloading.vehicles", param);
            reponse = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), message, LanguageTranslator.getString("generics.reading"), 0);
            if (reponse == 0) {
                FileReadManager.getInstance().queueFiles(Arrays.asList(v1b));
                while (FileReadManager.getInstance().isReading()) {
                    Fonctions.pause(1);
                }
            }
        }
        if (c1b != null && c1b.length != 0) {
            param = new String[]{String.valueOf(c1b.length)};
            message = LanguageTranslator.getString("dbox.unloading.drivers", param);
            reponse = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), message, LanguageTranslator.getString("generics.reading"), 0);
            if (reponse == 0) {
                FileReadManager.getInstance().queueFiles(Arrays.asList(c1b));
            }
        }
        while (root.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        TimsLogger.debug("DLK d\u00e9branch\u00e9e", "MFT");
        return 0;
    }

    private int dbox2unloading(File root) {
        int reponse;
        String message;
        String[] param;
        File[] c1b = new File(String.valueOf(root.getAbsolutePath()) + "\\CARD").listFiles(Fonctions.getC1BDetector());
        File[] v1b = new File(String.valueOf(root.getAbsolutePath()) + "\\TACHO").listFiles(Fonctions.getV1BDetector());
        TimsLogger.info("D\u00e9chargement automatique dbox " + root.getAbsolutePath() + " " + c1b == null ? "0" : (String.valueOf(c1b.length) + " C1B" + ", " + v1b == null ? "0" : String.valueOf(v1b.length) + " V1B"), "MFT");
        if (v1b != null && v1b.length != 0) {
            param = new String[]{String.valueOf(v1b.length)};
            message = LanguageTranslator.getString("dbox.unloading.vehicles", param);
            reponse = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), message, LanguageTranslator.getString("generics.reading"), 0);
            if (reponse == 0) {
                FileReadManager.getInstance().queueFiles(Arrays.asList(v1b));
                while (FileReadManager.getInstance().isReading()) {
                    Fonctions.pause(1);
                }
            }
        }
        if (c1b != null && c1b.length != 0) {
            param = new String[]{String.valueOf(c1b.length)};
            message = LanguageTranslator.getString("dbox.unloading.drivers", param);
            reponse = JOptionPane.showConfirmDialog(MainFrameTransport.getInstance(), message, LanguageTranslator.getString("generics.reading"), 0);
            if (reponse == 0) {
                FileReadManager.getInstance().queueFiles(Arrays.asList(c1b));
            }
        }
        while (root.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        TimsLogger.debug("DBox 2 d\u00e9branch\u00e9e", "MFT");
        return 0;
    }

    private int optacUnloading(File root) {
        TimsLogger.info("TODO D\u00e9chargement optac " + root.getAbsolutePath());
        return 0;
    }

    public JButton getBtnAutoRead() {
        if (this.btnAutoRead == null) {
            this.btnAutoRead = new JButton();
            this.btnAutoRead.setPreferredSize(new Dimension(25, 25));
            this.btnAutoRead.setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_grey_round")));
            this.btnAutoRead.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((JButton)e.getSource()).isEnabled()) {
                        MainFrameTransport.this.stopDirectoryWatcher();
                    } else {
                        MainFrameTransport.this.startDirectoryWatcher();
                    }
                }
            });
            this.btnAutoRead.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    MainFrameTransport.this.getLblTray().setText("");
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    MainFrameTransport.this.getLblTray().setText(MainFrameTransport.this.getBtnAutoRead().getActionCommand());
                }
            });
        }
        return this.btnAutoRead;
    }

    public void startDirectoryWatcher() {
        if (this.dw != null) {
            this.dw.stop();
        }
        if (!System.getProperty("automatic.read", "").equals("")) {
            TimsLogger.info("#MFT.startDirectoryWatcher# Starting " + System.getProperty("automatic.read", "") + " watcher");
            if (!new File(System.getProperty("automatic.read", "")).exists()) {
                TimsLogger.error("#MFT.startDirectoryWatcher# Directory " + System.getProperty("automatic.read", "") + "doesn't exist");
                this.getBtnAutoRead().setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_grey_round")));
                this.getBtnAutoRead().setToolTipText(LanguageTranslator.getString("auto.read.error.directory", System.getProperty("automatic.read", "")));
            } else {
                this.dw = new DirectoryWatcher(BddTransport.getInstance().getCompany(), System.getProperty("automatic.read", ""), 5, true);
                this.dw.addListener(new FileListener(BddTransport.getInstance().getCompany()));
                this.dw.start();
                this.getBtnAutoRead().setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_green_round")));
                this.getBtnAutoRead().setActionCommand(LanguageTranslator.getString("auto.read.enable", System.getProperty("automatic.read", "")));
            }
        } else {
            TimsLogger.error("#MFT.startDirectoryWatcher# Directory isn't configured");
        }
    }

    public void stopDirectoryWatcher() {
        if (this.dw != null) {
            this.dw.stop();
        }
        this.getBtnAutoRead().setIcon(Fonctions.getIcon(Transport.res.getResourceString("icone_grey_round")));
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (Transport.apiMode == 0) {
                if (e.getTable().equals("t_conducteur") && e.getAction() != Constants.ACTION_TYPE.NONE) {
                    this.majPnlAccueil();
                    if (ArbreDonnees.typeAffichage == 1) {
                        this.getTree().updateValues(this.getTxtSearch().getText());
                    }
                }
                if (e.getTable().equals("t_vehicule") && e.getAction() != Constants.ACTION_TYPE.NONE) {
                    this.majPnlAccueil();
                    if (ArbreDonnees.typeAffichage == 2) {
                        this.getTree().updateValues(this.getTxtSearch().getText());
                    }
                }
                if (e.getTable().equals("t_agence") && e.getAction() != Constants.ACTION_TYPE.NONE) {
                    this.getTree().updateValues(this.getTxtSearch().getText());
                }
                if (e.getTable().equals("t_conflit")) {
                    this.majPnlAccueil();
                }
                if (e.getTable().equals("t_societe") && e.getAction() == Constants.ACTION_TYPE.UPDATE) {
                    TimsLogger.debug("Refreshing interface after company change");
                    this.startDirectoryWatcher();
                    this.getTree().updateValues(this.getTxtSearch().getText());
                    this.majPnlAccueil();
                    if (System.getProperty("company.type", "1").equals("1")) {
                        this.btnVehicule.setIcon(new ImageIcon(this.cl.getResource(Transport.res.getResourceString("icone_camion"))));
                    } else {
                        this.btnVehicule.setIcon(new ImageIcon(this.cl.getResource(Transport.res.getResourceString("icone_bus"))));
                    }
                }
            }
        }
    }

    public ArbreDonnees getTree() {
        return ArbreDonnees.getInstance();
    }

    public JPanel getPnlBtnLeft() {
        if (this.pnlBtnExportList == null) {
            this.pnlBtnExportList = new JPanel();
            this.pnlBtnExportList.setLayout(new GridBagLayout());
            this.pnlBtnExportList.add((Component)this.getBtnFlag(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, null));
            this.pnlBtnExportList.add((Component)this.getPnlList(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 0, 13, null));
            ToolTipManager.sharedInstance().registerComponent(this.pnlBtnExportList);
        }
        return this.pnlBtnExportList;
    }

    public JButton getBtnFlag() {
        if (this.btnFlag == null) {
            this.btnFlag = new JButton(new ImageIcon(this.cl.getResource("images/" + LanguageTranslator.getLocale().getLanguage() + ".png")));
            this.btnFlag.setPreferredSize(new Dimension(55, 35));
            this.btnFlag.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameTransport.this.getPnlAllFlag().show(MainFrameTransport.this.btnFlag, 0, 0);
                }
            });
        }
        return this.btnFlag;
    }

    public JPanelButton getPnlList() {
        if (this.pnlBtnList == null) {
            this.pnlBtnList = new JPanelButton(2, this.getBtnExportList(), this.getBtnPrintList());
        }
        return this.pnlBtnList;
    }

    private JButton getBtnExportList() {
        if (this.btnExportList == null) {
            this.btnExportList = new JButton();
            this.btnExportList.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_xls"))));
            this.btnExportList.setPreferredSize(new Dimension(35, 35));
            this.btnExportList.setToolTipText(LanguageTranslator.getString("button.driver.export"));
            this.btnExportList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameTransport.this.exportList("xls");
                }
            });
        }
        return this.btnExportList;
    }

    private JButton getBtnPrintList() {
        if (this.btnPrintList == null) {
            this.btnPrintList = new JButton();
            this.btnPrintList.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_print"))));
            this.btnPrintList.setPreferredSize(new Dimension(35, 35));
            this.btnPrintList.setToolTipText(LanguageTranslator.getString("button.driver.print"));
            this.btnPrintList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameTransport.this.exportList("\u00e9cran");
                }
            });
        }
        return this.btnPrintList;
    }

    private void exportList(String exportType) {
        if (ArbreDonnees.typeAffichage == 1) {
            Fonctions.driversToReport(exportType);
        }
        if (ArbreDonnees.typeAffichage == 2) {
            Fonctions.vehiclesToReport(exportType);
        }
    }

    public JPanel getPnlSearch() {
        JPanel pnlSearch = new JPanel();
        pnlSearch.setLayout(new BorderLayout());
        pnlSearch.setBorder(this.getTxtSearch().getBorder());
        pnlSearch.setBackground(this.getTxtSearch().getBackground());
        this.getTxtSearch().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pnlSearch.add(this.getTxtSearch());
        this.getBtnSearch().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getBtnSearch().setBackground(pnlSearch.getBackground());
        this.getBtnSearch().setContentAreaFilled(false);
        pnlSearch.add((Component)this.getBtnSearch(), "After");
        return pnlSearch;
    }

    public JTextField getTxtSearch() {
        if (this.txtSearch == null) {
            this.txtSearch = new JTextField();
            this.txtSearch.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        MainFrameTransport.this.search();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
        return this.txtSearch;
    }

    public JButton getBtnSearch() {
        if (this.btnSearch == null) {
            this.btnSearch = new JButton(new ImageIcon(this.cl.getResource(Transport.res.getResourceString("icone_search"))));
            this.btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameTransport.this.search();
                }
            });
        }
        return this.btnSearch;
    }

    private void search() {
        TimsLogger.debug("Search for '" + this.getTxtSearch().getText() + "'", "MFT");
        this.getTree().updateValues(this.getTxtSearch().getText());
        if (!this.getTxtSearch().getText().equals("")) {
            this.getTree().expandAll();
        }
    }

    public JPopupMenu getPnlAllFlag() {
        this.allFlag = new JPopupMenu();
        FlowLayout ppml = new FlowLayout();
        ppml.setHgap(0);
        ppml.setVgap(0);
        this.allFlag.setLayout(ppml);
        int x = 0;
        while (x < LanguageTranslator.available.length) {
            if (!LanguageTranslator.getLocale().getLanguage().equals(LanguageTranslator.available[x])) {
                this.allFlag.add(this.getJMenuLang(LanguageTranslator.available[x]));
            }
            ++x;
        }
        return this.allFlag;
    }

    public JMenuItem getJMenuLang(String lang) {
        JMenuItem menu = null;
        try {
            menu = new JMenuItem();
            menu.setActionCommand(lang);
            menu.setIcon(new ImageIcon(this.cl.getResource("images/" + lang + ".png")));
            menu.addActionListener(LanguageTranslator.getInstance());
        }
        catch (Exception ex) {
            TimsLogger.warn(ex.getMessage(), "MFT");
        }
        return menu;
    }

    public void reloadLabel() {
        this.getBtnFlag().setIcon(new ImageIcon(this.cl.getResource("images/" + LanguageTranslator.getLocale().getLanguage() + ".png")));
        this.setTitle(LanguageTranslator.getString("title"));
        this.btnConducteur.setToolTipText(LanguageTranslator.getString("driverToolTip"));
        this.btnVehicule.setToolTipText(LanguageTranslator.getString("vehicleToolTip"));
        if (this.btnConducteur.isSelected()) {
            this.getTree().setType(1);
        } else {
            this.getTree().setType(2);
        }
        this.createMenuBar();
        this.majPnlAccueil();
        this.validate();
        this.repaint();
    }

    public void createCompanyCardListener() {
        Thread cardListener = new Thread(){

            @Override
            public void run() {
                CompanyCardAcquisition download = new CompanyCardAcquisition();
                download.lireCaP();
                System.gc();
            }
        };
        cardListener.start();
    }

    @Override
    public void browseAide() {
        try {
            String url = "http://www.pgh.fr/tims/aide/";
            if (System.getProperty("URL") != null && !System.getProperty("URL").equals("pgh.fr")) {
                url = "http://" + System.getProperty("HOME_PATH") + "aide/";
            }
            Runtime.getRuntime().exec("\"C:\\Program Files\\Internet Explorer\\iexplore.exe\" " + url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void switchArchivage() {
        archivage = !archivage;
        Conducteur.setList(null);
        this.getTree().setArchivage();
        String title = LanguageTranslator.getString("title");
        if (archivage) {
            title = String.valueOf(title) + " (" + LanguageTranslator.getString("archiveMode") + ")";
        }
        this.setTitle(title);
    }

    public void saveLog() {
        new DialogLog(this);
    }

    public void afficheRegion(int regionId) {
        Region current = new Region(regionId);
        this.mainPane.removeAll();
        if (Transport.conn.isConsultable(FICHE_REGION)) {
            this.getPnlRegion().loadRegion(current);
            this.mainPane.addViewPane(this.getPnlRegion());
        }
    }

    private PnlRegion getPnlRegion() {
        if (this.pnlRegion == null) {
            this.pnlRegion = new PnlRegion();
        }
        return this.pnlRegion;
    }

    public void afficheAgence(int agencyId) {
        Transport.ps.startOperation();
        this.typeSelection = 0;
        Agence current = new Agence(agencyId);
        this.mainPane.removeAll();
        if (Transport.conn.isConsultable(FICHE_AGENCE)) {
            Transport.ps.startOperation();
            if (this.pnlAgence == null) {
                this.pnlAgence = new PnlDetailAgence();
            }
            this.pnlAgence.setAgence(current);
            this.mainPane.addViewPane(this.pnlAgence);
            Transport.ps.endOperation(PerformanceScanner.READING, "agency tab");
        }
        if (Transport.conn.isConsultable(FICHE_INFRACTION) && LicenceManager.isExploitationLevel() && ArbreDonnees.typeAffichage == 1) {
            Transport.ps.startOperation();
            this.pnlInfractionS = new PanelInfractionAgence(current);
            this.mainPane.addViewPane(this.pnlInfractionS);
            Transport.ps.endOperation(PerformanceScanner.READING, "offence tab");
        }
        if (Transport.conn.isConsultable(FICHE_VEHICULE) && LicenceManager.isExploitationLevel() && ArbreDonnees.typeAffichage == 2) {
            Transport.ps.startOperation();
            this.pnlVehiculeAgence = new PnlVehiculeAgence(current);
            this.mainPane.addViewPane(this.pnlVehiculeAgence);
            Transport.ps.endOperation(PerformanceScanner.READING, "vehicle tab");
        }
        if (Transport.conn.isConsultable(FICHE_CONDUCTEUR) && LicenceManager.isExploitationLevel() && ArbreDonnees.typeAffichage == 1) {
            Transport.ps.startOperation();
            this.pnlConducteurAgence = new PnlConducteurAgence(current);
            this.mainPane.addViewPane(this.pnlConducteurAgence);
            Transport.ps.endOperation(PerformanceScanner.READING, "driver tab");
        }
        if (Transport.conn.isConsultable(FICHE_PLANNING) && LicenceManager.isHRLevel()) {
            Transport.ps.startOperation();
            this.pnlPlanningAgence = new PnlPlanningAgence(current);
            this.mainPane.addViewPane(this.pnlPlanningAgence);
            Transport.ps.endOperation(PerformanceScanner.READING, "planning tab");
        }
        if (Transport.conn.isConsultable(FICHE_TOURNEE) && LicenceManager.isHRLevel()) {
            Transport.ps.startOperation();
            this.pnlRoundAgency = new PnlRoundAgency(current);
            this.mainPane.addViewPane(this.pnlRoundAgency);
            Transport.ps.endOperation(PerformanceScanner.READING, "round tab");
        }
        if (ConnexionSettings.getInstance().isConsultable(FICHE_CONSOMMATION) && LicenceManager.isModuleEnable(LicenceManager.MODULE_CONSUMPTION)) {
            Transport.ps.startOperation();
            this.getPnlConsoAgence().set(current);
            this.mainPane.addViewPane(this.getPnlConsoAgence());
            Transport.ps.endOperation(PerformanceScanner.READING, "consumption tab", "#MFT.afficheAgence# conso : %s");
        }
        if (Transport.conn.isConsultable(FICHE_POSITION) && LicenceManager.isExploitationLevel()) {
            this.getPnlPositionAgency().set(current);
            this.mainPane.addViewPane(this.getPnlPositionAgency());
        }
        this.typeSelection = 3;
        this.mainPane.setSelectedIndex(this.indexAgencyViewSelected);
        Transport.ps.endOperation(PerformanceScanner.READING, "agency");
    }

    public void afficheAccueil() {
        Transport.ps.startOperation();
        this.mainPane.removeAll();
        if (Transport.conn.isConsultable(FICHE_TABLEAUBORD)) {
            this.getPnlAccueil().reload();
            this.mainPane.addViewPane(this.getPnlAccueil());
        }
        Transport.ps.endOperation(PerformanceScanner.READING, "dashboard");
    }

    public void afficheConducteur(int driverId) {
        Transport.ps.startOperation();
        TimsLogger.info("#MFT# affichage du conducteur n\u00b0" + driverId);
        this.typeSelection = 0;
        Conducteur current = new Conducteur(driverId);
        this.mainPane.removeAll();
        if (Transport.conn.isConsultable(FICHE_CONDUCTEUR)) {
            this.getPnlConducteurC().setConducteur(current);
            this.mainPane.addViewPane(this.getPnlConducteurC());
        }
        if (Transport.conn.isConsultable(FICHE_ACTIVITE)) {
            this.getPnlActiviteC().setDB(Transport.bdd, current);
            this.getPnlActiviteC().setActiv(ConversionTime.getFirstDayOfPreviousWeek(ConversionTime.stringToDate(current.getLastWorkedDay(), "yyyy-MM-dd"), 1));
            this.mainPane.addViewPane(this.getPnlActiviteC());
        }
        if (Transport.conn.isConsultable(FICHE_INFRACTION) && LicenceManager.isExploitationLevel()) {
            this.getPnlInfractionC().setConducteur(current);
            this.mainPane.addViewPane(this.getPnlInfractionC());
        }
        if (Transport.conn.isConsultable(FICHE_ACCIDENT) && LicenceManager.isModuleEnable(LicenceManager.MODULE_ACCIDENT)) {
            this.getPnlAccident().set(current, null);
            this.mainPane.addViewPane(this.getPnlAccident());
        }
        TimsLogger.debug("Transport.conn.isConsultable(MainFrameTransport.FICHE_CONSOMMATION) = " + Transport.conn.isConsultable(FICHE_CONSOMMATION), "MFT");
        TimsLogger.debug("LicenceManager.isModuleEnable(LicenceManager.MODULE_CONSUMPTION) = " + LicenceManager.isModuleEnable(LicenceManager.MODULE_CONSUMPTION), "MFT");
        if (Transport.conn.isConsultable(FICHE_CONSOMMATION) && LicenceManager.isModuleEnable(LicenceManager.MODULE_CONSUMPTION)) {
            this.getPnlConso().setConducteur(current);
            this.mainPane.addViewPane(this.getPnlConso());
        }
        this.typeSelection = 1;
        this.mainPane.setSelectedIndex(this.indexDriverViewSelected);
        Transport.ps.endOperation(PerformanceScanner.READING, "driver");
    }

    public void setActiviteConducteur(String dateJour, String format) {
        this.mainPane.setSelectedIndex(1);
        this.pnlActiviteC.setActiv(ConversionTime.stringToDate(dateJour, format));
        this.pnlActiviteC.load = false;
        this.pnlActiviteC.loadData();
    }

    public void majTabC() {
        this.pnlActiviteC.refresh();
    }

    public void afficheVehicule(Vehicule vehicle) {
        TimsLogger.info("#MFT# Affichage du v\u00e9hicule n\u00b0" + vehicle.getCleVehicule());
        vehicle.loadById(vehicle.getCleVehicule());
        Transport.ps.startOperation();
        this.typeSelection = 0;
        this.mainPane.removeAll();
        if (Transport.conn.isConsultable(FICHE_VEHICULE)) {
            this.getPnlVehicule().setVehicle(vehicle);
            this.mainPane.addViewPane(this.getPnlVehicule());
        }
        if (Transport.conn.isConsultable(FICHE_ACTIVITE)) {
            this.pnlActiviteUEV = new PnlActiviteUEV(vehicle);
            this.getPnlActiviteUEV().setVehicle(vehicle);
            this.getPnlActiviteUEV().setAffichage(vehicle.getLastDay());
            this.mainPane.addViewPane(this.pnlActiviteUEV);
        }
        this.getPnlIO().setVehicle(vehicle);
        this.mainPane.addViewPane(this.getPnlIO());
        this.getPnlEventsFaultsUev().setVehicle(vehicle);
        this.mainPane.addViewPane(this.getPnlEventsFaultsUev());
        this.getPnlSpeedUEV().setVehicle(vehicle);
        this.mainPane.addViewPane(this.getPnlSpeedUEV());
        this.getPnlEtalonnage().setVehicle(vehicle);
        this.mainPane.addViewPane(this.getPnlEtalonnage());
        this.typeSelection = 2;
        if (Transport.conn.isConsultable(FICHE_ACCIDENT) && LicenceManager.isModuleEnable(LicenceManager.MODULE_ACCIDENT)) {
            this.getPnlAccident().set(null, vehicle);
            this.mainPane.addViewPane(this.getPnlAccident());
        }
        if (Transport.conn.isConsultable(FICHE_CONSOMMATION) && LicenceManager.isModuleEnable(LicenceManager.MODULE_CONSUMPTION)) {
            this.getPnlConsoVehicule().setVehicle(vehicle);
            this.mainPane.addViewPane(this.getPnlConsoVehicule());
        }
        this.mainPane.setSelectedIndex(this.indexVehicleViewSelected);
        Transport.ps.endOperation(PerformanceScanner.READING, "vehicle", "#MFT.afficheVehicule# total : %s");
    }

    public PnlVehicule getPnlVehicule() {
        if (this.pnlVehicule == null) {
            this.pnlVehicule = new PnlVehicule();
        }
        return this.pnlVehicule;
    }

    private PnlActiviteUEV getPnlActiviteUEV() {
        if (this.pnlActiviteUEV == null) {
            this.pnlActiviteUEV = new PnlActiviteUEV();
        }
        return this.pnlActiviteUEV;
    }

    public void setActiviteVehicule(String dateJour) {
        this.mainPane.setSelectedIndex(1);
        this.pnlActiviteUEV.setAffichage(dateJour);
    }

    private PnlEventsFaultsUev getPnlEventsFaultsUev() {
        if (this.pnlEventsFaultsUev == null) {
            this.pnlEventsFaultsUev = new PnlEventsFaultsUev();
        }
        return this.pnlEventsFaultsUev;
    }

    public PnlInputOutput getPnlIO() {
        if (this.pnlInputOutput == null) {
            this.pnlInputOutput = new PnlInputOutput();
        }
        return this.pnlInputOutput;
    }

    private PnlAccident getPnlAccident() {
        if (this.pnlAccident == null) {
            this.pnlAccident = new PnlAccident();
        }
        return this.pnlAccident;
    }

    public PnlEtalonnage getPnlEtalonnage() {
        if (this.pnlEtalonnage == null) {
            this.pnlEtalonnage = new PnlEtalonnage();
        }
        return this.pnlEtalonnage;
    }

    private PnlDriverConsumption getPnlConso() {
        if (this.pnlConsumption == null) {
            this.pnlConsumption = new PnlDriverConsumption();
        }
        return this.pnlConsumption;
    }

    private PnlVehicleConsumption getPnlConsoVehicule() {
        if (this.pnlVehicleConso == null) {
            this.pnlVehicleConso = new PnlVehicleConsumption();
        }
        return this.pnlVehicleConso;
    }

    private PnlAgencyConsumption getPnlConsoAgence() {
        if (this.pnlAgencyConsumption == null) {
            this.pnlAgencyConsumption = new PnlAgencyConsumption();
        }
        return this.pnlAgencyConsumption;
    }

    public PnlAgencyPosition getPnlPositionAgency() {
        if (this.pnlAgencyPosition == null) {
            this.pnlAgencyPosition = new PnlAgencyPosition();
        }
        return this.pnlAgencyPosition;
    }

    @Override
    public void showAPropo() {
        Object[] opt = new Object[]{LanguageTranslator.getString("license.reinit"), LanguageTranslator.getString("button.ok")};
        String module = "";
        if (LicenceManager.isModuleEnable(LicenceManager.MODULE_ACCIDENT)) {
            module = String.valueOf(module) + LanguageTranslator.getString("licence.activateModule", LanguageTranslator.getString("accident")) + "<br/>";
        }
        if (LicenceManager.isModuleEnable(LicenceManager.MODULE_CONSUMPTION)) {
            module = String.valueOf(module) + LanguageTranslator.getString("licence.activateModule", LanguageTranslator.getString("consumption")) + "<br/>";
        }
        String eval = "";
        if (LicenceManager.EVALUATION_LEFT_DAY != 10000) {
            String dayLeft = String.valueOf(LicenceManager.EVALUATION_LEFT_DAY);
            eval = "<b>" + LanguageTranslator.getString("license.evaluation", dayLeft) + "</b><br/>";
        }
        String content = "<html>" + eval + LanguageTranslator.getString("main.version", Transport.res.getResourceString("executableVersion"), LicenceManager.getVersionLevel()) + "<br/>" + (LicenceManager.COMPANY_AUTHORIZED != 10000 ? String.valueOf(LanguageTranslator.getString("license.limit.company", String.valueOf(LicenceManager.COMPANY_AUTHORIZED))) + "<br/>" : "") + (LicenceManager.AGENCY_AUTHORIZED != 10000 ? String.valueOf(LanguageTranslator.getString("license.limit.agency", String.valueOf(LicenceManager.AGENCY_AUTHORIZED))) + "<br/>" : "") + (LicenceManager.DRIVER_AUTHORIZED != 10000 ? String.valueOf(LanguageTranslator.getString("license.limit.driver", String.valueOf(LicenceManager.DRIVER_AUTHORIZED))) + "<br/>" : "") + (!module.equals("") ? String.valueOf(module) + "<br/>" : "") + "n\u00b0 client : " + LicenceManager.getInstance().getClient() + "</html>";
        JLabel version = new JLabel(content);
        JPanel message = new JPanel();
        message.add((Component)version, "North");
        SynchronizedOptionDialog tmp = new SynchronizedOptionDialog(message, LanguageTranslator.getString("main.about"), new ImageIcon(appli.getIconImage()), opt);
        tmp.run();
        if (tmp.option == 0) {
            SynchronizedOptionDialog reinit = new SynchronizedOptionDialog(LanguageTranslator.getString("license.reinit.confirm"), LanguageTranslator.getString("license.reinit"));
            reinit.run();
            if (reinit.option == 0) {
                Preferences p = Preferences.userRoot().node("TIMS");
                p.remove("Licence");
            }
        }
    }

    public void showLicence() {
    }

    public void createDialogScan() {
        this.dialogScan = DialogScan.getInstance();
        if (this.dialogScan.loadLibrary()) {
            this.dialogScan.setAgence();
            this.dialogScan.setVisible(true);
        } else {
            MessageSystemManager.error((Component)this, Fonctions.isJava64() ? LanguageTranslator.getString("scan.init.64bits") : LanguageTranslator.getString("scan.init.error"), LanguageTranslator.getString("generic.initialization"));
        }
    }

    public void createDialogNewCompany() {
        if (Societe.loadList(null).size() < LicenceManager.COMPANY_AUTHORIZED) {
            DialogCompany pnl2 = new DialogCompany((Frame)appli, null);
            pnl2.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(appli, LanguageTranslator.getString("company.maxExceeded", String.valueOf(LicenceManager.COMPANY_AUTHORIZED)), LanguageTranslator.getString("message.numberedError", "71"), 0, new ImageIcon(appli.getIconImage()));
        }
    }

    public void createDialogAgence() {
        if (Agence.getList().size() < LicenceManager.AGENCY_AUTHORIZED) {
            DialogCreationAgence tmp = new DialogCreationAgence(this);
            tmp.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(appli, LanguageTranslator.getString("agency.maxExceeded", String.valueOf(LicenceManager.AGENCY_AUTHORIZED)), LanguageTranslator.getString("message.numberedError", "81"), 0, new ImageIcon(appli.getIconImage()));
        }
    }

    public void createDialogRegion() {
        DialogRegion tmp = new DialogRegion(this);
        tmp.setVisible(true);
    }

    public void createDialogChangerSociete() {
        new DialogCompanyList(this);
    }

    public void createDialogAdministrationProfil() {
        Transport.ps.startOperation();
        DialogAdministrationProfil pnlAdminP = new DialogAdministrationProfil(appli);
        pnlAdminP.setVisible(true);
        Transport.ps.endOperation(PerformanceScanner.READING, "profile admin");
    }

    public void createDialogAdministrationRapport() {
        Transport.ps.startOperation();
        DialogAdministrationRapport pnlAdminR = new DialogAdministrationRapport(appli);
        pnlAdminR.setVisible(true);
        Transport.ps.endOperation(PerformanceScanner.READING, "report admin");
    }

    public void createDialogAdministrationUtilisateur() {
        DialogAdministrationUtilisateur pnlAdminU = new DialogAdministrationUtilisateur(appli);
        pnlAdminU.setVisible(true);
    }

    public void createDialogDetailUser() {
        DetailUserConnexion user = new DetailUserConnexion(this);
        user.setVisible(true);
    }

    public PnlDetailConducteur getPnlConducteurC() {
        if (this.pnlConducteur == null) {
            this.pnlConducteur = new PnlDetailConducteur();
        }
        return this.pnlConducteur;
    }

    public PnlActiviteC getPnlActiviteC() {
        this.pnlActiviteC = PnlActiviteC.getInstance();
        return this.pnlActiviteC;
    }

    public PnlInfractionCond getPnlInfractionC() {
        if (this.pnlInfractionC == null) {
            this.pnlInfractionC = new PnlInfractionCond();
        }
        return this.pnlInfractionC;
    }

    public PnlSpeedUEV getPnlSpeedUEV() {
        if (this.pnlSpeedUEV == null) {
            this.pnlSpeedUEV = new PnlSpeedUEV();
        }
        return this.pnlSpeedUEV;
    }

    public PnlAccueil getPnlAccueil() {
        if (this.pnlAccueil == null) {
            this.pnlAccueil = new PnlAccueil();
        }
        return this.pnlAccueil;
    }

    public void majPnlAccueil() {
        this.getPnlAccueil();
        this.afficheAccueil();
    }

    public void createDialogConducteur() {
        if (Conducteur.loadList(new Integer[0]).size() < LicenceManager.DRIVER_AUTHORIZED) {
            DialogCreationConducteur tmp = new DialogCreationConducteur((Frame)this, null);
            tmp.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(appli, LanguageTranslator.getString("driver.maxExceeded", String.valueOf(LicenceManager.DRIVER_AUTHORIZED)), LanguageTranslator.getString("message.numberedError", "91"), 0, new ImageIcon(appli.getIconImage()));
        }
    }

    public void createDialogVehicule() {
        DialogCreationVehicule vehic = new DialogCreationVehicule((Frame)this, null);
        vehic.setVisible(true);
    }

    public void createDialogSupprimerVehicule() {
        new DialogSupprimerVehicule(this).setVisible(true);
    }

    public void createDialogDBox() {
        DBox threadDechargement = new DBox();
        threadDechargement.start();
    }

    public void createDialogDBoxCfg() {
        DialogConfigurationDBox threadDechargement = new DialogConfigurationDBox(this);
        threadDechargement.setVisible(true);
    }

    public void createDialogPays() {
        DialogPays pnl = new DialogPays(appli);
        pnl.setBddPays(Transport.bdd);
        pnl.setVisible(true);
    }

    public void createDialogSupprimerSoc() {
        new DialogCompanyList(this);
    }

    public void createDialogSupprimerAgence() {
        DialogSupprimerAgence pnl = new DialogSupprimerAgence(appli);
        pnl.setBddSupprimerSoc(Transport.bdd);
        pnl.setVisible(true);
    }

    public void createDialogSupprimerCond() {
        new DialogSupprimerConducteur(this).setVisible(true);
    }

    public void createDialogRegleFrais() {
        new DialogTypeFrais(this).setVisible(true);
    }

    public void createDialogTelechargementUEV() {
        Transport.ps.startOperation();
        new DialogTelechargementDonneesUEV(MainFrameTransport.getInstance()).setVisible(true);
        Transport.ps.endOperation(PerformanceScanner.READING, "UEV download");
    }

    public void createDialogTelechargement() {
        Transport.ps.startOperation();
        new DialogTelechargementDonneesConducteur(MainFrameTransport.getInstance()).setVisible(true);
        Transport.ps.endOperation(PerformanceScanner.READING, "card download");
    }

    public void createDialogTypeContrat() {
        DialogTypeContrat pnl = new DialogTypeContrat(this);
        pnl.setVisible(true);
    }

    public void createDialogTypeActivite() {
        test = 15;
        DialogTypeActivite typeActivite = new DialogTypeActivite(this);
        typeActivite.setVisible(true);
    }

    public void createDialogTypeJournee() {
        new DialogTypeJournee(this).setVisible(true);
    }

    public void createDialogCalendrier() {
        ElementArbre filter = this.getTree().getSelected();
        Transport.ps.startOperation();
        NewDialogCalendrier cld = new NewDialogCalendrier(this);
        if (filter != null) {
            if (filter instanceof Conducteur) {
                cld.setDriver((Conducteur)filter);
            }
            if (filter instanceof Agence) {
                cld.setAgency((Agence)filter);
            }
        }
        cld.setVisible(true);
        Transport.ps.endOperation(PerformanceScanner.READING, "calendar");
    }

    public void createDialogGlobalCalendrier() {
        Transport.ps.startOperation();
        new DialogGlobalCalendar(this).setVisible(true);
        Transport.ps.endOperation(PerformanceScanner.READING, "calendar");
    }

    public void createDialogPayPeriod() {
        Transport.ps.startOperation();
        new DialogPayPeriod(this).setVisible(true);
        Transport.ps.endOperation(PerformanceScanner.READING, "pay period");
    }

    public void closeAgencyPeriod() {
        if (this.getTree().getSelected() == null || !(this.getTree().getSelected() instanceof Agence) || this.getTree().getSelected().getCle() == 0) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("payPeriod.noAgencySelected"), LanguageTranslator.getString("generics.error"), 0);
            return;
        }
        if (Integer.parseInt(System.getProperty("pay_period_close_type", String.valueOf(1))) == 2) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("payPeriod.agencyCloseDisabled"), LanguageTranslator.getString("generics.error"), 0);
            return;
        }
        Agence agency = new Agence(this.getTree().getSelected().getCle());
        Vector<Agence> toClose = new Vector<Agence>();
        toClose.add(agency);
        Vector<PayPeriod> list = PayPeriod.loadList(toClose);
        if (list.size() == 0) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("payPeriod.noneToClose"), LanguageTranslator.getString("generics.error"), 0);
        } else if (list.get(0).getEnd().after(new Date())) {
            Object[] options = new String[]{LanguageTranslator.getString("payPeriod.forceClose", list.get(0).getName()), LanguageTranslator.getString("payPeriod.export"), LanguageTranslator.getString("generics.cancel")};
            int choice = JOptionPane.showOptionDialog(this, LanguageTranslator.getString("payPeriod.currentPeriod", list.get(0).getName(), ConversionTime.dateToString(list.get(0).getEnd(), "dd/MM/yyyy")), LanguageTranslator.getString("generics.alert"), 2, 2, null, options, null);
            switch (choice) {
                case 0: {
                    new ActivityToCcmx(toClose, list.get(0)).start();
                    break;
                }
                case 1: {
                    PayPeriod toExport = null;
                    for (PayPeriod tmp : PayPeriod.getList()) {
                        if (tmp.equals(list.get(0))) break;
                        toExport = tmp;
                    }
                    new ActivityToCcmx(toClose, toExport).start();
                    break;
                }
            }
        } else if (JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("payPeriod.closeConfirmation", list.get(0).getName()), LanguageTranslator.getString("message.confirm"), 2) == 0) {
            new ActivityToCcmx(toClose, list.get(0)).start();
        }
    }

    public void closeRegionPayPeriod() {
        if (this.getTree().getSelected() == null || !(this.getTree().getSelected() instanceof Region) || this.getTree().getSelected().getCle() == 0) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("payPeriod.noRegionSelected"), LanguageTranslator.getString("generics.error"), 0);
            return;
        }
        if (Integer.parseInt(System.getProperty("pay_period_close_type", String.valueOf(1))) == 1) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("payPeriod.regionCloseDisabled"), LanguageTranslator.getString("generics.error"), 0);
            return;
        }
        Vector<Agence> agencies = Agence.loadList(null, this.getTree().getSelected().getCle());
        HashMap<PayPeriod, Integer> list = PayPeriod.loadResumeList(agencies);
        PayPeriod toClose = null;
        for (PayPeriod tmp : PayPeriod.getList()) {
            if (list.get(tmp).intValue() != agencies.size()) {
                TimsLogger.debug("#MFT.closeRegionPeriod# " + tmp.getName() + " isn't closed for all agencies (only " + list.get(tmp) + " of " + agencies.size() + " closed)");
                toClose = tmp;
                break;
            }
            TimsLogger.debug("#MFT.closeRegionPeriod# " + tmp.getName() + " is closed for all agencies");
        }
        if (toClose == null) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("payPeriod.noneToClose"), LanguageTranslator.getString("generics.error"), 0);
        } else if (toClose.getEnd().after(new Date())) {
            Object[] options = new String[]{LanguageTranslator.getString("payPeriod.forceClose", toClose.getName()), LanguageTranslator.getString("payPeriod.export"), LanguageTranslator.getString("generics.cancel")};
            int choice = JOptionPane.showOptionDialog(this, LanguageTranslator.getString("payPeriod.currentPeriod", toClose.getName(), ConversionTime.dateToString(toClose.getEnd(), "dd/MM/yyyy")), LanguageTranslator.getString("generics.alert"), 2, 2, null, options, null);
            switch (choice) {
                case 0: {
                    try {
                        PayPeriodCloser ppc = null;
                        String closerClass = System.getProperty("pay.period.closer", "NONE");
                        if (!"NONE".equals(System.getProperty("pay.period.closer", "NONE"))) {
                            Class<?> c = Class.forName(closerClass);
                            ppc = (PayPeriodCloser)c.newInstance();
                            ppc.setAgencies(agencies);
                            ppc.setPeriod(toClose);
                            ppc.start();
                            while (ppc.getStatus() == 256) {
                            }
                            if (ppc.getStatus() == 1) {
                                JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("payPeriod.closeDone"), LanguageTranslator.getString("message.done"), 1);
                            } else {
                                JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), ppc.getResult(), LanguageTranslator.getString("error.numberedError", String.valueOf(ppc.getStatus())), 0);
                            }
                        } else {
                            TimsLogger.warn("No closer set");
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (InstantiationException ex) {
                        ex.printStackTrace();
                    }
                    new ActivityToCcmx(agencies, toClose).start();
                    break;
                }
                case 1: {
                    PayPeriod toExport = null;
                    for (PayPeriod tmp : PayPeriod.getList()) {
                        if (tmp.equals(toClose)) break;
                        toExport = tmp;
                    }
                    new ActivityToCcmx(agencies, toExport).start();
                    break;
                }
            }
        } else if (JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("payPeriod.closeConfirmation", toClose.getName()), LanguageTranslator.getString("message.confirm"), 2) == 0) {
            new ActivityToCcmx(agencies, toClose).start();
        }
    }

    public void createDialogRapport() {
        new DialogRapport(appli, Transport.bdd);
    }

    public void createDialogRate() {
        new DialogRate(this).setVisible(true);
    }

    public void createDialogRF() {
        new OffenceRules((Frame)this, Pays.getPays(LanguageTranslator.getString("FRANCE")).getCle()).setVisible(true);
    }

    public void createDialogRSE() {
        new OffenceRules((Frame)this, 0).setVisible(true);
    }

    public void createDialogExportVehicule() {
        new DialogExportVehicule((Frame)this, Transport.bdd).setVisible(true);
    }

    public void createDialogImportVehicule() {
        File[] tmp = VehicleImport.getFile(LanguageTranslator.getString("export.path"), LanguageTranslator.getString("button.import"), false, null);
        VehicleImport imp = new VehicleImport(tmp);
        if (!imp.run()) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.error"), LanguageTranslator.getString("message.error"), 0);
        } else {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.done"), LanguageTranslator.getString("message.done"), 1);
        }
    }

    public void createDialogExportConducteur() {
        new DialogExportConducteur((Frame)this, Transport.bdd).setVisible(true);
    }

    public void importDriver() {
        File[] tmp = DriverImport.getFile(LanguageTranslator.getString("export.path"), LanguageTranslator.getString("button.import"), false, null);
        DriverImport imp = new DriverImport(tmp);
        if (!imp.run()) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.error"), LanguageTranslator.getString("message.error"), 0);
        } else {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.done"), LanguageTranslator.getString("message.done"), 1);
        }
    }

    public void calculInfraction() {
        new DialogInfraction(this).setVisible(true);
    }

    protected void createMenuBar() {
        try {
            StringTokenizer menuString = new StringTokenizer(Transport.res.getResourceString("menu"), MENU_SEPARATOR);
            if (menuString.countTokens() == 0) {
                return;
            }
            JMenuBar menuBar = new JMenuBar();
            while (menuString.hasMoreTokens()) {
                String idMenu = "menu." + menuString.nextToken();
                String translation = LanguageTranslator.getString(idMenu).trim();
                int idxMnemo = translation.indexOf(MENU_MNEMO_PREF);
                translation = translation.replace(MENU_MNEMO_PREF, "");
                JMenu menu = new JMenu(translation);
                if (idxMnemo >= 0) {
                    menu.setMnemonic(translation.charAt(idxMnemo));
                }
                if (this.createMenu(menu, idMenu) <= 0) continue;
                menuBar.add(menu);
            }
            this.setJMenuBar(menuBar);
        }
        catch (Exception ex) {
            TimsLogger.warn("transpo.system.ui.MainFrameTransport.initMenuBar() error");
            ex.printStackTrace();
        }
    }

    protected int createMenu(JMenuItem menu, String idMenu) {
        TimsLogger.verbose("#MFT.createMenu# calling for super.menu " + menu.getText() + " and idMenu " + idMenu);
        int nbMenu = 0;
        try {
            StringTokenizer menuString = new StringTokenizer(Transport.res.getResourceString(idMenu), MENU_SEPARATOR);
            while (menuString.hasMoreTokens()) {
                nbMenu += this.createSubMenu(menu, String.valueOf(idMenu) + "." + menuString.nextToken());
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("\ttranspo.system.ui.MainFrameTransport.createMenu( menu )  : ");
            ex.printStackTrace();
        }
        if (idMenu.equals("menu.file")) {
            try {
                JMenuItem menuItem = new JMenuItem("maintenance toute soci\u00e9t\u00e9");
                AbstractAction act = (AbstractAction)Class.forName("transpo.system.ui.actions.Maintenance").newInstance();
                act.putValue("appli", this);
                act.putValue("bdd", Transport.bdd);
                menuItem.addActionListener(act);
                menuItem.setEnabled(act.isEnabled());
                menu.add(menuItem);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        TimsLogger.verbose("#MFT.createMenu# end call for super.menu " + menu.getText() + " and idMenu " + idMenu);
        return nbMenu;
    }

    protected int createSubMenu(JMenuItem menu, String idSmenu) throws Exception {
        int nbMenu;
        block24: {
            int module;
            int versionMinimum;
            boolean affiche;
            StringTokenizer parameters;
            int idxMnemo;
            String translation;
            block23: {
                block22: {
                    TimsLogger.info("\t#MFT.createSubMenu# calling for menu " + idSmenu);
                    TimsLogger.verbose("\t#MFT.createSubMenu# calling for menu " + idSmenu);
                    nbMenu = 0;
                    translation = LanguageTranslator.getString(idSmenu).trim();
                    idxMnemo = translation.indexOf(MENU_MNEMO_PREF);
                    translation = translation.replace(MENU_MNEMO_PREF, "");
                    if (Transport.res.getResourceString(idSmenu) != null) break block22;
                    TimsLogger.warn("\t#MFT.createSubMenu# " + idSmenu + " has no parameters");
                    return 0;
                }
                parameters = new StringTokenizer(Transport.res.getResourceString(idSmenu), MENU_SEPARATOR);
                affiche = false;
                versionMinimum = 0;
                module = -1;
                if (parameters != null && parameters.countTokens() != 0) break block23;
                TimsLogger.warn("\t#MFT.createMenu#submenu error, no parameters whereas 1,2 or 4 was expected for " + idSmenu);
                return 0;
            }
            try {
                String type = parameters.nextToken();
                String action = parameters.nextToken();
                if (parameters.countTokens() == 0) {
                    affiche = true;
                } else if (parameters.countTokens() < 3) {
                    affiche = true;
                    versionMinimum = Integer.parseInt(parameters.nextToken());
                    if (parameters.hasMoreTokens()) {
                        TimsLogger.verbose("\t#MFT.createSubMenu# module enable");
                        module = Integer.parseInt(parameters.nextToken());
                    }
                } else if (parameters.countTokens() >= 3) {
                    String fonction = parameters.nextToken();
                    String fiche = parameters.nextToken();
                    versionMinimum = Integer.parseInt(parameters.nextToken());
                    if (parameters.hasMoreTokens()) {
                        TimsLogger.info("\t#MFT.createSubMenu# module enable");
                        TimsLogger.verbose("\t#MFT.createSubMenu# module enable");
                        module = Integer.parseInt(parameters.nextToken());
                    }
                    if (fonction.equals("C")) {
                        affiche = Transport.conn.isAjoutable(fiche);
                    }
                    if (fonction.equals("V")) {
                        affiche = Transport.conn.isConsultable(fiche);
                    }
                    if (fonction.equals("M")) {
                        affiche = Transport.conn.isModifiable(fiche);
                    }
                    if (fonction.equals("S")) {
                        affiche = Transport.conn.isSupprimable(fiche);
                    }
                }
                if (affiche && versionMinimum <= LicenceManager.getInstance().level && (module == -1 || LicenceManager.isModuleEnable(module))) {
                    TimsLogger.info("\t#MFT.createSubMenu# creating menu " + idSmenu);
                    TimsLogger.verbose("\t#MFT.createSubMenu# creating menu " + idSmenu);
                    JMenuItem menuItem = null;
                    menuItem = type.equals("2") ? new JCheckBoxMenuItem(translation) : (type.equals("1") ? new JMenuItem(translation) : new JMenu(translation));
                    if (idxMnemo >= 0) {
                        menuItem.setMnemonic(translation.charAt(idxMnemo));
                    }
                    if (!type.equals("0")) {
                        AbstractAction act = (AbstractAction)Class.forName("transpo.system.ui.actions." + action).newInstance();
                        act.putValue("appli", this);
                        act.putValue("bdd", Transport.bdd);
                        menuItem.addActionListener(act);
                        menuItem.setActionCommand(translation);
                        menuItem.setEnabled(act.isEnabled());
                        TimsLogger.info("\t#MFT.createSubMenu# menu " + idSmenu + " created with action " + "transpo.system.ui.actions." + action);
                        TimsLogger.verbose("\t#MFT.createSubMenu# menu " + idSmenu + " created with action " + "transpo.system.ui.actions." + action);
                    } else {
                        try {
                            StringTokenizer subMenus = new StringTokenizer(Transport.res.getResourceString(String.valueOf(idSmenu) + ".sub"), MENU_SEPARATOR);
                            while (subMenus.hasMoreTokens()) {
                                nbMenu += this.createSubMenu(menuItem, String.valueOf(idSmenu) + "." + subMenus.nextToken());
                            }
                        }
                        catch (Exception ex) {
                            TimsLogger.warn("#MFT.createSubMenu# impossible de trouver " + idSmenu + ".sub");
                        }
                    }
                    menu.add(menuItem);
                    ++nbMenu;
                    break block24;
                }
                TimsLogger.info("\t#MFT.createSubMenu# menu " + idSmenu + " doesn't complete all requirements (" + affiche + MENU_SEPARATOR + (versionMinimum <= LicenceManager.getInstance().level) + MENU_SEPARATOR + (module == -1 || LicenceManager.isModuleEnable(module)) + ")");
                TimsLogger.verbose("\t#MFT.createSubMenu# menu " + idSmenu + " doesn't complete all requirements (" + affiche + MENU_SEPARATOR + (versionMinimum <= LicenceManager.getInstance().level) + MENU_SEPARATOR + (module == -1 || LicenceManager.isModuleEnable(module)) + ")");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        TimsLogger.info("\t#MFT.createSubMenu# end call for menu " + idSmenu);
        TimsLogger.verbose("\t#MFT.createSubMenu# end call for menu " + idSmenu);
        return nbMenu;
    }

    public void refreshTree(int type) {
        this.getTree().setType(type);
    }

    public void createReport() {
        Vector<Agence> agency = Agence.loadList(null, 0);
        Agence t = new Agence();
        t.loadById(13);
        agency.add(t);
        Vector<Conducteur> driver = Conducteur.loadList(0);
        Conducteur c = new Conducteur();
        c.loadById(242);
        try {
            String destination = null;
            JFileChooser choix = new JFileChooser();
            choix.setFileSelectionMode(1);
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                destination = choix.getSelectedFile().getAbsolutePath();
            }
            DynamicGeneric mr = new TimeToCcmxCayon(destination);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("BEGIN", ConversionTime.stringToDate2("01/09/2010", "dd/MM/yyyy"));
            parameters.put("END", ConversionTime.stringToDate2("30/09/2010", "dd/MM/yyyy"));
            ((MasterReport)mr).setValues(new ProgressBar(this, "tmp"), new Report(0, "test", "test", "templatePortrait.jrxml", "transport.report.TimeToCcmxCayon", 3, -1, 1), agency, driver, null, parameters);
            ((MasterReport)mr).process();
            mr = new DayToCcmxCayon(destination);
            ((MasterReport)mr).setValues(new ProgressBar(this, "tmp"), new Report(0, "test", "test", "templatePortrait.jrxml", "transport.report.DayToCcmxCayon", 3, -1, 1), agency, driver, null, parameters);
            ((MasterReport)mr).process();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("report.error", ex.toString()), LanguageTranslator.getString("message.numberedError", String.valueOf(6)), 2);
            System.err.println("erreur de g\u00e9n\u00e9ration rapport " + ex);
            ex.printStackTrace();
        }
    }

    public void createDialogPreferences() {
        new DialogPreferences(this).setVisible(true);
    }

    public void createInterv() {
        for (Vehicule tmp : Vehicule.loadList(0)) {
            int id = 1;
            while (id <= 5) {
                int nb = 5 + (int)(Math.random() * 10.0);
                int x = 0;
                while (x < nb) {
                    Date day = new Date();
                    int minus = (int)(Math.random() * 800.0);
                    day = ConversionTime.add(day, 5, -(30 + minus));
                    TimsLogger.verbose("adding on " + tmp.getCleVehicule() + " the " + day);
                    new Intervention(0, id, tmp.getCleVehicule(), day, 123000, "sg", 10.0f, 10.0f, 0, null).insert();
                    ++x;
                }
                ++id;
            }
        }
    }

    public void createObligation() {
        for (Conducteur tmp : Conducteur.loadList(0)) {
            int id = 1;
            while (id <= 5) {
                int nb = 5 + (int)(Math.random() * 10.0);
                int x = 0;
                while (x < nb) {
                    Date day = new Date();
                    int minus = (int)(Math.random() * 500.0);
                    day = ConversionTime.add(day, 5, -(30 + minus));
                    TimsLogger.verbose("adding on " + tmp.getCleConducteur() + " the " + day);
                    new EmployeeObligation(0, id, tmp.getCleConducteur(), day, null, 60, "lyon", "", 10.0f, 0, null).insert();
                    ++x;
                }
                ++id;
            }
        }
    }

    public void testCFSV2() {
        CopyOfCopyFileServeur2.getInstance().add(new File("c:\\test1.JPG\\"), "http://application.pgh.fr/upload.php?path=test&check=test", false);
        CopyOfCopyFileServeur2.getInstance().add(new File("c:\\test2.JPG\\"), "http://application.pgh.fr/upload.php?path=test&check=test", false);
        CopyOfCopyFileServeur2.getInstance().add(new File("c:\\test3.JPG\\"), "http://application.pgh.fr/upload.php?path=test&check=test", false);
    }

    public void createDialogDecodeDBox() {
        final JFileChooser choix = new JFileChooser();
        choix.setFileSelectionMode(0);
        choix.setMultiSelectionEnabled(true);
        choix.setDialogTitle("Selectionner le fichier \u00e0 decoder");
        choix.setApproveButtonText("decoder");
        if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        JDBox download = new JDBox();
                        download.decodeFichier(choix.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("mainframetransport.createDialogDecodeDBox(  )  : " + ex);
                        ex.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public static void checkDatabase(String structurePath, String destinationFile) {
        Vector<Societe> tmp = Societe.loadList(null);
        try {
            File up;
            if (structurePath == null || destinationFile == null) {
                JFileChooser choix = new JFileChooser(System.getProperty("user.home"));
                choix.setFileSelectionMode(1);
                choix.setDialogTitle("Selectionner le reperoire ou se trouvent les structures a respecter");
                choix.setApproveButtonText("Verifier");
                if (choix.showOpenDialog(MainFrameTransport.getInstance()) != 0) {
                    return;
                }
                structurePath = choix.getSelectedFile().getAbsolutePath();
                destinationFile = choix.getSelectedFile().getAbsolutePath();
            }
            TimsLogger.debug("TIMS - free : " + Runtime.getRuntime().freeMemory());
            System.gc();
            Vector<String> error = new Vector<String>();
            Vector<String> warning = new Vector<String>();
            PrintWriter errorWriter = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(destinationFile) + "\\TIMS - ERROR.txt")));
            PrintWriter warningWriter = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(destinationFile) + "\\TIMS - WARNING.txt")));
            FileReader reader = null;
            BufferedReader br = null;
            String ligne = null;
            boolean fileExist = true;
            if (!new File(String.valueOf(structurePath) + "\\TimsStructure.txt").exists() && (up = FileManager.getServerFile("http://www.pgh.fr/tims/files/TimsStructure%20-%20" + Transport.res.getResourceString("databaseVersion") + ".txt", String.valueOf(structurePath) + "\\TimsStructure.txt")) == null) {
                errorWriter.println("TimsStructure.txt not found");
                warningWriter.println("TimsStructure.txt not found");
                fileExist = false;
            }
            if (fileExist) {
                reader = new FileReader(String.valueOf(structurePath) + "\\TimsStructure.txt");
                br = new BufferedReader(reader);
                ligne = "";
                ligne = br.readLine();
                while (ligne != null) {
                    String[] table = ligne.split(";");
                    String detail = Transport.bdd.getTableDetails(table[0], BddTransport.getBaseDefault(false));
                    TimsLogger.debug(String.valueOf(table[0]) + " => " + detail);
                    if (detail.equals("")) {
                        error.add(String.valueOf(table[0]) + " doesn't exist");
                    } else {
                        int y;
                        boolean found;
                        String[] baseTable = detail.split(";");
                        int x = 0;
                        while (x < table.length) {
                            found = false;
                            y = 0;
                            while (y < baseTable.length) {
                                if (table[x].equalsIgnoreCase(baseTable[y])) {
                                    found = true;
                                    break;
                                }
                                ++y;
                            }
                            if (!found) {
                                error.add(String.valueOf(table[0]) + " => " + table[x] + " : champ non trouv\u00e9 dans la base.");
                            }
                            ++x;
                        }
                        x = 0;
                        while (x < baseTable.length) {
                            found = false;
                            y = 0;
                            while (y < table.length) {
                                if (baseTable[x].equalsIgnoreCase(table[y])) {
                                    found = true;
                                    break;
                                }
                                ++y;
                            }
                            if (!found) {
                                warning.add(String.valueOf(baseTable[0]) + " => " + baseTable[x] + " : champ dans la base non repertori\u00e9 dans la structure.");
                            }
                            ++x;
                        }
                    }
                    ligne = br.readLine();
                }
                if (error.size() != 0) {
                    errorWriter.println("\r\nError for " + BddTransport.getBaseDefault(false));
                    int v = 0;
                    while (v < error.size()) {
                        errorWriter.println((String)error.get(v));
                        ++v;
                    }
                }
                if (warning.size() != 0) {
                    warningWriter.println("\r\nWarning for " + BddTransport.getBaseDefault(false));
                    int v = 0;
                    while (v < warning.size()) {
                        warningWriter.println((String)warning.get(v));
                        ++v;
                    }
                }
                error.clear();
                error = null;
                warning.clear();
                warning = null;
                reader.close();
                br.close();
                reader = null;
                br = null;
            }
            int u = 0;
            while (u < tmp.size()) {
                File up2;
                Transport.bdd.changeDB(tmp.get(u).getNomSociete(), false);
                TimsLogger.debug(String.valueOf(tmp.get(u).getNomSociete()) + " - free : " + Runtime.getRuntime().freeMemory());
                System.gc();
                error = new Vector();
                warning = new Vector();
                if (!new File(String.valueOf(structurePath) + "\\DBStructure.txt").exists() && (up2 = FileManager.getServerFile("http://www.pgh.fr/tims/files/DBStructure%20-%20" + Transport.res.getResourceString("databaseVersion") + ".txt", String.valueOf(structurePath) + "\\DBStructure.txt")) == null) {
                    errorWriter.println("DBStructure.txt not found");
                    warningWriter.println("DBStructure.txt not found");
                    break;
                }
                reader = new FileReader(String.valueOf(structurePath) + "\\DBStructure.txt");
                br = new BufferedReader(reader);
                ligne = "";
                ligne = br.readLine();
                while (ligne != null) {
                    String[] table = ligne.split(";");
                    String detail = Transport.bdd.getTableDetails(table[0], tmp.get(u).getNomBase());
                    TimsLogger.debug(String.valueOf(table[0]) + " => " + detail);
                    if (detail.equals("")) {
                        error.add(String.valueOf(table[0]) + " doesn't exist");
                    } else {
                        int y;
                        boolean found;
                        String[] baseTable = detail.split(";");
                        int x = 0;
                        while (x < table.length) {
                            found = false;
                            y = 0;
                            while (y < baseTable.length) {
                                if (table[x].equalsIgnoreCase(baseTable[y])) {
                                    found = true;
                                    break;
                                }
                                ++y;
                            }
                            if (!found) {
                                error.add(String.valueOf(table[0]) + " => " + table[x] + " : champ non trouv\u00e9 dans la base.");
                            }
                            ++x;
                        }
                        x = 0;
                        while (x < baseTable.length) {
                            found = false;
                            y = 0;
                            while (y < table.length) {
                                if (baseTable[x].equalsIgnoreCase(table[y])) {
                                    found = true;
                                    break;
                                }
                                ++y;
                            }
                            if (!found) {
                                warning.add(String.valueOf(baseTable[0]) + " => " + baseTable[x] + " : champ dans la base non repertori\u00e9 dans la structure.");
                            }
                            ++x;
                        }
                    }
                    ligne = br.readLine();
                }
                if (error.size() != 0) {
                    errorWriter.println("\r\nError for " + tmp.get(u).getNomSociete());
                    int v = 0;
                    while (v < error.size()) {
                        errorWriter.println((String)error.get(v));
                        ++v;
                    }
                    errorWriter.flush();
                }
                if (warning.size() != 0) {
                    warningWriter.println("\r\nWarning for " + tmp.get(u).getNomSociete());
                    int v = 0;
                    while (v < warning.size()) {
                        warningWriter.println((String)warning.get(v));
                        ++v;
                    }
                    warningWriter.flush();
                }
                error.clear();
                error = null;
                warning.clear();
                warning = null;
                reader.close();
                br.close();
                reader = null;
                br = null;
                ++u;
            }
            errorWriter.close();
            warningWriter.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("MainFrameTransport.checkDatabase(  )  : " + ex);
            ex.printStackTrace();
            return;
        }
    }

    public void createDatabaseStructure() {
        try {
            JFileChooser choix = new JFileChooser(System.getProperty("user.home"));
            choix.setFileSelectionMode(1);
            choix.setDialogTitle("Selectionner le fichier de structure");
            choix.setApproveButtonText("G\u00e9nerer");
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) != 0) {
                return;
            }
            PrintWriter ecrivain = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(choix.getSelectedFile().getAbsolutePath()) + "\\DBStructure.txt")));
            PrintWriter ecrivainTims = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(choix.getSelectedFile().getAbsolutePath()) + "\\TimsStructure.txt")));
            Vector<String> table = Transport.bdd.getTableListe();
            int x = 0;
            while (x < table.size()) {
                ecrivain.print(String.valueOf(Transport.bdd.getTableDetails(table.get(x), null)) + "\r\n");
                ecrivain.flush();
                ++x;
            }
            Vector<String> timsTable = Transport.bdd.getTimsTableListe();
            int x2 = 0;
            while (x2 < timsTable.size()) {
                ecrivainTims.print(String.valueOf(Transport.bdd.getTableDetails(timsTable.get(x2), BddTransport.getBaseDefault(false))) + "\r\n");
                ecrivainTims.flush();
                ++x2;
            }
            ecrivain.close();
            ecrivainTims.close();
        }
        catch (Exception ex) {
            TimsLogger.warn("MainFrameTransport.checkDatabase(  )  : " + ex);
            return;
        }
    }

    public void writeForUser() {
        try {
            PrintWriter fichier = new PrintWriter(new BufferedWriter(new FileWriter("soc.sql")));
            Vector<Utilisateur> a = Utilisateur.list("");
            int z = 0;
            while (z < a.size()) {
                if (!a.get(z).isRestreintAgence()) {
                    fichier.println("(" + (z + 1) + MENU_SEPARATOR + a.get(z).getCleUser() + MENU_SEPARATOR + a.get(z).getCleAgence() + ",0)");
                }
                ++z;
            }
            fichier.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void serviceRecalculation() {
        Integer[] toCalc;
        String begin = "2008-10-30";
        String end = "2012-01-17";
        Integer[] integerArray = toCalc = new Integer[]{95};
        int n = toCalc.length;
        int n2 = 0;
        while (n2 < n) {
            int driverId = integerArray[n2];
            TimsLogger.debug("serviceRecalculation " + driverId + " " + begin + " " + end);
            try {
                TraitementTempsService tts = new TraitementTempsService(driverId, begin, end, true);
                tts.loadActivite();
                tts.calculService();
                tts.saveListe();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    public void serviceCalculation() {
        Vector<String[]> tmp = Transport.bdd.getOtherActivity();
        TimsLogger.debug(String.valueOf(tmp.size()) + " jours");
        int i = 0;
        while (i < tmp.size()) {
            TimsLogger.verbose("Calcul pour " + tmp.get(i)[0] + " le " + tmp.get(i)[1]);
            try {
                TraitementTempsService tts = new TraitementTempsService(Integer.parseInt(tmp.get(i)[0]), tmp.get(i)[1], tmp.get(i)[1], true);
                tts.loadActivite();
                tts.calculService();
                tts.saveListe();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public int getTrayHeight() {
        if (this.trayLine == null) {
            return 0;
        }
        return this.trayLine.getHeight();
    }

    @Override
    public void exit() {
        if (System.getProperty("URL") == null && System.getProperty("auto.save.activation", "1").equals("1")) {
            Configuration cfg = new Configuration(true);
            if (!cfg.load("auto.save.date")) {
                TimsLogger.error("MFT.exit# create auto.save.date parameter");
                cfg = new Configuration(true, 0, "auto.save.date", ConversionTime.dateToStringDb(new Date()), true, false);
                cfg.insert();
            }
            Date day = ConversionTime.stringToDateDb(cfg.getEval());
            Object[] options = new String[]{LanguageTranslator.getString("generics.yes"), LanguageTranslator.getString("generics.no"), LanguageTranslator.getString("generics.later")};
            if (ConversionTime.getDaysBetween(ConversionTime.stringToDateDb(cfg.getEval()), new Date()) > Integer.parseInt(System.getProperty("auto.save.frequency", "21"))) {
                SynchronizedOptionDialog save = new SynchronizedOptionDialog(LanguageTranslator.getString("generics.save.outdated", ConversionTime.dateToStringFr(day)), LanguageTranslator.getString("generics.save"), options);
                save.run();
                if (save.getOption() == 0) {
                    this.saveData();
                    return;
                }
                if (save.getOption() == 2) {
                    Date next = ConversionTime.addDay(new Date(), Integer.parseInt(System.getProperty("auto.save.frequency", "21")));
                    String sNext = ConversionTime.dateToStringDb(next);
                    TimsLogger.info("MFT.exit# ask for later save... set " + sNext);
                    cfg.setEval(sNext);
                    cfg.update();
                }
            }
        }
        ProgressBarIndetermine tmp = new ProgressBarIndetermine((Frame)this, LanguageTranslator.getString("main.closing"));
        tmp.setVisible(true);
        ConnexionSettings.getInstance().closeConnexion();
        BddTransport.closeConnection();
        while (copying != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        tmp.dispose();
        System.gc();
        System.exit(0);
    }

    public void saveData() {
        JFileChooser choix = new JFileChooser(System.getProperty("user.home"));
        choix.setFileSelectionMode(1);
        choix.setDialogTitle(LanguageTranslator.getString("save.destination"));
        choix.setApproveButtonText(LanguageTranslator.getString("button.save"));
        if (choix.showOpenDialog(MainFrameTransport.getInstance()) != 0) {
            return;
        }
        this.pg = new ProgressBar(this, LanguageTranslator.getString("save.processing"));
        this.pg.setVisible(true);
        SaveWorker saver = new SaveWorker(choix.getSelectedFile());
        saver.start();
    }

    class AideAction
    implements ActionListener {
        AideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainFrameTransport.this.browseAide();
        }
    }

    class SaveWorker
    extends Thread {
        File to = null;

        public SaveWorker(File to) {
            this.to = to;
            MainFrameTransport.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent evt) {
                    if ("progress".equals(evt.getPropertyName())) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TimsLogger.debug("#SaveWorker.propertyChange# update progress ... " + evt.getNewValue());
                                if (!MainFrameTransport.this.pg.isVisible()) {
                                    MainFrameTransport.this.pg.setVisible(true);
                                }
                                MainFrameTransport.this.pg.setValue((Integer)evt.getNewValue());
                            }
                        });
                    }
                    if ("label".equals(evt.getPropertyName())) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TimsLogger.debug("#SaveWorker.propertyChange# update label ... " + evt.getNewValue());
                                if (!MainFrameTransport.this.pg.isVisible()) {
                                    MainFrameTransport.this.pg.setVisible(true);
                                }
                                MainFrameTransport.this.pg.setString((String)evt.getNewValue());
                            }
                        });
                    }
                }
            });
        }

        @Override
        public void run() {
            this.doSave();
        }

        public void doSave() {
            TimsLogger.debug("#SaveWorker.doInBackground# Sauvegarde en cours...");
            try {
                this.backupDatabase(this.to);
                this.backupFiles(null, this.to, 0.0, 100.0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrameTransport.this.pg.setVisible(false);
                        Configuration cfg = new Configuration(true);
                        cfg.load("auto.save.date");
                        cfg.setEval(ConversionTime.dateToStringDb(new Date()));
                        cfg.update();
                        MainFrameTransport.getInstance().exit();
                    }
                });
            }
            catch (Exception ex) {
                MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("save.error", ex.getMessage()), LanguageTranslator.getString("save.failed"));
                ex.printStackTrace();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrameTransport.this.pg.setVisible(false);
                }
            });
        }

        public void backupFiles(File from, File to, double progressStart, double progressEnd) throws Exception {
            File[] files;
            if (System.getProperty("URL") != null) {
                return;
            }
            if (from == null) {
                from = new File(FileManager.ARCHIVE_DIRECTORY);
            }
            this.majUI("Sauvegarde du r\u00e9pertoire " + from.getAbsolutePath());
            if (to == null) {
                JFileChooser choix = new JFileChooser(System.getProperty("user.home"));
                choix.setFileSelectionMode(1);
                choix.setDialogTitle(LanguageTranslator.getString("save.destination"));
                choix.setApproveButtonText(LanguageTranslator.getString("button.save"));
                if (choix.showOpenDialog(MainFrameTransport.getInstance()) != 0) {
                    return;
                }
                to = choix.getSelectedFile().getAbsoluteFile();
            }
            if (to.equals(from)) {
                throw new Exception("Same source/destination");
            }
            if (!to.exists()) {
                to.mkdirs();
            }
            if ((files = from.listFiles()).length == 0) {
                return;
            }
            double step = (progressEnd - progressStart) / (double)files.length;
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                double progress = progressStart + (double)i * step;
                this.majUI(progress);
                File dest = new File(to, file.getName());
                if (file.isFile()) {
                    if (dest.exists()) {
                        dest.delete();
                    }
                    Fonctions.copy(file.getAbsolutePath(), new File(to, file.getName()).getAbsolutePath());
                }
                if (file.isDirectory()) {
                    File to2 = new File(to, file.getName());
                    if (!to2.exists()) {
                        to2.mkdirs();
                    }
                    this.backupFiles(file, to2, progress, progress + step);
                }
                ++i;
            }
        }

        public File backupDatabase(File destinationFile) throws Exception {
            if (System.getProperty("URL") != null) {
                return null;
            }
            if (destinationFile == null) {
                JFileChooser choix = new JFileChooser(System.getProperty("user.home"));
                choix.setFileSelectionMode(1);
                choix.setDialogTitle(LanguageTranslator.getString("save.destination"));
                choix.setApproveButtonText(LanguageTranslator.getString("button.save"));
                if (choix.showOpenDialog(MainFrameTransport.getInstance()) != 0) {
                    return null;
                }
                destinationFile = choix.getSelectedFile();
            }
            this.majUI("Sauvegarde de la base de donn\u00e9es, cette op\u00e9ration peut prendre plusieurs minutes");
            String mysqlExePath = String.valueOf(System.getProperty("user.dir", "C:\\Program Files (x86)\\Tims")) + "\\mysql\\bin\\mysqldump.exe";
            if (!new File(mysqlExePath).exists()) {
                throw new Exception("Cannot find mysqldump at " + mysqlExePath);
            }
            String[] cmd = new String[]{String.valueOf(System.getProperty("user.dir", "C:\\Program Files (x86)\\Tims")) + "\\mysql\\bin\\mysqldump.exe", "-uroot", "-pmysql1", "-P3309", "tims"};
            File saveFile = new File(destinationFile + "\\database\\save.sql");
            if (!saveFile.getParentFile().exists()) {
                saveFile.getParentFile().mkdirs();
                saveFile.createNewFile();
            }
            Fonctions.executeScript(cmd, true, new PrintStream(destinationFile + "\\database\\save.sql"));
            return destinationFile;
        }

        private void majUI(Object value) {
            if (value instanceof Integer) {
                MainFrameTransport.this.firePropertyChange("progress", null, (Integer)value);
            }
            if (value instanceof Double) {
                MainFrameTransport.this.firePropertyChange("progress", null, ((Double)value).intValue());
            }
            if (value instanceof String) {
                MainFrameTransport.this.firePropertyChange("label", null, value.toString());
            }
        }
    }
}

