/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.ActionPriority;
import fr.pgh.data.bdd.ActionState;
import fr.pgh.data.bdd.ActionType;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.AgencyType;
import fr.pgh.data.bdd.ComboBoxable;
import fr.pgh.data.bdd.CompanyAction;
import fr.pgh.data.bdd.CompanyCard;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Conflit;
import fr.pgh.data.bdd.ContractState;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.DevCategory;
import fr.pgh.data.bdd.DevProduct;
import fr.pgh.data.bdd.DevState;
import fr.pgh.data.bdd.DevType;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.EmployeeObligationTypeGroup;
import fr.pgh.data.bdd.EmployeeType;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.Garage;
import fr.pgh.data.bdd.GlobalCalendar;
import fr.pgh.data.bdd.IcontactCompany;
import fr.pgh.data.bdd.IcontactPerson;
import fr.pgh.data.bdd.IcontactRegion;
import fr.pgh.data.bdd.InterventionType;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.Offense;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Product;
import fr.pgh.data.bdd.Profil;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.RoundType;
import fr.pgh.data.bdd.Rule;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.TailleAgence;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.data.bdd.TypePaye;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.data.bdd.VehicleAffectation;
import fr.pgh.data.bdd.VehicleBody;
import fr.pgh.data.bdd.VehicleType;
import fr.pgh.data.bdd.Vehicule;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class ComboBoxModel
extends DefaultComboBoxModel {
    private static final long serialVersionUID = 1L;
    String defaultValue = "";
    Vector<Integer> cle = null;
    Vector<?> objectList = null;
    int x = 0;

    public ComboBoxModel(Vector<?> list) {
        this(list, false, null);
    }

    public ComboBoxModel(Vector<?> list, boolean reminder, String defaultValue) {
        this.defaultValue = defaultValue;
        if (reminder) {
            this.objectList = (Vector)list.clone();
        }
        this.cle = new Vector();
        this.setVector(list, defaultValue);
    }

    public void updateList(Vector<?> list, boolean reminder, String defaultValue) {
        this.defaultValue = defaultValue;
        if (reminder) {
            this.objectList = (Vector)list.clone();
        }
        this.cle = new Vector();
        this.setVector(list, defaultValue);
    }

    public void setVector(Vector<?> list, String defaultValue) {
        this.removeAllElements();
        this.cle.clear();
        if (this.objectList != null) {
            this.objectList = (Vector)list.clone();
        }
        if (defaultValue != null) {
            this.cle.add(0);
            super.addElement(defaultValue);
        }
        if (list == null) {
            return;
        }
        this.x = 0;
        while (this.x < list.size()) {
            this.addElement(list.get(this.x));
            ++this.x;
        }
    }

    @Override
    public void addElement(Object obj) {
        if (obj instanceof ComboBoxable) {
            this.cle.add(((ComboBoxable)obj).getId());
            super.addElement(((ComboBoxable)obj).getName());
        } else if (obj instanceof Societe) {
            this.cle.add(((Societe)obj).getCleSociete());
            super.addElement(((Societe)obj).getNomSociete());
        } else if (obj instanceof Agence) {
            this.cle.add(((Agence)obj).getCleAgence());
            super.addElement(((Agence)obj).getDescription());
        } else if (obj instanceof Conducteur) {
            this.cle.add(((Conducteur)obj).getCleConducteur());
            super.addElement(String.valueOf(((Conducteur)obj).getNom()) + "  " + ((Conducteur)obj).getPrenom());
        } else if (obj instanceof Vehicule) {
            this.cle.add(((Vehicule)obj).getCleVehicule());
            super.addElement(((Vehicule)obj).toString());
        } else if (obj instanceof JourType) {
            this.cle.add(((JourType)obj).getCle());
            super.addElement(((JourType)obj).getDesignation());
        } else if (obj instanceof TypePaye) {
            this.cle.add(((TypePaye)obj).getCleType());
            super.addElement(((TypePaye)obj).getDescription());
        } else if (obj instanceof TypeContrat) {
            this.cle.add(((TypeContrat)obj).getCle());
            super.addElement(((TypeContrat)obj).getDesignation());
        } else if (obj instanceof EmployeeType) {
            this.cle.add(((EmployeeType)obj).getId());
            super.addElement(((EmployeeType)obj).getName());
        } else if (obj instanceof Profil) {
            this.cle.add(((Profil)obj).getCle());
            super.addElement(((Profil)obj).getNomProfil());
        } else if (obj instanceof AgencyType) {
            this.cle.add(((AgencyType)obj).getId());
            super.addElement(((AgencyType)obj).getName());
        } else if (obj instanceof TailleAgence) {
            this.cle.add(((TailleAgence)obj).getCle());
            super.addElement(((TailleAgence)obj).getDesignation());
        } else if (obj instanceof Pays) {
            this.cle.add(((Pays)obj).getCle());
            super.addElement(((Pays)obj).getLibelle());
        } else if (obj instanceof Region) {
            this.cle.add(((Region)obj).getId());
            super.addElement(((Region)obj).getName());
        } else if (obj instanceof Conflit) {
            this.cle.add(((Conflit)obj).getCle());
            super.addElement((Conflit)obj);
        } else if (obj instanceof ExpensesType) {
            this.cle.add(((ExpensesType)obj).getCle());
            super.addElement(((ExpensesType)obj).getDesignation());
        } else if (obj instanceof RoundType) {
            this.cle.add(((RoundType)obj).getId());
            super.addElement(((RoundType)obj).getCode());
        } else if (obj instanceof CustomReport) {
            this.cle.add(((CustomReport)obj).getId());
            super.addElement(((CustomReport)obj).getName());
        } else if (obj instanceof Report) {
            this.cle.add(((Report)obj).getId());
            super.addElement(((Report)obj).getCustomizedName());
        } else if (obj instanceof Rule) {
            this.cle.add(((Rule)obj).getId());
            super.addElement(((Rule)obj).getName());
        } else if (obj instanceof Offense) {
            String toAdd = ((Offense)obj).getDesignation();
            if (this.getIndexOf(toAdd) == -1) {
                super.addElement(toAdd);
            }
        } else if (obj instanceof GlobalCalendar) {
            this.cle.add(((GlobalCalendar)obj).getId());
            super.addElement(((GlobalCalendar)obj).getName());
        } else if (obj instanceof TypeActivite) {
            this.cle.add(((TypeActivite)obj).getCle());
            super.addElement(((TypeActivite)obj).getName());
        } else if (obj instanceof OffenceType) {
            this.cle.add(((OffenceType)obj).getId());
            super.addElement(LanguageTranslator.getString(((OffenceType)obj).getName()));
        } else if (obj instanceof CompanyCard) {
            this.cle.add(((CompanyCard)obj).getId());
            super.addElement(((CompanyCard)obj).getCardNumber());
        } else if (obj instanceof File) {
            this.cle.add(0);
            super.addElement(((File)obj).getName());
        } else if (obj instanceof InterventionType) {
            this.cle.add(((InterventionType)obj).getId());
            super.addElement(((InterventionType)obj).getName());
        } else if (obj instanceof VehicleType) {
            this.cle.add(((VehicleType)obj).getId());
            super.addElement(((VehicleType)obj).getName());
        } else if (obj instanceof VehicleBody) {
            this.cle.add(((VehicleBody)obj).getId());
            super.addElement(((VehicleBody)obj).getName());
        } else if (obj instanceof VehicleAffectation) {
            this.cle.add(((VehicleAffectation)obj).getId());
            super.addElement(((VehicleAffectation)obj).getName());
        } else if (obj instanceof EmployeeObligationType) {
            this.cle.add(((EmployeeObligationType)obj).getId());
            super.addElement(((EmployeeObligationType)obj).getName());
        } else if (obj instanceof Garage) {
            this.cle.add(((Garage)obj).getId());
            super.addElement(((Garage)obj).toString());
        } else if (obj instanceof Accident) {
            this.cle.add(((Accident)obj).getId());
            super.addElement(ConversionTime.dateToString(((Accident)obj).getDay(), "dd/MM/yyyy"));
        } else if (obj instanceof EmployeeObligationTypeGroup) {
            this.cle.add(((EmployeeObligationTypeGroup)obj).getId());
            super.addElement(((EmployeeObligationTypeGroup)obj).getName());
        } else if (obj instanceof ActionPriority) {
            this.cle.add(((ActionPriority)obj).getId());
            super.addElement(((ActionPriority)obj).getName());
        } else if (obj instanceof Product) {
            this.cle.add(((Product)obj).getId());
            super.addElement(((Product)obj).getName());
        } else if (obj instanceof ActionState) {
            this.cle.add(((ActionState)obj).getId());
            super.addElement(((ActionState)obj).getName());
        } else if (obj instanceof ActionType) {
            this.cle.add(((ActionType)obj).getId());
            super.addElement(((ActionType)obj).getName());
        } else if (obj instanceof IcontactPerson) {
            this.cle.add(((IcontactPerson)obj).getId());
            super.addElement(String.valueOf(((IcontactPerson)obj).toString()) + " - " + ((IcontactPerson)obj).getPhone());
        } else if (obj instanceof IcontactCompany) {
            this.cle.add(((IcontactCompany)obj).getId());
            super.addElement(String.valueOf(((IcontactCompany)obj).getName()) + " - " + ((IcontactCompany)obj).getPhone());
        } else if (obj instanceof CompanyAction) {
            this.cle.add(((CompanyAction)obj).getId());
            super.addElement(ConversionTime.dateToString(((CompanyAction)obj).getDate(), "dd/MM/yyyy HH:mm"));
        } else if (obj instanceof IcontactRegion) {
            this.cle.add(((IcontactRegion)obj).getId());
            super.addElement(((IcontactRegion)obj).getName());
        } else if (obj instanceof ContractState) {
            this.cle.add(((ContractState)obj).getId());
            super.addElement(((ContractState)obj).getName());
        } else if (obj instanceof DevState) {
            this.cle.add(((DevState)obj).getId());
            super.addElement(((DevState)obj).getName());
        } else if (obj instanceof DevProduct) {
            this.cle.add(((DevProduct)obj).getId());
            super.addElement(((DevProduct)obj).getName());
        } else if (obj instanceof DevType) {
            this.cle.add(((DevType)obj).getId());
            super.addElement(((DevType)obj).getName());
        } else if (obj instanceof DevCategory) {
            this.cle.add(((DevCategory)obj).getId());
            super.addElement(((DevCategory)obj).getName());
        } else if (obj instanceof Utilisateur) {
            this.cle.add(((Utilisateur)obj).getCleUser());
            super.addElement(obj.toString());
        } else {
            System.err.println("#ComboBoxModel.addElement# UNKNOW TYPE " + obj.getClass().getName() + " ... ERROR MAY HAPPEN");
            super.addElement(obj.toString());
        }
    }

    public String getLabel(int toFind) {
        if (toFind == 0) {
            return this.defaultValue;
        }
        int x = 0;
        while (x < this.getSize()) {
            if (this.cle.get(x) == toFind) {
                return (String)this.getElementAt(x);
            }
            ++x;
        }
        TimsLogger.debug("#ComboBoxModel.getLabel# " + toFind + " not found");
        return "";
    }

    public void setSelected(int toFind) {
        if (toFind == 0) {
            this.setSelectedItem(this.defaultValue);
        }
        int x = 0;
        while (x < this.getSize()) {
            if (this.cle.get(x) == toFind) {
                this.setSelectedItem(this.getElementAt(x));
                return;
            }
            ++x;
        }
        TimsLogger.debug("#ComboBoxModel.setSelected# unable to select " + toFind);
    }

    public int getSelectedCle() {
        if (this.getSelectedItem() == null) {
            return 0;
        }
        String des = this.getSelectedItem().toString();
        int x = 0;
        while (x < this.getSize()) {
            String elt = (String)this.getElementAt(x);
            if (elt.equals(des)) {
                return this.cle.get(x);
            }
            ++x;
        }
        return 0;
    }

    public Object getObjectAt(int index) {
        if (this.objectList == null) {
            TimsLogger.info("#ComboBoxModel.getObjectAt# try to get an object whereas reminder not activated");
            return null;
        }
        if (this.getSize() != this.objectList.size()) {
            --index;
        }
        if (index < 0) {
            TimsLogger.debug("#ComboBoxModel.getObjectAt# return defaultValue");
            return null;
        }
        return this.objectList.get(index);
    }

    public Vector<Object> getList() {
        TimsLogger.verbose("#cbModel.getList()# (objectList is null ? " + String.valueOf(this.objectList == null) + ")");
        if (this.objectList == null) {
            return null;
        }
        TimsLogger.verbose("#cbModel.getList()# objectList " + this.objectList.size());
        Vector<Object> toReturn = new Vector<Object>();
        if (this.getSelectedItem() != null && !this.getSelectedItem().equals(this.defaultValue)) {
            TimsLogger.verbose("#cbModel.getList()# getSelectedItem() = " + this.getSelectedItem() + " defaultValue = " + this.defaultValue);
            toReturn.add(this.getObjectAt(this.getIndexOf(this.getSelectedItem())));
        } else {
            for (Object tmp : this.objectList) {
                TimsLogger.verbose("#cbModel.getList()# adding " + tmp);
                if (tmp == null) continue;
                toReturn.add(tmp);
            }
        }
        return toReturn;
    }
}

