/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.AccidentAction;
import fr.pgh.data.bdd.Utilisateur;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMAccidentAction
extends AbstractTableModel {
    Vector<AccidentAction> list = null;
    String[] columns = new String[]{LanguageTranslator.getString("generics.action"), LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("generics.author")};

    public TMAccidentAction() {
        this.list = new Vector();
    }

    public TMAccidentAction(Vector<AccidentAction> action) {
        this.list = action;
    }

    @Override
    public int getRowCount() {
        return this.list == null ? 0 : this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex) == null ? String.class : this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AccidentAction tmp = this.list.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return tmp.getPurpose();
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getInsertionDate(), "dd/MM/yyyy HH'h'mm");
            }
            case 2: {
                Utilisateur user = new Utilisateur();
                if (!user.loadById(tmp.getUserId())) break;
                return String.valueOf(user.getNom()) + " " + user.getPrenom();
            }
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.list.get(rowIndex).setPurpose(aValue.toString());
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public Vector<AccidentAction> getData() {
        return this.list;
    }

    public void addLine() {
        this.list.add(new AccidentAction(0, ConnexionSettings.getInstance().getUserCle(), new Date(), 0, ""));
        this.fireTableRowsInserted(this.list.size(), this.list.size());
    }
}

