/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.TMPrintable;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMActivity
extends AbstractTableModel
implements TMPrintable {
    private static final long serialVersionUID = 1L;
    String[] titres = new String[]{LanguageTranslator.getString("generics.begin"), LanguageTranslator.getString("generics.end"), LanguageTranslator.getString("generics.activity"), LanguageTranslator.getString("generics.length"), LanguageTranslator.getString("activity.cardStatus"), LanguageTranslator.getString("activity.drivingStatus"), LanguageTranslator.getString("activity.reader"), LanguageTranslator.getString("generics.id")};
    Vector<ActiviteConducteur> donnees = null;

    public TMActivity(Vector<ActiviteConducteur> donnees) {
        this.donnees = donnees;
    }

    public void setModel(Vector<ActiviteConducteur> donnees) {
        this.donnees = donnees;
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public int getRowCount() {
        return this.donnees == null ? 0 : this.donnees.size();
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        ActiviteConducteur tmp = this.donnees.get(arg0);
        switch (arg1) {
            case 0: {
                return ConversionTime.heureIntToString(tmp.getHeureDebut(), "h");
            }
            case 1: {
                return ConversionTime.heureIntToString(tmp.getHeureFin(), "h");
            }
            case 2: {
                return tmp.getDescription();
            }
            case 3: {
                return ConversionTime.heureIntToString(tmp.getDuree(), "h");
            }
            case 4: {
                return tmp.getEtatCarte();
            }
            case 5: {
                return tmp.getEtatConduite();
            }
            case 6: {
                return tmp.getLecteur();
            }
            case 7: {
                return tmp.getCleType();
            }
        }
        return LanguageTranslator.getString("generics.notFound");
    }

    public ActiviteConducteur getObjectAt(int x) {
        return this.donnees.get(x);
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }

    @Override
    public ArrayList<Map<String, ?>> getData() {
        TimsLogger.debug("TMACtivity# getData() " + this.getRowCount() + " line to export");
        ArrayList toReturn = new ArrayList();
        int x = 0;
        while (x < this.getRowCount()) {
            HashMap<String, Object> toAdd = new HashMap<String, Object>();
            System.err.print("#TMActivity.getData()# line " + x + " : ");
            int y = 0;
            while (y < this.getColumnCount()) {
                toAdd.put(this.getColumnName(y), this.getValueAt(x, y));
                System.err.print(String.valueOf(this.getColumnName(y)) + " = " + this.getValueAt(x, y) + ", ");
                ++y;
            }
            System.err.println();
            toReturn.add(toAdd);
            ++x;
        }
        return toReturn;
    }
}

