/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceType;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class TMAgencyOffence
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    Vector<Offence> donnees;
    Vector<Conducteur> drivers;
    String[] titres = new String[]{LanguageTranslator.getString("generics.driver"), LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("offence.time"), LanguageTranslator.getString("generics.designation"), LanguageTranslator.getString("offence.autorisedThreshold"), LanguageTranslator.getString("offence.threshold"), LanguageTranslator.getString("offence.type"), LanguageTranslator.getString("offence.maxCost")};

    public TMAgencyOffence(ArrayList<Offence> alDonnees, ArrayList<Conducteur> alDrivers) {
        this.donnees = new Vector<Offence>(alDonnees);
        this.drivers = new Vector<Conducteur>(alDrivers);
    }

    public TMAgencyOffence(Vector<Offence> donnees, Vector<Conducteur> drivers) {
        this.donnees = donnees;
        this.drivers = drivers;
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        Offence donnee = this.donnees.get(parm1);
        switch (parm2) {
            case 0: {
                try {
                    Conducteur driver = Conducteur.getDriver(this.drivers, donnee.getDriverId());
                    return String.valueOf(driver.getNom()) + " " + driver.getPrenom();
                }
                catch (Exception ex) {
                    TimsLogger.warn("Driver not found " + donnee.getDriverId());
                }
            }
            case 1: {
                return ConversionTime.dateToString(donnee.getDate(), "dd/MM/yyyy");
            }
            case 2: {
                return ConversionTime.heureIntToString(donnee.getTime(), "h");
            }
            case 3: {
                return donnee.getDesignation();
            }
            case 4: {
                OffencePart part = OffencePart.getOffencePart(donnee.getOffencePartId());
                OffenceType type = OffenceType.getOffenceType(part.getOffenceTypeId());
                if (type == null) {
                    return LanguageTranslator.getString("generics.unknown");
                }
                String sThreshold = "offence.threshold.minor";
                if (type.getName().equals("offence.type.weeklyWork")) {
                    sThreshold = "offence.threshold";
                    try {
                        int driverType = Conducteur.getDriver(this.drivers, donnee.getDriverId()).getCleTypeConducteur();
                        sThreshold = String.valueOf(sThreshold) + (driverType == 1 ? ".GR" : (driverType == 2 ? ".ZC" : ".ME"));
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("Driver not found " + donnee.getDriverId());
                    }
                }
                if (type.getName().equals("offence.type.manualInput")) {
                    sThreshold = "offence.threshold";
                }
                int threshold = Fonctions.getOffenceThreshold(type, part.getName(), sThreshold).getThreshold();
                return ConversionTime.heureIntToString(threshold, "h");
            }
            case 5: {
                return ConversionTime.heureIntToString(donnee.getThreshold(), "h");
            }
            case 6: {
                return this.getTypeOffenceWording(donnee.getType());
            }
            case 7: {
                return String.valueOf(donnee.getCost()) + " \u20ac";
            }
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    private String getTypeOffenceWording(int type) {
        if (type == 0) {
            return LanguageTranslator.getString("generics.information");
        }
        if (type == 1) {
            return LanguageTranslator.getString("offence.minor");
        }
        if (type == 2) {
            return LanguageTranslator.getString("offence.serious");
        }
        if (type == 3) {
            return LanguageTranslator.getString("offence.verySerious");
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    public Vector<Offence> getData() {
        return this.donnees;
    }

    @Override
    public int getRowCount() {
        return this.donnees.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

