/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActionPriority;
import fr.pgh.data.bdd.ActionState;
import fr.pgh.data.bdd.ActionType;
import fr.pgh.data.bdd.CompanyAction;
import fr.pgh.data.bdd.IcontactCompany;
import fr.pgh.data.bdd.IcontactPerson;
import fr.pgh.data.bdd.Product;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.exception.DBObjectNotFoundException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMCompanyAction
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.company"), LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("generics.responsible"), LanguageTranslator.getString("generics.product"), LanguageTranslator.getString("generics.actionType"), LanguageTranslator.getString("generics.priority"), LanguageTranslator.getString("generics.contact"), LanguageTranslator.getString("generics.state")};
    private Vector<CompanyAction> data = null;

    public TMCompanyAction(Vector<CompanyAction> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<CompanyAction> getData() {
        return this.data;
    }

    public CompanyAction getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        CompanyAction tmp = this.data.get(row);
        switch (col) {
            case 0: {
                try {
                    return IcontactCompany.get(tmp.getCompanyId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for company id " + tmp.getCompanyId());
                    return "?";
                }
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy HH'h'mm");
            }
            case 2: {
                try {
                    return Utilisateur.find(tmp.getManagerId()).toString();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for manager id " + tmp.getCompanyId());
                    return "?";
                }
            }
            case 3: {
                try {
                    return Product.get(tmp.getProductId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for product id " + tmp.getCompanyId());
                    return "?";
                }
            }
            case 4: {
                try {
                    return ActionType.get(tmp.getActionTypeId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for action type id " + tmp.getCompanyId());
                    return "?";
                }
            }
            case 5: {
                try {
                    return ActionPriority.get(tmp.getPriorityId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for ActionPriority id " + tmp.getCompanyId());
                    return "?";
                }
            }
            case 6: {
                try {
                    return IcontactPerson.get(tmp.getContactId()).toString();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for IcontactPerson id " + tmp.getCompanyId());
                    return "?";
                }
            }
            case 7: {
                try {
                    return ActionState.get(tmp.getStateId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for ActionState id " + tmp.getCompanyId());
                    return "?";
                }
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

