/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.CompanyCard;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMCompanyCard
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.cardNumber"), LanguageTranslator.getString("generics.delivery"), LanguageTranslator.getString("generics.validityBegin"), LanguageTranslator.getString("generics.expiry")};
    private Vector<CompanyCard> data = null;

    public TMCompanyCard(Vector<CompanyCard> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        CompanyCard tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return tmp.getCardNumber();
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getIssueDate(), "dd/MM/yyyy");
            }
            case 2: {
                return ConversionTime.dateToString(tmp.getValidityBegin(), "dd/MM/yyyy");
            }
            case 3: {
                return ConversionTime.dateToString(tmp.getExpiryDate(), "dd/MM/yyyy");
            }
        }
        String retour = LanguageTranslator.getString("generics.notFound");
        return retour;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }
}

