/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.CompanyCard;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMCompanyCardExpiration
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.agency"), LanguageTranslator.getString("generics.cardNumber"), LanguageTranslator.getString("generics.expiry")};
    private Vector<CompanyCard> data = null;

    public TMCompanyCardExpiration(Vector<CompanyCard> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<CompanyCard> getData() {
        return this.data;
    }

    public CompanyCard getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        CompanyCard tmp = this.data.get(row);
        switch (col) {
            case 0: {
                Agence agency = Agence.find(Agence.getList(), tmp.getAgencyId());
                return agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription();
            }
            case 1: {
                return tmp.getCardNumber();
            }
            case 2: {
                return tmp.getExpiryDate();
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? String.class : this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void removeAllElements() {
        this.data.clear();
        this.fireTableRowsDeleted(0, this.getRowCount());
    }
}

