/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.ConsumptionEval;
import java.awt.Color;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMConsumptionEvaluation
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.designation"), LanguageTranslator.getString("consumption.percentage"), LanguageTranslator.getString("generics.color")};
    private Vector<ConsumptionEval> data = null;

    public TMConsumptionEvaluation(Vector<ConsumptionEval> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<ConsumptionEval> getData() {
        return this.data;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ConsumptionEval tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return tmp.getName();
            }
            case 1: {
                return tmp.getPercentage();
            }
            case 2: {
                return new Color(tmp.getColor());
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ConsumptionEval tmp = this.data.get(row);
        switch (col) {
            case 0: {
                tmp.setName(value.toString());
                break;
            }
            case 1: {
                tmp.setPercentage(Integer.parseInt(value.toString()));
                break;
            }
            case 2: {
                tmp.setColor(((Color)value).getRGB());
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void addRow(ConsumptionEval tmp) {
        this.insertRow(this.getRowCount(), tmp);
    }

    private void insertRow(int row, ConsumptionEval tmp) {
        this.data.insertElementAt(tmp, row);
        this.fireTableRowsInserted(row, row);
    }

    public ConsumptionEval removeRow(int row) {
        ConsumptionEval tmp = this.data.get(row);
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
        return tmp;
    }

    public ConsumptionEval getRow(int row) {
        return this.data.get(row);
    }
}

