/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMDay
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.day"), LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("generics.begin"), LanguageTranslator.getString("generics.end"), LanguageTranslator.getString("generics.length"), LanguageTranslator.getString("generics.semi"), LanguageTranslator.getString("generics.full")};
    private Vector<LienJourConducteur> data = null;

    public TMDay(Vector<LienJourConducteur> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<LienJourConducteur> getData() {
        return this.data;
    }

    @Override
    public Object getValueAt(int row, int col) {
        LienJourConducteur tmp = this.data.get(row);
        switch (col) {
            case 0: {
                JourType tmpJ = new JourType(tmp.getCleJourType());
                if (tmpJ.getCle() == 0) {
                    return "";
                }
                return tmpJ.getDesignation();
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getDateJour(), "dd/MM/yyyy");
            }
            case 2: {
                return ConversionTime.heureIntToString(tmp.getHeureDebut(), "h");
            }
            case 3: {
                return ConversionTime.heureIntToString(tmp.getHeureFin(), "h");
            }
            case 4: {
                return ConversionTime.heureIntToString(tmp.getDuree(0), "h");
            }
            case 5: {
                if (tmp.getType() == 1) {
                    return true;
                }
                return false;
            }
            case 6: {
                if (tmp.getType() == 2) {
                    return true;
                }
                return false;
            }
        }
        return LanguageTranslator.getString("generics.notFound");
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 3 && this.data.get(row).getCle() != -1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        LienJourConducteur tmp = this.data.get(row);
        switch (col) {
            case 0: {
                JourType tmpF = new JourType((String)value);
                if (tmp.getCleJourType() == tmpF.getCle()) {
                    return;
                }
                tmp.setCleJourType(tmpF.getCle());
                break;
            }
            case 1: {
                tmp.setDateJour(ConversionTime.timestampUiToBdd(value.toString()));
                break;
            }
            case 2: {
                tmp.setHeureDebut(ConversionTime.heureStringToInt(value.toString(), "h"));
                break;
            }
            case 4: {
                tmp.setDuree(ConversionTime.heureStringToInt(value.toString(), "h"));
                if (tmp.getType() == 1) {
                    this.setValueAt(false, row, 5);
                }
                if (tmp.getType() != 2) break;
                this.setValueAt(false, row, 6);
                break;
            }
            case 5: {
                if (new Boolean(value.toString()).booleanValue()) {
                    tmp.setType(1);
                    break;
                }
                tmp.setType(0);
                break;
            }
            case 6: {
                if (new Boolean(value.toString()).booleanValue()) {
                    tmp.setType(2);
                    break;
                }
                tmp.setType(0);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void addRow(LienJourConducteur tmp) {
        this.insertRow(this.getRowCount(), tmp);
    }

    private void insertRow(int row, LienJourConducteur tmp) {
        this.data.insertElementAt(tmp, row);
        this.fireTableRowsInserted(row, row);
    }

    public void removeAllElements() {
        this.data.clear();
        this.fireTableRowsDeleted(0, this.getRowCount());
    }

    public LienJourConducteur removeRow(int row) {
        LienJourConducteur tmp = this.data.get(row);
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
        return tmp;
    }
}

