/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.JourType;
import java.awt.Color;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class TMDayType
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("dayType.designation"), LanguageTranslator.getString("generics.code"), LanguageTranslator.getString("generics.color"), LanguageTranslator.getString("dayType.defaultLength"), LanguageTranslator.getString("dayType.paid"), LanguageTranslator.getString("dayType.HSGenerator"), LanguageTranslator.getString("dayType.RCGenerator"), LanguageTranslator.getString("generics.export"), Fonctions.getSenorityWording()};
    private Vector<JourType> data = null;

    public TMDayType(Vector<JourType> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<JourType> getData() {
        return this.data;
    }

    public JourType getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        JourType tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return tmp.getDesignation();
            }
            case 1: {
                return tmp.getCode();
            }
            case 2: {
                return new Color(tmp.getColor());
            }
            case 3: {
                return ConversionTime.heureIntToString(tmp.getService(), "h");
            }
            case 4: {
                return tmp.isPaid();
            }
            case 5: {
                return tmp.isGenerateHS();
            }
            case 6: {
                return tmp.isGenerateRC();
            }
            case 7: {
                if (tmp.getExport() != 0) {
                    return true;
                }
                return false;
            }
            case 8: {
                return tmp.getSenority();
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? String.class : this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        JourType tmp = this.data.get(row);
        switch (col) {
            case 0: {
                tmp.setDesignation(value.toString());
                break;
            }
            case 1: {
                tmp.setCode(value.toString());
                break;
            }
            case 2: {
                tmp.setColor(((Color)value).getRGB());
                break;
            }
            case 3: {
                tmp.setService(ConversionTime.heureStringToInt(value.toString(), "h"));
                break;
            }
            case 4: {
                if (value.toString().equals("false")) {
                    tmp.setGenerateHS(false);
                }
                tmp.setPaid(new Boolean(value.toString()));
                break;
            }
            case 5: {
                if (value.toString().equals("true")) {
                    tmp.setPaid(true);
                }
                tmp.setGenerateHS(new Boolean(value.toString()));
                break;
            }
            case 6: {
                tmp.setGenerateRC(new Boolean(value.toString()));
                break;
            }
            case 7: {
                tmp.setExport(new Boolean(value.toString()) != false ? 1 : 0);
                break;
            }
            case 8: {
                tmp.setSenority(Integer.parseInt(value.toString()));
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void addRow(JourType tmp) {
        this.insertRow(this.getRowCount(), tmp);
    }

    private void insertRow(int row, JourType tmp) {
        this.data.insertElementAt(tmp, row);
        this.fireTableRowsInserted(row, row);
    }

    public void removeAllElements() {
        this.data.clear();
        this.fireTableRowsDeleted(0, this.getRowCount());
    }

    public JourType removeRow(int row) {
        JourType tmp = this.data.get(row);
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
        return tmp;
    }
}

