/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActionPriority;
import fr.pgh.data.bdd.DevAction;
import fr.pgh.data.bdd.DevCategory;
import fr.pgh.data.bdd.DevProduct;
import fr.pgh.data.bdd.DevState;
import fr.pgh.data.bdd.DevType;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.exception.DBObjectNotFoundException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMDevAction
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("generics.category"), LanguageTranslator.getString("generics.description"), LanguageTranslator.getString("generics.responsible"), LanguageTranslator.getString("generics.detection"), LanguageTranslator.getString("generics.correction"), LanguageTranslator.getString("generics.type"), LanguageTranslator.getString("generics.priority"), LanguageTranslator.getString("generics.state")};
    private Vector<DevAction> data = null;

    public TMDevAction(Vector<DevAction> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<DevAction> getData() {
        return this.data;
    }

    public DevAction getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        DevAction tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy HH'h'mm");
            }
            case 1: {
                try {
                    return DevCategory.get(tmp.getCategoryId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for category id " + tmp.getCategoryId());
                    return "?";
                }
            }
            case 2: {
                return tmp.getDescription();
            }
            case 3: {
                try {
                    return Utilisateur.find(tmp.getManagerId()).toString();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for manager id " + tmp.getManagerId());
                    return "?";
                }
            }
            case 4: {
                try {
                    return DevProduct.get(tmp.getDetectionVersionId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for product id " + tmp.getDetectionVersionId());
                    return "?";
                }
            }
            case 5: {
                try {
                    return DevProduct.get(tmp.getCorrectionVersionId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for product id " + tmp.getCorrectionVersionId());
                    return "?";
                }
            }
            case 6: {
                try {
                    return DevType.get(tmp.getTypeId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for type id " + tmp.getTypeId());
                    return "?";
                }
            }
            case 7: {
                try {
                    return ActionPriority.get(tmp.getPriorityId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for ActionPriority id " + tmp.getPriorityId());
                    return "?";
                }
            }
            case 8: {
                try {
                    return DevState.get(tmp.getStateId()).getName();
                }
                catch (DBObjectNotFoundException ex) {
                    TimsLogger.warn("no information for DevState id " + tmp.getStateId());
                    return "?";
                }
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

