/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DayPlanning;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DayTypeNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class TMDriverPlanning
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected Vector<?> list;
    protected Vector<String> date;
    protected ArrayList<Map<String, ?>> data = null;
    protected int rowSelected = -1;
    protected int beginSelected = -1;
    protected int endSelected = -1;

    public TMDriverPlanning(Vector<?> list, Vector<String> date, ArrayList<Map<String, ?>> data) {
        TimsLogger.debug("Show show ");
        for (Map<String, ?> toPrint : data) {
            Fonctions.afficheMap(toPrint);
        }
        this.list = list;
        this.date = date;
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.date == null ? 1 : this.date.size();
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Map<String, ?> tmp = this.data.get(row);
        Vector toReturn = (Vector)tmp.get(this.getColumnName(column));
        TimsLogger.debug(tmp.get(LanguageTranslator.getString("generics.driver")) + " / " + this.getColumnName(column) + " => " + (toReturn == null ? "null" : Integer.valueOf(toReturn.size())));
        return toReturn;
    }

    @Override
    public String getColumnName(int col) {
        return this.date.get(col);
    }

    public ArrayList<Map<String, ?>> getData() {
        return this.data;
    }

    public ArrayList<Map<String, ?>> getExcelData() {
        ArrayList excelData = new ArrayList();
        for (Map<String, ?> line : this.data) {
            Fonctions.afficheMap(line);
            String driver = line.get(LanguageTranslator.getString("generics.driver")).toString();
            HashMap<String, String> typeLibelle = new HashMap<String, String>();
            HashMap<String, String> vehicleLibelle = new HashMap<String, String>();
            HashMap<String, String> commLibelle = new HashMap<String, String>();
            typeLibelle.put(LanguageTranslator.getString("generics.driver"), driver);
            vehicleLibelle.put(LanguageTranslator.getString("generics.driver"), driver);
            commLibelle.put(LanguageTranslator.getString("generics.driver"), driver);
            excelData.add(typeLibelle);
            excelData.add(vehicleLibelle);
            excelData.add(commLibelle);
            for (Map.Entry<String, ?> set : line.entrySet()) {
                if (set.getKey().equals(LanguageTranslator.getString("generics.driver"))) continue;
                DayPlanning toAdd = (DayPlanning)((Vector)set.getValue()).get(0);
                String vehicles = "";
                for (Integer id : toAdd.getVehicles()) {
                    try {
                        vehicles = String.valueOf(vehicles) + ", " + Vehicule.getVehicule(null, id).getRegistrationNumber();
                    }
                    catch (DBObjectNotFoundException e) {
                        TimsLogger.warn("#PlanningAgence.loadTable# Vehicle not found " + id);
                    }
                }
                try {
                    typeLibelle.put(set.getKey().toString(), JourType.getDayType(toAdd.getDayTypeId()).getDesignation());
                }
                catch (DayTypeNotFoundException e) {
                    typeLibelle.put(set.getKey().toString(), LanguageTranslator.getString("generics.unknown"));
                }
                if (vehicles.length() != 0) {
                    vehicleLibelle.put(set.getKey().toString(), vehicles.substring(2));
                }
                commLibelle.put(set.getKey().toString(), toAdd.getComm());
            }
        }
        return excelData;
    }

    public Vector<String> getDate() {
        return this.date;
    }

    public Vector<?> getObjectList() {
        return this.list;
    }

    public void addValue(String day, Conducteur driver, DayPlanning toAdd) {
        TimsLogger.debug("#PTM.addValue# on ajoute " + toAdd.toString() + " pour " + driver.getNom() + " le " + day);
        int row = this.list.indexOf(driver);
        Map<String, ?> tmp = this.data.get(row);
        Vector<DayPlanning> list = new Vector<DayPlanning>();
        list.add(toAdd);
        tmp.put(day, list);
        this.fireTableRowsUpdated(row, row);
    }

    public void removeValue(String begin, String end, Conducteur driver) {
        boolean first = true;
        int row = this.list.indexOf(driver);
        Map<String, ?> tmp = this.data.get(row);
        while (!"".equals(end) && !begin.equals(end) || first) {
            tmp.remove(begin);
            first = false;
            begin = ConversionTime.addDay(begin, "dd/MM/yyyy", 1);
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void setSelectionBegin(int row, int column) {
        int oldRow = -1;
        if (this.rowSelected != -1) {
            oldRow = this.rowSelected;
        }
        this.rowSelected = row;
        this.beginSelected = column;
        this.endSelected = -1;
        if (oldRow != -1) {
            this.fireTableRowsUpdated(oldRow, oldRow);
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void setSelectionEnd(int column) {
        this.endSelected = column;
        this.fireTableRowsUpdated(this.rowSelected, this.rowSelected);
    }

    public int getSelectionEnd() {
        return this.endSelected;
    }

    public void clearSelection() {
        int row = this.rowSelected;
        this.rowSelected = -1;
        this.beginSelected = -1;
        this.endSelected = -1;
        if (row != -1) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    public int getSelectionType(int row, int col) {
        if (row != this.rowSelected) {
            return 0;
        }
        if (this.endSelected == -1 && this.beginSelected == col) {
            return 4;
        }
        if (this.endSelected != -1 && this.beginSelected <= col && col <= this.endSelected) {
            if (col == this.beginSelected) {
                return 1;
            }
            if (col == this.endSelected) {
                return 2;
            }
            return 3;
        }
        return 0;
    }
}

