/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.UevEventsFaults;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class TMEventsFaultsUev
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    ArrayList<UevEventsFaults> data;
    String[] column = new String[]{LanguageTranslator.getString("generics.begin"), LanguageTranslator.getString("generics.end"), LanguageTranslator.getString("vehicle.event.type"), LanguageTranslator.getString("generics.detail"), LanguageTranslator.getString("generics.cardNumber"), LanguageTranslator.getString("generics.driver")};

    public TMEventsFaultsUev(ArrayList<UevEventsFaults> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.column.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 5;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 5) {
            UevEventsFaults tmp = this.data.get(rowIndex);
            tmp.compareAndUpdateCard((Conducteur)aValue);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        UevEventsFaults tmp = this.data.get(parm1);
        switch (parm2) {
            case 0: {
                return ConversionTime.dateToString(tmp.getBegin(), "dd/MM/yyyy HH'h'mm");
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getEnd(), "dd/MM/yyyy HH'h'mm");
            }
            case 2: {
                return Fonctions.getCategorieEventFault(tmp.getTypeId());
            }
            case 3: {
                return Fonctions.getLibelleEventFault(tmp.getTypeId());
            }
            case 4: {
                String libelle = LanguageTranslator.getString("generics.unknown");
                if (tmp.getDriverCardBegin() != null && !tmp.getDriverCardBegin().startsWith("\u00ff\u00ff\u00ff") && !tmp.getDriverCardBegin().startsWith("??")) {
                    libelle = tmp.getDriverCardBegin();
                } else if (tmp.getDriverCardEnd() != null && !tmp.getDriverCardEnd().startsWith("\u00ff\u00ff\u00ff") && !tmp.getDriverCardEnd().startsWith("??")) {
                    libelle = tmp.getDriverCardEnd();
                } else if (tmp.getCodriverCardBegin() != null && !tmp.getCodriverCardBegin().startsWith("\u00ff\u00ff\u00ff") && !tmp.getCodriverCardBegin().startsWith("??")) {
                    libelle = tmp.getCodriverCardBegin();
                } else if (tmp.getCodriverCardEnd() != null && !tmp.getCodriverCardEnd().startsWith("\u00ff\u00ff\u00ff") && !tmp.getCodriverCardEnd().startsWith("??")) {
                    libelle = tmp.getCodriverCardEnd();
                }
                return libelle;
            }
            case 5: {
                String libelle = LanguageTranslator.getString("generics.unknown");
                if (tmp.getDriverCardBegin() != null && !tmp.getDriverCardBegin().startsWith("\u00ff\u00ff\u00ff\u00ff\u00ff") && !tmp.getDriverCardBegin().startsWith("??")) {
                    libelle = tmp.getDriverCardBegin().replace("*", "");
                } else if (tmp.getDriverCardEnd() != null && !tmp.getDriverCardEnd().startsWith("\u00ff\u00ff\u00ff") && !tmp.getDriverCardEnd().startsWith("??")) {
                    libelle = tmp.getDriverCardEnd().replace("*", "");
                } else if (tmp.getCodriverCardBegin() != null && !tmp.getCodriverCardBegin().startsWith("\u00ff\u00ff\u00ff") && !tmp.getCodriverCardBegin().startsWith("??")) {
                    libelle = tmp.getCodriverCardBegin().replace("*", "");
                } else if (tmp.getCodriverCardEnd() != null && !tmp.getCodriverCardEnd().startsWith("\u00ff\u00ff\u00ff") && !tmp.getCodriverCardEnd().startsWith("??")) {
                    libelle = tmp.getCodriverCardEnd().replace("*", "");
                }
                if (libelle.equals(LanguageTranslator.getString("generics.unknown"))) {
                    return libelle;
                }
                try {
                    Conducteur driver = Conducteur.getDriver(null, libelle, -1);
                    return String.valueOf(driver.getNom()) + " " + driver.getPrenom();
                }
                catch (Exception ex) {
                    TimsLogger.warn("#TableModelEventsFAults.getValueAt()# conducteur inconnu : " + libelle);
                    return LanguageTranslator.getString("generics.notFound");
                }
            }
        }
        return LanguageTranslator.getString("generics.notFound");
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.column[col];
    }
}

