/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Vehicule;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMGlobal
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    Vector<?> list;
    Vector<String> date;
    Vector<HashMap<String, Object>> data = null;

    public TMGlobal(Vector<?> list, Vector<String> date, Vector<HashMap<String, Object>> data) {
        this.list = list;
        this.date = date;
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.date.size() + 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String designation;
        if (column == 0) {
            if (this.list.get(row) instanceof Conducteur) {
                return String.valueOf(((Conducteur)this.list.get(row)).getNom()) + " " + ((Conducteur)this.list.get(row)).getPrenom();
            }
            return String.valueOf(((Vehicule)this.list.get(row)).getRegistrationNumber()) + " " + ((Vehicule)this.list.get(row)).getDesignation();
        }
        String toReturn = "";
        HashMap<String, Object> tmp = this.data.get(row);
        Integer time = (Integer)tmp.get(this.getColumnName(column));
        if (time == null) {
            time = 0;
        }
        toReturn = String.valueOf(toReturn) + ConversionTime.heureIntToString(time, "h");
        if (column != this.date.size() && (designation = (String)tmp.get(String.valueOf(this.getColumnName(column)) + "_ABS")) != null) {
            toReturn = String.valueOf(toReturn) + "<br>" + designation;
        }
        return toReturn;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public String getColumnName(int col) {
        String toReturn = "" + col;
        toReturn = col == 0 ? (this.list.get(0) instanceof Conducteur ? LanguageTranslator.getString("generics.driver") : LanguageTranslator.getString("generics.vehicle")) : (col == this.date.size() + 1 ? LanguageTranslator.getString("generics.total") : this.date.get(col - 1));
        return toReturn;
    }
}

