/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.VehicleUsed;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMIO
extends AbstractTableModel {
    Vector<VehicleUsed> donnees = null;
    String[] titres = new String[]{LanguageTranslator.getString("vehicle.io"), LanguageTranslator.getString("vehicle.io.withdraw"), LanguageTranslator.getString("user.lastName"), LanguageTranslator.getString("user.firstName"), LanguageTranslator.getString("generics.card"), LanguageTranslator.getString("vehicle.io.insertKm"), LanguageTranslator.getString("vehicle.io.withdrawKm"), LanguageTranslator.getString("vehicle.io.manualInput"), LanguageTranslator.getString("vehicle.io.slot")};

    public TMIO(Vector<VehicleUsed> donnees) {
        this.donnees = donnees;
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        VehicleUsed tmp = this.donnees.get(parm1);
        switch (parm2) {
            case 0: {
                return ConversionTime.dateToString(tmp.getDateDebut(), "dd/MM/yyyy HH'h'mm");
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getDateFin(), "dd/MM/yyyy HH'h'mm");
            }
            case 2: {
                return tmp.getNom();
            }
            case 3: {
                return tmp.getPrenom();
            }
            case 4: {
                return tmp.getNumeroCarte();
            }
            case 5: {
                return tmp.getKmDebut();
            }
            case 6: {
                return tmp.getKmFin();
            }
            case 7: {
                return tmp.isManualInput() ? 1 : 0;
            }
            case 8: {
                if (tmp.getLecteur() == 0) {
                    return LanguageTranslator.getString("slot.driver");
                }
                return LanguageTranslator.getString("slot.codriver");
            }
        }
        return LanguageTranslator.getString("generics.notFound");
    }

    @Override
    public int getRowCount() {
        return this.donnees.size();
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? String.class : this.getValueAt(0, c).getClass();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }
}

