/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.InterventionType;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMInterv
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    Vector<Intervention> list;
    String[] titres = new String[]{LanguageTranslator.getString("intervention.type"), LanguageTranslator.getString("generics.date"), LanguageTranslator.getString("generics.km"), LanguageTranslator.getString("intervention.performer"), LanguageTranslator.getString("generics.cost"), LanguageTranslator.getString("generics.moCost"), LanguageTranslator.getString("generics.state")};

    public TMInterv(Vector<Intervention> list) {
        this.list = list;
    }

    public void setInterv(Vector<Intervention> list) {
        this.list = list;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        Intervention tmp = this.list.get(parm1);
        switch (parm2) {
            case 0: {
                try {
                    return InterventionType.getInterventionType(tmp.getTypeId()).getName();
                }
                catch (Exception ex) {
                    TimsLogger.warn("Type d'intervention inconnu " + tmp.getTypeId());
                    return LanguageTranslator.getString("generics.notFound");
                }
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getDay(), "dd/MM/yyyy");
            }
            case 2: {
                return tmp.getKm();
            }
            case 3: {
                return tmp.getPerformer();
            }
            case 4: {
                return Float.valueOf(tmp.getCost());
            }
            case 5: {
                return Float.valueOf(tmp.getMoCost());
            }
            case 6: {
                return Intervention.getStatusLibelle(tmp.getState());
            }
        }
        return LanguageTranslator.getString("generics.notFound");
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }

    public Intervention getIntervAt(int row) {
        return this.list.get(row);
    }
}

