/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.EmployeeObligation;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.Intervention;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMObligation
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    Vector<EmployeeObligation> list;
    String[] columns = new String[]{LanguageTranslator.getString("obligation.type"), LanguageTranslator.getString("generics.obtaining"), LanguageTranslator.getString("generics.expiry"), LanguageTranslator.getString("generics.length"), LanguageTranslator.getString("generics.place"), LanguageTranslator.getString("generics.cost"), LanguageTranslator.getString("generics.state"), LanguageTranslator.getString("generics.attachmentAcronym")};

    public TMObligation(Vector<EmployeeObligation> list) {
        this.list = list;
    }

    public void setList(Vector<EmployeeObligation> list) {
        this.list = list;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        EmployeeObligation tmp = this.list.get(parm1);
        switch (parm2) {
            case 0: {
                try {
                    return EmployeeObligationType.getObligationType(tmp.getTypeId()).getName();
                }
                catch (Exception ex) {
                    TimsLogger.warn("Type d'obligation inconnu " + tmp.getTypeId());
                    return LanguageTranslator.getString("generics.notFound");
                }
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getDay(), "dd/MM/yyyy");
            }
            case 2: {
                if (tmp.getExpiration() == null) {
                    try {
                        return ConversionTime.dateToString(ConversionTime.addDay(tmp.getDay(), EmployeeObligationType.getObligationType(tmp.getTypeId()).getPeriodExpiration()), "dd/MM/yyyy");
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("Type d'obligation inconnu " + tmp.getTypeId());
                    }
                }
                return ConversionTime.dateToString(tmp.getExpiration(), "dd/MM/yyyy");
            }
            case 3: {
                return ConversionTime.heureIntToString(tmp.getLength(), "h");
            }
            case 4: {
                return tmp.getPlace();
            }
            case 5: {
                return Float.valueOf(tmp.getCost());
            }
            case 6: {
                return Intervention.getStatusLibelle(tmp.getState());
            }
            case 7: {
                return tmp.getAttachment();
            }
        }
        return LanguageTranslator.getString("generics.notFound");
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    public EmployeeObligation getObligationAt(int row) {
        return this.list.get(row);
    }
}

