/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMPrintable2
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected Vector<?> list;
    protected Vector<String> date;
    protected ArrayList<Map<String, ?>> data = null;

    public TMPrintable2(Vector<?> list, Vector<String> date, ArrayList<Map<String, ?>> data) {
        this.list = list;
        this.date = date;
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.date == null ? 1 : this.date.size() + 1;
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        String toReturn = "";
        Map<String, ?> tmp = this.data.get(row);
        Integer time = (Integer)tmp.get(this.getColumnName(column));
        if (time == null) {
            time = 0;
        }
        toReturn = String.valueOf(toReturn) + ConversionTime.heureIntToString(time, "h");
        if (column != this.date.size()) {
            String interv;
            String designation = (String)tmp.get(String.valueOf(this.getColumnName(column)) + "_ABS");
            if (designation != null && !designation.equals("")) {
                toReturn = String.valueOf(toReturn) + "<br>" + designation + " " + tmp.get(String.valueOf(this.getColumnName(column)) + "_COL").toString();
            }
            if ((interv = (String)tmp.get(String.valueOf(this.getColumnName(column)) + "_INT")) != null && !interv.equals("")) {
                toReturn = String.valueOf(toReturn) + "<br>" + interv;
            }
        }
        return toReturn;
    }

    @Override
    public String getColumnName(int col) {
        if (this.date == null || col == this.date.size()) {
            return LanguageTranslator.getString("generics.total");
        }
        return this.date.get(col);
    }

    public ArrayList<Map<String, ?>> getData() {
        return this.data;
    }

    public Vector<String> getDate() {
        return this.date;
    }

    public Vector<?> getObjectList() {
        return this.list;
    }

    public void addValue(String day, Conducteur driver, String code, int remuneration, int color) {
        TimsLogger.debug("#PTM.addValue# on ajoute " + code + " (" + remuneration + ") pour " + driver.getNom() + " le " + day);
        int row = this.list.indexOf(driver);
        Integer oldTotal = (Integer)this.data.get(row).get(day);
        if (oldTotal == null) {
            oldTotal = 0;
        }
        Map<String, ?> tmp = this.data.get(row);
        tmp.put(day, oldTotal + remuneration);
        tmp.put(String.valueOf(day) + "_ABS", code);
        tmp.put(String.valueOf(day) + "_COL", color);
        oldTotal = (Integer)this.data.get(row).get(LanguageTranslator.getString("generics.total"));
        if (oldTotal == null) {
            oldTotal = 0;
        }
        tmp.put(LanguageTranslator.getString("generics.total"), oldTotal + remuneration);
        this.fireTableRowsUpdated(row, row);
    }
}

