/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Rate;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMRate
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("rate.115M"), LanguageTranslator.getString("rate.118M"), LanguageTranslator.getString("rate.120M"), LanguageTranslator.getString("rate.128M"), LanguageTranslator.getString("rate.138M"), LanguageTranslator.getString("rate.150M"), LanguageTranslator.getString("rate.beginDate"), LanguageTranslator.getString("rate.insertionDate")};
    private Vector<Rate> data = null;

    public TMRate(Vector<Rate> data, TableModelListener listener) {
        this.addTableModelListener(listener);
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<Rate> getData() {
        return this.data;
    }

    public Rate getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Rate tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return Float.valueOf(tmp.getT115M());
            }
            case 1: {
                return Float.valueOf(tmp.getT118M());
            }
            case 2: {
                return Float.valueOf(tmp.getT120M());
            }
            case 3: {
                return Float.valueOf(tmp.getT128M());
            }
            case 4: {
                return Float.valueOf(tmp.getT138M());
            }
            case 5: {
                return Float.valueOf(tmp.getT150M());
            }
            case 6: {
                return ConversionTime.dateToStringFr(tmp.getDateDebut());
            }
            case 7: {
                return ConversionTime.dateToStringFr(tmp.getDateInsertion());
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 6 && col != 7;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        Rate tmp = this.data.get(row);
        switch (col) {
            case 0: {
                tmp.setT115M(Float.parseFloat(value.toString()));
                break;
            }
            case 1: {
                tmp.setT118M(Float.parseFloat(value.toString()));
                break;
            }
            case 2: {
                tmp.setT120M(Float.parseFloat(value.toString()));
                break;
            }
            case 3: {
                tmp.setT128M(Float.parseFloat(value.toString()));
                break;
            }
            case 4: {
                tmp.setT138M(Float.parseFloat(value.toString()));
                break;
            }
            case 5: {
                tmp.setT150M(Float.parseFloat(value.toString()));
                break;
            }
            case 6: {
                tmp.setDateDebut(ConversionTime.stringToDate(value.toString(), "dd/MM/yyyy"));
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public void addRow(Rate tmp) {
        this.insertRow(this.getRowCount(), tmp);
    }

    private void insertRow(int row, Rate tmp) {
        this.data.insertElementAt(tmp, row);
        this.fireTableRowsInserted(row, row);
    }

    public void removeAllElements() {
        this.data.clear();
        this.fireTableRowsDeleted(0, this.getRowCount());
    }

    public Rate removeRow(int row) {
        Rate tmp = this.data.get(row);
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
        return tmp;
    }
}

