/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Region;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMRegion
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.region"), LanguageTranslator.getString("generics.code"), LanguageTranslator.getString("generics.country")};
    private Vector<Region> data = null;

    public TMRegion(Vector<Region> data, TableModelListener listener) {
        this.addTableModelListener(listener);
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<Region> getData() {
        return this.data;
    }

    public Region getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Region tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return tmp.getName();
            }
            case 1: {
                return tmp.getCode();
            }
            case 2: {
                return Pays.LIBELLE[tmp.getCountryId()][1];
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        Region tmp = this.data.get(row);
        switch (col) {
            case 0: {
                tmp.setName(value.toString());
                break;
            }
            case 1: {
                tmp.setCode(value.toString());
                break;
            }
            case 2: {
                tmp.setCountryId(Pays.getPays(value.toString()).getCle());
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public void addRow(Region tmp) {
        this.insertRow(this.getRowCount(), tmp);
    }

    private void insertRow(int row, Region tmp) {
        this.data.insertElementAt(tmp, row);
        this.fireTableRowsInserted(row, row);
    }

    public void removeAllElements() {
        this.data.clear();
        this.fireTableRowsDeleted(0, this.getRowCount());
    }

    public Region removeRow(int row) {
        Region tmp = this.data.get(row);
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
        return tmp;
    }
}

