/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.Report;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMReport
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.originalName"), LanguageTranslator.getString("generics.customizedName")};
    private Vector<Report> data = null;

    public TMReport(Vector<Report> donnees) {
        this.data = donnees;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Report tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return LanguageTranslator.getString("report." + tmp.getTranslationId());
            }
            case 1: {
                return tmp.getCustomizedName();
            }
        }
        String retour = LanguageTranslator.getString("generics.notFound");
        return retour;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Report tmp = this.data.get(row);
        switch (col) {
            case 1: {
                tmp.setCustomizedName(value.toString());
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public Vector<Report> getTableau() {
        return this.data;
    }
}

