/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.UevSpeed;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMSpeed
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    ArrayList<UevSpeed> donnees = null;
    Vector<Conducteur> drivers = null;
    String[] titres = new String[]{LanguageTranslator.getString("generics.begin"), LanguageTranslator.getString("generics.end"), LanguageTranslator.getString("speed.maximumSpeed"), LanguageTranslator.getString("speed.averageSpeed"), LanguageTranslator.getString("generics.cardNumber"), LanguageTranslator.getString("generics.driver")};

    public TMSpeed(ArrayList<UevSpeed> donnees) {
        this.donnees = donnees;
        this.drivers = Conducteur.loadList(new Integer[0]);
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 5) {
            UevSpeed tmp = this.donnees.get(rowIndex);
            tmp.compareAndUpdateCard((Conducteur)aValue);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 5;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        UevSpeed tmp = this.donnees.get(parm1);
        switch (parm2) {
            case 0: {
                return ConversionTime.dateToString(tmp.getDateDebut(), "dd/MM/yyyy HH'h'mm':'ss");
            }
            case 1: {
                return ConversionTime.dateToString(tmp.getDateFin(), "dd/MM/yyyy HH'h'mm':'ss");
            }
            case 2: {
                return tmp.getVitesseMax();
            }
            case 3: {
                return tmp.getVitesseMoyenne();
            }
            case 4: {
                if (tmp.getNumeroCarteConducteur() == null || tmp.getNumeroCarteConducteur().startsWith("\u00ff\u00ff") || tmp.getNumeroCarteConducteur().startsWith("??")) {
                    return LanguageTranslator.getString("generics.unknown");
                }
                return tmp.getNumeroCarteConducteur();
            }
            case 5: {
                if (tmp.getNumeroCarteConducteur() == null || tmp.getNumeroCarteConducteur().startsWith("\u00ff\u00ff") || tmp.getNumeroCarteConducteur().startsWith("??")) {
                    return LanguageTranslator.getString("generics.unknown");
                }
                try {
                    Conducteur driver = Conducteur.getDriver(this.drivers, tmp.getNumeroCarteConducteur().replace("*", ""), -1);
                    return String.valueOf(driver.getNom()) + " " + driver.getPrenom();
                }
                catch (Exception ex) {
                    TimsLogger.warn("#TableModelSpeed.getValueAt()# conducteur inconnu : " + tmp.getNumeroCarteConducteur());
                    return LanguageTranslator.getString("generics.notFound");
                }
            }
        }
        return LanguageTranslator.getString("generics.notFound");
    }

    @Override
    public int getRowCount() {
        return this.donnees.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }
}

