/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.UserWarningActivation;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMUserAlert
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.name"), LanguageTranslator.getString("parameters.enable")};
    private ArrayList<AutomaticWarning> data = null;
    private ArrayList<UserWarningActivation> activation = new ArrayList();

    public TMUserAlert(ArrayList<AutomaticWarning> data) {
        this.data = data;
    }

    public void setActivation(ArrayList<UserWarningActivation> activation) {
        this.activation = activation;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        AutomaticWarning tmp = this.data.get(row);
        switch (col) {
            case 0: {
                return LanguageTranslator.getString(tmp.getName());
            }
            case 1: {
                if (this.activation == null) {
                    return false;
                }
                for (UserWarningActivation tmpC : this.activation) {
                    if (tmp.getId() != tmpC.getAutoWarningId()) continue;
                    return true;
                }
                return false;
            }
        }
        String retour = LanguageTranslator.getString("generics.notFound");
        return retour;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        AutomaticWarning tmp = this.data.get(row);
        switch (col) {
            case 1: {
                if ("true".equals(value.toString())) {
                    this.activation.add(new UserWarningActivation(0, tmp.getId(), 0));
                    break;
                }
                int x = 0;
                while (x < this.activation.size()) {
                    UserWarningActivation tmpC = this.activation.get(x);
                    if (tmp.getId() == tmpC.getAutoWarningId()) {
                        if (tmpC.getId() != 0) {
                            tmpC.delete();
                        }
                        this.activation.remove(x);
                    }
                    ++x;
                }
                break;
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public ArrayList<UserWarningActivation> getActivation() {
        return this.activation;
    }
}

