/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Vehicule;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMVehicle
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    Vector<Vehicule> vehicule;
    Vector<String> date;
    Integer[][] value;

    public TMVehicle(Vector<Vehicule> vehicule, Vector<String> date, Integer[][] value) {
        this.vehicule = vehicule;
        this.date = date;
        this.value = value;
    }

    @Override
    public int getColumnCount() {
        return this.date.size() + 2;
    }

    @Override
    public Object getValueAt(int parm1, int parm2) {
        if (parm2 == 0) {
            return this.vehicule.get(parm1).getRegistrationNumber();
        }
        if (parm2 == this.date.size() + 1) {
            return ConversionTime.heureIntToString(this.getTotal(parm1).toString(), "h");
        }
        return ConversionTime.heureIntToString(this.value[parm1][parm2 - 1], "h");
    }

    @Override
    public int getRowCount() {
        return this.vehicule.size();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return LanguageTranslator.getString("generics.vehicle");
        }
        if (col == this.date.size() + 1) {
            return LanguageTranslator.getString("generics.total");
        }
        return ConversionTime.dateFromBDDToFrance(this.date.get(col - 1), false, false).substring(0, 5);
    }

    public Object getTotal(int parm1) {
        Integer somme = 0;
        int x = 0;
        while (x < this.value[parm1].length) {
            somme = somme + this.value[parm1][x];
            ++x;
        }
        return somme;
    }
}

