/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.DayPlanning;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class TMVehiclePlanning
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected Vector<?> list;
    protected Vector<String> date;
    protected ArrayList<Map<String, ?>> data = null;
    protected int rowSelected = -1;
    protected int beginSelected = -1;
    protected int endSelected = -1;

    public TMVehiclePlanning(Vector<?> list, Vector<String> date, ArrayList<Map<String, ?>> data) {
        TimsLogger.debug("Show show ");
        for (Map<String, ?> toPrint : data) {
            Fonctions.afficheMap(toPrint);
        }
        this.list = list;
        this.date = date;
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.date == null ? 1 : this.date.size();
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Map<String, ?> tmp = this.data.get(row);
        Vector toReturn = (Vector)tmp.get(this.getColumnName(column));
        TimsLogger.debug(tmp.get(LanguageTranslator.getString("generics.vehicle")) + " / " + this.getColumnName(column) + " => " + (toReturn == null ? "null" : Integer.valueOf(toReturn.size())));
        return tmp.get(this.getColumnName(column));
    }

    @Override
    public String getColumnName(int col) {
        return this.date.get(col);
    }

    public ArrayList<Map<String, ?>> getData() {
        return this.data;
    }

    public ArrayList<Map<String, ?>> getExcelData() {
        ArrayList excelData = new ArrayList();
        for (Map<String, ?> map : this.data) {
        }
        return excelData;
    }

    public Vector<String> getDate() {
        return this.date;
    }

    public Vector<?> getObjectList() {
        return this.list;
    }

    public Object getSelectedObject() {
        return this.rowSelected == -1 ? null : this.list.get(this.rowSelected);
    }

    public void addValue(String day, Vehicule vehicle, DayPlanning toAdd) {
        TimsLogger.debug("#PTM.addValue# on ajoute " + toAdd.toString() + " pour " + vehicle.getRegistrationNumber() + " le " + day);
        int row = this.list.indexOf(vehicle);
        if (row == -1) {
            return;
        }
        Map<String, ?> tmp = this.data.get(row);
        Vector<DayPlanning> list = new Vector<DayPlanning>();
        list.add(toAdd);
        tmp.put(day, list);
        this.fireTableRowsUpdated(row, row);
    }

    public void removeValue(String begin, String end, Vehicule vehicle) {
        boolean first = true;
        int row = this.list.indexOf(vehicle);
        if (row == -1) {
            return;
        }
        Map<String, ?> tmp = this.data.get(row);
        while (!"".equals(end) && !begin.equals(end) || first) {
            tmp.remove(begin);
            first = false;
            begin = ConversionTime.addDay(begin, "dd/MM/yyyy", 1);
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void setSelectionBegin(int row, int column) {
        this.rowSelected = row;
        this.beginSelected = column;
        this.endSelected = -1;
        this.fireTableDataChanged();
    }

    public void setSelectionEnd(int column) {
        this.endSelected = column;
        this.fireTableDataChanged();
    }

    public void clearSelection() {
        int row = this.rowSelected;
        this.rowSelected = -1;
        this.beginSelected = -1;
        this.endSelected = -1;
        this.fireTableRowsUpdated(row, row);
    }

    public int getSelectionType(int row, int col) {
        if (row != this.rowSelected) {
            return 0;
        }
        if (this.endSelected == -1 && this.beginSelected == col) {
            return 4;
        }
        if (this.endSelected != -1 && this.beginSelected <= col && col <= this.endSelected) {
            if (col == this.beginSelected) {
                return 1;
            }
            if (col == this.endSelected) {
                return 2;
            }
            return 3;
        }
        return 0;
    }
}

