/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMVehicleUsed
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.vehicle"), LanguageTranslator.getString("generics.begin"), LanguageTranslator.getString("generics.begin"), LanguageTranslator.getString("generics.end"), LanguageTranslator.getString("generics.end"), LanguageTranslator.getString("vehicle.departure"), LanguageTranslator.getString("vehicle.arrival"), LanguageTranslator.getString("generics.total")};
    private Vector<VehicleUsed> data = null;

    public TMVehicleUsed(Vector<VehicleUsed> data, TableModelListener listener) {
        this.addTableModelListener(listener);
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<VehicleUsed> getData() {
        return this.data;
    }

    @Override
    public Object getValueAt(int row, int col) {
        VehicleUsed tmp = this.data.get(row);
        switch (col) {
            case 0: {
                if (tmp.getCleVehicule() != 0) {
                    return tmp.getImmatriculation();
                }
                return tmp.getImmatriculation() == null ? LanguageTranslator.getString("generics.unknown") : String.valueOf(tmp.getImmatriculation()) + "*";
            }
            case 1: {
                return ConversionTime.dateToStringFr(tmp.getDateDebut());
            }
            case 2: {
                return ConversionTime.dateToString(tmp.getDateDebut(), "HH'h'mm");
            }
            case 3: {
                return ConversionTime.dateToStringFr(tmp.getDateFin());
            }
            case 4: {
                return ConversionTime.dateToString(tmp.getDateFin(), "HH'h'mm");
            }
            case 5: {
                return tmp.getKmDebut();
            }
            case 6: {
                return tmp.getKmFin();
            }
            case 7: {
                return tmp.getKmFin() - tmp.getKmDebut();
            }
        }
        return "?";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 1 && col != 3 && col != 7;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        VehicleUsed tmp = this.data.get(row);
        switch (col) {
            case 0: {
                Vehicule tmpV = new Vehicule();
                String field = (String)value;
                TimsLogger.verbose("#TMVU.setValueOf# last index of '-' = " + field.lastIndexOf("-") + " length = " + field.length());
                int endIndex = field.indexOf(" - ");
                if (endIndex == -1) {
                    endIndex = ((String)value).length();
                }
                if (!tmpV.loadByImmat(((String)value).substring(0, endIndex).trim(), true)) {
                    TimsLogger.warn("#TMVU.setValueOf# not found : " + ((String)value).substring(0, endIndex).trim());
                }
                tmp.setCleVehicule(tmpV.getCleVehicule());
                tmp.setImmatriculation(tmpV.getRegistrationNumber());
                break;
            }
            case 1: {
                tmp.setDateDebut(ConversionTime.stringToDate(String.valueOf(String.valueOf(value)) + " " + this.getValueAt(row, 2), "dd/MM/yyyy HH'h'mm"));
                break;
            }
            case 2: {
                tmp.setDateDebut(ConversionTime.stringToDate(this.getValueAt(row, 1) + " " + String.valueOf(value), "dd/MM/yyyy HH'h'mm"));
                break;
            }
            case 3: {
                tmp.setDateFin(ConversionTime.stringToDate(String.valueOf(String.valueOf(value)) + " " + this.getValueAt(row, 4), "dd/MM/yyyy HH'h'mm"));
                break;
            }
            case 4: {
                tmp.setDateFin(ConversionTime.stringToDate(this.getValueAt(row, 3) + " " + String.valueOf(value), "dd/MM/yyyy HH'h'mm"));
                break;
            }
            case 5: {
                tmp.setKmDebut((Integer)value);
                this.setValueAt((Integer)this.getValueAt(row, 6) - (Integer)this.getValueAt(row, 5), row, 7);
                break;
            }
            case 6: {
                tmp.setKmFin((Integer)value);
                this.setValueAt((Integer)this.getValueAt(row, 6) - (Integer)this.getValueAt(row, 5), row, 7);
                break;
            }
            case 7: {
                tmp.setKmEffectue((Integer)value);
            }
        }
        TimsLogger.verbose("nb listener " + this.listenerList.getListenerList().length);
        this.fireTableCellUpdated(row, col);
    }

    public void addRow(VehicleUsed tmp) {
        this.insertRow(this.getRowCount(), tmp);
    }

    private void insertRow(int row, VehicleUsed tmp) {
        this.data.insertElementAt(tmp, row);
        this.fireTableRowsInserted(row, row);
    }

    public VehicleUsed removeRow(int row) {
        VehicleUsed tmp = this.data.get(row);
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
        return tmp;
    }

    public VehicleUsed getRow(int row) {
        return this.data.get(row);
    }
}

