/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.modele;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class TMWidgetDriverExpiration
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{LanguageTranslator.getString("generics.driver"), LanguageTranslator.getString("driver.fimoFco"), LanguageTranslator.getString("generics.cardExpiration"), LanguageTranslator.getString("user.medicalExam"), LanguageTranslator.getString("driver.licenceMedicalExam"), LanguageTranslator.getString("driver.adr"), LanguageTranslator.getString("driver.caces")};
    private Vector<Conducteur> data = null;

    public TMWidgetDriverExpiration(Vector<Conducteur> data) {
        this.data = data;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Vector<Conducteur> getData() {
        return this.data;
    }

    public Conducteur getRow(int row) {
        return this.data.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Conducteur tmp = this.data.get(row);
        int toAdd = 0;
        Date toReturn = null;
        switch (col) {
            case 0: {
                return String.valueOf(tmp.getNom()) + " " + tmp.getPrenom();
            }
            case 1: {
                toReturn = ConversionTime.stringToDate2(tmp.getFimoFco(), "yyyy-MM-dd");
                toAdd = Integer.parseInt(System.getProperty("fco_expiration", "1826"));
                break;
            }
            case 2: {
                return ConversionTime.stringToDate2(tmp.getDateFinValiditeCarte(), "yyyy-MM-dd");
            }
            case 3: {
                toReturn = ConversionTime.stringToDate2(tmp.getDateVisite(), "yyyy-MM-dd");
                toAdd = Integer.parseInt(System.getProperty("medical_visit_expiration", "1826"));
                if (!tmp.isNightWorker()) break;
                toAdd = Integer.parseInt(System.getProperty("medical_visit_night_expiration", "200"));
                break;
            }
            case 4: {
                toReturn = ConversionTime.stringToDate2(tmp.getDateVisitePermis(), "yyyy-MM-dd");
                toAdd = Integer.parseInt(System.getProperty("medical_visit_driving_expiration", "1826"));
                break;
            }
            case 5: {
                toReturn = ConversionTime.stringToDate2(tmp.getAdr(), "yyyy-MM-dd");
                toAdd = Integer.parseInt(System.getProperty("adr_expiration", "1826"));
                break;
            }
            case 6: {
                toReturn = ConversionTime.stringToDate2(tmp.getCaces(), "yyyy-MM-dd");
                toAdd = Integer.parseInt(System.getProperty("caces_expiration", "1826"));
            }
        }
        if (toReturn == null) {
            return toReturn;
        }
        return ConversionTime.addDay(toReturn, toAdd);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? String.class : this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TimsLogger.verbose("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        Conducteur tmp = this.data.get(row);
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                tmp.setFimoFco((String)value);
                break;
            }
            case 3: {
                tmp.setDateFinValiditeCarte((String)value);
                break;
            }
            case 5: {
                tmp.setDateVisite((String)value);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public void removeAllElements() {
        this.data.clear();
        this.fireTableRowsDeleted(0, this.getRowCount());
    }
}

