/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.renderer;

import fr.pgh.conversion.ConversionTime;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Fonctions;

public class InterventionStateRenderer
extends JLabel
implements TableCellRenderer {
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered;

    public InterventionStateRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    public static void initialize(JTable table) {
        TableColumn column = null;
        int x = 0;
        while (x < table.getModel().getColumnCount()) {
            column = table.getColumnModel().getColumn(x);
            if (x < 2) {
                column.setPreferredWidth(70);
            } else if ((x - 2) % 3 != 0) {
                Fonctions.hideColumn(column);
            } else {
                column.setMinWidth(45);
                column.setCellRenderer(new InterventionStateRenderer(false));
            }
            ++x;
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background = null;
        if (column < 2) {
            this.setBackground(Color.white);
            this.setHorizontalAlignment(2);
            return this;
        }
        this.setHorizontalAlignment(0);
        if (value == null) {
            background = MainFrameTransport.BG_COLOR_UNABLE;
            this.setText("");
        } else {
            background = (Color)table.getModel().getValueAt(row, column + 1);
            Date dayOfValue = (Date)value;
            this.setText(ConversionTime.dateToString(dayOfValue, "dd/MM/yyyy"));
        }
        if (background == null) {
            return this;
        }
        this.setBackground(background);
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        return this;
    }
}

