/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class ObligationTableRenderer
extends DefaultTableCellRenderer {
    Color CANCELLED = new Color(0xFFF1F1);
    Color SCHEDULED = new Color(16775589);
    Color DONE = new Color(0xDEFFDE);
    ImageIcon attachment = new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_loupe")));

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setForeground(Color.black);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else if (table.getModel().getValueAt(row, 6).equals(LanguageTranslator.getString("generics.done"))) {
            this.setBackground(this.DONE);
        } else if (table.getModel().getValueAt(row, 6).equals(LanguageTranslator.getString("generics.scheduled"))) {
            this.setBackground(this.SCHEDULED);
        } else if (table.getModel().getValueAt(row, 6).equals(LanguageTranslator.getString("generics.cancelled"))) {
            this.setBackground(this.CANCELLED);
        }
        if (col == 7) {
            this.setText(null);
            this.setIcon(this.attachment);
            this.setEnabled(value != null);
            this.setToolTipText(value != null ? value.toString() : LanguageTranslator.getString("generics.none"));
        } else {
            this.setEnabled(true);
            this.setIcon(null);
            this.setText(value.toString());
            this.setToolTipText(null);
        }
        return this;
    }
}

