/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.PopupCaller;
import transpo.system.util.Fonctions;

public class AbsencePopup
extends JPopupMenu
implements DataListener {
    JList<JourType> list = null;
    JTextField txtBegin = null;
    JTextField txtEnd = null;
    JButton btnPlus = null;
    JButton btnMinus = null;
    MouseListener lsl = null;
    JourType selected = null;
    Conducteur current = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        BddEvent e;
        if (dataEvent instanceof BddEvent && (e = (BddEvent)dataEvent).getTable().equals(JourType.table)) {
            this.getList().setModel(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
        }
    }

    public AbsencePopup() {
        this.initialize();
    }

    public void set(Conducteur driver, Date begin) {
        this.current = driver;
        this.getTxtBegin().setText(ConversionTime.dateToStringFr(begin));
        this.getTxtEnd().setText(ConversionTime.dateToStringFr(begin));
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (!(invoker instanceof PopupCaller)) {
            TimsLogger.debug("ListPopup must be invoked by a class which is implementing ListPopupCaller");
            return;
        }
        TimsLogger.debug(" source at " + invoker.getX() + " " + invoker.getY());
        super.show(invoker, x, y);
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(LanguageTranslator.getString("generics.from")), Fonctions.getGridBagConstraints(0, 0));
        this.add((Component)this.getTxtBegin(), Fonctions.getGridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
        this.add((Component)new JLabel(LanguageTranslator.getString("generics.to")), Fonctions.getGridBagConstraints(0, 1));
        this.add((Component)this.getBtnMinus(), Fonctions.getGridBagConstraints(1, 1));
        this.add((Component)this.getTxtEnd(), Fonctions.getGridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
        this.add((Component)this.getBtnPlus(), Fonctions.getGridBagConstraints(3, 1));
        this.add(this.getList(), Fonctions.getGridBagConstraints(0, 2, 1, 4, 1.0, 1.0, 1, -1, null));
    }

    public JList<JourType> getList() {
        if (this.list == null) {
            this.list = new JList(new ComboBoxModel(JourType.getList(), true, LanguageTranslator.getString("generics.none")));
        }
        return this.list;
    }

    public JTextField getTxtBegin() {
        if (this.txtBegin == null) {
            this.txtBegin = new JTextField();
        }
        return this.txtBegin;
    }

    public JTextField getTxtEnd() {
        if (this.txtEnd == null) {
            this.txtEnd = new JTextField();
        }
        return this.txtEnd;
    }

    public JButton getBtnPlus() {
        if (this.btnPlus == null) {
            this.btnPlus = new JButton("+");
            this.btnPlus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbsencePopup.this.getTxtEnd().setText(ConversionTime.addDay(AbsencePopup.this.getTxtEnd().getText(), "dd/MM/yyyy", 1));
                    AbsencePopup.this.getBtnMinus().setEnabled(true);
                }
            });
        }
        return this.btnPlus;
    }

    public JButton getBtnMinus() {
        if (this.btnMinus == null) {
            this.btnMinus = new JButton("-");
            this.btnMinus.setEnabled(false);
            this.btnMinus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbsencePopup.this.getTxtEnd().setText(ConversionTime.addDay(AbsencePopup.this.getTxtEnd().getText(), "dd/MM/yyyy", -1));
                    if (AbsencePopup.this.getTxtEnd().getText().equals(AbsencePopup.this.getTxtBegin().getText())) {
                        AbsencePopup.this.getBtnMinus().setEnabled(false);
                    } else {
                        AbsencePopup.this.getBtnMinus().setEnabled(true);
                    }
                }
            });
        }
        return this.btnMinus;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.getList().removeMouseListener(this.getMouseListener());
        }
        if (visible) {
            this.getList().addMouseListener(this.getMouseListener());
        }
        super.setVisible(visible);
    }

    public void saveAndExit() {
        this.selected = (JourType)((ComboBoxModel)this.getList().getModel()).getObjectAt(this.getList().getSelectedIndex());
        Date beginDate = ConversionTime.stringToDateFr(this.getTxtBegin().getText());
        Date endDate = ConversionTime.stringToDateFr(this.getTxtEnd().getText());
        while (beginDate.compareTo(endDate) <= 0) {
            TimsLogger.verbose("#AbsencePopup.saveAndExit# add " + (this.selected == null ? "none" : this.selected.getCode()) + " on " + beginDate);
            if (this.selected == null) {
                LienJourConducteur tmp = new LienJourConducteur();
                tmp.load(this.current.getCle(), new Timestamp(beginDate.getTime()));
                if (tmp.getCle() != 0) {
                    TimsLogger.debug("#AbsencePopup.saveAndExit# delete " + tmp.getDesignation());
                    tmp.delete();
                }
            } else {
                LienJourConducteur ljc = new LienJourConducteur();
                ljc.setCleUser(ConnexionSettings.getInstance().getUserCle());
                ljc.setCleConducteur(this.current.getCleConducteur());
                ljc.setDateJour(beginDate);
                ljc.setHeureDebut(480);
                ljc.setCleJourType(this.selected.getCle());
                ljc.setType(2);
                ljc.update();
            }
            beginDate = ConversionTime.addDay(beginDate, 1);
        }
        this.setVisible(false);
        ((PopupCaller)((Object)this.getInvoker())).submitPopup();
    }

    public MouseListener getMouseListener() {
        if (this.lsl == null) {
            this.lsl = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AbsencePopup.this.saveAndExit();
                    }
                }
            };
        }
        return this.lsl;
    }

    public Object getSelected() {
        return this.selected;
    }
}

