/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.TypeActivite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogDetailActivApercu;
import transpo.system.ui.views.GrapheActivite;
import transpo.system.ui.views.PnlLegende;
import transpo.system.util.Fonctions;

public class ApercuCarte
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private GrapheActivite panelGraph = null;
    private Vector<Jour> dayInfo = null;
    private Vector<Jour> printedDay = new Vector();
    private int nbJour = 0;
    private int nbPage = 0;
    private int pageCourante = 1;
    private JButton boutonGauche = null;
    private JButton boutonDroit = null;
    private JButton[] libelleJour = new JButton[7];
    private JLabel lnbPages = new JLabel();
    private JButton boutonQuit = null;
    private PnlLegende pLegende = null;

    public ApercuCarte(JFrame f, Vector<ChangementActivite> activityChangeInfo) {
        super(f);
        this.getJour(activityChangeInfo);
        this.nbJour = this.dayInfo.size();
        this.pageCourante = this.nbPage = this.nbJour % 7 == 0 ? this.nbJour / 7 : this.nbJour / 7 + 1;
        this.initialize();
    }

    public ApercuCarte(JFrame f, ArrayList<Jour> days) {
        super(f);
        this.dayInfo = new Vector();
        for (Jour toAdd : days) {
            this.dayInfo.add(toAdd);
        }
        this.nbJour = this.dayInfo.size();
        this.pageCourante = this.nbPage = this.nbJour % 7 == 0 ? this.nbJour / 7 : this.nbJour / 7 + 1;
        this.initialize();
    }

    private void getJour(Vector<ChangementActivite> activityChangeInfo) {
        this.dayInfo = new Vector();
        int x = 0;
        int conduite = 0;
        int travail = 0;
        int dispo = 0;
        int repos = 0;
        int de = 0;
        int inconnu = 0;
        int nuit = 0;
        Vector<ActiviteConducteur> tmpJour = new Vector<ActiviteConducteur>();
        while (x < activityChangeInfo.size()) {
            int duree;
            ChangementActivite tmp = activityChangeInfo.get(x);
            int heureFin = 1440;
            if (x != activityChangeInfo.size() - 1 && activityChangeInfo.get(x + 1).getDate().equals(tmp.getDate())) {
                heureFin = activityChangeInfo.get(x + 1).getHeure();
            }
            if ((duree = heureFin - tmp.getHeure()) != 0) {
                try {
                    TypeActivite ta = TypeActivite.getActivityType(tmp.getTypeActivite());
                    tmpJour.add(new ActiviteConducteur(0, 0, 0, tmp.getTypeActivite(), ta.getName(), String.valueOf(ta.getColor()), tmp.getHeure(), heureFin, duree, ConversionTime.dateToString(tmp.getDate(), "yyyy-MM-dd"), "", "CAP", tmp.getEtatCarte(), tmp.getEtatConduite(), tmp.getLecteur(), 0, 0, 0));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (x == activityChangeInfo.size() - 1 || !activityChangeInfo.get(x + 1).getDate().equals(tmp.getDate())) {
                String dateJour = ConversionTime.dateToString(activityChangeInfo.get(x).getDate(), "yyyy-MM-dd");
                int debut = Integer.parseInt(Fonctions.getHeureDebut(tmpJour));
                int fin = Integer.parseInt(Fonctions.getHeureFin(tmpJour));
                int y = 0;
                while (y < tmpJour.size()) {
                    ActiviteConducteur act = tmpJour.get(y);
                    switch (act.getCleType()) {
                        case 1: {
                            conduite += act.getDuree();
                            nuit += Fonctions.getTempsNuit(act);
                            break;
                        }
                        case 2: {
                            travail += act.getDuree();
                            nuit += Fonctions.getTempsNuit(act);
                            break;
                        }
                        case 3: {
                            dispo += act.getDuree();
                            nuit += Fonctions.getTempsNuit(act);
                            break;
                        }
                        case 4: {
                            repos += act.getDuree();
                            break;
                        }
                        case 5: {
                            de += act.getDuree();
                            nuit += Fonctions.getTempsNuit(act);
                            break;
                        }
                        case 7: {
                            inconnu += act.getDuree();
                            break;
                        }
                        default: {
                            TimsLogger.warn("activit\u00e9s inconnue " + act.getCleType());
                        }
                    }
                    ++y;
                }
                Jour detailJour = new Jour(0, 0, dateJour, conduite, travail, dispo, repos, de, inconnu, 0, conduite + travail + dispo + de, debut, fin, nuit, 0, 0, false, tmpJour, "", 0, null, false);
                this.dayInfo.add(detailJour);
                conduite = 0;
                travail = 0;
                dispo = 0;
                repos = 0;
                de = 0;
                inconnu = 0;
                nuit = 0;
                tmpJour = new Vector();
            }
            ++x;
        }
    }

    private void initialize() {
        this.setSize(new Dimension(800, 450));
        this.setResizable(false);
        this.setTitle(LanguageTranslator.getString("overview.title"));
        this.setContentPane(this.getJContentPane());
        this.loadGraph();
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.gridx = 0;
            gridBagConstraints51.gridwidth = 4;
            gridBagConstraints51.fill = 1;
            gridBagConstraints51.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints51.gridy = 8;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 3;
            gridBagConstraints11.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints11.fill = 3;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.fill = 3;
            gridBagConstraints10.insets = new Insets(0, 60, 10, 60);
            gridBagConstraints10.anchor = 10;
            gridBagConstraints10.gridy = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.insets = new Insets(17, 0, 5, 8);
            gridBagConstraints9.gridy = 7;
            gridBagConstraints9.anchor = 11;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(17, 0, 0, 8);
            gridBagConstraints8.gridy = 6;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(17, 0, 0, 8);
            gridBagConstraints7.gridy = 5;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(17, 0, 0, 8);
            gridBagConstraints6.gridy = 4;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(17, 0, 0, 8);
            gridBagConstraints5.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(17, 0, 0, 8);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(20, 0, 0, 8);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.gridheight = 7;
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPanelGraph(), gridBagConstraints);
            this.jContentPane.add((Component)this.getBoutonGauche(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getBoutonDroit(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getLibelleJour(0), gridBagConstraints3);
            this.jContentPane.add((Component)this.getLibelleJour(1), gridBagConstraints4);
            this.jContentPane.add((Component)this.getLibelleJour(2), gridBagConstraints5);
            this.jContentPane.add((Component)this.getLibelleJour(3), gridBagConstraints6);
            this.jContentPane.add((Component)this.getLibelleJour(4), gridBagConstraints7);
            this.jContentPane.add((Component)this.getLibelleJour(5), gridBagConstraints8);
            this.jContentPane.add((Component)this.getLibelleJour(6), gridBagConstraints9);
            this.jContentPane.add((Component)this.lnbPages, gridBagConstraints10);
            this.jContentPane.add((Component)this.getBoutonQuit(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getPLegende(), gridBagConstraints51);
        }
        return this.jContentPane;
    }

    private JPanel getPanelGraph() {
        if (this.panelGraph == null) {
            this.panelGraph = new GrapheActivite(false);
            this.panelGraph.setPreferredSize(new Dimension(680, 320));
            this.panelGraph.setSize(new Dimension(680, 320));
            this.panelGraph.setMinimumSize(new Dimension(680, 320));
            this.panelGraph.setMaximumSize(new Dimension(680, 320));
            this.panelGraph.initialiser(null, null, null, null, null, null, null, null, null, null, null, null, false);
            this.panelGraph.setPreferredSize(new Dimension(800, 400));
        }
        return this.panelGraph;
    }

    private JButton getBoutonGauche() {
        if (this.boutonGauche == null) {
            this.boutonGauche = new JButton("<");
            this.boutonGauche.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApercuCarte apercuCarte = ApercuCarte.this;
                    apercuCarte.pageCourante = apercuCarte.pageCourante - 1;
                    ApercuCarte.this.loadGraph();
                }
            });
        }
        return this.boutonGauche;
    }

    private JButton getLibelleJour(int i) {
        if (this.libelleJour[i] == null) {
            this.libelleJour[i] = new JButton("");
            this.libelleJour[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JButton source = (JButton)e.getSource();
                    if (source == ApercuCarte.this.libelleJour[0]) {
                        ApercuCarte.this.detailShow(source.getText(), ((Jour)ApercuCarte.this.printedDay.get(0)).getActivity());
                    }
                    if (source == ApercuCarte.this.libelleJour[1]) {
                        ApercuCarte.this.detailShow(source.getText(), ((Jour)ApercuCarte.this.printedDay.get(1)).getActivity());
                    }
                    if (source == ApercuCarte.this.libelleJour[2]) {
                        ApercuCarte.this.detailShow(source.getText(), ((Jour)ApercuCarte.this.printedDay.get(2)).getActivity());
                    }
                    if (source == ApercuCarte.this.libelleJour[3]) {
                        ApercuCarte.this.detailShow(source.getText(), ((Jour)ApercuCarte.this.printedDay.get(3)).getActivity());
                    }
                    if (source == ApercuCarte.this.libelleJour[4]) {
                        ApercuCarte.this.detailShow(source.getText(), ((Jour)ApercuCarte.this.printedDay.get(4)).getActivity());
                    }
                    if (source == ApercuCarte.this.libelleJour[5]) {
                        ApercuCarte.this.detailShow(source.getText(), ((Jour)ApercuCarte.this.printedDay.get(5)).getActivity());
                    }
                    if (source == ApercuCarte.this.libelleJour[6]) {
                        ApercuCarte.this.detailShow(source.getText(), ((Jour)ApercuCarte.this.printedDay.get(6)).getActivity());
                    }
                }
            });
        }
        return this.libelleJour[i];
    }

    private JButton getBoutonDroit() {
        if (this.boutonDroit == null) {
            this.boutonDroit = new JButton(">");
            this.boutonDroit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApercuCarte apercuCarte = ApercuCarte.this;
                    apercuCarte.pageCourante = apercuCarte.pageCourante + 1;
                    ApercuCarte.this.loadGraph();
                }
            });
        }
        return this.boutonDroit;
    }

    private void loadGraph() {
        this.boutonDroit.setEnabled(true);
        this.boutonGauche.setEnabled(true);
        if (this.pageCourante == 1) {
            this.boutonGauche.setEnabled(false);
        }
        if (this.pageCourante == this.nbPage) {
            this.boutonDroit.setEnabled(false);
        }
        this.printedDay.clear();
        int x = 1;
        while (x <= 7) {
            int hashToLoad = (this.pageCourante - 1) * 7 + x;
            int offset = hashToLoad - 1;
            if (offset <= this.nbJour - 1) {
                this.printedDay.add(this.dayInfo.get(offset));
                this.libelleJour[x - 1].setText(ConversionTime.dateFromBDDToFrance(this.dayInfo.get(offset).getDate()));
            } else {
                this.libelleJour[x - 1].setText("-");
            }
            ++x;
        }
        this.panelGraph.initialiser(null, null, this.printedDay, null, null, null, null, null, null, null, null, null, false);
        this.lnbPages.setText(String.valueOf(LanguageTranslator.getString("generics.page")) + " " + this.pageCourante + " " + LanguageTranslator.getString("generics.of") + " " + this.nbPage);
    }

    private JButton getBoutonQuit() {
        if (this.boutonQuit == null) {
            this.boutonQuit = new JButton();
            this.boutonQuit.setText(LanguageTranslator.getString("button.quit"));
            this.boutonQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApercuCarte.this.dispose();
                }
            });
        }
        return this.boutonQuit;
    }

    private JPanel getPLegende() {
        if (this.pLegende == null) {
            this.pLegende = new PnlLegende();
            PnlLegende.initCouleur();
            this.pLegende.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        return this.pLegende;
    }

    private void detailShow(String date, Vector activ) {
        DialogDetailActivApercu detail_activite = new DialogDetailActivApercu(MainFrameTransport.getInstance(), date, activ);
        detail_activite.setVisible(true);
    }
}

