/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JRoundButton;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.CompanyCard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class CompanyCardUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private CompanyCard selected = null;
    private JPanel jContentPane = null;
    private JScrollPane jspListe = null;
    private JList cardList = null;
    private JPanel pnlBtn = null;
    private JRoundButton btnQuitter = null;
    private JTextField txtCardNumber = null;
    private JPanel pnlDetail = null;
    private JRoundButton btnEnregistrer = null;
    private JLabel lblNom = null;
    private JRoundButton btnCreer = null;
    private JTextField txtDelivery = null;
    private JLabel lblHeureContrat = null;
    private JTextField txtValidityBegin = null;
    private JLabel lblValidityBegin = null;
    private JLabel lblExpiry = null;
    private JTextField txtExpiry = null;
    private JLabel lblAgency = null;
    private JFittedComboBox cbAgency = null;
    private JCheckBox cbArchive = null;
    private JTextField txtOwner = null;
    private JLabel lblOwner = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogTypeContrat.dispose()#");
        super.dispose();
    }

    public CompanyCardUI(Frame owner) {
        super(owner);
        this.initialize();
    }

    public CompanyCardUI(Dialog owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(450, 270);
        this.setTitle(LanguageTranslator.getString("card.company"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(10, 5, 10, 5);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.ipadx = 0;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridy = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(10, 5, 10, 5);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspListe(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPnlDetail(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setViewportView(this.getCardList());
            this.jspListe.setPreferredSize(new Dimension(120, 0));
        }
        return this.jspListe;
    }

    private JList getCardList() {
        if (this.cardList == null) {
            this.cardList = new JList();
            this.cardList.setSelectionMode(0);
            this.cardList.setModel(new transpo.system.ui.modele.ComboBoxModel(CompanyCard.loadList(new int[0]), true, null));
            this.cardList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selected = CompanyCardUI.this.getCardList().getSelectedIndex();
                    if (!e.getValueIsAdjusting() && selected != -1) {
                        CompanyCard toSel = (CompanyCard)((transpo.system.ui.modele.ComboBoxModel)CompanyCardUI.this.getCardList().getModel()).getObjectAt(selected);
                        CompanyCardUI.this.setSelected(toSel);
                    }
                    if (selected == -1) {
                        CompanyCardUI.this.setSelected(null);
                    }
                }
            });
        }
        return this.cardList;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.insets = new Insets(0, 5, 5, 5);
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints5.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), gridBagConstraints13);
            if (ConnexionSettings.getInstance().isModifiable("COMPANY_CARD")) {
                this.pnlBtn.add((Component)this.getBtnEnregistrer(), gridBagConstraints5);
            }
            if (ConnexionSettings.getInstance().isAjoutable("COMPANY_CARD")) {
                this.pnlBtn.add((Component)this.getBtnCreer(), gridBagConstraints12);
            }
        }
        return this.pnlBtn;
    }

    private JRoundButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JRoundButton(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompanyCardUI.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JTextField getTxtCardNumber() {
        if (this.txtCardNumber == null) {
            this.txtCardNumber = new JTextField();
        }
        return this.txtCardNumber;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints19.gridy = 2;
            this.lblOwner = new JLabel();
            this.lblOwner.setText(LanguageTranslator.getString("generics.owner"));
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.fill = 1;
            gridBagConstraints16.gridy = 2;
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints16.gridwidth = 2;
            gridBagConstraints16.gridx = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 6;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridy = 1;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridy = 1;
            this.lblAgency = new JLabel();
            this.lblAgency.setText(LanguageTranslator.getString("generics.agency"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 5;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints7.gridy = 5;
            this.lblExpiry = new JLabel();
            this.lblExpiry.setText(LanguageTranslator.getString("generics.expiry"));
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints18.gridy = 4;
            this.lblValidityBegin = new JLabel();
            this.lblValidityBegin.setText(LanguageTranslator.getString("generics.validityBegin"));
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 0;
            gridBagConstraints17.gridy = 4;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridx = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.anchor = 17;
            gridBagConstraints15.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints15.gridy = 3;
            this.lblHeureContrat = new JLabel();
            this.lblHeureContrat.setText(LanguageTranslator.getString("generics.delivery"));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 0;
            gridBagConstraints11.gridy = 3;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 0;
            this.lblNom = new JLabel();
            this.lblNom.setText(LanguageTranslator.getString("generics.cardNumber"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = -1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridx = 1;
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getTxtCardNumber(), gridBagConstraints3);
            this.pnlDetail.add((Component)this.lblNom, gridBagConstraints6);
            this.pnlDetail.add((Component)this.getTxtDelivery(), gridBagConstraints11);
            this.pnlDetail.add((Component)this.lblHeureContrat, gridBagConstraints15);
            this.pnlDetail.add((Component)this.getTxtValidityBegin(), gridBagConstraints17);
            this.pnlDetail.add((Component)this.lblValidityBegin, gridBagConstraints18);
            this.pnlDetail.add((Component)this.lblExpiry, gridBagConstraints7);
            this.pnlDetail.add((Component)this.getTxtExpiry(), gridBagConstraints8);
            this.pnlDetail.add((Component)this.lblAgency, gridBagConstraints9);
            this.pnlDetail.add((Component)this.getCbAgency(), gridBagConstraints10);
            this.pnlDetail.add((Component)this.getCbArchive(), gridBagConstraints14);
            this.pnlDetail.add((Component)this.getTxtOwner(), gridBagConstraints16);
            this.pnlDetail.add((Component)this.lblOwner, gridBagConstraints19);
        }
        return this.pnlDetail;
    }

    private JRoundButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JRoundButton(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompanyCardUI.this.save();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public void save() {
        if (!this.check()) {
            return;
        }
        int agencyId = ((transpo.system.ui.modele.ComboBoxModel)this.getCbAgency().getModel()).getSelectedCle();
        if (this.selected != null && this.selected.getId() != 0) {
            this.selected.compareAndUpdate(this.getTxtCardNumber().getText(), agencyId, this.selected.getMemberState(), ConversionTime.stringToDate(this.getTxtDelivery().getText(), "dd/MM/yyyy"), ConversionTime.stringToDate(this.getTxtValidityBegin().getText(), "dd/MM/yyyy"), ConversionTime.stringToDate(this.getTxtExpiry().getText(), "dd/MM/yyyy"), this.selected.getCompanyAddress(), this.selected.getCompanyName(), this.selected.getPreferredLanguage(), this.getCbArchive().isSelected(), this.getTxtOwner().getText().trim());
        } else {
            if (this.selected == null) {
                this.selected = new CompanyCard();
            }
            this.selected.setAgencyId(agencyId);
            this.selected.setCardNumber(this.getTxtCardNumber().getText());
            this.selected.setIssueDate(ConversionTime.stringToDate(this.getTxtDelivery().getText(), "dd/MM/yyyy"));
            this.selected.setValidityBegin(ConversionTime.stringToDate(this.getTxtValidityBegin().getText(), "dd/MM/yyyy"));
            this.selected.setExpiryDate(ConversionTime.stringToDate(this.getTxtExpiry().getText(), "dd/MM/yyyy"));
            this.selected.setMemberState(17);
            this.selected.setCompanyAddress(null);
            this.selected.setCompanyName(null);
            this.selected.setOwner(this.getTxtOwner().getText().trim());
            this.selected.insert();
        }
        this.getCardList().setModel(new transpo.system.ui.modele.ComboBoxModel(CompanyCard.loadList(new int[0]), true, null));
    }

    public boolean check() {
        boolean toReturn = true;
        if (this.getTxtCardNumber().getText().length() < 14) {
            this.getTxtCardNumber().setBackground(new Color(255, 192, 203));
            this.getTxtCardNumber().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "14"));
            toReturn = false;
        } else {
            this.getTxtCardNumber().setBackground(Color.white);
        }
        if (this.getTxtDelivery().getText().equals("")) {
            this.getTxtDelivery().setBackground(new Color(255, 192, 203));
            this.getTxtDelivery().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDelivery().setBackground(Color.white);
        }
        if (this.getTxtValidityBegin().getText().equals("")) {
            this.getTxtValidityBegin().setBackground(new Color(255, 192, 203));
            this.getTxtValidityBegin().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtValidityBegin().setBackground(Color.white);
        }
        if (this.getTxtExpiry().getText().equals("")) {
            this.getTxtExpiry().setBackground(new Color(255, 192, 203));
            this.getTxtExpiry().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtExpiry().setBackground(Color.white);
        }
        return toReturn;
    }

    private JRoundButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JRoundButton(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompanyCardUI.this.newLine();
                }
            });
        }
        return this.btnCreer;
    }

    public void newLine() {
        this.setSelected(new CompanyCard());
    }

    public void setSelected(CompanyCard toSelect) {
        this.selected = toSelect;
        this.getTxtCardNumber().setText(this.selected == null ? "" : this.selected.getCardNumber());
        if (this.selected != null && this.selected.getAgencyId() != 0) {
            this.getCbAgency().setSelectedItem(((transpo.system.ui.modele.ComboBoxModel)this.getCbAgency().getModel()).getLabel(this.selected.getAgencyId()));
        } else {
            this.getCbAgency().setSelectedIndex(0);
        }
        this.getTxtDelivery().setText(this.selected == null ? "" : ConversionTime.dateToString(this.selected.getIssueDate(), "dd/MM/yyyy"));
        this.getTxtValidityBegin().setText(this.selected == null ? "" : ConversionTime.dateToString(this.selected.getValidityBegin(), "dd/MM/yyyy"));
        this.getTxtExpiry().setText(this.selected == null ? "" : ConversionTime.dateToString(this.selected.getExpiryDate(), "dd/MM/yyyy"));
        this.getCbArchive().setSelected(this.selected == null ? false : this.selected.isArchived());
        this.getTxtOwner().setText(this.selected == null ? "" : this.selected.getOwner());
    }

    private JTextField getTxtDelivery() {
        if (this.txtDelivery == null) {
            this.txtDelivery = new JTextField();
            this.txtDelivery.setPreferredSize(new Dimension(70, 20));
            this.txtDelivery.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(CompanyCardUI.this.getTxtDelivery());
                }
            });
        }
        return this.txtDelivery;
    }

    private JTextField getTxtValidityBegin() {
        if (this.txtValidityBegin == null) {
            this.txtValidityBegin = new JTextField();
            this.txtValidityBegin.setPreferredSize(new Dimension(70, 20));
            this.txtValidityBegin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(CompanyCardUI.this.getTxtValidityBegin());
                }
            });
        }
        return this.txtValidityBegin;
    }

    private JTextField getTxtExpiry() {
        if (this.txtExpiry == null) {
            this.txtExpiry = new JTextField();
            this.txtExpiry.setPreferredSize(new Dimension(70, 20));
            this.txtExpiry.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(CompanyCardUI.this.getTxtExpiry());
                }
            });
        }
        return this.txtExpiry;
    }

    private JFittedComboBox getCbAgency() {
        if (this.cbAgency == null) {
            this.cbAgency = new JFittedComboBox((ComboBoxModel)new transpo.system.ui.modele.ComboBoxModel(Agence.getList(), true, null));
            this.cbAgency.setPreferredSize(new Dimension(0, 25));
        }
        return this.cbAgency;
    }

    private JCheckBox getCbArchive() {
        if (this.cbArchive == null) {
            this.cbArchive = new JCheckBox();
            this.cbArchive.setText(LanguageTranslator.getString("generics.archive"));
        }
        return this.cbArchive;
    }

    private JTextField getTxtOwner() {
        if (this.txtOwner == null) {
            this.txtOwner = new JTextField();
        }
        return this.txtOwner;
    }
}

