/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.CustomReportColumn;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class CustomReportColumnPopup
extends JPopupMenu
implements DataListener {
    public static final int WIDTH = 240;
    CustomReportColumn columnDetail = null;
    JPanel content = null;
    JTextField originalName = null;
    JTextField visibleName = null;
    JComboBox format = null;
    JList availableFormat = null;
    JButton btnOk = null;
    MouseListener lsl = null;
    int columnIndex = 0;
    boolean isShowingComboBox = false;

    public CustomReportColumnPopup(CustomReportColumn columnDetail, int columnIndex) {
        this.columnDetail = columnDetail;
        this.columnIndex = columnIndex;
        this.add(this.getContent());
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.saveAndExit();
        }
        super.setVisible(visible);
    }

    public JPanel getContent() {
        if (this.content == null) {
            this.content = new JPanel();
            this.content.setLayout(new GridBagLayout());
            Insets ins = new Insets(2, 2, 2, 2);
            GridBagConstraints line1 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, ins, 0, 0);
            GridBagConstraints line12 = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, ins, 0, 0);
            GridBagConstraints line2 = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, ins, 0, 0);
            GridBagConstraints line22 = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, ins, 0, 0);
            GridBagConstraints line3 = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, ins, 0, 0);
            GridBagConstraints line32 = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, ins, 0, 0);
            GridBagConstraints line4 = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 1, ins, 0, 0);
            this.content.setPreferredSize(new Dimension(240, 120));
            this.content.add((Component)new JLabel(LanguageTranslator.getString("generics.originalName")), line1);
            this.content.add((Component)this.getTxtOriginalName(), line12);
            this.content.add((Component)new JLabel(LanguageTranslator.getString("generics.customizedName")), line2);
            this.content.add((Component)this.getTxtVisibleName(), line22);
            if (this.getListFormat() != null) {
                this.content.add((Component)new JLabel(LanguageTranslator.getString("generics.format")), line3);
            }
            if (this.getListFormat() != null) {
                this.content.add((Component)this.getListFormat(), line32);
            }
            this.content.add((Component)this.getBtnOk(), line4);
        }
        return this.content;
    }

    public JTextField getTxtVisibleName() {
        if (this.visibleName == null) {
            this.visibleName = new JTextField();
            if (this.columnDetail != null) {
                this.visibleName.setText(this.columnDetail.getVisibleName());
            }
        }
        return this.visibleName;
    }

    public JTextField getTxtOriginalName() {
        if (this.originalName == null) {
            this.originalName = new JTextField();
            if (this.columnDetail != null) {
                this.originalName.setText(this.columnDetail.getName());
            }
            this.originalName.setEnabled(false);
        }
        return this.originalName;
    }

    public JList getListFormat() {
        if (this.availableFormat == null) {
            if (this.columnDetail != null) {
                if (this.columnDetail.getType().equals(Date.class.getName())) {
                    this.availableFormat = new JList<String>(CustomReportColumn.DATE_FORMAT);
                    this.availableFormat.setToolTipText(ConversionTime.dateToString(new Date(), this.columnDetail.getExpression()));
                } else if (this.columnDetail.getType().equals(Integer.class.getName())) {
                    this.availableFormat = new JList<String>(CustomReportColumn.INTEGER_FORMAT);
                }
                if (this.availableFormat != null) {
                    this.availableFormat.setSelectedValue(this.columnDetail.getExpression(), true);
                }
            } else {
                this.availableFormat = new JList();
            }
        }
        return this.availableFormat;
    }

    public JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton(LanguageTranslator.getString("button.valid"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomReportColumnPopup.this.setVisible(false);
                }
            });
        }
        return this.btnOk;
    }

    public void saveAndExit() {
        String selectedFormat;
        boolean repaintTable = false;
        this.columnDetail.setVisibleName(this.getTxtVisibleName().getText());
        String string = selectedFormat = this.getListFormat() == null ? null : (String)this.getListFormat().getSelectedValue();
        if (selectedFormat != null && !this.columnDetail.getExpression().equals(selectedFormat)) {
            TimsLogger.debug("#CRCP.saveAndExit# update format : " + this.columnDetail.getExpression() + " => " + selectedFormat);
            if (this.columnDetail.getType().equals(Date.class.getName()) && !this.columnDetail.getExpression().equals(selectedFormat)) {
                repaintTable = true;
                this.columnDetail.setExpression(selectedFormat);
            }
            if (this.columnDetail.getType().equals(Integer.class.getName())) {
                if (selectedFormat.equals("nombre")) {
                    this.columnDetail.setExpression("# ###");
                } else {
                    this.columnDetail.setExpression("time");
                }
                repaintTable = true;
            }
        }
        TimsLogger.debug("#CRCP.saveAndExit# : " + this.columnDetail.getExpression() + " => " + selectedFormat);
        JTableHeader invoker = (JTableHeader)this.getInvoker();
        TableColumnModel model = invoker.getColumnModel();
        model.getColumn(this.columnIndex).setHeaderValue(this.getTxtVisibleName().getText());
        if (repaintTable) {
            invoker.getTable().repaint();
        }
        invoker.repaint();
    }

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        TimsLogger.verbose("changeUpate");
    }

    void testComponent(Component c, MouseListener listener) {
        if (c instanceof Container) {
            TimsLogger.debug(" container " + c.getClass().getName() + " => ");
            Component[] comps = ((Container)c).getComponents();
            int i = 0;
            while (i < comps.length) {
                TimsLogger.debug(String.valueOf(i) + " " + comps[i].getClass().getName() + "-- ");
                if (comps[i] instanceof MetalComboBoxButton) {
                    MouseListener[] tmp = ((MetalComboBoxButton)comps[i]).getMouseListeners();
                    TimsLogger.debug(String.valueOf(tmp.length) + " listeners :");
                    MouseListener toRemove = null;
                    MouseListener[] mouseListenerArray = tmp;
                    int n = tmp.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MouseListener t = mouseListenerArray[n2];
                        if (t.getClass().getName().equals("javax.swing.plaf.basic.BasicComboPopup$Handler")) {
                            toRemove = t;
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        } else {
            TimsLogger.debug("non container " + c.getClass().getName());
        }
    }

    private class CustomizedComboBox
    extends JComboBox {
        public boolean isAboutToShowPopup;

        public CustomizedComboBox(String[] integerFormat) {
            super(integerFormat);
            this.isAboutToShowPopup = false;
            TimsLogger.debug("customizedCb");
        }

        public CustomizedComboBox() {
            this.isAboutToShowPopup = false;
            TimsLogger.debug("customizedCb");
        }

        @Override
        public void showPopup() {
            TimsLogger.debug("on attrape le showpupup : ");
            this.setPopupVisible(true);
        }

        @Override
        public void setPopupVisible(boolean v) {
            TimsLogger.debug("on attrape le popup setPopupVisible : " + v);
            if (v) {
                this.isAboutToShowPopup = v;
            }
            super.setPopupVisible(v);
            if (v) {
                this.isAboutToShowPopup = !v;
            }
        }
    }
}

