/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JFittedComboBox;
import fr.pgh.component.JTextDate;
import fr.pgh.component.JTextHour;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.AccidentAction;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Garage;
import fr.pgh.data.bdd.Injured;
import fr.pgh.data.bdd.Repairing;
import fr.pgh.data.bdd.Vehicule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.CheckBoxBorder;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMAccidentAction;
import transpo.system.ui.modele.TMInjuried;
import transpo.system.ui.modele.TMRepair;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogAccident
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jspContentPane = null;
    private JPanel pnlBtn = null;
    private JButton btnQuitter = null;
    private JButton btnEnregistrer = null;
    private JPanel pnlContent = null;
    private JLabel lblNumber = null;
    private JTextField txtNumber = null;
    private JLabel lblInsuranceNumber = null;
    private JTextField txtInsuranceNumber = null;
    private JLabel lblAgency = null;
    private JFittedComboBox cbAgency = null;
    private JLabel lblDriver = null;
    private JFittedComboBox cbDriver = null;
    private JLabel lblVehicle = null;
    private JFittedComboBox cbVehicle = null;
    private JLabel lblDate = null;
    private JTextDate txtDate = null;
    private JLabel lblHour = null;
    private JTextHour txtHour = null;
    private JLabel lblPlace = null;
    private JTextField txtPlace = null;
    private JTextArea txtDescription = null;
    private JLabel lblType = null;
    private JFittedComboBox cbType = null;
    private JLabel lblResponsability = null;
    private JFittedComboBox cbResponsability = null;
    private JCheckBox cbSteal = null;
    private JCheckBox cbTowing = null;
    private JCheckBox cbBigDamages = null;
    private JLabel lblInsuranceType = null;
    private JTextField txtInsuranceType = null;
    private JLabel lblInsuranceCode = null;
    private JTextField txtInsuranceCode = null;
    private JLabel lblConventionType = null;
    private JTextField txtConventionType = null;
    private JCheckBox cbInTraffic = null;
    private JPanel pnlGarage = null;
    private JFittedComboBox cbGarage = null;
    private JCheckBox cbRestrictGarage = null;
    private JLabel lblGarageIn = null;
    private JTextField txtGarageIn = null;
    private JLabel lblGarageHour = null;
    private JTextHour txtGarageHour = null;
    private JLabel lblGarageOut = null;
    private JTextField txtGarageOut = null;
    private JPanel pnlFinancial = null;
    private JLabel lblRcCost = null;
    private JLabel lblRcExcess = null;
    private JLabel lblInsuranceRecourse = null;
    private JLabel lblCompanyRecourse = null;
    private JLabel lblDamageExcess = null;
    private JLabel lblVAT = null;
    private JLabel lblDilapidation = null;
    private JLabel lblSelfInsurance = null;
    private JLabel lblExpertCost = null;
    private JLabel lblFixingCost = null;
    private JLabel lblCompanyFixingCost = null;
    private JLabel lblLocationDebt = null;
    private JLabel lblCompanyLocationDebt = null;
    private JLabel lblGuarding = null;
    private JLabel lblTotalCost = null;
    private JLabel lblTotalInsurance = null;
    private JTextField txtRcCost = null;
    private JTextField txtRcExcess = null;
    private JTextField txtInsuranceRecourse = null;
    private JTextField txtCompanyRecourse = null;
    private JTextField txtDamageExcess = null;
    private JTextField txtVAT = null;
    private JTextField txtDilapidation = null;
    private JTextField txtSelfInsurance = null;
    private JTextField txtExpertCost = null;
    private JTextField txtFixingCost = null;
    private JTextField txtCompanyFixingCost = null;
    private JTextField txtLocationDebt = null;
    private JTextField txtCompanyLocationDebt = null;
    private JTextField txtGuarding = null;
    private JTextField txtTotalCost = null;
    private JTextField txtTotalInsurance = null;
    private JPanel pnlInjuried = null;
    private JCheckBox cbInjury = null;
    private JScrollPane jspList = null;
    private JTable tblInjuried = null;
    private JButton btnInjured = null;
    private JScrollPane jspAction = null;
    private JTable tblAction = null;
    private JButton btnAction = null;
    private JScrollPane jspRepair = null;
    private JTable tblRepair = null;
    private JButton btnRepair = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogAccident.dispose()#");
        super.dispose();
    }

    public DialogAccident(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogAccident()#");
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        int height = 685;
        int width = 660;
        if (ConnexionSettings.getInstance().isAjoutable("ACCIDENT_FINANCIAL")) {
            width = 860;
        }
        if (Toolkit.getDefaultToolkit().getScreenSize().height <= 600) {
            height = 600;
            if (width > 800) {
                width = 800;
            }
        }
        this.setSize(width, height);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("accident"));
        this.setContentPane(this.getJspContentPane());
    }

    private JScrollPane getJspContentPane() {
        if (this.jspContentPane == null) {
            this.jspContentPane = new JScrollPane();
            this.jspContentPane.setViewportView(this.getJContentPane());
        }
        return this.jspContentPane;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbFinancial = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 3, -1, new Insets(5, 2, 5, 5));
            GridBagConstraints gcbPnlContent = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2));
            GridBagConstraints gcbPnlBtn = Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 1, -1, new Insets(5, 5, 5, 5));
            this.jContentPane = new JPanel();
            if (ConnexionSettings.getInstance().isAjoutable("ACCIDENT_FINANCIAL")) {
                this.jContentPane.setPreferredSize(new Dimension(820, 640));
            } else {
                this.jContentPane.setPreferredSize(new Dimension(660, 640));
            }
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlBtn(), gcbPnlBtn);
            this.jContentPane.add((Component)this.getPnlContent(), gcbPnlContent);
            this.jContentPane.add((Component)this.getPnlFinancial(), gcbFinancial);
        }
        return this.jContentPane;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gcbQuit = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, -1, 13, new Insets(2, 0, 2, 5));
            GridBagConstraints gcbSave = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, -1, 13, new Insets(2, 0, 2, 5));
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnQuitter(), gcbQuit);
            this.pnlBtn.add((Component)this.getBtnEnregistrer(), gcbSave);
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAccident.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAccident.this.save();
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JFittedComboBox getCbAgency() {
        if (this.cbAgency == null) {
            this.cbAgency = new JFittedComboBox();
            this.cbAgency.setMaxWidth(170);
            this.cbAgency.setModel(new ComboBoxModel(Agence.getList(), true, LanguageTranslator.getString("generics.select")));
            this.cbAgency.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cleAgence = ((ComboBoxModel)DialogAccident.this.getCbAgency().getModel()).getSelectedCle();
                    DialogAccident.this.getCbDriver().setModel(new ComboBoxModel(Conducteur.loadList(cleAgence), true, LanguageTranslator.getString("generics.select")));
                    if (System.getProperty("company", "PGH").equals("scan.vehicle.enlarge")) {
                        DialogAccident.this.getCbVehicle().setModel(new ComboBoxModel(Vehicule.loadList(cleAgence), true, LanguageTranslator.getString("generics.select")));
                    }
                    if (DialogAccident.this.getCbRestrictGarage().isSelected()) {
                        DialogAccident.this.getCbGarage().setModel(new ComboBoxModel(Garage.loadList(cleAgence, false), true, LanguageTranslator.getString("generics.select")));
                    }
                }
            });
        }
        return this.cbAgency;
    }

    private JFittedComboBox getCbDriver() {
        if (this.cbDriver == null) {
            this.cbDriver = new JFittedComboBox();
            this.cbDriver.setMaxWidth(170);
            this.cbDriver.setModel(new ComboBoxModel(Conducteur.getList(), true, LanguageTranslator.getString("generics.select")));
        }
        return this.cbDriver;
    }

    private JFittedComboBox getCbVehicle() {
        if (this.cbVehicle == null) {
            this.cbVehicle = new JFittedComboBox();
            this.cbVehicle.setMaxWidth(170);
            this.cbVehicle.setModel(new ComboBoxModel(Vehicule.loadList(0), true, LanguageTranslator.getString("generics.select")));
        }
        return this.cbVehicle;
    }

    private JFittedComboBox getCbGarage() {
        if (this.cbGarage == null) {
            this.cbGarage = new JFittedComboBox();
            this.cbGarage.setMaxWidth(120);
            this.cbGarage.setModel(new ComboBoxModel(Garage.getList(), true, LanguageTranslator.getString("generics.select")));
        }
        return this.cbGarage;
    }

    private JCheckBox getCbRestrictGarage() {
        if (this.cbRestrictGarage == null) {
            this.cbRestrictGarage = new JCheckBox(LanguageTranslator.getString("accident.restrictGarage"));
            this.cbRestrictGarage.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ComboBoxModel to = null;
                    if (e.getStateChange() == 1) {
                        int selected = ((ComboBoxModel)DialogAccident.this.getCbAgency().getModel()).getSelectedCle();
                        to = new ComboBoxModel(Garage.loadList(selected, false), true, LanguageTranslator.getString("generics.select"));
                    } else {
                        to = new ComboBoxModel(Garage.loadList(0, false), true, LanguageTranslator.getString("generics.select"));
                    }
                    DialogAccident.this.cbGarage.setModel(to);
                }
            });
        }
        return this.cbRestrictGarage;
    }

    private JTextField getTxtNumber() {
        if (this.txtNumber == null) {
            this.txtNumber = new JTextField();
        }
        return this.txtNumber;
    }

    private JTextField getTxtInsuranceNumber() {
        if (this.txtInsuranceNumber == null) {
            this.txtInsuranceNumber = new JTextField();
        }
        return this.txtInsuranceNumber;
    }

    private JTextField getTxtInsuranceType() {
        if (this.txtInsuranceType == null) {
            this.txtInsuranceType = new JTextField();
        }
        return this.txtInsuranceType;
    }

    private JTextField getTxtInsuranceCode() {
        if (this.txtInsuranceCode == null) {
            this.txtInsuranceCode = new JTextField();
        }
        return this.txtInsuranceCode;
    }

    private JTextField getTxtConventionType() {
        if (this.txtConventionType == null) {
            this.txtConventionType = new JTextField();
        }
        return this.txtConventionType;
    }

    private JTextField getTxtPlace() {
        if (this.txtPlace == null) {
            this.txtPlace = new JTextField();
        }
        return this.txtPlace;
    }

    private JTextDate getTxtDate() {
        if (this.txtDate == null) {
            this.txtDate = new JTextDate();
            this.txtDate.setPreferredSize(new Dimension(70, 20));
            this.txtDate.setMinimumSize(new Dimension(60, 20));
            this.txtDate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogAccident.this.getTxtDate());
                }
            });
        }
        return this.txtDate;
    }

    private JTextHour getTxtHour() {
        if (this.txtHour == null) {
            this.txtHour = new JTextHour();
        }
        return this.txtHour;
    }

    private JTextArea getTxtDescription() {
        if (this.txtDescription == null) {
            this.txtDescription = new JTextArea();
        }
        return this.txtDescription;
    }

    private JTextField getTxtGarageIn() {
        if (this.txtGarageIn == null) {
            this.txtGarageIn = new JTextField();
            this.txtGarageIn.setMinimumSize(new Dimension(70, 20));
            this.txtGarageIn.setPreferredSize(new Dimension(70, 20));
            this.txtGarageIn.setMaximumSize(new Dimension(70, 20));
            this.txtGarageIn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogAccident.this.getTxtGarageIn());
                }
            });
        }
        return this.txtGarageIn;
    }

    private JTextHour getTxtGarageHour() {
        if (this.txtGarageHour == null) {
            this.txtGarageHour = new JTextHour();
        }
        return this.txtGarageHour;
    }

    private JTextField getTxtGarageOut() {
        if (this.txtGarageOut == null) {
            this.txtGarageOut = new JTextField();
            this.txtGarageOut.setMinimumSize(new Dimension(70, 20));
            this.txtGarageOut.setPreferredSize(new Dimension(70, 20));
            this.txtGarageOut.setMaximumSize(new Dimension(70, 20));
            this.txtGarageOut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogAccident.this.getTxtGarageOut());
                }
            });
        }
        return this.txtGarageOut;
    }

    private JFittedComboBox getCbType() {
        if (this.cbType == null) {
            this.cbType = new JFittedComboBox(Accident.TYPE_WORDING);
            this.cbType.setMaxWidth(150);
        }
        return this.cbType;
    }

    private JFittedComboBox getCbResponsability() {
        if (this.cbResponsability == null) {
            this.cbResponsability = new JFittedComboBox(Accident.RESPONSABILITY_WORDING);
            this.cbResponsability.setMaxWidth(150);
        }
        return this.cbResponsability;
    }

    private JCheckBox getCbInjury() {
        if (this.cbInjury == null) {
            this.cbInjury = new JCheckBox(LanguageTranslator.getString("generics.injuried"));
            this.cbInjury.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DialogAccident.this.getCbInjury().isSelected()) {
                        DialogAccident.this.getBtnInjured().setEnabled(true);
                    }
                }
            });
        }
        return this.cbInjury;
    }

    private JCheckBox getCbSteal() {
        if (this.cbSteal == null) {
            this.cbSteal = new JCheckBox(LanguageTranslator.getString("accident.steal"));
        }
        return this.cbSteal;
    }

    private JCheckBox getCbBigDamages() {
        if (this.cbBigDamages == null) {
            this.cbBigDamages = new JCheckBox(LanguageTranslator.getString("accident.bigDamages"));
            this.cbBigDamages.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.cbBigDamages;
    }

    private void showWarning() {
        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("accident.bigDamagesChecked"), LanguageTranslator.getString("generics.warning"), 2);
    }

    private JCheckBox getCbInTraffic() {
        if (this.cbInTraffic == null) {
            this.cbInTraffic = new JCheckBox(LanguageTranslator.getString("accident.inTraffic"));
            this.cbInTraffic.setSelected(true);
            this.cbInTraffic.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogAccident.this.getTxtNumber().setEditable(e.getStateChange() == 1);
                }
            });
        }
        return this.cbInTraffic;
    }

    private JCheckBox getCbTowing() {
        if (this.cbTowing == null) {
            this.cbTowing = new JCheckBox(LanguageTranslator.getString("accident.towing"));
        }
        return this.cbTowing;
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setViewportView(this.getTblInjuried());
        }
        return this.jspList;
    }

    private JTable getTblInjuried() {
        if (this.tblInjuried == null) {
            this.tblInjuried = new JTable();
            this.tblInjuried.setModel(new TMInjuried());
        }
        return this.tblInjuried;
    }

    private JButton getBtnInjured() {
        if (this.btnInjured == null) {
            this.btnInjured = new JButton();
            this.btnInjured.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnInjured.setMinimumSize(new Dimension(20, 20));
            this.btnInjured.setEnabled(false);
            this.btnInjured.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TMInjuried)DialogAccident.this.getTblInjuried().getModel()).addLine();
                }
            });
        }
        return this.btnInjured;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.lblDate = new JLabel(LanguageTranslator.getString("accident.date"));
            this.lblHour = new JLabel(LanguageTranslator.getString("generics.hour"));
            this.lblAgency = new JLabel(LanguageTranslator.getString("generics.agency"));
            this.lblDriver = new JLabel(LanguageTranslator.getString("generics.driver"));
            this.lblVehicle = new JLabel(LanguageTranslator.getString("generics.vehicle"));
            this.lblNumber = new JLabel(LanguageTranslator.getString("accident.identification"));
            this.lblInsuranceNumber = new JLabel(LanguageTranslator.getString("accident.insuranceNumber"));
            this.lblPlace = new JLabel(LanguageTranslator.getString("accident.place"));
            this.lblType = new JLabel(LanguageTranslator.getString("accident.type"));
            this.lblResponsability = new JLabel(LanguageTranslator.getString("generics.responsability"));
            this.lblInsuranceType = new JLabel(LanguageTranslator.getString("accident.insuranceType"));
            this.lblInsuranceCode = new JLabel(LanguageTranslator.getString("accident.insuranceCode"));
            this.lblConventionType = new JLabel(LanguageTranslator.getString("accident.conventionType"));
            GridBagConstraints gcbLblAgency = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbAgency = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblDate = Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtDate = Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblDriver = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbDriver = Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblHour = Fonctions.getGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtHour = Fonctions.getGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblVehicle = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbVehicle = Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblNumber = Fonctions.getGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtNumber = Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblResp = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbResp = Fonctions.getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblINumber = Fonctions.getGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtINumber = Fonctions.getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblType = Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbCbType = Fonctions.getGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblPlace = Fonctions.getGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtPlace = Fonctions.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblInsType = Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtInsType = Fonctions.getGridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblInsCode = Fonctions.getGridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtInsCode = Fonctions.getGridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbLblConvType = Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbTxtConvType = Fonctions.getGridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 2, 10, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbCbInTraffic = Fonctions.getGridBagConstraints(2, 6, 1, 2, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbPnlCb = Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 2, -1, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbPnlAction = Fonctions.getGridBagConstraints(1, 7, 1, 3, 0.0, 0.0, 1, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbPnlDesc = Fonctions.getGridBagConstraints(0, 8, 1, 4, 1.0, 1.0, 1, -1, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbPnlGarage = Fonctions.getGridBagConstraints(0, 9, 1, 4, 0.0, 0.0, 1, 17, new Insets(1, 5, 0, 5));
            GridBagConstraints gcbPnlInjury = Fonctions.getGridBagConstraints(0, 10, 1, 4, 1.0, 1.0, 1, -1, new Insets(1, 0, 0, 5));
            GridBagConstraints gcbCbSteal = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 0, 5));
            GridBagConstraints gcbCbBigDamages = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 0, 5));
            GridBagConstraints gcbCbTowing = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 2, -1, new Insets(2, 0, 0, 5));
            JPanel pnlCb = new JPanel(new GridBagLayout());
            pnlCb.add((Component)this.getCbSteal(), gcbCbSteal);
            pnlCb.add((Component)this.getCbBigDamages(), gcbCbBigDamages);
            pnlCb.add((Component)this.getCbTowing(), gcbCbTowing);
            JPanel pnlDate = new JPanel(new GridBagLayout());
            pnlDate.add((Component)this.lblDate, gcbLblDate);
            pnlDate.add((Component)this.getTxtDate(), gcbTxtDate);
            pnlDate.add((Component)this.lblHour, gcbLblHour);
            pnlDate.add((Component)this.getTxtHour(), gcbTxtHour);
            GridBagConstraints gcbJspAction = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 0, 0, 1));
            GridBagConstraints gcbBtnAction = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, -1, 15, new Insets(0, 0, 2, 1));
            JPanel pnlAction = new JPanel(new GridBagLayout());
            pnlAction.add((Component)this.getJspAction(), gcbJspAction);
            pnlAction.add((Component)this.getBtnAction(), gcbBtnAction);
            JPanel pnlDescription = new JPanel(new GridBagLayout());
            JScrollPane jsp = new JScrollPane();
            jsp.setViewportView(this.getTxtDescription());
            jsp.setVerticalScrollBarPolicy(22);
            GridBagConstraints gcbTxtDescription = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 5, 5, 5));
            pnlDescription.setBorder(new TitledBorder(LanguageTranslator.getString("accident.description")));
            pnlDescription.add((Component)jsp, gcbTxtDescription);
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.lblDate, gcbLblDate);
            this.pnlContent.add((Component)this.getTxtDate(), gcbTxtDate);
            this.pnlContent.add((Component)this.lblHour, gcbLblHour);
            this.pnlContent.add((Component)this.getTxtHour(), gcbTxtHour);
            this.pnlContent.add((Component)this.lblAgency, gcbLblAgency);
            this.pnlContent.add((Component)this.getCbAgency(), gcbCbAgency);
            this.pnlContent.add((Component)this.lblDriver, gcbLblDriver);
            this.pnlContent.add((Component)this.getCbDriver(), gcbCbDriver);
            this.pnlContent.add((Component)this.lblVehicle, gcbLblVehicle);
            this.pnlContent.add((Component)this.getCbVehicle(), gcbCbVehicle);
            this.pnlContent.add((Component)this.lblNumber, gcbLblNumber);
            this.pnlContent.add((Component)this.getTxtNumber(), gcbTxtNumber);
            this.pnlContent.add((Component)this.lblInsuranceNumber, gcbLblINumber);
            this.pnlContent.add((Component)this.getTxtInsuranceNumber(), gcbTxtINumber);
            this.pnlContent.add((Component)this.lblPlace, gcbLblPlace);
            this.pnlContent.add((Component)this.getTxtPlace(), gcbTxtPlace);
            this.pnlContent.add((Component)this.lblType, gcbLblType);
            this.pnlContent.add((Component)this.getCbType(), gcbCbType);
            this.pnlContent.add((Component)this.lblResponsability, gcbLblResp);
            this.pnlContent.add((Component)this.getCbResponsability(), gcbCbResp);
            this.pnlContent.add((Component)pnlCb, gcbPnlCb);
            this.pnlContent.add((Component)pnlAction, gcbPnlAction);
            this.pnlContent.add((Component)pnlDescription, gcbPnlDesc);
            this.pnlContent.add((Component)this.getPnlGarage(), gcbPnlGarage);
            this.pnlContent.add((Component)this.getPnlInjuried(), gcbPnlInjury);
            this.pnlContent.add((Component)this.lblInsuranceType, gcbLblInsType);
            this.pnlContent.add((Component)this.getTxtInsuranceType(), gcbTxtInsType);
            this.pnlContent.add((Component)this.lblInsuranceCode, gcbLblInsCode);
            this.pnlContent.add((Component)this.getTxtInsuranceCode(), gcbTxtInsCode);
            this.pnlContent.add((Component)this.lblConventionType, gcbLblConvType);
            this.pnlContent.add((Component)this.getTxtConventionType(), gcbTxtConvType);
            this.pnlContent.add((Component)this.getCbInTraffic(), gcbCbInTraffic);
        }
        return this.pnlContent;
    }

    private JPanel getPnlInjuried() {
        if (this.pnlInjuried == null) {
            this.pnlInjuried = new JPanel(new GridBagLayout());
            CheckBoxBorder border = new CheckBoxBorder(this.getCbInjury(), this.pnlInjuried, BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            GridBagConstraints gcbJspTbl = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(1, 5, 0, 1));
            GridBagConstraints gcbBtn = Fonctions.getGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 15, new Insets(0, 0, 2, 1));
            this.pnlInjuried.setBorder(border);
            this.pnlInjuried.add((Component)this.getJspList(), gcbJspTbl);
            this.pnlInjuried.add((Component)this.getBtnInjured(), gcbBtn);
        }
        return this.pnlInjuried;
    }

    private JPanel getPnlGarage() {
        if (this.pnlGarage == null) {
            GridBagConstraints gcbCbGarage = Fonctions.getGridBagConstraints(0, 0, 1, 4, 0.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbCbRestrict = Fonctions.getGridBagConstraints(0, 1, 1, 4, 0.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblGarageIn = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtGarageIn = Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblGarageHour = Fonctions.getGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtGarageHour = Fonctions.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbPnlRepair = Fonctions.getGridBagConstraints(4, 0, 3, 1, 1.0, 1.0, 1, -1, new Insets(5, 0, 0, 1));
            GridBagConstraints gcbBtnRepair = Fonctions.getGridBagConstraints(5, 0, 3, 1, 0.0, 0.0, 0, 15, new Insets(0, 0, 2, 1));
            this.lblGarageIn = new JLabel(LanguageTranslator.getString("accident.garageIn"));
            this.lblGarageHour = new JLabel(LanguageTranslator.getString("generics.hour"));
            this.lblGarageOut = new JLabel(LanguageTranslator.getString("accident.garageOut"));
            this.pnlGarage = new JPanel(new GridBagLayout());
            this.pnlGarage.setMaximumSize(new Dimension(0, 120));
            this.pnlGarage.setMinimumSize(new Dimension(0, 120));
            this.pnlGarage.setPreferredSize(new Dimension(0, 120));
            this.pnlGarage.setSize(new Dimension(0, 120));
            this.pnlGarage.setBorder(new TitledBorder(LanguageTranslator.getString("generics.garage")));
            this.pnlGarage.add((Component)this.getCbGarage(), gcbCbGarage);
            this.pnlGarage.add((Component)this.getCbRestrictGarage(), gcbCbRestrict);
            this.pnlGarage.add((Component)this.lblGarageIn, gcbLblGarageIn);
            this.pnlGarage.add((Component)this.getTxtGarageIn(), gcbTxtGarageIn);
            this.pnlGarage.add((Component)this.lblGarageHour, gcbLblGarageHour);
            this.pnlGarage.add((Component)this.getTxtGarageHour(), gcbTxtGarageHour);
            this.pnlGarage.add((Component)this.getJspRepair(), gcbPnlRepair);
            this.pnlGarage.add((Component)this.getBtnRepair(), gcbBtnRepair);
        }
        return this.pnlGarage;
    }

    private JScrollPane getJspRepair() {
        if (this.jspRepair == null) {
            this.jspRepair = new JScrollPane();
            this.jspRepair.setViewportView(this.getTblRepair());
        }
        return this.jspRepair;
    }

    private JTable getTblRepair() {
        if (this.tblRepair == null) {
            this.tblRepair = new JTable();
            this.tblRepair.setModel(new TMRepair());
        }
        return this.tblRepair;
    }

    private JButton getBtnRepair() {
        if (this.btnRepair == null) {
            this.btnRepair = new JButton();
            this.btnRepair.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnRepair.setMinimumSize(new Dimension(20, 20));
            this.btnRepair.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TMRepair)DialogAccident.this.getTblRepair().getModel()).addLine();
                }
            });
        }
        return this.btnRepair;
    }

    private JScrollPane getJspAction() {
        if (this.jspAction == null) {
            this.jspAction = new JScrollPane();
            this.jspAction.setViewportView(this.getTblAction());
        }
        return this.jspAction;
    }

    private JTable getTblAction() {
        if (this.tblAction == null) {
            this.tblAction = new JTable();
            this.tblAction.setModel(new TMAccidentAction());
        }
        return this.tblAction;
    }

    private JButton getBtnAction() {
        if (this.btnAction == null) {
            this.btnAction = new JButton();
            this.btnAction.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_cliq"))));
            this.btnAction.setMinimumSize(new Dimension(20, 20));
            this.btnAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TMAccidentAction)DialogAccident.this.getTblAction().getModel()).addLine();
                }
            });
        }
        return this.btnAction;
    }

    private void save() {
        Fonctions.commit(this.getTblInjuried());
        Fonctions.commit(this.getTblRepair());
        Fonctions.commit(this.getTblAction());
        if (!this.check()) {
            return;
        }
        if (this.getCbBigDamages().isSelected()) {
            this.showWarning();
        }
        Transport.bdd.startTransaction();
        Accident toSave = new Accident();
        String date = String.valueOf(this.getTxtDate().getText()) + " " + this.getTxtHour().getText();
        String garageIn = String.valueOf(this.getTxtGarageIn().getText()) + " " + this.getTxtGarageHour().getText();
        boolean saved = toSave.compareAndUpdate(this.getTxtNumber().getText(), this.getTxtInsuranceNumber().getText(), ((ComboBoxModel)this.getCbAgency().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbDriver().getModel()).getSelectedCle(), ((ComboBoxModel)this.getCbVehicle().getModel()).getSelectedCle(), ConversionTime.stringToDate(date, "dd/MM/yyyy HH'h'mm"), this.getTxtPlace().getText(), this.getCbType().getSelectedIndex(), this.getCbInjury().isSelected(), this.getCbSteal().isSelected(), this.getTxtDescription().getText(), this.getCbBigDamages().isSelected(), this.getCbResponsability().getSelectedIndex(), ((ComboBoxModel)this.getCbGarage().getModel()).getSelectedCle(), garageIn.length() == 16 ? ConversionTime.stringToDate(garageIn, "dd/MM/yyyy HH'h'mm") : null, ConversionTime.stringToDate(this.getTxtGarageOut().getText(), "dd/MM/yyyy"), this.getCbTowing().isSelected(), this.getTxtRcCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtRcCost().getText()).floatValue(), this.getTxtRcExcess().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtRcExcess().getText()).floatValue(), this.getTxtInsuranceRecourse().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtInsuranceRecourse().getText()).floatValue(), this.getTxtCompanyRecourse().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtCompanyRecourse().getText()).floatValue(), this.getTxtDamageExcess().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtDamageExcess().getText()).floatValue(), this.getTxtVAT().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtVAT().getText()).floatValue(), this.getTxtDilapidation().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtDilapidation().getText()).floatValue(), this.getTxtSelfInsurance().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtSelfInsurance().getText()).floatValue(), this.getTxtExpertCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtExpertCost().getText()).floatValue(), this.getTxtFixingCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtFixingCost().getText()).floatValue(), this.getTxtCompanyFixingCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtCompanyFixingCost().getText()).floatValue(), this.getTxtLocationDebt().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtLocationDebt().getText()).floatValue(), this.getTxtCompanyLocationDebt().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtCompanyLocationDebt().getText()).floatValue(), this.getTxtGuarding().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtGuarding().getText()).floatValue(), this.getTxtTotalCost().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtTotalCost().getText()).floatValue(), this.getTxtTotalInsurance().getText().equals("") ? 0.0f : Float.valueOf(this.getTxtTotalInsurance().getText()).floatValue(), true, this.getCbInTraffic().isSelected(), this.getTxtInsuranceType().getText(), this.getTxtConventionType().getText(), this.getTxtInsuranceType().getText(), null);
        if (this.getCbInjury().isSelected()) {
            Vector<Injured> injured = ((TMInjuried)this.getTblInjuried().getModel()).getData();
            for (Injured injured2 : injured) {
                if (injured2.compareAndUpdate(toSave.getId(), injured2.isEmployee(), injured2.getFirstName(), injured2.getLastName(), injured2.getAddress(), injured2.getCity(), injured2.getPostalCode(), injured2.getPhone())) continue;
                TimsLogger.debug("#DialogAccident.save()# unable to save Injured");
                saved = false;
                break;
            }
        }
        Vector<AccidentAction> actions = ((TMAccidentAction)this.getTblAction().getModel()).getData();
        for (AccidentAction accidentAction : actions) {
            if (accidentAction.compareAndUpdate(accidentAction.getUserId(), accidentAction.getInsertionDate(), toSave.getId(), accidentAction.getPurpose())) continue;
            TimsLogger.debug("#DialogAccident.save()# unable to save AccidentAction");
            saved = false;
            break;
        }
        Vector<Repairing> vector = ((TMRepair)this.getTblRepair().getModel()).getData();
        int garageId = ((ComboBoxModel)this.getCbGarage().getModel()).getSelectedCle();
        for (Repairing tmp : vector) {
            if (tmp.compareAndUpdate(ConversionTime.stringToDate(garageIn, "dd/MM/yyyy HH'h'mm"), toSave.getId(), garageId, tmp.getPurpose(), tmp.getTotalCost(), 0.0f)) continue;
            TimsLogger.debug("#DialogAccident.save()# unable to save Repairing");
            saved = false;
            break;
        }
        if (saved) {
            Transport.bdd.commit();
            JOptionPane.showMessageDialog(this, this.getMessage(), LanguageTranslator.getString("message.done"), 1);
            Vector<Agence> agencies = new Vector<Agence>();
            agencies.add((Agence)((ComboBoxModel)this.getCbAgency().getModel()).getObjectAt(this.getCbAgency().getSelectedIndex()));
            Vector<Conducteur> drivers = new Vector<Conducteur>();
            drivers.add((Conducteur)((ComboBoxModel)this.getCbDriver().getModel()).getObjectAt(this.getCbDriver().getSelectedIndex()));
            Vector<Vehicule> vehicles = new Vector<Vehicule>();
            vehicles.add((Vehicule)((ComboBoxModel)this.getCbVehicle().getModel()).getObjectAt(this.getCbVehicle().getSelectedIndex()));
            Fonctions.generateReport(toSave, agencies, drivers, vehicles);
            this.dispose();
        } else {
            Transport.bdd.rollback();
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.error"), 1);
        }
    }

    private JPanel getMessage() {
        JPanel msg = new JPanel(new BorderLayout());
        msg.add((Component)new JLabel(LanguageTranslator.getString("message.saveSucceed")), "North");
        msg.add((Component)new JLabel(LanguageTranslator.getString("accident.saveSucceed")), "Center");
        return msg;
    }

    private boolean check() {
        boolean toReturn = true;
        if (this.getTxtNumber().getText().length() > 13) {
            this.getTxtNumber().setBackground(new Color(255, 192, 203));
            this.getTxtNumber().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "13"));
            toReturn = false;
        } else {
            this.getTxtNumber().setBackground(Color.white);
        }
        if (this.getTxtPlace().getText().equals("")) {
            this.getTxtPlace().setBackground(new Color(255, 192, 203));
            this.getTxtPlace().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtPlace().setBackground(Color.white);
        }
        if (this.getTxtDescription().getText().equals("")) {
            this.getTxtDescription().setBackground(new Color(255, 192, 203));
            this.getTxtDescription().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtDescription().setBackground(Color.white);
        }
        if (this.getTxtDate().getText().equals("") || this.getTxtDate().getDate().after(new Date())) {
            this.getTxtDate().setBackground(new Color(255, 192, 203));
            if (this.getTxtDate().getText().equals("")) {
                this.getTxtDate().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            } else {
                this.getTxtDate().setToolTipText(LanguageTranslator.getString("error.afterToday"));
            }
            toReturn = false;
        } else {
            this.getTxtDate().setBackground(Color.white);
        }
        if (!this.getTxtHour().isValidHour()) {
            this.getTxtHour().setBackground(new Color(255, 192, 203));
            this.getTxtHour().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getTxtHour().setBackground(Color.white);
        }
        if (((ComboBoxModel)this.getCbAgency().getModel()).getSelectedCle() == 0) {
            this.getCbAgency().setBackground(new Color(255, 192, 203));
            this.getCbAgency().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getCbAgency().setBackground(UIManager.getColor("ComboBox.background"));
        }
        if (((ComboBoxModel)this.getCbDriver().getModel()).getSelectedCle() == 0) {
            this.getCbDriver().setBackground(new Color(255, 192, 203));
            this.getCbDriver().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getCbDriver().setBackground(UIManager.getColor("ComboBox.background"));
        }
        if (((ComboBoxModel)this.getCbVehicle().getModel()).getSelectedCle() == 0) {
            this.getCbVehicle().setBackground(new Color(255, 192, 203));
            this.getCbVehicle().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getCbVehicle().setBackground(UIManager.getColor("ComboBox.background"));
        }
        return toReturn;
    }

    private JPanel getPnlFinancial() {
        if (this.pnlFinancial == null) {
            GridBagConstraints gcblblRcCost = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtRcCost = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblRcExcess = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtRcExcess = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblInsuranceRecourse = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtInsuranceRecourse = Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblCompanyRecourse = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCompanyRecourse = Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblDamageExcess = Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtDamageExcess = Fonctions.getGridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblVAT = Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtVAT = Fonctions.getGridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblDilapidation = Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtDilapidation = Fonctions.getGridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblSelfInsurance = Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtSelfInsurance = Fonctions.getGridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblExpertCost = Fonctions.getGridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtExpertCost = Fonctions.getGridBagConstraints(1, 8, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblFixingCost = Fonctions.getGridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtFixingCost = Fonctions.getGridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblCompanyFixingCost = Fonctions.getGridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCompanyFixingCost = Fonctions.getGridBagConstraints(1, 10, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblLocationDebt = Fonctions.getGridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtLocationDebt = Fonctions.getGridBagConstraints(1, 11, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblCompanyLocationDebt = Fonctions.getGridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCompanyLocationDebt = Fonctions.getGridBagConstraints(1, 12, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcblblGuarding = Fonctions.getGridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtGuarding = Fonctions.getGridBagConstraints(1, 13, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblTotalCost = Fonctions.getGridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtTotalCost = Fonctions.getGridBagConstraints(1, 14, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblTotalInsurance = Fonctions.getGridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtTotalInsurance = Fonctions.getGridBagConstraints(1, 15, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 0, 0, 5));
            this.lblRcCost = new JLabel(LanguageTranslator.getString("accident.rcCost"));
            this.lblRcExcess = new JLabel(LanguageTranslator.getString("accident.rcExcess"));
            this.lblInsuranceRecourse = new JLabel(LanguageTranslator.getString("accident.insuranceRecourse"));
            this.lblCompanyRecourse = new JLabel(LanguageTranslator.getString("accident.companyRecourse"));
            this.lblDamageExcess = new JLabel(LanguageTranslator.getString("accident.damageExcess"));
            this.lblVAT = new JLabel(LanguageTranslator.getString("accident.VAT"));
            this.lblDilapidation = new JLabel(LanguageTranslator.getString("accident.dilapidation"));
            this.lblSelfInsurance = new JLabel(LanguageTranslator.getString("accident.selfInsurance"));
            this.lblExpertCost = new JLabel(LanguageTranslator.getString("accident.expertCost"));
            this.lblFixingCost = new JLabel(LanguageTranslator.getString("accident.fixingCost"));
            this.lblCompanyFixingCost = new JLabel(LanguageTranslator.getString("accident.companyFixingCost"));
            this.lblLocationDebt = new JLabel(LanguageTranslator.getString("accident.locationDebt"));
            this.lblCompanyLocationDebt = new JLabel(LanguageTranslator.getString("accident.companyLocationDebt"));
            this.lblGuarding = new JLabel(LanguageTranslator.getString("accident.guarding"));
            this.lblTotalCost = new JLabel(LanguageTranslator.getString("accident.totalCost"));
            this.lblTotalInsurance = new JLabel(LanguageTranslator.getString("accident.totalInsurance"));
            this.pnlFinancial = new JPanel();
            this.pnlFinancial.setMinimumSize(new Dimension(220, 0));
            this.pnlFinancial.setMaximumSize(new Dimension(220, 0));
            this.pnlFinancial.setPreferredSize(new Dimension(220, 0));
            this.pnlFinancial.setSize(new Dimension(220, 0));
            this.pnlFinancial.setBorder(new TitledBorder(LanguageTranslator.getString("accident.financial")));
            this.pnlFinancial.setLayout(new GridBagLayout());
            this.pnlFinancial.add((Component)this.lblRcCost, gcblblRcCost);
            this.pnlFinancial.add((Component)this.getTxtRcCost(), gcbTxtRcCost);
            this.pnlFinancial.add((Component)this.lblRcExcess, gcblblRcExcess);
            this.pnlFinancial.add((Component)this.getTxtRcExcess(), gcbTxtRcExcess);
            this.pnlFinancial.add((Component)this.getTxtInsuranceRecourse(), gcbTxtInsuranceRecourse);
            this.pnlFinancial.add((Component)this.lblInsuranceRecourse, gcblblInsuranceRecourse);
            this.pnlFinancial.add((Component)this.lblCompanyRecourse, gcblblCompanyRecourse);
            this.pnlFinancial.add((Component)this.getTxtCompanyRecourse(), gcbTxtCompanyRecourse);
            this.pnlFinancial.add((Component)this.lblDamageExcess, gcblblDamageExcess);
            this.pnlFinancial.add((Component)this.getTxtDamageExcess(), gcbTxtDamageExcess);
            this.pnlFinancial.add((Component)this.lblVAT, gcblblVAT);
            this.pnlFinancial.add((Component)this.getTxtVAT(), gcbTxtVAT);
            this.pnlFinancial.add((Component)this.lblDilapidation, gcblblDilapidation);
            this.pnlFinancial.add((Component)this.getTxtDilapidation(), gcbTxtDilapidation);
            this.pnlFinancial.add((Component)this.lblSelfInsurance, gcblblSelfInsurance);
            this.pnlFinancial.add((Component)this.getTxtSelfInsurance(), gcbTxtSelfInsurance);
            this.pnlFinancial.add((Component)this.lblExpertCost, gcblblExpertCost);
            this.pnlFinancial.add((Component)this.getTxtExpertCost(), gcbTxtExpertCost);
            this.pnlFinancial.add((Component)this.lblFixingCost, gcblblFixingCost);
            this.pnlFinancial.add((Component)this.getTxtFixingCost(), gcbTxtFixingCost);
            this.pnlFinancial.add((Component)this.lblCompanyFixingCost, gcblblCompanyFixingCost);
            this.pnlFinancial.add((Component)this.getTxtCompanyFixingCost(), gcbTxtCompanyFixingCost);
            this.pnlFinancial.add((Component)this.lblLocationDebt, gcblblLocationDebt);
            this.pnlFinancial.add((Component)this.getTxtLocationDebt(), gcbTxtLocationDebt);
            this.pnlFinancial.add((Component)this.lblCompanyLocationDebt, gcblblCompanyLocationDebt);
            this.pnlFinancial.add((Component)this.getTxtCompanyLocationDebt(), gcbTxtCompanyLocationDebt);
            this.pnlFinancial.add((Component)this.lblGuarding, gcblblGuarding);
            this.pnlFinancial.add((Component)this.getTxtGuarding(), gcbTxtGuarding);
            this.pnlFinancial.add((Component)this.lblTotalCost, gcbLblTotalCost);
            this.pnlFinancial.add((Component)this.getTxtTotalCost(), gcbTxtTotalCost);
            this.pnlFinancial.add((Component)this.lblTotalInsurance, gcbLblTotalInsurance);
            this.pnlFinancial.add((Component)this.getTxtTotalInsurance(), gcbTxtTotalInsurance);
        }
        return this.pnlFinancial;
    }

    private JTextField getTxtRcCost() {
        if (this.txtRcCost == null) {
            this.txtRcCost = new JTextField();
        }
        return this.txtRcCost;
    }

    private JTextField getTxtRcExcess() {
        if (this.txtRcExcess == null) {
            this.txtRcExcess = new JTextField();
        }
        return this.txtRcExcess;
    }

    private JTextField getTxtInsuranceRecourse() {
        if (this.txtInsuranceRecourse == null) {
            this.txtInsuranceRecourse = new JTextField();
        }
        return this.txtInsuranceRecourse;
    }

    private JTextField getTxtCompanyRecourse() {
        if (this.txtCompanyRecourse == null) {
            this.txtCompanyRecourse = new JTextField();
        }
        return this.txtCompanyRecourse;
    }

    private JTextField getTxtDamageExcess() {
        if (this.txtDamageExcess == null) {
            this.txtDamageExcess = new JTextField();
        }
        return this.txtDamageExcess;
    }

    private JTextField getTxtVAT() {
        if (this.txtVAT == null) {
            this.txtVAT = new JTextField();
        }
        return this.txtVAT;
    }

    private JTextField getTxtDilapidation() {
        if (this.txtDilapidation == null) {
            this.txtDilapidation = new JTextField();
        }
        return this.txtDilapidation;
    }

    private JTextField getTxtSelfInsurance() {
        if (this.txtSelfInsurance == null) {
            this.txtSelfInsurance = new JTextField();
        }
        return this.txtSelfInsurance;
    }

    private JTextField getTxtExpertCost() {
        if (this.txtExpertCost == null) {
            this.txtExpertCost = new JTextField();
        }
        return this.txtExpertCost;
    }

    private JTextField getTxtFixingCost() {
        if (this.txtFixingCost == null) {
            this.txtFixingCost = new JTextField();
        }
        return this.txtFixingCost;
    }

    private JTextField getTxtCompanyFixingCost() {
        if (this.txtCompanyFixingCost == null) {
            this.txtCompanyFixingCost = new JTextField();
        }
        return this.txtCompanyFixingCost;
    }

    private JTextField getTxtLocationDebt() {
        if (this.txtLocationDebt == null) {
            this.txtLocationDebt = new JTextField();
        }
        return this.txtLocationDebt;
    }

    private JTextField getTxtCompanyLocationDebt() {
        if (this.txtCompanyLocationDebt == null) {
            this.txtCompanyLocationDebt = new JTextField();
        }
        return this.txtCompanyLocationDebt;
    }

    private JTextField getTxtGuarding() {
        if (this.txtGuarding == null) {
            this.txtGuarding = new JTextField();
        }
        return this.txtGuarding;
    }

    private JTextField getTxtTotalCost() {
        if (this.txtTotalCost == null) {
            this.txtTotalCost = new JTextField();
        }
        return this.txtTotalCost;
    }

    private JTextField getTxtTotalInsurance() {
        if (this.txtTotalInsurance == null) {
            this.txtTotalInsurance = new JTextField();
        }
        return this.txtTotalInsurance;
    }

    public void setSelectedAgency(int agencyId) {
        ((ComboBoxModel)this.getCbAgency().getModel()).setSelected(agencyId);
    }

    public void setSelectedDriver(int driverId) {
        ((ComboBoxModel)this.getCbDriver().getModel()).setSelected(driverId);
    }

    public void setSelectedVehicle(int vehicleId) {
        ((ComboBoxModel)this.getCbVehicle().getModel()).setSelected(vehicleId);
    }
}

