/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.bdd.Utilisateur;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogChangementMdp
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private Utilisateur toChange = null;
    private JPasswordField txtNewPwd = null;
    private JPasswordField txtConfirmPwd = null;
    private JPanel pnlBtn = null;
    private JButton btnValider = null;
    private JButton btnAnnuler = null;
    private JPanel pnlPwdAdmin = null;
    private JLabel lblAdminPwd = null;
    private JPasswordField txtAdminPwd = null;
    private JPanel pnlUserPwd = null;
    private JLabel lblNewPwd = null;
    private JLabel lblConfirm = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogChangementMdp.dispose()#");
        super.dispose();
    }

    public DialogChangementMdp(JDialog owner, Utilisateur toChange) {
        TimsLogger.verbose("#DialogChangementMdp()#");
        this.toChange = toChange;
        this.initialize();
    }

    private void initialize() {
        this.setSize(370, 200);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
        this.setTitle("Changement du mot de passe");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbAdmin = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, -1, new Insets(5, 5, 5, 0));
            GridBagConstraints gcbUser = Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, -1, new Insets(0, 5, 5, 0));
            GridBagConstraints gcbBtn = Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, -1, new Insets(0, 0, 5, 0));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlPwdAdmin(), gcbAdmin);
            this.jContentPane.add((Component)this.getPnlUserPwd(), gcbUser);
            this.jContentPane.add((Component)this.getPnlBtn(), gcbBtn);
        }
        return this.jContentPane;
    }

    private JPasswordField getTxtNewPwd() {
        if (this.txtNewPwd == null) {
            this.txtNewPwd = new JPasswordField();
            this.txtNewPwd.setPreferredSize(new Dimension(150, 20));
        }
        return this.txtNewPwd;
    }

    private JPasswordField getTxtConfirmPwd() {
        if (this.txtConfirmPwd == null) {
            this.txtConfirmPwd = new JPasswordField();
        }
        return this.txtConfirmPwd;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.weightx = 1.0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnValider(), gridBagConstraints5);
            this.pnlBtn.add((Component)this.getBtnAnnuler(), gridBagConstraints4);
        }
        return this.pnlBtn;
    }

    private JButton getBtnValider() {
        if (this.btnValider == null) {
            this.btnValider = new JButton();
            this.btnValider.setText(LanguageTranslator.getString("button.valid"));
            this.btnValider.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogChangementMdp.this.validChange();
                }
            });
        }
        return this.btnValider;
    }

    public void validChange() {
        String admin = new String(new StringBuffer().append(this.getTxtAdminPwd().getPassword()).toString());
        String passe = new String(new StringBuffer().append(this.getTxtNewPwd().getPassword()).toString());
        String confirm = new String(new StringBuffer().append(this.getTxtConfirmPwd().getPassword()).toString());
        if (ConnexionSettings.getInstance().verifPassword(admin)) {
            if (!passe.equals(confirm)) {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("password.badConfirm"), LanguageTranslator.getString("message.inputError"), 0);
                this.getTxtNewPwd().setText("");
                this.getTxtConfirmPwd().setText("");
            } else {
                this.toChange.setMdp(passe);
                this.toChange.updatePassword();
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("password.updated"), LanguageTranslator.getString("message.done"), 1);
                this.dispose();
            }
        } else {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("password.badAdminPwd"), LanguageTranslator.getString("message.inputError"), 0);
            this.getTxtAdminPwd().setText("");
        }
    }

    private JButton getBtnAnnuler() {
        if (this.btnAnnuler == null) {
            this.btnAnnuler = new JButton();
            this.btnAnnuler.setText(LanguageTranslator.getString("button.quit"));
            this.btnAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogChangementMdp.this.dispose();
                }
            });
        }
        return this.btnAnnuler;
    }

    private JPanel getPnlPwdAdmin() {
        if (this.pnlPwdAdmin == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.gridx = 0;
            this.lblAdminPwd = new JLabel();
            this.lblAdminPwd.setText(LanguageTranslator.getString("user.admin.ownPassword"));
            this.pnlPwdAdmin = new JPanel();
            this.pnlPwdAdmin.setLayout(new GridBagLayout());
            this.pnlPwdAdmin.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("user.admin.ownPasswordTitle"), 0, 0, null, null));
            this.pnlPwdAdmin.add((Component)this.lblAdminPwd, gridBagConstraints6);
            this.pnlPwdAdmin.add((Component)this.getTxtAdminPwd(), gridBagConstraints7);
        }
        return this.pnlPwdAdmin;
    }

    private JPasswordField getTxtAdminPwd() {
        if (this.txtAdminPwd == null) {
            this.txtAdminPwd = new JPasswordField();
            this.txtAdminPwd.setPreferredSize(new Dimension(150, 20));
        }
        return this.txtAdminPwd;
    }

    private JPanel getPnlUserPwd() {
        if (this.pnlUserPwd == null) {
            this.lblNewPwd = new JLabel();
            this.lblNewPwd.setText(LanguageTranslator.getString("user.admin.newPassword"));
            this.lblConfirm = new JLabel();
            this.lblConfirm.setText(LanguageTranslator.getString("user.admin.oldPassword"));
            GridBagConstraints gcbLblNew = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, -1, -1, new Insets(0, 0, 0, 0));
            GridBagConstraints gcbNewPwd = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(0, 5, 0, 5));
            GridBagConstraints gcbLblConfirm = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, -1, null);
            GridBagConstraints gcbConfirm = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 2, -1, new Insets(0, 5, 0, 5));
            this.pnlUserPwd = new JPanel();
            this.pnlUserPwd.setLayout(new GridBagLayout());
            this.pnlUserPwd.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("user.admin.newPasswordTitle"), 0, 0, null, null));
            this.pnlUserPwd.add((Component)this.lblNewPwd, gcbLblNew);
            this.pnlUserPwd.add((Component)this.getTxtNewPwd(), gcbNewPwd);
            this.pnlUserPwd.add((Component)this.getTxtConfirmPwd(), gcbConfirm);
            this.pnlUserPwd.add((Component)this.lblConfirm, gcbLblConfirm);
        }
        return this.pnlUserPwd;
    }
}

