/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.ClosePayPeriod;
import fr.pgh.data.bdd.PayPeriod;
import fr.pgh.exception.AgencyNotFoundException;
import fr.pgh.exception.PayPeriodNotFoundException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.exp.ActivityToCcmx;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.TMCPP;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class DialogClosePayPeriod
extends JDialog
implements TableModelListener {
    private JPanel jContentPane = null;
    private JScrollPane jspTable = null;
    private JTable tblPayPeriod = null;
    private JPanel pnlBtn = null;
    private JButton btnQuit = null;
    private JButton btnSave = null;
    Vector<PayPeriod> payPeriods = null;
    Vector<Agence> agencies = null;
    private Boolean[][] value = null;

    public DialogClosePayPeriod(JFrame frame) {
        super(frame);
        this.initialize();
        this.loadTable();
        this.afficheTable();
    }

    private void initialize() {
        this.setSize(650, 300);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
        this.setTitle(LanguageTranslator.getString("generics.closePayPeriod"));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJspTable(), "Center");
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJspTable() {
        if (this.jspTable == null) {
            this.jspTable = new JScrollPane();
        }
        return this.jspTable;
    }

    private JTable getTblPayPeriod() {
        if (this.tblPayPeriod == null) {
            this.tblPayPeriod = new JTable();
            this.tblPayPeriod.setAutoResizeMode(0);
        }
        return this.tblPayPeriod;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
            this.pnlBtn.add((Component)this.getBtnSave(), null);
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogClosePayPeriod.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        return this.btnSave;
    }

    private void afficheTable() {
        if (this.getTblPayPeriod().getModel() == null || !(this.getTblPayPeriod().getModel() instanceof TMCPP)) {
            this.getTblPayPeriod().setModel(new TMCPP(this.payPeriods, this.value));
            ((TMCPP)this.getTblPayPeriod().getModel()).addTableModelListener(this);
        } else {
            ((TMCPP)this.getTblPayPeriod().getModel()).setValue(this.payPeriods, this.value);
        }
        TableColumn column = null;
        int x = 0;
        while (x < this.getTblPayPeriod().getModel().getColumnCount()) {
            column = this.getTblPayPeriod().getColumnModel().getColumn(x);
            column.setPreferredWidth(50);
            ++x;
        }
        JList list = new JList(new ComboBoxModel((Vector<?>)this.agencies));
        list.setFixedCellWidth(150);
        list.setFixedCellHeight(this.getTblPayPeriod().getRowHeight());
        list.setCellRenderer(new RowHeader(this.getTblPayPeriod()));
        list.setBackground(this.getTblPayPeriod().getTableHeader().getBackground());
        this.getJspTable().setRowHeaderView(list);
        this.getJspTable().setViewportView(this.getTblPayPeriod());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        TimsLogger.verbose("row " + row + " column " + column + " value " + this.getTblPayPeriod().getValueAt(row, column));
        TimsLogger.verbose("agencyId " + this.agencies.get(row).getCleAgence() + " payPeriodId " + this.payPeriods.get(column).getId());
        Boolean askToclose = (Boolean)this.getTblPayPeriod().getValueAt(row, column);
        if (!askToclose.booleanValue()) {
            Vector<ClosePayPeriod> list = ClosePayPeriod.loadList(this.agencies.get(row).getCleAgence(), this.payPeriods.get(column).getId(), null, null);
            for (ClosePayPeriod toCheck : list) {
                if (toCheck.getActive() == 0) continue;
                toCheck.compareAndUpdate(toCheck.getAgencyId(), toCheck.getPayPeriodId(), toCheck.getUserId(), toCheck.getCloture(), toCheck.getExported(), toCheck.getClotureDate(), 0);
            }
        } else {
            Vector<Agence> toClose = new Vector<Agence>();
            toClose.add(this.agencies.get(e.getFirstRow()));
            new ActivityToCcmx(toClose, this.payPeriods.get(e.getColumn())).start();
        }
    }

    private void loadTable() {
        this.payPeriods = PayPeriod.loadList(null);
        this.agencies = Agence.loadList(null, 0);
        Vector<ClosePayPeriod> closed = ClosePayPeriod.loadList(0, 0, null, null);
        this.value = new Boolean[this.payPeriods.size()][this.agencies.size()];
        int x = 0;
        while (x < this.payPeriods.size()) {
            int y = 0;
            while (y < this.agencies.size()) {
                this.value[x][y] = false;
                ++y;
            }
            ++x;
        }
        for (ClosePayPeriod close : closed) {
            try {
                int x2 = this.getPayPeriodPosition(this.payPeriods, close.getPayPeriodId());
                int y = this.getAgencyPosition(this.agencies, close.getAgencyId());
                if (this.value[x2][y].booleanValue()) {
                    TimsLogger.verbose(String.valueOf(this.payPeriods.get(x2).getName()) + " has multiple close on " + this.agencies.get(y).getDescription());
                    continue;
                }
                if (close.getActive() != 0) {
                    this.value[x2][y] = true;
                    continue;
                }
                this.value[x2][y] = false;
            }
            catch (Exception ex) {
                TimsLogger.warn("Problem with pay period " + close.getPayPeriodId() + " and agency " + close.getAgencyId());
                ex.printStackTrace();
            }
        }
    }

    public int getAgencyPosition(Vector<Agence> agencies, int agencyId) throws AgencyNotFoundException {
        int x = 0;
        while (x < agencies.size()) {
            Agence tmp = agencies.get(x);
            if (tmp.getCleAgence() == agencyId) {
                return x;
            }
            ++x;
        }
        throw new AgencyNotFoundException();
    }

    public int getPayPeriodPosition(Vector<PayPeriod> payPeriods, int payPeriodId) throws PayPeriodNotFoundException {
        int x = 0;
        while (x < payPeriods.size()) {
            PayPeriod tmp = payPeriods.get(x);
            if (tmp.getId() == payPeriodId) {
                return x;
            }
            ++x;
        }
        throw new PayPeriodNotFoundException();
    }

    public class RowHeader
    extends JLabel
    implements ListCellRenderer {
        public RowHeader(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            return this;
        }
    }
}

