/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JTextDate;
import fr.pgh.component.JTextHour;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.CompanyAction;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Societe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;

public class DialogCompany
extends JDialog {
    public static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTextField txtNomSociete = null;
    private JButton btnQuitter = null;
    private JButton btnCreer = null;
    private JPanel pnlBtn = null;
    private JPanel pnlContent = null;
    private JTextField txtPersonName = null;
    private JTextField txtPersonFirstName = null;
    private JTextField txtMail = null;
    private JTextField txtPhone = null;
    private JTextArea txtAddress = null;
    private JTextField txtCity = null;
    private JTextField txtPostalCode = null;
    private JComboBox cbCountry = null;
    private JTextField txtFax = null;
    private JPanel pnlCompanyAction = null;
    private JTabbedPane pnlGlobal = null;
    private Societe current = null;
    private JLabel lblCode = null;
    private JTextField txtCode = null;
    private String admin_pwd = null;
    private JPanel pnlContract = null;
    private JTextDate txtBeginDate = null;
    private JTextDate txtEndDate = null;
    private JTextField txtAmount = null;
    private JPanel pnlList = null;
    private JScrollPane jspListAction = null;
    private JList<String> listAction = null;
    private JPanel pnlContentTechnical = null;
    private JTextDate txtDateTechnical = null;
    private JTextHour txtHourTechnical = null;
    private JComboBox<String> cbState = null;
    private JComboBox<String> cbManager = null;
    private JComboBox<String> cbProduct = null;
    private JComboBox<String> cbAction = null;
    private JComboBox<String> cbPriority = null;
    private JComboBox<String> cbContact = null;
    private JTextArea txtPbTechnical = null;
    private JTextArea txtSolveTechnical = null;
    private JTextHour txtLengthTelTechnical = null;
    private JTextHour txtLengthIntervTechnical = null;
    private JTextField cost = null;
    private JTextDate txtDateEndTechnical = null;
    private JPanel pnlBtnTechnical = null;
    private JButton btnNewTechnical = null;
    private JButton btnSaveTechnical = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCompany.dispose()#");
        super.dispose();
    }

    public DialogCompany(Frame owner, Societe toShow) {
        super(owner);
        this.setModal(true);
        TimsLogger.verbose("#DialogCompany()#");
        this.initialize();
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            JOptionPane.showMessageDialog(this, "La version oracle ne supporte pas le multi-soci\u00e9t\u00e9", "Fonction desactiv\u00e9e", 0);
            this.getBtnCreer().setEnabled(false);
        }
        if (toShow != null) {
            this.current = toShow;
            this.load();
        }
    }

    private void load() {
        if (this.current != null) {
            this.getCbCountry().setSelectedItem(((ComboBoxModel)this.getCbCountry().getModel()).getLabel(this.current.getCountry()));
            this.getTxtMail().setText(this.current.getMail());
            this.getTxtPhone().setText(this.current.getPhone());
            this.getTxtFax().setText(this.current.getFax());
            this.getTxtNomSociete().setText(this.current.getNomSociete());
            this.getTxtCode().setText(this.current.getCode());
            this.getTxtAddress().setText(this.current.getAddress());
            this.getTxtCity().setText(this.current.getCity());
            this.getTxtPostalCode().setText(this.current.getPostalCode());
            this.getTxtPersonFirstName().setText(this.current.getDirectorFirstName());
            this.getTxtPersonName().setText(this.current.getDirectorLastName());
        }
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 800, 480));
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("company.create.title"));
        this.setContentPane(this.getJContentPane());
        this.setModal(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
            this.jContentPane.add((Component)this.getPnlGlobal(), "Center");
        }
        return this.jContentPane;
    }

    private JTabbedPane getPnlGlobal() {
        if (this.pnlGlobal == null) {
            this.pnlGlobal = new JTabbedPane();
            this.pnlGlobal.addTab(LanguageTranslator.getString("generics.information"), this.getPnlContent());
            this.pnlGlobal.addTab(LanguageTranslator.getString("generics.action"), this.getPnlCompanyAction());
        }
        return this.pnlGlobal;
    }

    private JTextField getTxtNomSociete() {
        if (this.txtNomSociete == null) {
            this.txtNomSociete = new JTextField();
        }
        return this.txtNomSociete;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCompany.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.save"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCompany.this.validation();
                }
            });
        }
        return this.btnCreer;
    }

    private void validation() {
        String toFill = this.check();
        if (!toFill.equals("")) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.missingField", toFill), LanguageTranslator.getString("message.inputError"), 0);
            TimsLogger.debug(toFill);
        } else if (this.current == null) {
            String nom = this.getTxtNomSociete().getText().trim();
            if (Societe.loadList(nom).size() != 0 || nom.equalsIgnoreCase("TIMS")) {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.companyExists"), LanguageTranslator.getString("message.inputError"), 0);
            } else {
                String base = nom.toLowerCase().replace(".", "").replace(" ", "").replace("'", "").replace("-", "").replace("\u00e9", "e").replace("\u00e8", "e").replace("\u00ea", "e").replace("\u00e0", "a").replace("\u00ee", "i").replace("\u00e7", "c").replace("\u00fb", "u");
                if (base.equals("test")) {
                    base = "testtims";
                }
                while (Transport.bdd.isBaseExiste(base)) {
                    base = String.valueOf(base) + "1";
                }
                this.createDB(nom, base);
            }
        } else if (!this.current.compareAndUpdate(this.getTxtNomSociete().getText(), this.getTxtCode().getText(), this.getTxtPhone().getText(), this.getTxtFax().getText(), this.getTxtMail().getText(), this.getTxtAddress().getText(), this.getTxtCity().getText(), this.getTxtPostalCode().getText(), ((ComboBoxModel)this.getCbCountry().getModel()).getSelectedCle(), this.getTxtPersonFirstName().getText(), this.getTxtPersonName().getText())) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveError"), LanguageTranslator.getString("message.saveError"), 0);
        } else {
            this.dispose();
        }
    }

    public void createDB(String nom, String base) {
        Transport.ps.startOperation();
        String pwd = "";
        String encryptedPwd = "";
        String user = "";
        String chemin = null;
        if (System.getProperty("URL") != null) {
            block12: {
                try {
                    File up = FileManager.getServerFile("files/createTable" + Transport.res.getResourceString("databaseVersion") + ".sql", String.valueOf(Transport.savePath) + "createTable.sql");
                    chemin = up.getAbsolutePath();
                }
                catch (IOException ex) {
                    JFileChooser choix = new JFileChooser();
                    if (choix.showOpenDialog(this) != 0) break block12;
                    chemin = choix.getSelectedFile().getAbsolutePath();
                }
            }
            if (chemin == null) {
                TimsLogger.warn("#DialogdCompany.createDB# no selected file");
                return;
            }
            this.admin_pwd = JOptionPane.showInputDialog("Entrez le mot de passe administrateur");
            Transport.bdd.reloadConnection("createdbuser", this.admin_pwd);
            user = String.valueOf(base.length() > 12 ? base.substring(0, 12) : base) + "_utl";
            int random = ThreadLocalRandom.current().nextInt(100000, 999999);
            pwd = String.valueOf(base) + random;
            encryptedPwd = Fonctions.encryptPassword(pwd, Fonctions.getDecryptKey());
        } else {
            chemin = "createTable.sql";
        }
        Transport.bdd.startTransaction();
        boolean succeed = false;
        this.current = new Societe(0, nom, this.getTxtCode().getText(), base, this.getTxtPhone().getText(), this.getTxtFax().getText(), this.getTxtMail().getText(), this.getTxtAddress().getText(), this.getTxtCity().getText(), this.getTxtPostalCode().getText(), ((ComboBoxModel)this.getCbCountry().getModel()).getSelectedCle(), this.getTxtPersonName().getText(), this.getTxtPersonFirstName().getText(), null, encryptedPwd);
        if (this.current.update() && Transport.bdd.creeDB(base)) {
            boolean srvError = false;
            if (!(System.getProperty("URL") == null || BddTransport.getInstance().executeCmd("CREATE USER '" + user + "'@'%' identified by '" + pwd + "';") && BddTransport.getInstance().executeCmd("GRANT SELECT, INSERT, UPDATE, DELETE, LOCK TABLES ON " + base + ".* TO '" + user + "'@'%';") && BddTransport.getInstance().executeCmd("GRANT SELECT, INSERT, UPDATE, DELETE, LOCK TABLES ON tims.* TO '" + user + "'@'%';"))) {
                srvError = true;
            }
            if (!srvError) {
                String results = Fonctions.executeSqlFromFile(chemin, Transport.bdd);
                if (results != null && !results.equals("")) {
                    TimsLogger.info("#DialogCompany# erreur : " + results);
                } else {
                    succeed = true;
                }
            }
        }
        if (!succeed) {
            Transport.bdd.rollback();
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("company.creation.error"), LanguageTranslator.getString("message.error"), 0);
        } else {
            Transport.bdd.commit();
            Transport.bdd.changeDB(nom, true);
        }
        Transport.ps.endOperation(PerformanceScanner.INSERT, "database creation");
        this.dispose();
    }

    private String check() {
        String empty = "";
        if (this.getTxtNomSociete().getText().equals("")) {
            empty = String.valueOf(empty) + LanguageTranslator.getString("company.name") + "\n";
            this.getTxtNomSociete().setBackground(new Color(255, 192, 203));
        } else {
            this.getTxtNomSociete().setBackground(Color.white);
        }
        if (this.getTxtPersonName().getText().equals("")) {
            empty = String.valueOf(empty) + LanguageTranslator.getString("company.directorFirstName") + "\n";
            this.getTxtPersonName().setBackground(new Color(255, 192, 203));
        } else {
            this.getTxtPersonName().setBackground(Color.white);
        }
        if (this.getTxtPersonFirstName().getText().equals("")) {
            empty = String.valueOf(empty) + LanguageTranslator.getString("company.directorLastName") + "\n";
            this.getTxtPersonFirstName().setBackground(new Color(255, 192, 203));
        } else {
            this.getTxtPersonFirstName().setBackground(Color.white);
        }
        if (this.getTxtMail().getText().equals("")) {
            empty = String.valueOf(empty) + LanguageTranslator.getString("generics.mail") + "\n";
            this.getTxtMail().setBackground(new Color(255, 192, 203));
        } else {
            this.getTxtMail().setBackground(Color.white);
        }
        if (this.getTxtPhone().getText().equals("")) {
            empty = String.valueOf(empty) + LanguageTranslator.getString("generics.phone") + "\n";
            this.getTxtPhone().setBackground(new Color(255, 192, 203));
        } else {
            this.getTxtPhone().setBackground(Color.white);
        }
        if (this.getTxtAddress().getText().equals("")) {
            empty = String.valueOf(empty) + LanguageTranslator.getString("generics.address") + "\n";
            this.getTxtAddress().setBackground(new Color(255, 192, 203));
        } else {
            this.getTxtAddress().setBackground(Color.white);
        }
        if (this.getTxtCity().getText().equals("")) {
            empty = String.valueOf(empty) + LanguageTranslator.getString("generics.city") + "\n";
            this.getTxtCity().setBackground(new Color(255, 192, 203));
        } else {
            this.getTxtCity().setBackground(Color.white);
        }
        if (this.getTxtPostalCode().getText().equals("")) {
            empty = String.valueOf(empty) + LanguageTranslator.getString("generics.cp") + "\n";
            this.getTxtPostalCode().setBackground(new Color(255, 192, 203));
        } else {
            this.getTxtPostalCode().setBackground(Color.white);
        }
        return empty;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnQuitter(), null);
            this.pnlBtn.add((Component)this.getBtnCreer(), null);
        }
        return this.pnlBtn;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)new JLabel(LanguageTranslator.getString("company.name")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getTxtNomSociete(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)new JLabel(LanguageTranslator.getString("generics.code")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getTxtCode(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)new JLabel(LanguageTranslator.getString("company.directorLastName")), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getTxtPersonName(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)new JLabel(LanguageTranslator.getString("company.directorFirstName")), Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getTxtPersonFirstName(), Fonctions.getGridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)new JLabel(LanguageTranslator.getString("generics.mail")), Fonctions.getGridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getTxtMail(), Fonctions.getGridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            JPanel pnlAddress = new JPanel();
            pnlAddress.setLayout(new GridBagLayout());
            pnlAddress.setBorder(new TitledBorder(LanguageTranslator.getString("generics.address")));
            pnlAddress.add((Component)new JLabel(LanguageTranslator.getString("generics.address")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            pnlAddress.add((Component)this.getTxtAddress(), Fonctions.getGridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            pnlAddress.add((Component)new JLabel(LanguageTranslator.getString("generics.city")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            pnlAddress.add((Component)this.getTxtCity(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            pnlAddress.add((Component)new JLabel(LanguageTranslator.getString("generics.cp")), Fonctions.getGridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            pnlAddress.add((Component)this.getTxtPostalCode(), Fonctions.getGridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)pnlAddress, Fonctions.getGridBagConstraints(2, 0, 2, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)new JLabel(LanguageTranslator.getString("generics.country")), Fonctions.getGridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getCbCountry(), Fonctions.getGridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)new JLabel(LanguageTranslator.getString("generics.phone")), Fonctions.getGridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getTxtPhone(), Fonctions.getGridBagConstraints(3, 3, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)new JLabel(LanguageTranslator.getString("generics.fax")), Fonctions.getGridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContent.add((Component)this.getTxtFax(), Fonctions.getGridBagConstraints(3, 4, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            if (System.getProperty("URL") != null && Transport.conn.isConsultable("ADMIN_PGH")) {
                this.pnlContent.add((Component)this.getPnlContract(), Fonctions.getGridBagConstraints(4, 0, 1, 4, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            }
        }
        return this.pnlContent;
    }

    private JTextField getTxtPersonName() {
        if (this.txtPersonName == null) {
            this.txtPersonName = new JTextField();
        }
        return this.txtPersonName;
    }

    private JTextField getTxtPersonFirstName() {
        if (this.txtPersonFirstName == null) {
            this.txtPersonFirstName = new JTextField();
        }
        return this.txtPersonFirstName;
    }

    private JTextField getTxtMail() {
        if (this.txtMail == null) {
            this.txtMail = new JTextField();
        }
        return this.txtMail;
    }

    private JTextField getTxtPhone() {
        if (this.txtPhone == null) {
            this.txtPhone = new JTextField();
        }
        return this.txtPhone;
    }

    private JTextArea getTxtAddress() {
        if (this.txtAddress == null) {
            this.txtAddress = new JTextArea();
        }
        return this.txtAddress;
    }

    private JTextField getTxtCity() {
        if (this.txtCity == null) {
            this.txtCity = new JTextField();
        }
        return this.txtCity;
    }

    private JTextField getTxtPostalCode() {
        if (this.txtPostalCode == null) {
            this.txtPostalCode = new JTextField();
        }
        return this.txtPostalCode;
    }

    private JComboBox getCbCountry() {
        if (this.cbCountry == null) {
            this.cbCountry = new JComboBox();
            this.cbCountry.setModel(new ComboBoxModel(Pays.getVector(), false, null));
            this.cbCountry.setSelectedItem("France");
        }
        return this.cbCountry;
    }

    private JTextField getTxtFax() {
        if (this.txtFax == null) {
            this.txtFax = new JTextField();
        }
        return this.txtFax;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JPanel getPnlContract() {
        if (this.pnlContract == null) {
            this.pnlContract = new JPanel();
            this.pnlContract.setBorder(new TitledBorder(LanguageTranslator.getString("company.action")));
            this.pnlContract.setLayout(new GridBagLayout());
            this.pnlContract.add((Component)new JLabel(LanguageTranslator.getString("generics.begin")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContract.add((Component)this.getTxtBeginDate(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContract.add((Component)new JLabel(LanguageTranslator.getString("generics.end")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContract.add((Component)this.getTxtEndDate(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContract.add((Component)new JLabel(LanguageTranslator.getString("generics.cost")), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlContract.add((Component)this.getTxtAmount(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
        }
        return this.pnlContract;
    }

    private JTextDate getTxtBeginDate() {
        if (this.txtBeginDate == null) {
            this.txtBeginDate = new JTextDate();
        }
        return this.txtBeginDate;
    }

    private JTextDate getTxtEndDate() {
        if (this.txtEndDate == null) {
            this.txtEndDate = new JTextDate();
        }
        return this.txtEndDate;
    }

    private JTextField getTxtAmount() {
        if (this.txtAmount == null) {
            this.txtAmount = new JTextDate();
        }
        return this.txtAmount;
    }

    private JPanel getPnlCompanyAction() {
        if (this.pnlCompanyAction == null) {
            this.pnlCompanyAction = new JPanel();
            this.pnlCompanyAction.setLayout(new GridBagLayout());
            this.pnlCompanyAction.add((Component)this.getPnlList(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 3, -1, new Insets(5, 5, 5, 2)));
            this.pnlCompanyAction.add((Component)this.getPnlContentTechnical(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlCompanyAction.add((Component)this.getPnlBtnTechnical(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
        }
        return this.pnlCompanyAction;
    }

    private JPanel getPnlList() {
        if (this.pnlList == null) {
            this.pnlList = new JPanel();
            this.pnlList.setMinimumSize(new Dimension(100, 0));
            this.pnlList.setBorder(new TitledBorder(LanguageTranslator.getString("company.action")));
            this.pnlList.setLayout(new GridBagLayout());
            this.pnlList.add((Component)this.getJspListAction(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
        }
        return this.pnlList;
    }

    private JScrollPane getJspListAction() {
        if (this.jspListAction == null) {
            this.jspListAction = new JScrollPane();
            this.jspListAction.setViewportView(this.getListAction());
        }
        return this.jspListAction;
    }

    private JList<String> getListAction() {
        if (this.listAction == null) {
            this.listAction = new JList();
            this.listAction.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogCompany.this.getListAction().getSelectedIndex() != -1) {
                        ComboBoxModel tmp = (ComboBoxModel)DialogCompany.this.getListAction().getModel();
                        DialogCompany.this.load((CompanyAction)tmp.getObjectAt(DialogCompany.this.getListAction().getSelectedIndex()));
                    }
                }
            });
        }
        return this.listAction;
    }

    private void load(CompanyAction ca) {
    }

    private JPanel getPnlContentTechnical() {
        if (this.pnlContentTechnical == null) {
            this.pnlContentTechnical = new JPanel();
            this.pnlContentTechnical.setLayout(new GridBagLayout());
            this.pnlContentTechnical.setBorder(new TitledBorder(LanguageTranslator.getString("company.action.details")));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.date")), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtDateTechnical(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtHourTechnical(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.state")), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getCbState(), Fonctions.getGridBagConstraints(4, 0, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.name")), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getCbManager(), Fonctions.getGridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.product")), Fonctions.getGridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getCbProduct(), Fonctions.getGridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.action")), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getCbAction(), Fonctions.getGridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.priority")), Fonctions.getGridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getCbPriority(), Fonctions.getGridBagConstraints(4, 2, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.contact")), Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getCbContact(), Fonctions.getGridBagConstraints(1, 3, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.length.tel")), Fonctions.getGridBagConstraints(3, 3, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtLengthTelTechnical(), Fonctions.getGridBagConstraints(4, 3, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.length.interv")), Fonctions.getGridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtLengthIntervTechnical(), Fonctions.getGridBagConstraints(1, 4, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.cost")), Fonctions.getGridBagConstraints(3, 4, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtLengthIntervTechnical(), Fonctions.getGridBagConstraints(4, 4, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)new JLabel(LanguageTranslator.getString("generics.end")), Fonctions.getGridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            this.pnlContentTechnical.add((Component)this.getTxtDateEndTechnical(), Fonctions.getGridBagConstraints(1, 5, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            JPanel pnlPb = new JPanel();
            pnlPb.add(this.getTxtPbTechnical());
            pnlPb.setBorder(new TitledBorder(LanguageTranslator.getString("generics.problem")));
            this.pnlContentTechnical.add((Component)pnlPb, Fonctions.getGridBagConstraints(0, 6, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
            JPanel pnlSolve = new JPanel();
            pnlSolve.add(this.getTxtSolveTechnical());
            pnlSolve.setBorder(new TitledBorder(LanguageTranslator.getString("generics.solve")));
            this.pnlContentTechnical.add((Component)pnlSolve, Fonctions.getGridBagConstraints(3, 6, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 2)));
        }
        return this.pnlContentTechnical;
    }

    private JTextDate getTxtDateTechnical() {
        if (this.txtDateTechnical == null) {
            this.txtDateTechnical = new JTextDate();
        }
        return this.txtDateTechnical;
    }

    private JTextHour getTxtHourTechnical() {
        if (this.txtHourTechnical == null) {
            this.txtHourTechnical = new JTextHour();
        }
        return this.txtHourTechnical;
    }

    private JComboBox getCbState() {
        if (this.cbState == null) {
            this.cbState = new JComboBox();
        }
        return this.cbState;
    }

    private JComboBox getCbManager() {
        if (this.cbManager == null) {
            this.cbManager = new JComboBox();
        }
        return this.cbManager;
    }

    private JComboBox getCbProduct() {
        if (this.cbProduct == null) {
            this.cbProduct = new JComboBox();
        }
        return this.cbProduct;
    }

    private JComboBox getCbAction() {
        if (this.cbAction == null) {
            this.cbAction = new JComboBox();
        }
        return this.cbAction;
    }

    private JComboBox getCbPriority() {
        if (this.cbPriority == null) {
            this.cbPriority = new JComboBox();
        }
        return this.cbPriority;
    }

    private JComboBox getCbContact() {
        if (this.cbContact == null) {
            this.cbContact = new JComboBox();
        }
        return this.cbContact;
    }

    private JTextArea getTxtPbTechnical() {
        if (this.txtPbTechnical == null) {
            this.txtPbTechnical = new JTextArea();
        }
        return this.txtPbTechnical;
    }

    private JTextArea getTxtSolveTechnical() {
        if (this.txtSolveTechnical == null) {
            this.txtSolveTechnical = new JTextArea();
        }
        return this.txtSolveTechnical;
    }

    private JTextHour getTxtLengthTelTechnical() {
        if (this.txtLengthTelTechnical == null) {
            this.txtLengthTelTechnical = new JTextHour();
        }
        return this.txtLengthTelTechnical;
    }

    private JTextHour getTxtLengthIntervTechnical() {
        if (this.txtLengthIntervTechnical == null) {
            this.txtLengthIntervTechnical = new JTextHour();
        }
        return this.txtLengthIntervTechnical;
    }

    private JTextField getCost() {
        if (this.cost == null) {
            this.cost = new JTextField();
        }
        return this.cost;
    }

    private JTextDate getTxtDateEndTechnical() {
        if (this.txtDateEndTechnical == null) {
            this.txtDateEndTechnical = new JTextDate();
        }
        return this.txtDateEndTechnical;
    }

    private JPanel getPnlBtnTechnical() {
        if (this.pnlBtnTechnical == null) {
            this.pnlBtnTechnical = new JPanel();
        }
        return this.pnlBtnTechnical;
    }
}

