/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.data.bdd.Societe;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.LMSociety;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogCompany;

public class DialogCompanyList
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MainFrameTransport pere = null;
    private JPanel jContentPane = null;
    private JScrollPane jspListeDB = null;
    private JList listeDB = null;
    private JButton btnValider = null;
    private LMSociety modeleListe = null;
    Vector<Societe> liste = null;
    private JButton btnQuitter = null;
    private JButton btnUpdate = null;
    private JPanel pnlBtn = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogCompany.dispose()#");
        super.dispose();
    }

    public DialogCompanyList(MainFrameTransport owner) {
        super(owner);
        TimsLogger.verbose("#DialogCompany()#");
        this.liste = Societe.loadList(null);
        this.pere = owner;
        if (this.liste.size() != 0) {
            this.initialize();
        } else {
            DialogCompany createFirst = new DialogCompany(null, null);
            createFirst.setVisible(true);
            this.liste = Societe.loadList(null);
            Transport.bdd.changeDB(this.liste.get(0).getNomSociete(), true);
            this.dispose();
        }
    }

    private void initialize() {
        this.setSize(390, 430);
        this.setTitle(LanguageTranslator.getString("company.list"));
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJspListeDB(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints3);
        }
        return this.jContentPane;
    }

    private JScrollPane getJspListeDB() {
        if (this.jspListeDB == null) {
            this.jspListeDB = new JScrollPane();
            this.jspListeDB.setViewportView(this.getListeDB());
        }
        return this.jspListeDB;
    }

    private JList getListeDB() {
        if (this.listeDB == null) {
            this.listeDB = new JList();
            this.modeleListe = new LMSociety(this.liste);
            this.listeDB.setModel(this.modeleListe);
        }
        return this.listeDB;
    }

    private JButton getBtnValider() {
        if (this.btnValider == null) {
            this.btnValider = new JButton();
            this.btnValider.setText(LanguageTranslator.getString("button.change"));
            this.btnValider.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Societe db = DialogCompanyList.this.modeleListe.getSocieteAt(DialogCompanyList.this.getListeDB().getSelectedIndex());
                    Transport.bdd.changeDB(db.getNomSociete(), true);
                    MainFrameTransport.getInstance().repaint();
                    DialogCompanyList.this.dispose();
                }
            });
        }
        return this.btnValider;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogCompanyList.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnUpdate() {
        if (this.btnUpdate == null) {
            this.btnUpdate = new JButton();
            this.btnUpdate.setText(LanguageTranslator.getString("button.details"));
            this.btnUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Societe db = DialogCompanyList.this.modeleListe.getSocieteAt(DialogCompanyList.this.getListeDB().getSelectedIndex());
                    new DialogCompany((Frame)MainFrameTransport.getInstance(), db).setVisible(true);
                }
            });
        }
        return this.btnUpdate;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnUpdate(), new GridBagConstraints());
            this.pnlBtn.add((Component)this.getBtnValider(), null);
            this.pnlBtn.add((Component)this.getBtnQuitter(), null);
        }
        return this.pnlBtn;
    }
}

