/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.DataEvent;
import fr.pgh.data.DataListener;
import fr.pgh.data.bdd.ConsumptionEval;
import fr.pgh.data.bdd.ConsumptionEvalCriteria;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.editor.ColorEditor;
import transpo.system.ui.modele.TMConsumptionCriteria;
import transpo.system.ui.modele.TMConsumptionEvaluation;
import transpo.system.ui.renderer.ColorRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogConsumptionEvaluation
extends JDialog
implements DataListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlCriteria = null;
    private JScrollPane jspCriteria = null;
    private JTable tblCriteria = null;
    private BddTransport database = null;
    private JPanel pnlBtnCriteria = null;
    private JButton btnAddCriteria = null;
    private JButton btnDelCriteria = null;
    private JPanel pnlEval = null;
    private JScrollPane jspEval = null;
    private JTable tblEval = null;
    private JPanel pnlBtnEval = null;
    private JButton btnAddEval = null;
    private JButton btnDelEval = null;
    private JPanel pnlBtn = null;
    private JButton btnSave = null;
    private JButton btnQuitter = null;

    @Override
    public void changeUpdate(DataEvent dataEvent) {
        if (dataEvent instanceof BddEvent) {
            BddEvent e = (BddEvent)dataEvent;
            if (e.getTable().equals("CONSUMPTION_EVAL")) {
                this.loadTblEval();
            }
            if (e.getTable().equals("CONSUMPTION_CRITERIA")) {
                this.loadTblCriteria();
            }
        }
    }

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogConsumptionEvaluation.dispose()#");
        super.dispose();
    }

    public DialogConsumptionEvaluation(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogTypeActivite()#");
        this.initialize();
    }

    private void initialize() {
        this.setSize(750, 450);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("activity.type.title"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlCriteria(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, null));
            this.jContentPane.add(this.getPnlEval(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, -1, null));
            this.jContentPane.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 2, 1, 2, 1.0, 0.0, -1, -1, null));
        }
        return this.jContentPane;
    }

    private Component getPnlEval() {
        if (this.pnlEval == null) {
            this.pnlEval = new JPanel(new BorderLayout());
            this.pnlEval.setBorder(BorderFactory.createTitledBorder(LanguageTranslator.getString("consumption.evaluation")));
            this.pnlEval.add((Component)this.getJspEval(), "Center");
            this.pnlEval.add((Component)this.getPnlBtnEval(), "South");
        }
        return this.pnlEval;
    }

    private JScrollPane getJspEval() {
        if (this.jspEval == null) {
            this.jspEval = new JScrollPane();
            this.jspEval.setViewportView(this.getTblEval());
        }
        return this.jspEval;
    }

    private JTable getTblEval() {
        if (this.tblEval == null) {
            this.tblEval = new JTable();
            this.loadTblEval();
        }
        return this.tblEval;
    }

    private void loadTblEval() {
        Vector<ConsumptionEval> original = ConsumptionEval.getList();
        Vector<ConsumptionEval> clone = new Vector<ConsumptionEval>();
        for (ConsumptionEval originalta : original) {
            clone.add((ConsumptionEval)originalta.clone());
        }
        this.tblEval.setModel(new TMConsumptionEvaluation(clone));
        this.tblEval.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.tblEval.setDefaultEditor(Color.class, new ColorEditor());
        this.tblEval.setSelectionMode(0);
        this.tblEval.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    int row = lsm.getMinSelectionIndex();
                    DialogConsumptionEvaluation.this.getBtnDelEval().setEnabled(false);
                }
            }
        });
    }

    private JButton getBtnAddEval() {
        if (this.btnAddEval == null) {
            this.btnAddEval = new JButton();
            this.btnAddEval.setText(LanguageTranslator.getString("button.new"));
            this.btnAddEval.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogConsumptionEvaluation.this.newEvalLine();
                }
            });
        }
        return this.btnAddEval;
    }

    private JButton getBtnDelEval() {
        if (this.btnDelEval == null) {
            this.btnDelEval = new JButton(LanguageTranslator.getString("button.delete"));
            this.btnDelEval.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogConsumptionEvaluation.this.deleteEvalLine();
                }
            });
        }
        return this.btnDelEval;
    }

    private JPanel getPnlBtnEval() {
        if (this.pnlBtnEval == null) {
            this.pnlBtnEval = new JPanel();
            if (ConnexionSettings.getInstance().isAjoutable("CONSUMPTION_CRITERIA")) {
                this.pnlBtnEval.add(this.getBtnAddEval());
            }
            if (ConnexionSettings.getInstance().isSupprimable("CONSUMPTION_CRITERIA")) {
                this.pnlBtnEval.add(this.getBtnDelEval());
            }
            this.pnlBtnEval.add(this.getBtnQuitter());
        }
        return this.pnlBtnEval;
    }

    private void newEvalLine() {
        ((TMConsumptionEvaluation)this.getTblEval().getModel()).addRow(new ConsumptionEval());
    }

    private void deleteEvalLine() {
        int row = this.getTblEval().getSelectedRow();
        ((TMConsumptionEvaluation)this.getTblEval().getModel()).removeRow(row);
    }

    private JPanel getPnlCriteria() {
        if (this.pnlCriteria == null) {
            this.pnlCriteria = new JPanel(new BorderLayout());
            this.pnlCriteria.setBorder(BorderFactory.createTitledBorder(LanguageTranslator.getString("consumption.criteria")));
            this.pnlCriteria.add((Component)this.getJspCriteria(), "Center");
            this.pnlCriteria.add((Component)this.getPnlBtnCriteria(), "South");
        }
        return this.pnlCriteria;
    }

    private JScrollPane getJspCriteria() {
        if (this.jspCriteria == null) {
            this.jspCriteria = new JScrollPane();
            this.jspCriteria.setViewportView(this.getTblCriteria());
        }
        return this.jspCriteria;
    }

    private JTable getTblCriteria() {
        if (this.tblCriteria == null) {
            this.tblCriteria = new JTable();
            this.loadTblCriteria();
        }
        return this.tblCriteria;
    }

    private void loadTblCriteria() {
        Vector<ConsumptionEvalCriteria> original = ConsumptionEvalCriteria.getList();
        Vector<ConsumptionEvalCriteria> clone = new Vector<ConsumptionEvalCriteria>();
        for (ConsumptionEvalCriteria originalta : original) {
            clone.add((ConsumptionEvalCriteria)originalta.clone());
        }
        this.tblCriteria.setModel(new TMConsumptionCriteria(clone));
        this.tblCriteria.setSelectionMode(0);
        this.tblCriteria.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    int row = lsm.getMinSelectionIndex();
                    DialogConsumptionEvaluation.this.getBtnDelCriteria().setEnabled(false);
                }
            }
        });
    }

    private JButton getBtnAddCriteria() {
        if (this.btnAddCriteria == null) {
            this.btnAddCriteria = new JButton();
            this.btnAddCriteria.setText(LanguageTranslator.getString("button.new"));
            this.btnAddCriteria.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogConsumptionEvaluation.this.newCriteriaLine();
                }
            });
        }
        return this.btnAddCriteria;
    }

    private JButton getBtnDelCriteria() {
        if (this.btnDelCriteria == null) {
            this.btnDelCriteria = new JButton(LanguageTranslator.getString("button.delete"));
            this.btnDelCriteria.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogConsumptionEvaluation.this.deleteCriteriaLine();
                }
            });
        }
        return this.btnDelCriteria;
    }

    private JPanel getPnlBtnCriteria() {
        if (this.pnlBtnCriteria == null) {
            this.pnlBtnCriteria = new JPanel();
            if (ConnexionSettings.getInstance().isAjoutable("CONSUMPTION_CRITERIA")) {
                this.pnlBtnCriteria.add(this.getBtnAddCriteria());
            }
            if (ConnexionSettings.getInstance().isSupprimable("CONSUMPTION_CRITERIA")) {
                this.pnlBtnCriteria.add(this.getBtnDelCriteria());
            }
            this.pnlBtnCriteria.add(this.getBtnQuitter());
        }
        return this.pnlBtnCriteria;
    }

    private void newCriteriaLine() {
        ((TMConsumptionCriteria)this.getTblCriteria().getModel()).addRow(new ConsumptionEvalCriteria());
    }

    private void deleteCriteriaLine() {
        int row = this.getTblCriteria().getSelectedRow();
        ((TMConsumptionCriteria)this.getTblCriteria().getModel()).removeRow(row);
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            if (ConnexionSettings.getInstance().isModifiable("CONSUMPTION_CRITERIA")) {
                this.pnlBtn.add(this.getBtnSave());
            }
            this.pnlBtn.add(this.getBtnQuitter());
        }
        return this.pnlBtn;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("button.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogConsumptionEvaluation.this.save();
                    DialogConsumptionEvaluation.this.dispose();
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogConsumptionEvaluation.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private void save() {
        Fonctions.commit(this.getTblCriteria());
        Fonctions.commit(this.getTblEval());
        this.saveEval();
        this.saveCriteria();
    }

    private void saveCriteria() {
        TMConsumptionCriteria tmp = (TMConsumptionCriteria)this.getTblCriteria().getModel();
        int x = 0;
        int delx = 0;
        while (x < ConsumptionEvalCriteria.getList().size()) {
            ConsumptionEvalCriteria criteria;
            ConsumptionEvalCriteria consumptionEvalCriteria = criteria = x - delx < tmp.getRowCount() ? tmp.getRow(x - delx) : null;
            if (criteria == null || criteria.getId() != ConsumptionEvalCriteria.getList().get(x).getId()) {
                ConsumptionEvalCriteria.getList().get(x).delete();
                ++delx;
            } else {
                ConsumptionEvalCriteria.getList().get(x).compareAndUpdate(criteria.getName());
            }
            ++x;
        }
        while (x - delx < tmp.getRowCount()) {
            tmp.getRow(x - delx).update();
            ++x;
        }
    }

    private void saveEval() {
        TMConsumptionEvaluation tmp = (TMConsumptionEvaluation)this.getTblEval().getModel();
        int x = 0;
        int delx = 0;
        while (x < ConsumptionEval.getList().size()) {
            ConsumptionEval eval;
            ConsumptionEval consumptionEval = eval = x - delx < tmp.getRowCount() ? tmp.getRow(x - delx) : null;
            if (eval == null || eval.getId() != ConsumptionEval.getList().get(x).getId()) {
                ConsumptionEval.getList().get(x).delete();
                ++delx;
            } else {
                ConsumptionEval.getList().get(x).compareAndUpdate(eval.getName(), eval.getPercentage(), eval.getColor());
            }
            ++x;
        }
        while (x - delx < tmp.getRowCount()) {
            tmp.getRow(x - delx).update();
            ++x;
        }
    }
}

