/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Conflit;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.data.bdd.VehicleUsed;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.traitement.TraitementTempsService;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.GraphJour;
import transpo.system.ui.views.conducteur.PnlVehiculeConducteur;
import transpo.system.util.Fonctions;

public class DialogDetailConflit
extends JDialog {
    private static final long serialVersionUID = 1L;
    public int seuilMatin = 360;
    public int seuilSoir = 1260;
    private Conflit toShow = null;
    private VecteurResultat resultat = new VecteurResultat();
    private ActiviteConducteur activiteSelectionnee = null;
    private int sourceSelect;
    private JPanel jContentPane = null;
    private GraphJour pnlAnalyse = null;
    private GraphJour pnlBase = null;
    private JPanel pnlChoix = null;
    private JPanel pnlConflit = null;
    private GraphJour pnlResultat = null;
    private JButton btnDerniereActivite = null;
    private JButton btnGarder1 = null;
    private JButton btnGarder2 = null;
    private JLabel lblKm1 = null;
    private JTextField txtKmSomme = null;
    private JButton btnEnregistrer = null;
    private JButton btnReinitialiser = null;
    private JButton btnQuitter = null;
    private JLabel lblActivite = null;
    private JTextField txtActivite = null;
    private PnlVehiculeConducteur pnlVehicle = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogDetailConflit.dispose()#");
        super.dispose();
    }

    public DialogDetailConflit(JFrame owner, Conflit toShow) {
        super(owner);
        TimsLogger.verbose("#DialogDetailConflit()#");
        this.toShow = toShow;
        this.initialize();
    }

    public DialogDetailConflit(JDialog owner, Conflit toShow) {
        super(owner);
        this.toShow = toShow;
        this.initialize();
    }

    private void initialize() {
        this.setTitle(LanguageTranslator.getString("conflict.title", ConversionTime.dateFromBDDToFrance(this.toShow.getDateConflit(), false, false), this.toShow.getDateCreation()));
        this.setBounds(new Rectangle(0, 0, 800, 500));
        this.setContentPane(this.getJContentPane());
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.gridy = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.weightx = 1.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlBase(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPnlAnalyse(), gridBagConstraints);
            if (!this.toShow.isTraite()) {
                this.jContentPane.add((Component)this.getPnlChoix(), gridBagConstraints11);
            } else {
                this.jContentPane.add((Component)this.getPnlConflit(), gridBagConstraints11);
            }
            this.jContentPane.add((Component)this.getPnlResultat(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getPnlVehicle(), gridBagConstraints15);
        }
        return this.jContentPane;
    }

    private GraphJour getPnlAnalyse() {
        if (this.pnlAnalyse == null) {
            this.pnlAnalyse = new GraphJour("t_activite_conflit_analyse");
            this.pnlAnalyse.initialiser(Transport.bdd.getActivDetailConflit(this.toShow.getCleConducteur(), ConversionTime.stringToDate(this.toShow.getDateConflit(), "yyyy-MM-dd"), "t_activite_conflit_analyse", this.toShow.isTraite()), 0, 0);
            this.pnlAnalyse.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DialogDetailConflit.this.activiteSelectionnee = DialogDetailConflit.this.pnlAnalyse.getActivite((int)e.getPoint().getX());
                    DialogDetailConflit.this.getTxtActivite().setText(String.valueOf(ConversionTime.heureIntToString(DialogDetailConflit.this.activiteSelectionnee.getHeureDebut(), "h")) + " - " + ConversionTime.heureIntToString(DialogDetailConflit.this.activiteSelectionnee.getHeureFin(), "h") + " : " + DialogDetailConflit.this.activiteSelectionnee.getDescription());
                    DialogDetailConflit.this.getBtnDerniereActivite().setEnabled(true);
                    DialogDetailConflit.this.sourceSelect = 2;
                }
            });
        }
        return this.pnlAnalyse;
    }

    private GraphJour getPnlBase() {
        if (this.pnlBase == null) {
            this.pnlBase = new GraphJour("t_activite_conflit_base");
            this.pnlBase.initialiser(Transport.bdd.getActivDetailConflit(this.toShow.getCleConducteur(), ConversionTime.stringToDate(this.toShow.getDateConflit(), "yyyy-MM-dd"), "t_activite_conflit_base", this.toShow.isTraite()), 0, 0);
            this.pnlBase.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DialogDetailConflit.this.activiteSelectionnee = DialogDetailConflit.this.pnlBase.getActivite((int)e.getPoint().getX());
                    DialogDetailConflit.this.getTxtActivite().setText(String.valueOf(ConversionTime.heureIntToString(DialogDetailConflit.this.activiteSelectionnee.getHeureDebut(), "h")) + " - " + ConversionTime.heureIntToString(DialogDetailConflit.this.activiteSelectionnee.getHeureFin(), "h") + " : " + DialogDetailConflit.this.activiteSelectionnee.getDescription());
                    DialogDetailConflit.this.getBtnDerniereActivite().setEnabled(true);
                    DialogDetailConflit.this.sourceSelect = 1;
                }
            });
        }
        return this.pnlBase;
    }

    private JPanel getPnlChoix() {
        if (this.pnlChoix == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.gridwidth = 2;
            gridBagConstraints14.gridx = 2;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridy = 0;
            this.lblActivite = new JLabel();
            this.lblActivite.setText(LanguageTranslator.getString("conflict.select"));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.gridy = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 3;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.fill = 0;
            gridBagConstraints10.gridy = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 3;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.gridy = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 2;
            gridBagConstraints8.weightx = 0.5;
            gridBagConstraints8.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.weightx = 0.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 2;
            this.lblKm1 = new JLabel();
            this.lblKm1.setText(LanguageTranslator.getString("generics.km"));
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 1;
            this.pnlChoix = new JPanel();
            this.pnlChoix.setLayout(new GridBagLayout());
            this.pnlChoix.add((Component)this.getBtnDerniereActivite(), gridBagConstraints4);
            this.pnlChoix.add((Component)this.getBtnGarder1(), gridBagConstraints5);
            this.pnlChoix.add((Component)this.getBtnGarder2(), gridBagConstraints6);
            this.pnlChoix.add((Component)this.lblKm1, gridBagConstraints7);
            this.pnlChoix.add((Component)this.getTxtKmSomme(), gridBagConstraints8);
            this.pnlChoix.add((Component)this.getBtnEnregistrer(), gridBagConstraints9);
            this.pnlChoix.add((Component)this.getBtnReinitialiser(), gridBagConstraints10);
            this.pnlChoix.add((Component)this.getBtnQuitter(), gridBagConstraints12);
            this.pnlChoix.add((Component)this.lblActivite, gridBagConstraints13);
            this.pnlChoix.add((Component)this.getTxtActivite(), gridBagConstraints14);
        }
        return this.pnlChoix;
    }

    private JPanel getPnlConflit() {
        if (this.pnlConflit == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.gridx = 0;
            this.lblActivite = new JLabel();
            Utilisateur user = Utilisateur.getUser(this.toShow.getCleTraitant());
            if (user == null) {
                this.lblActivite.setText(LanguageTranslator.getString("conflict.processed", this.toShow.getDateProcession()));
            } else {
                this.lblActivite.setText(LanguageTranslator.getString("conflict.processedBy", String.valueOf(user.getNom()) + " " + user.getPrenom(), this.toShow.getDateProcession()));
            }
            this.pnlConflit = new JPanel();
            this.pnlConflit.setLayout(new GridBagLayout());
            this.pnlConflit.add((Component)this.lblActivite, gridBagConstraints14);
        }
        return this.pnlConflit;
    }

    private GraphJour getPnlResultat() {
        if (this.pnlResultat == null) {
            this.pnlResultat = new GraphJour("t_activite");
            if (this.toShow.isTraite()) {
                this.pnlResultat.initialiser(Transport.bdd.getActivite(this.toShow.getCleConducteur(), this.toShow.getDateConflit(), this.toShow.getDateConflit(), -1, 0), 0, 0);
            } else {
                this.pnlResultat.initialiser(this.resultat.getResultat(), 0, 0);
            }
        }
        return this.pnlResultat;
    }

    private JButton getBtnDerniereActivite() {
        if (this.btnDerniereActivite == null) {
            this.btnDerniereActivite = new JButton();
            this.btnDerniereActivite.setText(LanguageTranslator.getString("conflict.until"));
            this.btnDerniereActivite.setEnabled(false);
            this.btnDerniereActivite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogDetailConflit.this.activiteSelectionnee != null) {
                        if (DialogDetailConflit.this.sourceSelect == 2) {
                            DialogDetailConflit.this.resultat.setResultat(DialogDetailConflit.this.fusion(DialogDetailConflit.this.pnlAnalyse.getActiviteAvant(DialogDetailConflit.this.activiteSelectionnee.getHeureFin())));
                            DialogDetailConflit.this.pnlBase.initialiser(DialogDetailConflit.this.getGrapheDerniereActiviteClique(DialogDetailConflit.this.pnlBase, DialogDetailConflit.this.activiteSelectionnee.getHeureFin()), 0, 0);
                            DialogDetailConflit.this.pnlAnalyse.initialiser(DialogDetailConflit.this.getGrapheDerniereActiviteClique(DialogDetailConflit.this.pnlAnalyse, DialogDetailConflit.this.activiteSelectionnee.getHeureFin()), 0, 0);
                        }
                        if (DialogDetailConflit.this.sourceSelect == 1) {
                            DialogDetailConflit.this.resultat.setResultat(DialogDetailConflit.this.fusion(DialogDetailConflit.this.pnlBase.getActiviteAvant(DialogDetailConflit.this.activiteSelectionnee.getHeureFin())));
                            DialogDetailConflit.this.pnlAnalyse.initialiser(DialogDetailConflit.this.getGrapheDerniereActiviteClique(DialogDetailConflit.this.pnlAnalyse, DialogDetailConflit.this.activiteSelectionnee.getHeureFin()), 0, 0);
                            DialogDetailConflit.this.pnlBase.initialiser(DialogDetailConflit.this.getGrapheDerniereActiviteClique(DialogDetailConflit.this.pnlBase, DialogDetailConflit.this.activiteSelectionnee.getHeureFin()), 0, 0);
                        }
                        DialogDetailConflit.this.pnlResultat.initialiser(DialogDetailConflit.this.resultat.getResultat(), 0, 0);
                        DialogDetailConflit.this.sourceSelect = 0;
                        DialogDetailConflit.this.activiteSelectionnee = null;
                        DialogDetailConflit.this.getBtnDerniereActivite().setEnabled(false);
                        DialogDetailConflit.this.getBtnEnregistrer().setEnabled(DialogDetailConflit.this.resultat.isComplete());
                    }
                }
            });
        }
        return this.btnDerniereActivite;
    }

    private JButton getBtnGarder1() {
        if (this.btnGarder1 == null) {
            this.btnGarder1 = new JButton();
            this.btnGarder1.setText(LanguageTranslator.getString("conflict.day1"));
            this.btnGarder1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailConflit.this.resultat.setResultat(DialogDetailConflit.this.pnlBase.getJour());
                    DialogDetailConflit.this.resultat.setDebutSource(1);
                    DialogDetailConflit.this.resultat.setFinSource(1);
                    DialogDetailConflit.this.pnlResultat.initialiser(DialogDetailConflit.this.resultat.getResultat(), 0, 0);
                    DialogDetailConflit.this.getBtnEnregistrer().setEnabled(true);
                    DialogDetailConflit.this.getTxtKmSomme().setText(String.valueOf(DialogDetailConflit.this.toShow.getKmBase()));
                }
            });
        }
        return this.btnGarder1;
    }

    private JButton getBtnGarder2() {
        if (this.btnGarder2 == null) {
            this.btnGarder2 = new JButton();
            this.btnGarder2.setText(LanguageTranslator.getString("conflict.day2"));
            this.btnGarder2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailConflit.this.resultat.setResultat(DialogDetailConflit.this.pnlAnalyse.getJour());
                    DialogDetailConflit.this.pnlResultat.initialiser(DialogDetailConflit.this.resultat.getResultat(), 0, 0);
                    DialogDetailConflit.this.resultat.setDebutSource(2);
                    DialogDetailConflit.this.resultat.setFinSource(2);
                    DialogDetailConflit.this.getBtnEnregistrer().setEnabled(true);
                    DialogDetailConflit.this.getTxtKmSomme().setText(String.valueOf(DialogDetailConflit.this.toShow.getKmAnalyse()));
                }
            });
        }
        return this.btnGarder2;
    }

    private JTextField getTxtKmSomme() {
        if (this.txtKmSomme == null) {
            this.txtKmSomme = new JTextField();
            this.txtKmSomme.setText(String.valueOf(this.toShow.getKmAnalyse() + this.toShow.getKmBase()));
        }
        return this.txtKmSomme;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.setEnabled(false);
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Transport.ps.startOperation();
                    DialogDetailConflit.this.save();
                    Transport.ps.endOperation(PerformanceScanner.INSERT, "conlfict process");
                }
            });
        }
        return this.btnEnregistrer;
    }

    private void save() {
        if (!this.resultat.isComplete()) {
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("conflict.incomplete", "0"), LanguageTranslator.getString("message.numberedError", "0"), 0);
        }
        this.saveData();
        if (System.getProperty("horoquartz", "0").equals("1")) {
            Date lastExport = BddTransport.getInstance().getLastExport(this.toShow.getCleConducteur());
            Date jour = ConversionTime.stringToDate(this.toShow.getDateConflit(), "yyyy-MM-dd");
            if (lastExport != null && (jour.before(lastExport) || jour.equals(lastExport))) {
                BddTransport.getInstance().updateExportHoroquartz(this.toShow.getCleConducteur(), this.toShow.getDateConflit());
            }
        }
        Transport.bdd.updateConflit(this.toShow.getCleConducteur(), this.toShow.getDateConflit(), ConnexionSettings.getInstance().getUserCle(), true, ConversionTime.dateToString(new Date(), "yyyy-MM-dd hh:mm:ss"));
        JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        this.dispose();
    }

    private Vector<ActiviteConducteur> fusion(Vector<ActiviteConducteur> b) {
        Vector<ActiviteConducteur> retour = new Vector<ActiviteConducteur>();
        if (this.resultat.getResultat().size() == 0) {
            return b;
        }
        if (b.size() == 0) {
            return this.resultat.getResultat();
        }
        boolean baseFinished = false;
        boolean analyseFinished = false;
        int i = 1;
        int j = 1;
        Vector<ActiviteConducteur> a = this.resultat.getResultat();
        int x = 0;
        while (x < b.size()) {
            b.get(x).affiche();
            ++x;
        }
        if (Transport.debug >= 1) {
            TimsLogger.debug("");
            x = 0;
            while (x < a.size()) {
                a.get(x).affiche();
                ++x;
            }
        }
        while (!baseFinished || !analyseFinished) {
            ActiviteConducteur activBase = b.get(i - 1);
            ActiviteConducteur activAnalyse = a.get(j - 1);
            if (Transport.debug >= 1) {
                activBase.affiche();
            }
            if (Transport.debug >= 1) {
                activAnalyse.affiche();
            }
            TimsLogger.debug("");
            if (activAnalyse.getDuree() == 0) {
                if (j == a.size()) {
                    analyseFinished = true;
                    continue;
                }
                ++j;
                continue;
            }
            if (activBase.getDuree() == 0) {
                if (i == b.size()) {
                    baseFinished = true;
                    continue;
                }
                ++i;
                continue;
            }
            if (!baseFinished && (activBase.getHeureDebut() < activAnalyse.getHeureDebut() || analyseFinished)) {
                retour.add(activBase);
                if (i == b.size()) {
                    baseFinished = true;
                    continue;
                }
                ++i;
                continue;
            }
            if ((analyseFinished || activAnalyse.getHeureDebut() >= activBase.getHeureDebut() && !baseFinished) && activBase.getDuree() != 0) continue;
            retour.add(activAnalyse);
            if (j == a.size()) {
                analyseFinished = true;
                continue;
            }
            ++j;
        }
        return retour;
    }

    private JButton getBtnReinitialiser() {
        if (this.btnReinitialiser == null) {
            this.btnReinitialiser = new JButton();
            this.btnReinitialiser.setText(LanguageTranslator.getString("conflict.reinit"));
            this.btnReinitialiser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailConflit.this.raz();
                }
            });
        }
        return this.btnReinitialiser;
    }

    private void raz() {
        this.resultat = new VecteurResultat();
        this.getPnlResultat().initialiser(this.resultat.getResultat(), 0, 0);
        this.getPnlAnalyse().initialiser(Transport.bdd.getActivDetailConflit(this.toShow.getCleConducteur(), ConversionTime.stringToDate(this.toShow.getDateConflit(), "yyyy-MM-dd"), "t_activite_conflit_analyse", this.toShow.isTraite()), 0, 0);
        this.getPnlBase().initialiser(Transport.bdd.getActivDetailConflit(this.toShow.getCleConducteur(), ConversionTime.stringToDate(this.toShow.getDateConflit(), "yyyy-MM-dd"), "t_activite_conflit_base", this.toShow.isTraite()), 0, 0);
        this.resultat.setDebutSource(0);
        this.resultat.setFinSource(0);
        this.sourceSelect = 0;
        this.activiteSelectionnee = null;
        this.getBtnDerniereActivite().setEnabled(false);
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailConflit.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JTextField getTxtActivite() {
        if (this.txtActivite == null) {
            this.txtActivite = new JTextField();
        }
        return this.txtActivite;
    }

    public void saveData() {
        Transport.bdd.delJour(this.toShow.getCleConducteur(), this.toShow.getDateConflit(), "Gestion de conflit");
        Conducteur toSave = new Conducteur();
        toSave.loadById(this.toShow.getCleConducteur());
        Fonctions.saveDriverActivities(this.resultat.getResultat(), toSave, Integer.parseInt(this.getTxtKmSomme().getText()), this.getSource(this.resultat.getResultat()));
        Transport.bdd.delActiviteConflit(this.toShow.getCle(), this.toShow.getCleConducteur(), this.toShow.getDateConflit());
        this.getPnlVehicle().sauvegarde();
    }

    private String getSource(Vector<ActiviteConducteur> result) {
        Vector<String> sources = new Vector<String>();
        for (ActiviteConducteur act : result) {
            if (act.getNomSource() == null || sources.contains(act.getNomSource())) continue;
            sources.add(act.getNomSource());
        }
        String sSources = "";
        for (String s : sources) {
            sSources = String.valueOf(sSources) + ";" + s;
        }
        return sSources.substring(1);
    }

    public void majService() {
        TimsLogger.debug("#DialogDetailConflit.majService# d\u00e9but " + this.toShow.getDateConflit() + " fin " + this.toShow.getDateConflit());
        try {
            TraitementTempsService tts = new TraitementTempsService(this.toShow.getCleConducteur(), this.toShow.getDateConflit(), this.toShow.getDateConflit(), true);
            tts.loadActivite();
            tts.calculService();
            tts.saveListe();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Vector getGrapheDerniereActiviteClique(GraphJour graphe, int limite) {
        return graphe.getActiviteApres(limite);
    }

    private PnlVehiculeConducteur getPnlVehicle() {
        if (this.pnlVehicle == null) {
            this.pnlVehicle = new PnlVehiculeConducteur();
            if (!this.toShow.isTraite()) {
                Vector<VehicleUsed> tmp = VehicleUsed.loadListDriver(this.toShow.getCleConducteur(), 0, this.toShow.getDateConflit(), null);
                this.pnlVehicle.initialise(null, tmp, new Conducteur(this.toShow.getCleConducteur()), ConversionTime.dateFromBDDToFrance(this.toShow.getDateConflit(), false, false));
            }
        }
        return this.pnlVehicle;
    }

    public class VecteurResultat {
        private static final long serialVersionUID = 1L;
        public static final int SOURCE_INCONNUE = 0;
        public static final int SOURCE_BASE = 1;
        public static final int SOURCE_ANALYSE = 2;
        private int debutSource = 0;
        private int finSource = 0;
        private Vector<ActiviteConducteur> resultat = null;

        public VecteurResultat() {
            this.resultat = new Vector();
        }

        public VecteurResultat(Vector<ActiviteConducteur> v) {
            this.resultat = v;
        }

        public int getDebutSource() {
            return this.debutSource;
        }

        public void setDebutSource(int debutSource) {
            this.debutSource = debutSource;
        }

        public int getFinSource() {
            return this.finSource;
        }

        public void setFinSource(int finSource) {
            this.finSource = finSource;
        }

        public Vector<ActiviteConducteur> getResultat() {
            return this.resultat;
        }

        public void setResultat(Vector<ActiviteConducteur> resultat) {
            this.resultat = resultat;
        }

        public void clear() {
            this.resultat.clear();
        }

        public boolean isComplete() {
            ActiviteConducteur premiereActiv = this.resultat.get(0);
            ActiviteConducteur derniereActiv = this.resultat.get(this.resultat.size() - 1);
            return premiereActiv.getHeureDebut() == 0 && derniereActiv.getHeureFin() == 1440;
        }
    }
}

