/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Jour;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogCreerJour;
import transpo.system.ui.views.GraphJour;
import transpo.system.util.Fonctions;

public class DialogDetailJourSupprime
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private GraphJour graphJour = null;
    private JButton btnRestaurer = null;
    private String dateJour = null;
    private Conducteur conducteur = null;
    private JButton btnQuitter = null;
    private int nbJour = 0;
    private int jourCourant = 1;
    private JPanel pnlBtn = null;
    private JButton btnMoins = null;
    private JLabel lblPage = null;
    private JButton btnPlus = null;
    private Vector<String> cleJour = null;
    private JButton btnCreer = null;
    private Vector<ActiviteConducteur> activities = null;
    private Jour day = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogDetailJourSupprime.dispose()#");
        super.dispose();
    }

    public DialogDetailJourSupprime(Frame owner, Conducteur conducteur, String dateJour, Vector jour) {
        super(owner);
        TimsLogger.verbose("#DialogDetailJourSupprime()#");
        this.conducteur = conducteur;
        this.dateJour = dateJour;
        this.nbJour = jour.size();
        this.cleJour = jour;
        this.initialize();
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 660, 200));
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
        this.setModal(true);
        this.loadJour();
    }

    public void loadJour() {
        this.getBtnMoins().setEnabled(false);
        this.getBtnPlus().setEnabled(false);
        if (this.nbJour != 1) {
            if (this.jourCourant != 1) {
                this.getBtnMoins().setEnabled(true);
            } else if (this.jourCourant != this.nbJour) {
                this.getBtnPlus().setEnabled(true);
            }
        }
        this.lblPage.setText(String.valueOf(this.jourCourant) + " sur " + this.nbJour);
        this.activities = Transport.bdd.getActivite(this.conducteur.getCleConducteur(), ConversionTime.dateFromFranceToBDD(this.dateJour, false), null, -1, 1);
        this.getGraphJour().initialiser(this.activities, 0, 0);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 3;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.weighty = 0.0;
            gridBagConstraints21.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.gridy = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getGraphJour(), gridBagConstraints);
            this.jContentPane.add((Component)this.getBtnRestaurer(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getBtnQuitter(), gridBagConstraints21);
            this.jContentPane.add((Component)this.getPnlBtn(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getBtnCreer(), gridBagConstraints12);
        }
        return this.jContentPane;
    }

    private GraphJour getGraphJour() {
        if (this.graphJour == null) {
            this.graphJour = new GraphJour();
        }
        return this.graphJour;
    }

    private JButton getBtnRestaurer() {
        if (this.btnRestaurer == null) {
            this.btnRestaurer = new JButton();
            this.btnRestaurer.setText(LanguageTranslator.getString("button.restore"));
            this.btnRestaurer.setEnabled(true);
            this.btnRestaurer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailJourSupprime.this.restaurer();
                }
            });
        }
        return this.btnRestaurer;
    }

    public void restaurerJour() {
        if (Transport.bdd.getJourCle(this.conducteur.getCleConducteur(), this.dateJour) != "") {
            JOptionPane.showMessageDialog(this.getParent(), "impossible");
        }
        Transport.bdd.restaureJour(this.cleJour.get(this.jourCourant - 1));
    }

    public void restaurer() {
        if (Fonctions.saveDriverActivities(this.activities, this.conducteur, 0, LanguageTranslator.getString("generics.restore")) != 2) {
            JOptionPane.showMessageDialog(this, "Erreur d'enregistrement", "Journ\u00e9e non ajout\u00e9e", 0);
        } else {
            JOptionPane.showMessageDialog(this, "Enregistrement effectu\u00e9", "Journ\u00e9e ajout\u00e9e", 1);
        }
        this.dispose();
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailJourSupprime.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridy = 0;
            this.lblPage = new JLabel();
            this.lblPage.setText(LanguageTranslator.getString("generics.page"));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridy = 0;
            this.pnlBtn = new JPanel();
            this.pnlBtn.setLayout(new GridBagLayout());
            this.pnlBtn.add((Component)this.getBtnMoins(), gridBagConstraints3);
            this.pnlBtn.add((Component)this.lblPage, gridBagConstraints4);
            this.pnlBtn.add((Component)this.getBtnPlus(), gridBagConstraints5);
        }
        return this.pnlBtn;
    }

    private JButton getBtnMoins() {
        if (this.btnMoins == null) {
            this.btnMoins = new JButton();
            this.btnMoins.setText("<");
            this.btnMoins.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailJourSupprime dialogDetailJourSupprime = DialogDetailJourSupprime.this;
                    dialogDetailJourSupprime.jourCourant = dialogDetailJourSupprime.jourCourant - 1;
                    DialogDetailJourSupprime.this.loadJour();
                }
            });
        }
        return this.btnMoins;
    }

    private JButton getBtnPlus() {
        if (this.btnPlus == null) {
            this.btnPlus = new JButton();
            this.btnPlus.setText(">");
            this.btnPlus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDetailJourSupprime dialogDetailJourSupprime = DialogDetailJourSupprime.this;
                    dialogDetailJourSupprime.jourCourant = dialogDetailJourSupprime.jourCourant + 1;
                    DialogDetailJourSupprime.this.loadJour();
                }
            });
        }
        return this.btnPlus;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new DialogCreerJour((Frame)MainFrameTransport.getInstance(), DialogDetailJourSupprime.this.conducteur, DialogDetailJourSupprime.this.dateJour).setVisible(true);
                    DialogDetailJourSupprime.this.dispose();
                }
            });
        }
        return this.btnCreer;
    }
}

