/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.TableSorter;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.CompanyCard;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.EmployeeObligation;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.InterventionType;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import transpo.system.LicenceManager;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.TMCompanyCardExpiration;
import transpo.system.ui.modele.TMDriverExpiration;
import transpo.system.ui.modele.TMInterventionState;
import transpo.system.ui.modele.TMObligationState;
import transpo.system.ui.renderer.CompanyCardStateRenderer;
import transpo.system.ui.renderer.DriverStateRenderer;
import transpo.system.ui.renderer.InterventionStateRenderer;
import transpo.system.ui.renderer.ObligationStateRenderer;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transpo.ui.calendrier.JCalendrier;
import transport.report.CustomReportFactory;
import transport.report.generator.DJGeneratorColoredCellStyle;
import transport.report.generator.DJGeneratorWithDateStyle;

public class DialogExpirationState
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlChoix = null;
    private JButton btnEnregistrer = null;
    private JButton btnQuitter = null;
    private JTabbedPane pnlTbl;
    private JPanel pnlDriver = null;
    private JScrollPane jspDriver = null;
    private JTable tblDriver = null;
    private JCheckBox cbFimo = null;
    private JCheckBox cbMedical = null;
    private JCheckBox cbLicenseMedical = null;
    private JCheckBox cbCard = null;
    private JCheckBox cbAdr = null;
    private JCheckBox cbCaces = null;
    private JButton btnPrintDriver = null;
    private JButton btnExportDriver = null;
    private JPanel pnlVehicle = null;
    private JScrollPane jspVehicle = null;
    private JTable tblVehicle = null;
    private JButton btnPrintVehicle = null;
    private JButton btnExportVehicle = null;
    private JPanel pnlCompany = null;
    private JScrollPane jspCompany = null;
    private JTable tblCompany = null;
    private JButton btnPrintCompany = null;
    private JPanel pnlFiltersNewDriver = null;
    private JPanel pnlNewDriver = null;
    private JScrollPane jspNewDriver = null;
    private JTable tblNewDriver = null;
    private JButton btnPrintNewDriver = null;
    private JButton btnExportNewDriver = null;
    private JButton btnReloadObligation = null;
    private JMultiListBox mbObligation = null;
    private JTextField txtEndObligation = null;
    private JTextField txtBeginObligation = null;
    private JPanel pnlFiltersVehicle = null;
    private JButton btnReloadIntervention = null;
    private JMultiListBox mbIntervention = null;
    private JTextField txtEndIntervention = null;
    private JTextField txtBeginIntervention = null;
    MouseListener interventionMouseListener = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogTypeJournee.dispose()#");
        super.dispose();
    }

    public DialogExpirationState(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogTypeJournee()#");
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(800, 600);
        this.setTitle(LanguageTranslator.getString("generics.state"));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
        this.reloadObligation();
        this.reloadIntervention();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.gridy = 0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 0.0;
            gridBagConstraints12.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints12.gridy = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlChoix(), gridBagConstraints12);
            this.jContentPane.add((Component)this.getPnlTbl(), gridBagConstraints1);
        }
        return this.jContentPane;
    }

    private JTabbedPane getPnlTbl() {
        if (this.pnlTbl == null) {
            this.pnlTbl = new JTabbedPane();
            this.pnlTbl.addTab(LanguageTranslator.getString("generics.driver"), null, this.getPnlDriver(), null);
            if (LicenceManager.isHRLevel()) {
                this.pnlTbl.addTab(LanguageTranslator.getString("generics.driverObligation"), null, this.getPnlNewDriver(), null);
            }
            this.pnlTbl.addTab(LanguageTranslator.getString("generics.vehicle"), null, this.getPnlVehicle(), null);
            this.pnlTbl.addTab(LanguageTranslator.getString("generics.company"), null, this.getPnlCompany(), null);
        }
        return this.pnlTbl;
    }

    private JPanel getPnlChoix() {
        if (this.pnlChoix == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 3;
            gridBagConstraints10.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.gridy = 1;
            this.pnlChoix = new JPanel();
            this.pnlChoix.setLayout(new GridBagLayout());
            this.pnlChoix.add((Component)this.getBtnEnregistrer(), gridBagConstraints10);
            this.pnlChoix.add((Component)this.getBtnQuitter(), gridBagConstraints7);
        }
        return this.pnlChoix;
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setEnabled(false);
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.enregistrer();
                    DialogExpirationState.this.dispose();
                }
            });
        }
        return this.btnEnregistrer;
    }

    public boolean enregistrer() {
        return true;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JCheckBox getCbMedical() {
        if (this.cbMedical == null) {
            this.cbMedical = new JCheckBox();
            this.cbMedical.setSelected(true);
            this.cbMedical.setText(LanguageTranslator.getString("user.medicalExam"));
            this.cbMedical.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TableColumn aColumn = DialogExpirationState.this.getTblDriver().getColumn(LanguageTranslator.getString("user.medicalExam"));
                    if (DialogExpirationState.this.getCbMedical().isSelected()) {
                        Fonctions.showColumn(aColumn);
                    } else {
                        Fonctions.hideColumn(aColumn);
                    }
                }
            });
        }
        return this.cbMedical;
    }

    private JCheckBox getCbLicenseMedical() {
        if (this.cbLicenseMedical == null) {
            this.cbLicenseMedical = new JCheckBox();
            this.cbLicenseMedical.setSelected(true);
            this.cbLicenseMedical.setText(LanguageTranslator.getString("driver.licenceMedicalExam"));
            this.cbLicenseMedical.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TableColumn aColumn = DialogExpirationState.this.getTblDriver().getColumn(LanguageTranslator.getString("driver.licenceMedicalExam"));
                    if (DialogExpirationState.this.getCbLicenseMedical().isSelected()) {
                        Fonctions.showColumn(aColumn);
                    } else {
                        Fonctions.hideColumn(aColumn);
                    }
                }
            });
        }
        return this.cbLicenseMedical;
    }

    private JCheckBox getCbCard() {
        if (this.cbCard == null) {
            this.cbCard = new JCheckBox();
            this.cbCard.setSelected(true);
            this.cbCard.setText(LanguageTranslator.getString("generics.card"));
            this.cbCard.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TableColumn aColumn = DialogExpirationState.this.getTblDriver().getColumn(LanguageTranslator.getString("generics.card"));
                    if (DialogExpirationState.this.getCbCard().isSelected()) {
                        Fonctions.showColumn(aColumn);
                    } else {
                        Fonctions.hideColumn(aColumn);
                    }
                }
            });
        }
        return this.cbCard;
    }

    private JCheckBox getCbAdr() {
        if (this.cbAdr == null) {
            this.cbAdr = new JCheckBox();
            this.cbAdr.setSelected(true);
            this.cbAdr.setText(LanguageTranslator.getString("driver.adr"));
            this.cbAdr.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TableColumn aColumn = DialogExpirationState.this.getTblDriver().getColumn(LanguageTranslator.getString("driver.adr"));
                    if (DialogExpirationState.this.getCbAdr().isSelected()) {
                        Fonctions.showColumn(aColumn);
                    } else {
                        Fonctions.hideColumn(aColumn);
                    }
                }
            });
        }
        return this.cbAdr;
    }

    private JCheckBox getCbCaces() {
        if (this.cbCaces == null) {
            this.cbCaces = new JCheckBox();
            this.cbCaces.setSelected(true);
            this.cbCaces.setText(LanguageTranslator.getString("driver.caces"));
            this.cbCaces.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TableColumn aColumn = DialogExpirationState.this.getTblDriver().getColumn(LanguageTranslator.getString("driver.caces"));
                    if (DialogExpirationState.this.getCbCaces().isSelected()) {
                        Fonctions.showColumn(aColumn);
                    } else {
                        Fonctions.hideColumn(aColumn);
                    }
                }
            });
        }
        return this.cbCaces;
    }

    private JCheckBox getCbFimo() {
        if (this.cbFimo == null) {
            this.cbFimo = new JCheckBox();
            this.cbFimo.setSelected(true);
            this.cbFimo.setText(LanguageTranslator.getString("driver.fimoFco"));
            this.cbFimo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TableColumn aColumn = DialogExpirationState.this.getTblDriver().getColumn(LanguageTranslator.getString("driver.fimoFco"));
                    if (DialogExpirationState.this.getCbFimo().isSelected()) {
                        Fonctions.showColumn(aColumn);
                    } else {
                        Fonctions.hideColumn(aColumn);
                    }
                }
            });
        }
        return this.cbFimo;
    }

    private JPanel getPnlNewDriver() {
        if (this.pnlNewDriver == null) {
            this.pnlNewDriver = new JPanel();
            this.pnlNewDriver.setLayout(new GridBagLayout());
            this.pnlNewDriver.add((Component)this.getPnlFiltersNewDriver(), Fonctions.getGridBagConstraints(0, 0, 1, 2, 1.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlNewDriver.add((Component)this.getJspNewDriver(), Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlNewDriver.add((Component)this.getBtnPrintNewDriver(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, -1, 13, new Insets(0, 0, 5, 5)));
            this.pnlNewDriver.add((Component)this.getBtnExportNewDriver(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, -1, 13, new Insets(0, 0, 5, 5)));
        }
        return this.pnlNewDriver;
    }

    private JPanel getPnlFiltersNewDriver() {
        if (this.pnlFiltersNewDriver == null) {
            this.pnlFiltersNewDriver = new JPanel();
            this.pnlFiltersNewDriver.setLayout(new GridBagLayout());
            this.pnlFiltersNewDriver.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            JLabel begin = new JLabel(LanguageTranslator.getString("generics.begin"));
            JLabel end = new JLabel(LanguageTranslator.getString("generics.end"));
            JLabel obl = new JLabel(LanguageTranslator.getString("generics.driverObligation"));
            this.pnlFiltersNewDriver.add((Component)begin, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersNewDriver.add((Component)this.getTxtBeginObligation(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersNewDriver.add((Component)end, Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersNewDriver.add((Component)this.getTxtEndObligation(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersNewDriver.add((Component)obl, Fonctions.getGridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersNewDriver.add((Component)this.getMbObligation(), Fonctions.getGridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersNewDriver.add((Component)this.getBtnReloadObligation(), Fonctions.getGridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 0, -1, new Insets(5, 5, 5, 5)));
        }
        return this.pnlFiltersNewDriver;
    }

    private JButton getBtnReloadObligation() {
        if (this.btnReloadObligation == null) {
            this.btnReloadObligation = new JButton();
            this.btnReloadObligation.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnReloadObligation.setPreferredSize(new Dimension(25, 25));
            this.btnReloadObligation.setToolTipText(LanguageTranslator.getString("button.load"));
            this.btnReloadObligation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.reloadObligation();
                }
            });
        }
        return this.btnReloadObligation;
    }

    private void reloadObligation() {
        Date begin = this.getTxtBeginObligation().getText().equals("") ? null : ConversionTime.stringToDateFr(this.getTxtBeginObligation().getText());
        Date end = this.getTxtEndObligation().getText().equals("") ? null : ConversionTime.stringToDateFr(this.getTxtEndObligation().getText());
        Vector<Conducteur> drivers = new Vector();
        Vector<EmployeeObligation> nexts = Fonctions.getNextObligation(EmployeeObligation.loadLastList(0, 0), true, begin, end);
        TimsLogger.debug("#DialogExpirationState.reloadObligation# " + nexts.size() + " prochaines obligations entre le " + begin + " et " + end);
        if (begin != null || end != null) {
            for (EmployeeObligation next : nexts) {
                try {
                    Conducteur driver = Conducteur.getDriver(null, next.getDriverId());
                    if (drivers.contains(driver)) continue;
                    drivers.add(driver);
                }
                catch (DriverNotFoundException e) {
                    e.printStackTrace();
                }
            }
        } else {
            drivers = Conducteur.loadList(new Integer[0]);
        }
        TableSorter sorter = new TableSorter(new TMObligationState(drivers, this.getMbObligation().getSelectedItems(), nexts));
        this.getTblNewDriver().setModel(sorter);
        sorter.setTableHeader(this.tblNewDriver.getTableHeader());
        ObligationStateRenderer.initialize(this.tblNewDriver);
    }

    private JMultiListBox getMbObligation() {
        if (this.mbObligation == null) {
            this.mbObligation = new JMultiListBox();
            this.mbObligation.setPreferredSize(new Dimension(100, 25));
            this.mbObligation.setModel(new MultiListBoxModel<EmployeeObligationType>(EmployeeObligationType.loadList(false), true));
        }
        return this.mbObligation;
    }

    private JTextField getTxtEndObligation() {
        if (this.txtEndObligation == null) {
            this.txtEndObligation = new JTextField();
            this.txtEndObligation.setPreferredSize(new Dimension(0, 20));
            this.txtEndObligation.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogExpirationState.this.getTxtEndObligation());
                }
            });
        }
        return this.txtEndObligation;
    }

    private JTextField getTxtBeginObligation() {
        if (this.txtBeginObligation == null) {
            this.txtBeginObligation = new JTextField();
            this.txtBeginObligation.setPreferredSize(new Dimension(0, 20));
            this.txtBeginObligation.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogExpirationState.this.getTxtBeginObligation());
                }
            });
        }
        return this.txtBeginObligation;
    }

    private JScrollPane getJspNewDriver() {
        if (this.jspNewDriver == null) {
            this.jspNewDriver = new JScrollPane();
            this.jspNewDriver.setViewportView(this.getTblNewDriver());
        }
        return this.jspNewDriver;
    }

    private JTable getTblNewDriver() {
        if (this.tblNewDriver == null) {
            this.tblNewDriver = new JTable();
            this.tblNewDriver.setAutoResizeMode(0);
        }
        return this.tblNewDriver;
    }

    private JButton getBtnPrintNewDriver() {
        if (this.btnPrintNewDriver == null) {
            this.btnPrintNewDriver = new JButton();
            this.btnPrintNewDriver.setText(LanguageTranslator.getString("button.print"));
            this.btnPrintNewDriver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.newDriverPrint("imprimer");
                }
            });
        }
        return this.btnPrintNewDriver;
    }

    private JButton getBtnExportNewDriver() {
        if (this.btnExportNewDriver == null) {
            this.btnExportNewDriver = new JButton();
            this.btnExportNewDriver.setText(LanguageTranslator.getString("button.export"));
            this.btnExportNewDriver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.newDriverPrint("xls");
                }
            });
        }
        return this.btnExportNewDriver;
    }

    private JPanel getPnlDriver() {
        if (this.pnlDriver == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 2;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridy = 1;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 2;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = Fonctions.getGridBagConstraints(0, 3, 1, 4, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5));
            GridBagConstraints gridBagConstraints11 = Fonctions.getGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, -1, 13, new Insets(0, 0, 5, 5));
            GridBagConstraints gcbBtnExportDriver = Fonctions.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, -1, 13, new Insets(0, 0, 5, 5));
            this.pnlDriver = new JPanel();
            this.pnlDriver.setLayout(new GridBagLayout());
            this.pnlDriver.add((Component)this.getJspDriver(), gridBagConstraints2);
            this.pnlDriver.add((Component)this.getCbFimo(), gridBagConstraints3);
            this.pnlDriver.add((Component)this.getCbMedical(), gridBagConstraints4);
            this.pnlDriver.add((Component)this.getCbLicenseMedical(), gridBagConstraints5);
            this.pnlDriver.add((Component)this.getCbCard(), gridBagConstraints6);
            this.pnlDriver.add((Component)this.getBtnPrintDriver(), gridBagConstraints11);
            this.pnlDriver.add((Component)this.getBtnExportDriver(), gcbBtnExportDriver);
            this.pnlDriver.add((Component)this.getCbAdr(), gridBagConstraints17);
            this.pnlDriver.add((Component)this.getCbCaces(), gridBagConstraints18);
        }
        return this.pnlDriver;
    }

    private JScrollPane getJspDriver() {
        if (this.jspDriver == null) {
            this.jspDriver = new JScrollPane();
            this.jspDriver.setViewportView(this.getTblDriver());
        }
        return this.jspDriver;
    }

    private JTable getTblDriver() {
        if (this.tblDriver == null) {
            this.tblDriver = new JTable();
            this.tblDriver.setAutoResizeMode(0);
            TableSorter sorter = new TableSorter(new TMDriverExpiration(Conducteur.loadList(new Integer[0])));
            this.tblDriver.setModel(sorter);
            sorter.setTableHeader(this.tblDriver.getTableHeader());
            DriverStateRenderer.initialize(this.tblDriver);
        }
        return this.tblDriver;
    }

    private JButton getBtnPrintDriver() {
        if (this.btnPrintDriver == null) {
            this.btnPrintDriver = new JButton();
            this.btnPrintDriver.setText(LanguageTranslator.getString("button.print"));
            this.btnPrintDriver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.driverPrint("imprimer");
                }
            });
        }
        return this.btnPrintDriver;
    }

    private JButton getBtnExportDriver() {
        if (this.btnExportDriver == null) {
            this.btnExportDriver = new JButton();
            this.btnExportDriver.setText(LanguageTranslator.getString("button.export"));
            this.btnExportDriver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.driverPrint("xls");
                }
            });
        }
        return this.btnExportDriver;
    }

    private JPanel getPnlCompany() {
        if (this.pnlCompany == null) {
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints16.anchor = 13;
            gridBagConstraints16.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints8.gridx = 0;
            this.pnlCompany = new JPanel();
            this.pnlCompany.setLayout(new GridBagLayout());
            this.pnlCompany.add((Component)this.getJspCompany(), gridBagConstraints8);
            this.pnlCompany.add((Component)this.getBtnPrintCompany(), gridBagConstraints16);
        }
        return this.pnlCompany;
    }

    private JScrollPane getJspCompany() {
        if (this.jspCompany == null) {
            this.jspCompany = new JScrollPane();
            this.jspCompany.setViewportView(this.getTblCompany());
        }
        return this.jspCompany;
    }

    private JTable getTblCompany() {
        if (this.tblCompany == null) {
            this.tblCompany = new JTable();
            TableSorter sorter = new TableSorter(new TMCompanyCardExpiration(CompanyCard.loadList(new int[0])));
            this.tblCompany.setModel(sorter);
            sorter.setTableHeader(this.tblCompany.getTableHeader());
            CompanyCardStateRenderer.initialize(this.tblCompany);
        }
        return this.tblCompany;
    }

    private JPanel getPnlVehicle() {
        if (this.pnlVehicle == null) {
            this.pnlVehicle = new JPanel();
            this.pnlVehicle.setLayout(new GridBagLayout());
            this.pnlVehicle.add((Component)this.getPnlFiltersVehicle(), Fonctions.getGridBagConstraints(0, 0, 1, 2, 1.0, 0.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlVehicle.add((Component)this.getJspVehicle(), Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlVehicle.add((Component)this.getBtnPrintVehicle(), Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, -1, 13, new Insets(0, 0, 5, 5)));
            this.pnlVehicle.add((Component)this.getBtnExportVehicle(), Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, -1, 13, new Insets(0, 0, 5, 5)));
        }
        return this.pnlVehicle;
    }

    private JPanel getPnlFiltersVehicle() {
        if (this.pnlFiltersVehicle == null) {
            this.pnlFiltersVehicle = new JPanel();
            this.pnlFiltersVehicle.setLayout(new GridBagLayout());
            this.pnlFiltersVehicle.setBorder(BorderFactory.createTitledBorder(null, LanguageTranslator.getString("generics.filter"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            JLabel begin = new JLabel(LanguageTranslator.getString("generics.begin"));
            JLabel end = new JLabel(LanguageTranslator.getString("generics.end"));
            JLabel obl = new JLabel(LanguageTranslator.getString("generics.intervention"));
            this.pnlFiltersVehicle.add((Component)begin, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersVehicle.add((Component)this.getTxtBeginIntervention(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersVehicle.add((Component)end, Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersVehicle.add((Component)this.getTxtEndIntervention(), Fonctions.getGridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersVehicle.add((Component)obl, Fonctions.getGridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 0, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersVehicle.add((Component)this.getMbIntervention(), Fonctions.getGridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlFiltersVehicle.add((Component)this.getBtnReloadIntervention(), Fonctions.getGridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 0, -1, new Insets(5, 5, 5, 5)));
        }
        return this.pnlFiltersVehicle;
    }

    private JButton getBtnReloadIntervention() {
        if (this.btnReloadIntervention == null) {
            this.btnReloadIntervention = new JButton();
            this.btnReloadIntervention.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(Transport.res.getResourceString("icone_refresh"))));
            this.btnReloadIntervention.setPreferredSize(new Dimension(25, 25));
            this.btnReloadIntervention.setToolTipText(LanguageTranslator.getString("button.load"));
            this.btnReloadIntervention.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.reloadIntervention();
                }
            });
        }
        return this.btnReloadIntervention;
    }

    private void reloadIntervention() {
        Date begin = this.getTxtBeginIntervention().getText().equals("") ? null : ConversionTime.stringToDateFr(this.getTxtBeginIntervention().getText());
        Date end = this.getTxtEndIntervention().getText().equals("") ? null : ConversionTime.stringToDateFr(this.getTxtEndIntervention().getText());
        Vector<Vehicule> vehicles = new Vector<Vehicule>();
        Vector<Intervention> nexts = Fonctions.getNextIntervention(Intervention.loadLastList(0, 0), vehicles, true, begin, end);
        if (begin != null || end != null) {
            for (Intervention next : nexts) {
                try {
                    Vehicule vehicle = Vehicule.getVehicule(null, next.getVehicleId());
                    if (vehicles.contains(vehicle)) continue;
                    vehicles.add(vehicle);
                }
                catch (DBObjectNotFoundException e) {
                    e.printStackTrace();
                }
            }
        } else {
            vehicles = Vehicule.loadList(0);
        }
        TableSorter sorter = new TableSorter(new TMInterventionState(vehicles, this.getMbIntervention().getSelectedItems(), nexts));
        this.getTblVehicle().setModel(sorter);
        sorter.setTableHeader(this.getTblVehicle().getTableHeader());
        InterventionStateRenderer.initialize(this.getTblVehicle());
    }

    private JMultiListBox getMbIntervention() {
        if (this.mbIntervention == null) {
            this.mbIntervention = new JMultiListBox();
            this.mbIntervention.setPreferredSize(new Dimension(100, 25));
            this.mbIntervention.setModel(new MultiListBoxModel<InterventionType>(InterventionType.loadList(false), true));
        }
        return this.mbIntervention;
    }

    private JTextField getTxtEndIntervention() {
        if (this.txtEndIntervention == null) {
            this.txtEndIntervention = new JTextField();
            this.txtEndIntervention.setPreferredSize(new Dimension(0, 20));
            this.txtEndIntervention.setEditable(false);
            this.txtEndIntervention.setEnabled(true);
            this.txtEndIntervention.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogExpirationState.this.getTxtEndIntervention());
                }
            });
        }
        return this.txtEndIntervention;
    }

    private JTextField getTxtBeginIntervention() {
        if (this.txtBeginIntervention == null) {
            this.txtBeginIntervention = new JTextField();
            this.txtBeginIntervention.setPreferredSize(new Dimension(0, 20));
            this.txtBeginIntervention.setEditable(false);
            this.txtBeginIntervention.setEnabled(true);
            this.txtBeginIntervention.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Fonctions.afficheCalendrier(DialogExpirationState.this.getTxtBeginIntervention());
                }
            });
        }
        return this.txtBeginIntervention;
    }

    private JScrollPane getJspVehicle() {
        if (this.jspVehicle == null) {
            this.jspVehicle = new JScrollPane();
            this.jspVehicle.setViewportView(this.getTblVehicle());
        }
        return this.jspVehicle;
    }

    private JTable getTblVehicle() {
        if (this.tblVehicle == null) {
            this.tblVehicle = new JTable();
            this.tblVehicle.setAutoResizeMode(0);
            this.tblVehicle.addMouseListener(this.getInterventionTblMouseListener());
        }
        return this.tblVehicle;
    }

    private MouseListener getInterventionTblMouseListener() {
        if (this.interventionMouseListener == null) {
            this.interventionMouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    try {
                        Point p = e.getPoint();
                        int row = DialogExpirationState.this.getTblVehicle().rowAtPoint(p);
                        int column = DialogExpirationState.this.getTblVehicle().columnAtPoint(p);
                        if (row == -1 || column <= 1) {
                            TimsLogger.debug("clic hors d'une cellule");
                            return;
                        }
                        TableSorter model = (TableSorter)DialogExpirationState.this.getTblVehicle().getModel();
                        Vehicule vehicle = (Vehicule)model.getValueAt(row, 1);
                        InterventionType intType = InterventionType.getInterventionType(model.getColumnName(column));
                        if (e.getClickCount() == 2) {
                            TimsLogger.debug("#GSP.mousseListener# double click on " + intType.getName() + " for " + vehicle.getRegistrationNumber());
                            JCalendrier.affiche(DialogExpirationState.this.getTblVehicle(), p);
                            if (JCalendrier.clicked()) {
                                TimsLogger.debug("#GSP.mousseListener# create intervention on " + intType.getName() + " for " + vehicle.getRegistrationNumber() + " on " + JCalendrier.getDate());
                                Intervention toAdd = new Intervention(0, intType.getId(), vehicle.getCleVehicule(), ConversionTime.stringToDate(JCalendrier.getDate(), "dd/MM/yyyy"), 0, LanguageTranslator.getString("generics.unknown"), 0.0f, 0.0f, 0, null);
                                toAdd.insert();
                                ((TMInterventionState)model.getTableModel()).setValueAt(Fonctions.getNextIntervention(toAdd, vehicle), row, column);
                            }
                        } else if (SwingUtilities.isRightMouseButton(e)) {
                            TimsLogger.debug("#GSP.mousseListener# right click on " + intType.getName() + " for " + vehicle.getRegistrationNumber());
                        }
                    }
                    catch (DBObjectNotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
            };
        }
        return this.interventionMouseListener;
    }

    private JButton getBtnPrintVehicle() {
        if (this.btnPrintVehicle == null) {
            this.btnPrintVehicle = new JButton();
            this.btnPrintVehicle.setText(LanguageTranslator.getString("button.print"));
            this.btnPrintVehicle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.vehiclePrint("imprimer");
                }
            });
        }
        return this.btnPrintVehicle;
    }

    private JButton getBtnExportVehicle() {
        if (this.btnExportVehicle == null) {
            this.btnExportVehicle = new JButton();
            this.btnExportVehicle.setText(LanguageTranslator.getString("button.export"));
            this.btnExportVehicle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.vehiclePrint("xls");
                }
            });
        }
        return this.btnExportVehicle;
    }

    private JButton getBtnPrintCompany() {
        if (this.btnPrintCompany == null) {
            this.btnPrintCompany = new JButton();
            this.btnPrintCompany.setText(LanguageTranslator.getString("button.print"));
            this.btnPrintCompany.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogExpirationState.this.companyPrint();
                }
            });
        }
        return this.btnPrintCompany;
    }

    private void driverPrint(String out) {
        Vector<Color> conditionalColors = new Vector<Color>();
        Vector<Integer> conditionalThresholds = new Vector<Integer>();
        conditionalColors.add(MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT);
        conditionalThresholds.add(-100000);
        conditionalColors.add(MainFrameTransport.BG_COLOR_ALERTE_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("driver_error", "10")));
        conditionalColors.add(MainFrameTransport.BG_COLOR_OK_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("driver_warning", "60")));
        conditionalThresholds.add(-100000);
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.driverState"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultDriverExpirationStateColumn(this.getCbFimo().isSelected(), this.getCbCard().isSelected(), this.getCbLicenseMedical().isSelected(), this.getCbMedical().isSelected(), this.getCbAdr().isSelected(), this.getCbCaces().isSelected());
        cr.setColumn(columns);
        Fonctions.tblToReport(cr, new DJGeneratorWithDateStyle(conditionalColors, conditionalThresholds), ((TableSorter)this.getTblDriver().getModel()).getData(), out);
    }

    private void vehiclePrint(String out) {
        Vector<Color> conditionalColors = new Vector<Color>();
        conditionalColors.add(MainFrameTransport.BG_COLOR_OK_DEFAULT);
        conditionalColors.add(MainFrameTransport.BG_COLOR_ALERTE_DEFAULT);
        conditionalColors.add(MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT);
        conditionalColors.add(MainFrameTransport.BG_PASTEL_RED);
        conditionalColors.add(MainFrameTransport.BG_PASTEL_BLUE);
        Vector<Integer> conditionalId = new Vector<Integer>();
        conditionalId.add(1);
        conditionalId.add(2);
        conditionalId.add(3);
        conditionalId.add(4);
        conditionalId.add(5);
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.vehicleState"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultVehicleExpirationStateColumn(InterventionType.getList());
        cr.setColumn(columns);
        Fonctions.tblToReport(cr, new DJGeneratorColoredCellStyle(conditionalColors, conditionalId), ((TableSorter)this.getTblVehicle().getModel()).getData(), out);
    }

    private void companyPrint() {
        Vector<Color> conditionalColors = new Vector<Color>();
        Vector<Integer> conditionalThresholds = new Vector<Integer>();
        conditionalColors.add(MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT);
        conditionalThresholds.add(-100000);
        conditionalColors.add(MainFrameTransport.BG_COLOR_ALERTE_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("company_error", "10")));
        conditionalColors.add(MainFrameTransport.BG_COLOR_OK_DEFAULT);
        conditionalThresholds.add(Integer.parseInt(System.getProperty("company_warning", "60")));
        conditionalThresholds.add(-100000);
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.companyCardState"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultCompanyExpirationStateColumn(true);
        cr.setColumn(columns);
        Fonctions.tblToReport(cr, null, ((TableSorter)this.getTblCompany().getModel()).getData());
    }

    private void newDriverPrint(String out) {
        Vector<Color> conditionalColors = new Vector<Color>();
        conditionalColors.add(MainFrameTransport.BG_COLOR_OK_DEFAULT);
        conditionalColors.add(MainFrameTransport.BG_COLOR_ALERTE_DEFAULT);
        conditionalColors.add(MainFrameTransport.BG_COLOR_TOO_LATE_DEFAULT);
        conditionalColors.add(MainFrameTransport.BG_PASTEL_RED);
        conditionalColors.add(MainFrameTransport.BG_PASTEL_BLUE);
        Vector<Integer> conditionalId = new Vector<Integer>();
        conditionalId.add(1);
        conditionalId.add(2);
        conditionalId.add(3);
        conditionalId.add(4);
        conditionalId.add(5);
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.driverState"));
        Vector<CustomReportColumn> columns = CustomReportFactory.getDefaultDriverExpirationStateColumn(this.getMbObligation().getSelectedItems());
        cr.setColumn(columns);
        Fonctions.tblToReport(cr, new DJGeneratorColoredCellStyle(conditionalColors, conditionalId), ((TableSorter)this.getTblNewDriver().getModel()).getData(), out);
    }
}

