/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.jsmartcard.DriverCardProperty;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.reader.FileReadManager;

public class DialogFailedCard
extends JDialog {
    private JPanel jContentPane = null;
    private String[] list = null;
    private JList listeLog = null;
    private JPanel pnlBtn = null;
    private JButton btnQuit = null;
    private JButton btnSave = null;
    private JButton btnDelete = null;
    private JScrollPane jspList = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogFailedCard.dispose()#");
        super.dispose();
    }

    public DialogFailedCard(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogFailedCard()#");
        this.initialize();
        this.setVisible(true);
    }

    public String[] getList() {
        if (this.list == null) {
            this.list = DriverCardProperty.getFailedCard();
        }
        return this.list;
    }

    private void initialize() {
        this.setTitle(LanguageTranslator.getString("menu.driver.failedCard"));
        this.setSize(270, 290);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            ((BorderLayout)this.jContentPane.getLayout()).setVgap(5);
            ((BorderLayout)this.jContentPane.getLayout()).setHgap(5);
            this.jContentPane.add((Component)this.getPnlBtn(), "South");
            this.jContentPane.add((Component)this.getJspList(), "Center");
        }
        return this.jContentPane;
    }

    private JList getListeFailedCard() {
        if (this.listeLog == null) {
            this.listeLog = new JList<String>(this.getList());
        }
        return this.listeLog;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add((Component)this.getBtnSave(), null);
            this.pnlBtn.add((Component)this.getBtnDelete(), null);
            this.pnlBtn.add((Component)this.getBtnQuit(), null);
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuit() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogFailedCard.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton(LanguageTranslator.getString("button.load"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogFailedCard.this.readFile();
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton(LanguageTranslator.getString("button.delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogFailedCard.this.deleteFile();
                }
            });
        }
        return this.btnDelete;
    }

    private JScrollPane getJspList() {
        if (this.jspList == null) {
            this.jspList = new JScrollPane();
            this.jspList.setViewportView(this.getListeFailedCard());
        }
        return this.jspList;
    }

    private void readFile() {
        Vector<File> toRead = new Vector<File>();
        Object[] objectArray = this.getListeFailedCard().getSelectedValues();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object tmp = objectArray[n2];
            toRead.add(new File(String.valueOf(Transport.savePath) + "\\" + tmp.toString()));
            ++n2;
        }
        FileReadManager.getInstance().queueFiles(toRead);
    }

    private void deleteFile() {
        String[] stringArray = (String[])this.getListeFailedCard().getSelectedValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            TimsLogger.verbose("#DialogFailedCard# delete " + tmp);
            new File(String.valueOf(Transport.savePath) + "\\" + tmp).delete();
            ++n2;
        }
    }
}

