/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.TimsSession;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Garage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.modele.LMGarage;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class DialogGarage
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlListe = null;
    private JPanel pnlDetail = null;
    private JScrollPane jpsListe = null;
    private JList listGarage = null;
    private JCheckBox cbArchive = null;
    private JPanel pnlBtn = null;
    private JButton btnCreer = null;
    private JButton btnQuitter = null;
    private JButton btnArchive = null;
    private JButton btnEnregistrer = null;
    private JPanel pnlContent = null;
    private JLabel lblAgency = null;
    private JComboBox cbAgency = null;
    private JLabel lblName = null;
    private JTextField txtName = null;
    private JLabel lblCode = null;
    private JTextField txtCode = null;
    private JLabel lblContact = null;
    private JTextField txtContact = null;
    private JLabel lblAddress = null;
    private JTextArea txtAddress = null;
    private JLabel lblCity = null;
    private JTextField txtCity = null;
    private JLabel lblPostalCode = null;
    private JTextField txtPostalCode = null;
    private JLabel lblPhone = null;
    private JTextField txtPhone = null;
    private JLabel lblFax = null;
    private JTextField txtFax = null;
    private Garage current = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogGarage.dispose()#");
        super.dispose();
    }

    public DialogGarage(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogGarage()#");
        this.initialize();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private void initialize() {
        this.setSize(570, 320);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("generics.garage"));
        this.setContentPane(this.getJContentPane());
        this.load(new Garage());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gcbList = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 1, -1, new Insets(5, 5, 5, 5));
            GridBagConstraints gcbContent = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 0, 5, 5));
            GridBagConstraints gcbBtn = Fonctions.getGridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 1, 15, new Insets(2, 2, 2, 2));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlListe(), gcbList);
            this.jContentPane.add((Component)this.getPnlContent(), gcbContent);
            this.jContentPane.add((Component)this.getPnlBtn(), gcbBtn);
        }
        return this.jContentPane;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            GridBagConstraints gcbListe = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 0, 5, 0));
            GridBagConstraints gcbArchive = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(0, 0, 5, 0));
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.setPreferredSize(new Dimension(150, 0));
            this.pnlListe.add((Component)this.getJpsListe(), gcbListe);
            this.pnlListe.add((Component)this.getCbArchive(), gcbArchive);
        }
        return this.pnlListe;
    }

    private JScrollPane getJpsListe() {
        if (this.jpsListe == null) {
            this.jpsListe = new JScrollPane();
            this.jpsListe.setPreferredSize(new Dimension(0, 0));
            this.jpsListe.setViewportView(this.getListGarage());
        }
        return this.jpsListe;
    }

    private JList getListGarage() {
        if (this.listGarage == null) {
            this.listGarage = new JList();
            this.listGarage.setModel(new LMGarage(Garage.getList()));
            this.listGarage.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogGarage.this.getListGarage().getSelectedIndex() != -1) {
                        LMGarage tmp = (LMGarage)DialogGarage.this.getListGarage().getModel();
                        DialogGarage.this.load(tmp.getSpecifiedObjectAt(DialogGarage.this.getListGarage().getSelectedIndex()));
                    }
                }
            });
        }
        return this.listGarage;
    }

    private JButton getBtnCreer() {
        if (this.btnCreer == null) {
            this.btnCreer = new JButton();
            this.btnCreer.setText(LanguageTranslator.getString("button.new"));
            this.btnCreer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGarage.this.load(new Garage());
                }
            });
        }
        return this.btnCreer;
    }

    private JPanel getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanel();
            this.pnlBtn.add(this.getBtnCreer());
            this.pnlBtn.add(this.getBtnArchive());
            this.pnlBtn.add(this.getBtnQuitter());
            this.pnlBtn.add(this.getBtnEnregistrer());
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGarage.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JButton getBtnArchive() {
        if (this.btnArchive == null) {
            this.btnArchive = new JButton();
            this.btnArchive.setText(LanguageTranslator.getString("button.archive"));
            this.btnArchive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGarage.this.archive();
                }
            });
        }
        return this.btnArchive;
    }

    public void archive() {
        if (this.current != null && JOptionPane.showConfirmDialog(this, LanguageTranslator.getString("generics.confirmArchive"), LanguageTranslator.getString("button.archive"), 0, 2) == 0) {
            this.save(true);
        }
    }

    private JButton getBtnEnregistrer() {
        if (this.btnEnregistrer == null) {
            this.btnEnregistrer = new JButton();
            this.btnEnregistrer.setText(LanguageTranslator.getString("button.save"));
            this.btnEnregistrer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogGarage.this.current != null) {
                        DialogGarage.this.save(false);
                        DialogGarage.this.updateList();
                    }
                }
            });
        }
        return this.btnEnregistrer;
    }

    private JComboBox getCbAgency() {
        if (this.cbAgency == null) {
            this.cbAgency = new JComboBox();
            this.cbAgency.setModel(new ComboBoxModel(Agence.getList(), true, LanguageTranslator.getString("generics.select")));
        }
        return this.cbAgency;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
        }
        return this.txtName;
    }

    private JTextField getTxtCode() {
        if (this.txtCode == null) {
            this.txtCode = new JTextField();
        }
        return this.txtCode;
    }

    private JTextField getTxtContact() {
        if (this.txtContact == null) {
            this.txtContact = new JTextField();
        }
        return this.txtContact;
    }

    private JTextArea getTxtAddress() {
        if (this.txtAddress == null) {
            this.txtAddress = new JTextArea();
            this.txtAddress.setBorder(this.getTxtCity().getBorder());
        }
        return this.txtAddress;
    }

    private JTextField getTxtCity() {
        if (this.txtCity == null) {
            this.txtCity = new JTextField();
        }
        return this.txtCity;
    }

    private JTextField getTxtPostalCode() {
        if (this.txtPostalCode == null) {
            this.txtPostalCode = new JTextField();
        }
        return this.txtPostalCode;
    }

    private JTextField getTxtPhone() {
        if (this.txtPhone == null) {
            this.txtPhone = new JTextField();
        }
        return this.txtPhone;
    }

    private JTextField getTxtFax() {
        if (this.txtFax == null) {
            this.txtFax = new JTextField();
        }
        return this.txtFax;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.lblAgency = new JLabel(LanguageTranslator.getString("generics.agency"));
            this.lblName = new JLabel(LanguageTranslator.getString("generics.designation"));
            this.lblCode = new JLabel(LanguageTranslator.getString("generics.code"));
            this.lblContact = new JLabel(LanguageTranslator.getString("generics.contact"));
            this.lblAddress = new JLabel(LanguageTranslator.getString("generics.address"));
            this.lblCity = new JLabel(LanguageTranslator.getString("generics.city"));
            this.lblPostalCode = new JLabel(LanguageTranslator.getString("generics.cp"));
            this.lblPhone = new JLabel(LanguageTranslator.getString("generics.phone"));
            this.lblFax = new JLabel(LanguageTranslator.getString("generics.fax"));
            GridBagConstraints gcbLblAgency = Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbCbAgency = Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblName = Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtName = Fonctions.getGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblCode = Fonctions.getGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCode = Fonctions.getGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblContact = Fonctions.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtContact = Fonctions.getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblAddress = Fonctions.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, -1, 18, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtAddress = Fonctions.getGridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 1, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblCity = Fonctions.getGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtCity = Fonctions.getGridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblPostalCode = Fonctions.getGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtPostalCode = Fonctions.getGridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblPhone = Fonctions.getGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtPhone = Fonctions.getGridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            GridBagConstraints gcbLblFax = Fonctions.getGridBagConstraints(0, 8, 1, 1, 0.0, 0.0, -1, 17, new Insets(5, 5, 0, 5));
            GridBagConstraints gcbTxtFax = Fonctions.getGridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 2, 13, new Insets(5, 0, 0, 5));
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.lblAgency, gcbLblAgency);
            this.pnlContent.add((Component)this.getCbAgency(), gcbCbAgency);
            this.pnlContent.add((Component)this.lblName, gcbLblName);
            this.pnlContent.add((Component)this.getTxtName(), gcbTxtName);
            this.pnlContent.add((Component)this.lblCode, gcbLblCode);
            this.pnlContent.add((Component)this.getTxtCode(), gcbTxtCode);
            this.pnlContent.add((Component)this.lblContact, gcbLblContact);
            this.pnlContent.add((Component)this.getTxtContact(), gcbTxtContact);
            this.pnlContent.add((Component)this.lblAddress, gcbLblAddress);
            this.pnlContent.add((Component)this.getTxtAddress(), gcbTxtAddress);
            this.pnlContent.add((Component)this.lblCity, gcbLblCity);
            this.pnlContent.add((Component)this.getTxtCity(), gcbTxtCity);
            this.pnlContent.add((Component)this.lblPostalCode, gcbLblPostalCode);
            this.pnlContent.add((Component)this.getTxtPostalCode(), gcbTxtPostalCode);
            this.pnlContent.add((Component)this.lblPhone, gcbLblPhone);
            this.pnlContent.add((Component)this.getTxtPhone(), gcbTxtPhone);
            this.pnlContent.add((Component)this.lblFax, gcbLblFax);
            this.pnlContent.add((Component)this.getTxtFax(), gcbTxtFax);
        }
        return this.pnlContent;
    }

    private JCheckBox getCbArchive() {
        if (this.cbArchive == null) {
            this.cbArchive = new JCheckBox();
            this.cbArchive.setText(LanguageTranslator.getString("generics.seeArchive"));
            this.cbArchive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enable = DialogGarage.this.getCbArchive().isSelected();
                    DialogGarage.this.current = null;
                    DialogGarage.this.updateList();
                    if (enable) {
                        DialogGarage.this.getListGarage().setModel(new LMGarage(Garage.loadList(0, true)));
                        DialogGarage.this.getBtnEnregistrer().setEnabled(false);
                        DialogGarage.this.getBtnArchive().setEnabled(false);
                        DialogGarage.this.getBtnCreer().setEnabled(false);
                    } else {
                        DialogGarage.this.getListGarage().setModel(new LMGarage(Garage.getList()));
                        DialogGarage.this.getBtnEnregistrer().setEnabled(true);
                        DialogGarage.this.getBtnArchive().setEnabled(true);
                        DialogGarage.this.getBtnCreer().setEnabled(true);
                    }
                }
            });
        }
        return this.cbArchive;
    }

    private void load(Garage toLoad) {
        this.current = toLoad;
        ((ComboBoxModel)this.getCbAgency().getModel()).setSelected(this.current == null ? 0 : this.current.getAgencyId());
        this.getTxtName().setText(this.current.getName());
        this.getTxtCode().setText(this.current.getCode());
        this.getTxtContact().setText(this.current.getContact());
        this.getTxtAddress().setText(this.current.getAddress());
        this.getTxtCity().setText(this.current.getCity());
        this.getTxtPostalCode().setText(this.current.getPostalCode());
        this.getTxtPhone().setText(this.current.getPhone());
        this.getTxtFax().setText(this.current.getFax());
    }

    private void save(boolean archive) {
        if (this.check() && this.current.compareAndUpdate(((ComboBoxModel)this.getCbAgency().getModel()).getSelectedCle(), this.getTxtName().getText(), this.getTxtCode().getText(), this.getTxtContact().getText(), this.getTxtAddress().getText(), this.getTxtCity().getText(), this.getTxtPostalCode().getText(), this.getTxtPhone().getText(), this.getTxtFax().getText(), archive)) {
            this.updateList();
            JOptionPane.showMessageDialog(this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"), 1);
        }
    }

    private boolean check() {
        boolean toReturn = true;
        if (((ComboBoxModel)this.getCbAgency().getModel()).getSelectedCle() == 0) {
            this.getCbAgency().setBackground(new Color(255, 192, 203));
            this.getCbAgency().setToolTipText(LanguageTranslator.getString("generics.fillNeeded"));
            toReturn = false;
        } else {
            this.getCbAgency().setBackground(UIManager.getColor("ComboBox.background"));
        }
        if (this.getTxtCode().getText().length() > 8) {
            this.getTxtCode().setBackground(new Color(255, 192, 203));
            this.getTxtCode().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "8"));
            toReturn = false;
        } else {
            this.getTxtCode().setBackground(UIManager.getColor("ComboBox.background"));
        }
        if (this.getTxtPostalCode().getText().length() > 5) {
            this.getTxtPostalCode().setBackground(new Color(255, 192, 203));
            this.getTxtPostalCode().setToolTipText(LanguageTranslator.getString("generics.maxAuthorised", "5"));
            toReturn = false;
        } else {
            this.getTxtPostalCode().setBackground(UIManager.getColor("ComboBox.background"));
        }
        return toReturn;
    }

    public void updateList() {
        this.getListGarage().setModel(new LMGarage(Garage.getList()));
        if (this.current != null) {
            this.getListGarage().setSelectedValue(this.current.getName(), true);
        }
    }
}

