/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Conflit;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogDetailConflit;
import transpo.system.ui.views.PnlCalendrier;

public class DialogGestionConflit
extends JDialog {
    JPanel cPane = null;
    JComboBox agence = null;
    JComboBox chauffeur = null;
    JList listeConflit = null;
    PnlCalendrier pCalendrier = null;
    JPanel pSelection = null;
    JPanel pDetail = null;
    public String dateBDDSelectionnee = new String("");
    private JButton boutonQuitter = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogGestionConflit.dispose()#");
        super.dispose();
    }

    public DialogGestionConflit(JFrame f) {
        super(f);
        TimsLogger.verbose("#DialogGestionConflit()#");
        this.initialize();
    }

    private void initialize() {
        this.setTitle(LanguageTranslator.getString("conflict.manager.title"));
        this.setSize(700, 350);
        this.setLocationRelativeTo(this.getParent());
        this.setContentPane(this.getcPane());
        this.getCbAgence().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent Event2) {
                DialogGestionConflit.this.updateDriver();
            }
        });
        this.getCbConducteur().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent Event2) {
                if (DialogGestionConflit.this.getCbConducteur().getSelectedItem() != null || DialogGestionConflit.this.getCbConducteur().getSelectedItem() != "") {
                    DialogGestionConflit.this.pCalendrier.setChauffeur(((ComboBoxModel)DialogGestionConflit.this.getCbConducteur().getModel()).getSelectedCle());
                    DialogGestionConflit.this.pCalendrier.updateCalendar();
                }
            }
        });
    }

    private void loadDetailJour() {
        new DialogDetailConflit(this, (Conflit)((ComboBoxModel)this.listeConflit.getModel()).getObjectAt(this.listeConflit.getSelectedIndex()));
    }

    private JPanel getcPane() {
        if (this.cPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 1;
            GridBagConstraints cMain = new GridBagConstraints();
            cMain.fill = 1;
            cMain.gridx = 0;
            cMain.weightx = 1.0;
            cMain.weighty = 1.0;
            cMain.gridy = 0;
            this.cPane = new JPanel();
            this.cPane.setLayout(new GridBagLayout());
            this.cPane.add((Component)this.getpSelection(), cMain);
            this.cPane.add((Component)this.getBoutonQuitter(), gridBagConstraints);
        }
        return this.cPane;
    }

    private JPanel getpSelection() {
        if (this.pSelection == null) {
            this.pSelection = new JPanel();
            this.pSelection.setLayout(new GridBagLayout());
            GridBagConstraints cSel = new GridBagConstraints();
            cSel.fill = 1;
            cSel.gridx = 0;
            cSel.gridy = 0;
            cSel.insets = new Insets(20, 10, 10, 10);
            this.pSelection.add((Component)this.getCbAgence(), cSel);
            GridBagConstraints c01 = new GridBagConstraints();
            c01.fill = 1;
            c01.gridx = 0;
            c01.gridy = 1;
            c01.insets = new Insets(0, 10, 10, 10);
            this.pSelection.add((Component)this.getCbConducteur(), c01);
            GridBagConstraints c02 = new GridBagConstraints();
            c02.fill = 1;
            c02.gridx = 0;
            c02.gridy = 2;
            c02.insets = new Insets(0, 10, 10, 10);
            this.pSelection.add((Component)this.getListeConflit(), c02);
            GridBagConstraints c03 = new GridBagConstraints();
            c03.fill = 1;
            c03.gridx = 1;
            c03.gridy = 0;
            c03.weightx = 1.0;
            c03.gridheight = 3;
            this.pSelection.add((Component)this.getpCalendrier(), c03);
        }
        return this.pSelection;
    }

    private JPanel getpCalendrier() {
        if (this.pCalendrier == null) {
            this.pCalendrier = new PnlCalendrier(this);
            this.pCalendrier.setBorder(BorderFactory.createTitledBorder(LanguageTranslator.getString("generics.calendar")));
        }
        return this.pCalendrier;
    }

    private JList getListeConflit() {
        if (this.listeConflit == null) {
            this.listeConflit = new JList();
            this.listeConflit.setCellRenderer(new ListConflitRenderer());
            this.listeConflit.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (!DialogGestionConflit.this.listeConflit.isSelectionEmpty() && !event.getValueIsAdjusting()) {
                        DialogGestionConflit.this.loadDetailJour();
                    }
                }
            });
        }
        return this.listeConflit;
    }

    public JComboBox getCbConducteur() {
        if (this.chauffeur == null) {
            this.chauffeur = new JComboBox();
            ComboBoxModel tmp = new ComboBoxModel(Transport.bdd.getConducteurListAgence(""), false, LanguageTranslator.getString("generics.all"));
            this.chauffeur.setModel(tmp);
        }
        return this.chauffeur;
    }

    public JComboBox getCbAgence() {
        if (this.agence == null) {
            this.agence = new JComboBox();
            ComboBoxModel tmp = new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.all"));
            this.agence.setModel(tmp);
        }
        return this.agence;
    }

    public void loadList(String dateSelect) {
        Transport.ps.startOperation();
        int cleConducteur = ((ComboBoxModel)this.getCbConducteur().getModel()).getSelectedCle();
        Vector<Conflit> listC = Transport.bdd.getConflitList(cleConducteur, dateSelect, -1, true);
        ComboBoxModel tmp = new ComboBoxModel(listC, true, null);
        this.getListeConflit().setModel(tmp);
        Transport.ps.endOperation(PerformanceScanner.READING, "conflict");
    }

    private JButton getBoutonQuitter() {
        if (this.boutonQuitter == null) {
            this.boutonQuitter = new JButton();
            this.boutonQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.boutonQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogGestionConflit.this.dispose();
                }
            });
        }
        return this.boutonQuitter;
    }

    public void updateDriver() {
        int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        this.getCbConducteur().setModel(new ComboBoxModel(Conducteur.loadList(cleAgence), false, LanguageTranslator.getString("generics.all")));
    }

    public class ListConflitRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof Conflit)) {
                return this;
            }
            this.setText(String.valueOf(((Conflit)value).getNomConducteur()) + " " + ((Conflit)value).getPrenomConducteur());
            if (((Conflit)value).isTraite()) {
                this.setForeground(Color.ORANGE);
            } else {
                this.setForeground(Color.RED);
            }
            return this;
        }
    }
}

