/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.component.JPanelButton;
import fr.pgh.component.ui.renderer.CheckBoxHeader;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverDayAnomaly;
import fr.pgh.data.bdd.ImportActivity;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.MainElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.controller.ImportActivityController;
import transpo.system.ui.modele.LMImportActivity;
import transpo.system.ui.modele.TMDriverDayAnomalies;
import transpo.system.ui.modele.TMDriverWarning;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.viewable.ProgressViewManager;
import transpo.system.ui.views.GraphJour;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transpo.system.util.ProcessType;
import transpo.system.util.messaging.MessageSystemManager;

public class DialogImportActivity
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel pnlListe = null;
    private JPanel pnlDetail = null;
    private JScrollPane jspListe = null;
    private JList<ImportActivity> importList = null;
    private JPanelButton pnlBtn = null;
    private JButton btnNew = null;
    private JButton btnSave = null;
    private JButton btnOverview = null;
    private JButton btnQuit = null;
    private JLabel lblImportStatus = null;
    private JPanel pnlWarning = null;
    private JScrollPane jspWarning = null;
    private JTable tblWarning = null;
    private JPanel pnlUnknown = null;
    private JScrollPane jspUnknown = null;
    private JList<String> listUnknown = null;
    private JPanel pnlAnomaly = null;
    private JScrollPane jspAnomaly = null;
    private JTable tblAnomaly = null;
    private ImportActivityController controller = null;
    private ProgressViewManager pgBar = null;
    private Thread newImportThread = null;
    private final Thread saveThread = new Thread("saver"){

        @Override
        public void run() {
            DialogImportActivity.this.save();
        }
    };

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogImportActivity.dispose()#");
        super.dispose();
    }

    public DialogImportActivity(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogImportActivity()#");
        this.controller = new ImportActivityController(this.getProgression());
        this.initialize();
    }

    private void initialize() {
        this.setSize(950, 700);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(LanguageTranslator.getString("import.activity"));
        this.setContentPane(this.getJContentPane());
    }

    public ProgressViewManager getProgression() {
        if (this.pgBar == null) {
            this.pgBar = new ProgressViewManager(new ProgressBar(this, "Import..."));
        }
        return this.pgBar;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPnlListe(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 1, -1, new Insets(5, 0, 5, 5)));
            this.jContentPane.add((Component)this.getPnlDetail(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
        }
        return this.jContentPane;
    }

    private JPanel getPnlListe() {
        if (this.pnlListe == null) {
            this.pnlListe = new JPanel();
            this.pnlListe.setLayout(new GridBagLayout());
            this.pnlListe.setPreferredSize(new Dimension(120, 0));
            this.pnlListe.add((Component)this.getJspListe(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlListe.add((Component)this.getBtnCreer(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, -1, new Insets(0, 5, 5, 5)));
        }
        return this.pnlListe;
    }

    private JPanel getPnlDetail() {
        if (this.pnlDetail == null) {
            this.pnlDetail = new JPanel();
            this.pnlDetail.setLayout(new GridBagLayout());
            this.pnlDetail.add((Component)this.getLblImportStatus(), Fonctions.getGridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 2, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)this.getPnlWarning(), Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)this.getPnlUnknown(), Fonctions.getGridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 3, -1, new Insets(5, 5, 5, 5)));
            this.pnlDetail.add((Component)this.getPnlAnomaly(), Fonctions.getGridBagConstraints(0, 2, 1, 2, 2.0, 2.0, 1, -1, new Insets(0, 5, 5, 5)));
            this.pnlDetail.add((Component)this.getPnlBtn(), Fonctions.getGridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 0, -1, new Insets(5, 5, 5, 5)));
        }
        return this.pnlDetail;
    }

    private JLabel getLblImportStatus() {
        if (this.lblImportStatus == null) {
            this.lblImportStatus = new JLabel();
            this.lblImportStatus.setText(this.controller.getCurrentImport() == null ? "S\u00e9lectionner un import" : "" + (Object)((Object)this.controller.getCurrentImport().getState()));
        }
        return this.lblImportStatus;
    }

    private JPanel getPnlWarning() {
        if (this.pnlWarning == null) {
            this.pnlWarning = new JPanel();
            this.pnlWarning.setLayout(new BorderLayout());
            this.pnlWarning.setBorder(new TitledBorder(LanguageTranslator.getString("import.activity.warning.title")));
            this.pnlWarning.add((Component)this.getJspWarning(), "Center");
        }
        return this.pnlWarning;
    }

    private JScrollPane getJspWarning() {
        if (this.jspWarning == null) {
            this.jspWarning = new JScrollPane();
            this.jspWarning.setViewportView(this.getTblWarning());
        }
        return this.jspWarning;
    }

    private JTable getTblWarning() {
        if (this.tblWarning == null) {
            this.tblWarning = new JTable();
            this.tblWarning.setModel(new TMDriverWarning(null));
        }
        return this.tblWarning;
    }

    private JPanel getPnlUnknown() {
        if (this.pnlUnknown == null) {
            this.pnlUnknown = new JPanel();
            this.pnlUnknown.setLayout(new BorderLayout());
            this.pnlUnknown.setBorder(new TitledBorder(LanguageTranslator.getString("import.activity.unknown.title")));
            this.pnlUnknown.add((Component)this.getJspUnknown(), "Center");
        }
        return this.pnlUnknown;
    }

    private JScrollPane getJspUnknown() {
        if (this.jspUnknown == null) {
            this.jspUnknown = new JScrollPane();
            this.jspUnknown.setViewportView(this.getListUnknown());
            this.jspUnknown.setMinimumSize(new Dimension(130, 0));
        }
        return this.jspUnknown;
    }

    private JList<String> getListUnknown() {
        if (this.listUnknown == null) {
            this.listUnknown = new JList();
        }
        return this.listUnknown;
    }

    private JPanel getPnlAnomaly() {
        if (this.pnlAnomaly == null) {
            this.pnlAnomaly = new JPanel();
            this.pnlAnomaly.setLayout(new BorderLayout());
            this.pnlAnomaly.setBorder(new TitledBorder(LanguageTranslator.getString("import.activity.anomaly.title")));
            this.pnlAnomaly.add((Component)this.getJspAnomaly(), "Center");
        }
        return this.pnlAnomaly;
    }

    private JScrollPane getJspAnomaly() {
        if (this.jspAnomaly == null) {
            this.jspAnomaly = new JScrollPane();
            this.jspAnomaly.setViewportView(this.getTblAnomaly());
        }
        return this.jspAnomaly;
    }

    private JTable getTblAnomaly() {
        if (this.tblAnomaly == null) {
            this.tblAnomaly = new JTable();
            this.tblAnomaly.setModel(new TMDriverDayAnomalies(null));
            this.tblAnomaly.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TMDriverDayAnomalies model = (TMDriverDayAnomalies)DialogImportActivity.this.getTblAnomaly().getModel();
                    if (DialogImportActivity.this.getTblAnomaly().getSelectedColumn() < 3) {
                        DriverDayAnomaly tmp = model.getData().get(DialogImportActivity.this.getTblAnomaly().getSelectedRow());
                        DialogImportActivity.this.showAnomaly(tmp);
                    }
                }
            });
            ItemListener anomalyProcessUpdater = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String state = e.getStateChange() == 1 ? "checked" : "unchecked";
                    int column = ((CheckBoxHeader)e.getItem()).getColumn();
                    TimsLogger.verbose(String.valueOf(column) + " - " + state);
                    if (e.getStateChange() == 1) {
                        ProcessType toSet;
                        TMDriverDayAnomalies model = (TMDriverDayAnomalies)DialogImportActivity.this.getTblAnomaly().getModel();
                        ProcessType processType = column == 3 ? ProcessType.ERASE : (toSet = column == 4 ? ProcessType.MERGE : ProcessType.IGNORE);
                        if (model.getData() != null) {
                            for (DriverDayAnomaly dda : model.getData()) {
                                dda.setProcess(toSet);
                            }
                            model.fireTableRowsUpdated(0, model.getRowCount() - 1);
                        }
                    }
                }
            };
            ButtonGroup bg = new ButtonGroup();
            Enumeration<TableColumn> enumeration = this.tblAnomaly.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn aColumn = enumeration.nextElement();
                if (aColumn.getModelIndex() < 3) continue;
                CheckBoxHeader cbh = new CheckBoxHeader(anomalyProcessUpdater);
                bg.add(cbh);
                aColumn.setHeaderRenderer(cbh);
            }
        }
        return this.tblAnomaly;
    }

    private void showAnomaly(DriverDayAnomaly toShow) {
        JDialog tmpj = new JDialog();
        tmpj.setSize(new Dimension(800, 350));
        tmpj.setTitle("D\u00e9tail d'une anomalie");
        JPanel jcontent = new JPanel();
        jcontent.setLayout(new GridBagLayout());
        tmpj.setContentPane(jcontent);
        JLabel lblDetail = new JLabel("Anomalie du " + ConversionTime.dateToStringFr(toShow.getAnomalyDay()) + " pour " + Conducteur.getDriverLibelle(toShow.getDriverId()));
        JPanel pnlImported = new JPanel();
        pnlImported.setLayout(new GridBagLayout());
        pnlImported.setBorder(new TitledBorder("Import\u00e9 depuis le fichier " + this.controller.getCurrentImport().getFileName()));
        if (toShow.getImported() != null) {
            GraphJour imported = new GraphJour();
            imported.initialiser(toShow.getImported(), 0, 0);
            pnlImported.add((Component)imported, Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
        } else {
            try {
                JLabel abs = new JLabel(JourType.getDayType(toShow.getImportedDayType()).getDesignation());
                pnlImported.add((Component)abs, Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        JPanel pnlInitial = new JPanel();
        pnlInitial.setLayout(new GridBagLayout());
        pnlInitial.setBorder(new TitledBorder("Pr\u00e9sent dans la base"));
        if (toShow.getInitial() != null) {
            GraphJour initial = new GraphJour();
            initial.initialiser(toShow.getInitial(), 0, 0);
            pnlInitial.add((Component)initial, Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
        } else {
            try {
                JLabel abs = new JLabel(JourType.getDayType(toShow.getInitialDayType()).getDesignation());
                pnlInitial.add((Component)abs, Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        jcontent.add((Component)lblDetail, Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 2, -1, new Insets(5, 5, 0, 5)));
        jcontent.add((Component)pnlImported, Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
        jcontent.add((Component)pnlInitial, Fonctions.getGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
        if (toShow.getImported() != null && toShow.getInitial() != null) {
            JPanel pnlMerge = new JPanel();
            pnlMerge.setLayout(new GridBagLayout());
            pnlMerge.setBorder(new TitledBorder("R\u00e9sultat (" + toShow.getProcess().getText() + ")"));
            GraphJour merge = new GraphJour();
            merge.initialiser(toShow.getProcess() == ProcessType.MERGE ? Fonctions.mergeForImport(toShow) : toShow.getImported(), 0, 0);
            pnlMerge.add((Component)merge, Fonctions.getGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
            jcontent.add((Component)pnlMerge, Fonctions.getGridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 5, 5)));
        }
        tmpj.setVisible(true);
    }

    private JScrollPane getJspListe() {
        if (this.jspListe == null) {
            this.jspListe = new JScrollPane();
            this.jspListe.setMinimumSize(new Dimension(150, 0));
            this.jspListe.setViewportView(this.getImportList());
        }
        return this.jspListe;
    }

    private JList<ImportActivity> getImportList() {
        if (this.importList == null) {
            this.importList = new JList();
            this.importList.setModel(new LMImportActivity(ImportActivity.loadList()));
            this.importList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DialogImportActivity.this.getImportList().getSelectedIndex() != -1) {
                        LMImportActivity tmp = (LMImportActivity)DialogImportActivity.this.getImportList().getModel();
                        DialogImportActivity.this.load((ImportActivity)tmp.get(DialogImportActivity.this.getImportList().getSelectedIndex()));
                    }
                }
            });
            this.importList.setCellRenderer(new ListCellRenderer<ImportActivity>(){
                protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends ImportActivity> list, ImportActivity value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    renderer.setText(ConversionTime.dateToString(value.getIntegrationDate(), "dd/MM/yyyy HH'h'mm"));
                    return renderer;
                }
            });
        }
        return this.importList;
    }

    private JButton getBtnCreer() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setText(LanguageTranslator.getString("button.new"));
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogImportActivity.this.newImportThread = new Thread("uploader"){

                        @Override
                        public void run() {
                            DialogImportActivity.this.createNewImport();
                        }
                    };
                    DialogImportActivity.this.newImportThread.start();
                }
            });
        }
        return this.btnNew;
    }

    private void createNewImport() {
        File[] files;
        this.controller = new ImportActivityController(this.getProgression());
        File toRead = new File("C:\\Users\\Seb.DESKTOP-V4EH37M\\Desktop\\FICHIERS\\cayon\\IMPORT\\Export_FITv2_TIMS_202002200252.csv");
        if (!(Transport.debug >= 1 && toRead.exists() || (files = Fonctions.selectFile(0, null, LanguageTranslator.getString("generics.import"), LanguageTranslator.getString("generics.import"), false)) == null || files.length == 0)) {
            toRead = files[0];
        }
        this.controller.setFile(toRead);
        int result = this.controller.analyzeFile();
        if (result == 1) {
            this.showAnalyzeResult();
            this.getBtnOverview().setEnabled(true);
            this.getBtnSave().setEnabled(true);
        } else {
            MessageSystemManager.error((Component)this, LanguageTranslator.getString("import.analyzeError"), LanguageTranslator.getString("message.done"));
        }
    }

    private JButton getBtnOverview() {
        if (this.btnOverview == null) {
            this.btnOverview = new JButton();
            this.btnOverview.setText(LanguageTranslator.getString("button.overview"));
            this.btnOverview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogImportActivity.this.createDialogAct();
                }
            });
            this.btnOverview.setEnabled(false);
        }
        return this.btnOverview;
    }

    private JPanelButton getPnlBtn() {
        if (this.pnlBtn == null) {
            this.pnlBtn = new JPanelButton(this.getBtnQuitter(), this.getBtnOverview());
            if (ConnexionSettings.getInstance().isAjoutable("IMPORT_ACTIVITY")) {
                this.pnlBtn.addBtn(this.getBtnSave());
            }
        }
        return this.pnlBtn;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuit == null) {
            this.btnQuit = new JButton();
            this.btnQuit.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogImportActivity.this.dispose();
                }
            });
        }
        return this.btnQuit;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(LanguageTranslator.getString("import.save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogImportActivity.this.controller != null && DialogImportActivity.this.controller.getCurrentImport().getState() == ImportActivity.Status.ANALYZED) {
                        DialogImportActivity.this.saveThread.start();
                    }
                }
            });
            this.btnSave.setEnabled(false);
        }
        return this.btnSave;
    }

    private void load(ImportActivity toLoad) {
        this.controller.setCurrentImport(toLoad);
        this.showAnalyzeResult();
        this.getBtnSave().setEnabled(false);
        this.getBtnOverview().setEnabled(false);
    }

    private void save() {
        if (this.controller.save()) {
            MessageSystemManager.information((Component)this, LanguageTranslator.getString("message.saveSucceed"), LanguageTranslator.getString("message.done"));
        } else {
            MessageSystemManager.error((Component)this, LanguageTranslator.getString("import.saveError"), LanguageTranslator.getString("message.done"));
        }
        this.updateList();
        this.getBtnSave().setEnabled(false);
        this.getBtnOverview().setEnabled(false);
    }

    public void updateList() {
        this.getImportList().setModel(new LMImportActivity(ImportActivity.loadList()));
        if (this.controller != null) {
            this.getImportList().setSelectedValue(this.controller.getCurrentImport(), true);
        }
    }

    private void showAnalyzeResult() {
        TimsLogger.debug("#DialogImportActivity.showAnalyzeResult# print " + this.controller.getDriverWarnings().size() + " warnings and " + this.controller.getDriverDayAnomalies().size() + " anomalies");
        this.getTblWarning().setModel(new TMDriverWarning(this.controller.getDriverWarnings()));
        ((TMDriverDayAnomalies)this.getTblAnomaly().getModel()).setData(this.controller.getDriverDayAnomalies());
        this.getListUnknown().setListData(this.controller.getUnknownRegistrationNumber());
        if (this.controller.getCurrentImport().getState() != ImportActivity.Status.INTEGRATED) {
            this.getLblImportStatus().setText("<html>R\u00e9sultat de l'analyse du fichier " + this.controller.getCurrentImport().getFileName() + ".<br>Vous pouvez consulter les activit\u00e9s gr\u00e2ce \u00e0 l'aper\u00e7u et d\u00e9finir le traitement des anomalies avant de sauvegarder les informations.");
        } else {
            this.getLblImportStatus().setText("<html>Les donn\u00e9es du fichier " + this.controller.getCurrentImport().getFileName() + " ont \u00e9t\u00e9 int\u00e9gr\u00e9es le " + ConversionTime.dateToStringFr(this.controller.getCurrentImport().getIntegrationDate()) + " \u00e0 " + ConversionTime.dateToString(this.controller.getCurrentImport().getIntegrationDate(), "HH'h'mm") + ".<br> Les avertissements et anomalies suivants ont \u00e9t\u00e9 g\u00e9r\u00e9s lors de cet import</html>");
        }
    }

    public void createDialogAct() {
        new DialogActivity(this.controller.getDriverDays(), this.controller.getDriverMissings());
    }

    public class DialogActivity
    extends JDialog {
        private JButton next = null;
        private JButton previous = null;
        private JLabel driver = null;
        private JPanel content = null;
        private JPanel detail = null;
        HashMap<Integer, ArrayList<Jour>> ordonnedActivities = new HashMap();
        HashMap<Integer, ArrayList<LienJourConducteur>> ordonnedDays = new HashMap();
        ArrayList<Integer> driverOrder = new ArrayList();
        int current = 0;

        public DialogActivity(ArrayList<Jour> activities, ArrayList<LienJourConducteur> days) {
            ArrayList<MainElement> list;
            for (Jour jour : activities) {
                list = this.ordonnedActivities.get(jour.getDriverId());
                if (list == null) {
                    TimsLogger.debug("new activity list created for " + jour.getDriverId());
                    list = new ArrayList();
                    this.ordonnedActivities.put(jour.getDriverId(), list);
                    if (!this.driverOrder.contains(jour.getDriverId())) {
                        this.driverOrder.add(jour.getDriverId());
                    }
                }
                list.add(jour);
            }
            for (LienJourConducteur lienJourConducteur : days) {
                list = this.ordonnedDays.get(lienJourConducteur.getCleConducteur());
                if (list == null) {
                    TimsLogger.debug("new day list created for " + lienJourConducteur.getCleConducteur());
                    list = new ArrayList();
                    this.ordonnedDays.put(lienJourConducteur.getCleConducteur(), list);
                    if (!this.driverOrder.contains(lienJourConducteur.getCleConducteur())) {
                        this.driverOrder.add(lienJourConducteur.getCleConducteur());
                    }
                }
                list.add((Jour)((Object)lienJourConducteur));
            }
            this.initialize();
            TimsLogger.debug(String.valueOf(this.ordonnedActivities.size()) + " " + this.ordonnedDays.size());
            this.showDriver(0);
        }

        private JButton getBtnNext() {
            if (this.next == null) {
                this.next = new JButton();
                this.next.setIcon(Fonctions.getIcon("images/rightArrow.png"));
                this.next.setPreferredSize(new Dimension(32, 32));
                this.next.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DialogActivity.this.showDriver(1);
                    }
                });
                this.next.setEnabled(this.current < this.ordonnedActivities.size());
            }
            return this.next;
        }

        private JButton getBtnPrevious() {
            if (this.previous == null) {
                this.previous = new JButton();
                this.previous.setIcon(Fonctions.getIcon("images/leftArrow.png"));
                this.previous.setPreferredSize(new Dimension(32, 32));
                this.previous.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DialogActivity.this.showDriver(-1);
                    }
                });
                this.previous.setEnabled(false);
            }
            return this.previous;
        }

        private JLabel getDriver() {
            if (this.driver == null) {
                this.driver = new JLabel();
            }
            return this.driver;
        }

        private void showDriver(int inc) {
            this.current += inc;
            this.previous.setEnabled(this.current > 0);
            this.next.setEnabled(this.current < this.ordonnedActivities.size());
            this.load();
        }

        private void initialize() {
            this.setSize(new Dimension(800, 350));
            this.setTitle("D\u00e9tail du fichier d'import");
            this.setContentPane(this.getContent());
            this.setVisible(true);
        }

        private JPanel getContent() {
            if (this.content == null) {
                this.content = new JPanel();
                this.content.setLayout(new GridBagLayout());
                this.content.add((Component)this.getBtnPrevious(), Fonctions.getGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 5, 0, 5)));
                this.content.add((Component)this.getDriver(), Fonctions.getGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, -1, new Insets(5, 5, 0, 5)));
                this.content.add((Component)this.getBtnNext(), Fonctions.getGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, -1, new Insets(5, 5, 0, 5)));
                this.content.add((Component)this.getDetail(), Fonctions.getGridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
            }
            return this.content;
        }

        private JPanel getDetail() {
            if (this.detail == null) {
                this.detail = new JPanel();
                this.detail.setLayout(new GridBagLayout());
            }
            return this.detail;
        }

        private void load() {
            JPanel pnlGraph;
            ArrayList<Jour> activities = this.ordonnedActivities.get(this.driverOrder.get(this.current));
            ArrayList<LienJourConducteur> days = this.ordonnedDays.get(this.driverOrder.get(this.current));
            String toPrint = Conducteur.getDriverLibelle(this.driverOrder.get(this.current));
            JScrollPane jsp = new JScrollPane();
            this.getDetail().removeAll();
            this.getDetail().add((Component)jsp, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(0, 0, 0, 0)));
            JPanel globalPnl = new JPanel();
            TimsLogger.debug(String.valueOf(activities == null ? 0 : activities.size()) + " activities and " + (days == null ? 0 : days.size()) + " days for " + toPrint);
            globalPnl.setLayout(new GridLayout((activities == null ? 0 : activities.size()) + (days == null ? 0 : days.size()), 1));
            jsp.setViewportView(globalPnl);
            if (activities != null) {
                for (Jour jour : activities) {
                    TimsLogger.debug("#DialogImportActivity.showAnalyzeResult# Journ\u00e9e du " + jour.getDate());
                    pnlGraph = new JPanel();
                    pnlGraph.setPreferredSize(new Dimension(0, 70));
                    pnlGraph.setLayout(new GridBagLayout());
                    pnlGraph.setBorder(new TitledBorder("Journ\u00e9e du " + ConversionTime.dateFromBDDToFrance(jour.getDate())));
                    GraphJour g = new GraphJour();
                    g.initialiser(jour.getActivity(), 0, 0);
                    pnlGraph.add((Component)g, Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
                    globalPnl.add(pnlGraph);
                }
            } else {
                TimsLogger.debug("no activities for " + this.driverOrder.get(this.current));
            }
            if (days != null) {
                for (LienJourConducteur lienJourConducteur : days) {
                    TimsLogger.debug("#DialogImportActivity.showAnalyzeResult# Journ\u00e9e du " + lienJourConducteur.getDateJour());
                    pnlGraph = new JPanel();
                    pnlGraph.setPreferredSize(new Dimension(0, 70));
                    pnlGraph.setLayout(new GridBagLayout());
                    pnlGraph.add((Component)new JLabel(String.valueOf(lienJourConducteur.getDayType().getCode()) + " le " + ConversionTime.dateToStringFr(lienJourConducteur.getDateJour())), Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, -1, new Insets(5, 5, 0, 5)));
                    globalPnl.add(pnlGraph);
                }
            } else {
                TimsLogger.debug("no missing days for " + this.driverOrder.get(this.current));
            }
            this.getDriver().setText(toPrint);
        }
    }
}

