/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.ui.views;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.connexion.TimsSession;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Offence;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transport.offence.CalculInfractionPrincipal;

public class DialogInfraction
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton btnCalculer = null;
    private JButton btnQuitter = null;
    private JPanel pnlFiltre = null;
    private JPanel pnlChoix = null;
    private JCheckBox cbBrut = null;
    private JCheckBox cbModifie = null;
    private JCheckBox cbDernierCalcul = null;
    private JLabel lblAgence = null;
    private JComboBox cbAgence = null;
    private JPanel pnlDate = null;
    private JTextField txtDate = null;
    private JLabel lblDate = null;
    private JComboBox cbDriver = null;
    private JLabel lblDriver = null;

    @Override
    public void dispose() {
        TimsLogger.verbose("#DialogInfraction.dispose()#");
        super.dispose();
    }

    public DialogInfraction(Frame owner) {
        super(owner);
        TimsLogger.verbose("#DialogInfraction()#");
        this.initialize();
    }

    private void initialize() {
        this.setTitle(LanguageTranslator.getString("offence.calculation"));
        this.setBounds(new Rectangle(0, 0, 400, 220));
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(this.getParent());
        this.setConducteur();
        TimsSession.getInstance().addVisit(this.getClass().getName());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.weightx = 0.0;
            gridBagConstraints31.weighty = 0.0;
            gridBagConstraints31.fill = 2;
            gridBagConstraints31.gridwidth = 2;
            gridBagConstraints31.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints31.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.ipadx = 0;
            gridBagConstraints11.ipady = 0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.gridy = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints.gridy = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getBtnCalculer(), gridBagConstraints);
            this.jContentPane.add((Component)this.getBtnQuitter(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPnlFiltre(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getPnlChoix(), gridBagConstraints31);
        }
        return this.jContentPane;
    }

    private JButton getBtnCalculer() {
        if (this.btnCalculer == null) {
            this.btnCalculer = new JButton();
            this.btnCalculer.setText(LanguageTranslator.getString("button.calculation"));
            this.btnCalculer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Transport.ps.startOperation();
                    String dateJour = ConversionTime.dateToString(new Date(), "yyyy-MM-dd");
                    if (!DialogInfraction.this.getTxtDate().getText().equals("") && !DialogInfraction.this.raz()) {
                        Transport.ps.endOperation(PerformanceScanner.UPDATE, "offence calculation");
                        return;
                    }
                    try {
                        int cleAgence = ((ComboBoxModel)DialogInfraction.this.getCbAgence().getModel()).getSelectedCle();
                        int cleConducteur = ((ComboBoxModel)DialogInfraction.this.getCbDriver().getModel()).getSelectedCle();
                        Vector<Conducteur> listeConducteur = Transport.bdd.getConducteurListInfraction(cleAgence, cleConducteur);
                        CalculInfractionPrincipal cip = new CalculInfractionPrincipal(dateJour, listeConducteur, DialogInfraction.this.getCbBrut().isSelected() ? 1 : -1);
                        cip.start();
                        DialogInfraction.this.dispose();
                    }
                    catch (Exception ex) {
                        Transport.ps.endOperation(PerformanceScanner.UPDATE, "offence calculation");
                        System.err.println("calcul infraction erreur" + ex);
                    }
                    Transport.ps.endOperation(PerformanceScanner.UPDATE, "offence calculation");
                }
            });
        }
        return this.btnCalculer;
    }

    private boolean raz() {
        int reponse = JOptionPane.showConfirmDialog(this, "Voulez-vous vraiment supprimer les infractions depuis le " + this.getTxtDate().getText() + " ?");
        if (reponse == 0) {
            int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
            int cleConducteur = ((ComboBoxModel)this.getCbDriver().getModel()).getSelectedCle();
            String begin = ConversionTime.dateFromFranceToBDD(this.getTxtDate().getText(), false);
            String end = ConversionTime.dateToString(new Date(), "yyyy-MM-dd");
            Offence.delete(cleAgence, cleConducteur, begin, end, this.getCbBrut().isSelected());
            Transport.bdd.updateDriverOffenceDate(begin, cleAgence, cleConducteur, this.getCbBrut().isSelected());
        } else if (reponse == 2) {
            return false;
        }
        return true;
    }

    private JButton getBtnQuitter() {
        if (this.btnQuitter == null) {
            this.btnQuitter = new JButton();
            this.btnQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.btnQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogInfraction.this.dispose();
                }
            });
        }
        return this.btnQuitter;
    }

    private JPanel getPnlFiltre() {
        if (this.pnlFiltre == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 1;
            this.lblDriver = new JLabel();
            this.lblDriver.setText(LanguageTranslator.getString("generics.driver"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridy = 1;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints2.gridy = 0;
            this.lblAgence = new JLabel();
            this.lblAgence.setText(LanguageTranslator.getString("generics.agency"));
            this.pnlFiltre = new JPanel();
            this.pnlFiltre.setLayout(new GridBagLayout());
            this.pnlFiltre.add((Component)this.lblAgence, gridBagConstraints2);
            this.pnlFiltre.add((Component)this.getCbAgence(), gridBagConstraints3);
            this.pnlFiltre.add((Component)this.getCbDriver(), gridBagConstraints10);
            this.pnlFiltre.add((Component)this.lblDriver, gridBagConstraints12);
        }
        return this.pnlFiltre;
    }

    private JPanel getPnlChoix() {
        if (this.pnlChoix == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 0;
            this.pnlChoix = new JPanel();
            this.pnlChoix.setLayout(new GridBagLayout());
            this.pnlChoix.add((Component)this.getCbBrut(), gridBagConstraints4);
            this.pnlChoix.add((Component)this.getCbModifie(), gridBagConstraints5);
            this.pnlChoix.add((Component)this.getCbDernierCalcul(), gridBagConstraints7);
            if (ConnexionSettings.getInstance().isModifiable("INFRACTION")) {
                this.pnlChoix.add((Component)this.getPnlDate(), gridBagConstraints6);
            }
        }
        return this.pnlChoix;
    }

    private JCheckBox getCbBrut() {
        if (this.cbBrut == null) {
            this.cbBrut = new JCheckBox();
            this.cbBrut.setText(LanguageTranslator.getString("offence.calculation.original"));
            this.cbBrut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogInfraction.this.getCbModifie().setSelected(!DialogInfraction.this.getCbBrut().isSelected());
                }
            });
        }
        return this.cbBrut;
    }

    private JCheckBox getCbModifie() {
        if (this.cbModifie == null) {
            this.cbModifie = new JCheckBox();
            this.cbModifie.setText(LanguageTranslator.getString("offence.calculation.updated"));
            this.cbModifie.setSelected(true);
            this.cbModifie.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogInfraction.this.getCbBrut().setSelected(!DialogInfraction.this.getCbModifie().isSelected());
                }
            });
        }
        return this.cbModifie;
    }

    private JCheckBox getCbDernierCalcul() {
        if (this.cbDernierCalcul == null) {
            this.cbDernierCalcul = new JCheckBox();
            this.cbDernierCalcul.setText(LanguageTranslator.getString("offence.calculation.last"));
            this.cbDernierCalcul.setSelected(true);
            this.cbDernierCalcul.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DialogInfraction.this.getCbDernierCalcul().isSelected()) {
                        DialogInfraction.this.getTxtDate().setText("");
                    }
                }
            });
        }
        return this.cbDernierCalcul;
    }

    private JComboBox getCbAgence() {
        if (this.cbAgence == null) {
            this.cbAgence = new JComboBox();
            ComboBoxModel tmp = new ComboBoxModel(Agence.getList(), false, LanguageTranslator.getString("generics.all"));
            this.cbAgence.setModel(tmp);
            this.cbAgence.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DialogInfraction.this.setConducteur();
                }
            });
        }
        return this.cbAgence;
    }

    public void setConducteur() {
        int cleAgence = ((ComboBoxModel)this.getCbAgence().getModel()).getSelectedCle();
        ComboBoxModel modeleConducteur = new ComboBoxModel(Conducteur.loadList(cleAgence), true, LanguageTranslator.getString("generics.all"));
        this.getCbDriver().setModel(modeleConducteur);
    }

    private JPanel getPnlDate() {
        if (this.pnlDate == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints9.gridy = 0;
            this.lblDate = new JLabel();
            this.lblDate.setText(LanguageTranslator.getString("offence.calculation.since"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridx = 1;
            this.pnlDate = new JPanel();
            this.pnlDate.setLayout(new GridBagLayout());
            this.pnlDate.add((Component)this.getTxtDate(), gridBagConstraints8);
            this.pnlDate.add((Component)this.lblDate, gridBagConstraints9);
        }
        return this.pnlDate;
    }

    private JTextField getTxtDate() {
        if (this.txtDate == null) {
            this.txtDate = new JTextField();
            this.txtDate.setText("");
            this.txtDate.setEditable(false);
            this.txtDate.setEnabled(true);
            this.txtDate.setPreferredSize(new Dimension(70, 20));
            this.txtDate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Fonctions.afficheCalendrier(DialogInfraction.this.getTxtDate())) {
                        DialogInfraction.this.getCbDernierCalcul().setSelected(false);
                    }
                }
            });
        }
        return this.txtDate;
    }

    private JComboBox getCbDriver() {
        if (this.cbDriver == null) {
            this.cbDriver = new JComboBox();
        }
        return this.cbDriver;
    }
}

